/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.res.DynamicResourceValueItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements BuildVariantView.BuildVariantSelectionChangeListener,
SingleNamespaceResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceTable myFullTable;
    @NotNull
    private final ResourceNamespace myNamespace;

    private DynamicResourceValueRepository(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(1);
        }
        super("Gradle Dynamic");
        this.myFullTable = new ResourceTable();
        this.myFacet = facet;
        this.myNamespace = namespace;
        assert (facet.requiresAndroidModel());
        Module module = facet.getModule();
        MessageBusConnection parent = module.getProject().getMessageBus().connect((Disposable)module);
        parent.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS) {
                this.notifyProjectSynced();
            }
        });
        Disposer.register((Disposable)parent, (Disposable)this);
        BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        Project project = this.myFacet.getModule().getProject();
        if (!project.isDisposed()) {
            BuildVariantView.getInstance(project).removeListener(this);
        }
    }

    @Nullable
    public String getPackageName() {
        return AndroidManifestUtils.getPackageName(this.myFacet);
    }

    @NotNull
    public static DynamicResourceValueRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(2);
        }
        DynamicResourceValueRepository dynamicResourceValueRepository = new DynamicResourceValueRepository(facet, ResourceRepositoryManager.getOrCreateInstance(facet).getNamespace());
        if (dynamicResourceValueRepository == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(3);
        }
        return dynamicResourceValueRepository;
    }

    @NotNull
    @VisibleForTesting
    public static DynamicResourceValueRepository createForTest(@NotNull AndroidFacet facet, @NotNull ResourceNamespace namespace, @NotNull Map<String, ClassField> values2) {
        if (facet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(5);
        }
        if (values2 == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(6);
        }
        DynamicResourceValueRepository repository = new DynamicResourceValueRepository(facet, namespace);
        repository.addValues(values2);
        DynamicResourceValueRepository dynamicResourceValueRepository = repository;
        if (dynamicResourceValueRepository == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(7);
        }
        return dynamicResourceValueRepository;
    }

    protected ResourceTable getFullTable() {
        if (this.myFullTable.isEmpty()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return this.myFullTable;
            }
            IdeVariant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                this.addValues(buildType.getBuildType().getResValues());
            }
            this.addValues(selectedVariant.getMergedFlavor().getResValues());
        }
        return this.myFullTable;
    }

    private void notifyProjectSynced() {
        this.myFullTable.clear();
        super.invalidateParentCaches();
    }

    private void addValues(Map<String, ClassField> resValues) {
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField field2 = entry.getValue();
            String name = field2.getName();
            assert (entry.getKey().equals(name)) : entry.getKey() + " vs " + name;
            ResourceType type = ResourceType.getEnum((String)field2.getType());
            if (type == null) {
                LOG.warn("Ignoring field " + name + "(" + field2 + "): unknown type " + field2.getType());
                continue;
            }
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 == null) {
                map2 = ArrayListMultimap.create();
                this.myFullTable.put((Object)this.myNamespace, (Object)type, (Object)map2);
            } else if (map2.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(this.myNamespace, type, field2);
            map2.put((Object)name, (Object)item);
        }
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create) {
        ListMultimap multimap;
        if (namespace == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(8);
        }
        if (type == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(9);
        }
        if (!namespace.equals((Object)this.myNamespace)) {
            return create ? ArrayListMultimap.create() : null;
        }
        if (this.myFullTable.isEmpty()) {
            this.getFullTable();
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(10);
        }
        return resourceNamespace;
    }

    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Set<ResourceNamespace> set = Collections.singleton(this.myNamespace);
        if (set == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Override
    public void selectionChanged() {
        this.notifyProjectSynced();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            DynamicResourceValueRepository.$$$reportNull$$$0(12);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/DynamicResourceValueRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/DynamicResourceValueRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

