/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.res.aar.ProtoXmlPullParser;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceOpener {
    public static final byte PROTO_XML_LEAD_BYTE = 10;

    @NotNull
    public static ByteArrayInputStream open(@NotNull PathString resourcePath) throws IOException {
        String scheme;
        if (resourcePath == null) {
            FileResourceOpener.$$$reportNull$$$0(0);
        }
        URI uri = resourcePath.getFilesystemUri();
        switch (scheme = uri.getScheme()) {
            case "file": {
                ByteArrayInputStream byteArrayInputStream = FileResourceOpener.openFile(resourcePath.getRawPath());
                if (byteArrayInputStream == null) {
                    FileResourceOpener.$$$reportNull$$$0(1);
                }
                return byteArrayInputStream;
            }
            case "apk": {
                ByteArrayInputStream byteArrayInputStream = FileResourceOpener.openZipEntry(uri.getPath(), resourcePath.getPortablePath());
                if (byteArrayInputStream == null) {
                    FileResourceOpener.$$$reportNull$$$0(2);
                }
                return byteArrayInputStream;
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + resourcePath + "\"");
    }

    @NotNull
    public static ByteArrayInputStream open(@NotNull String resourcePath) throws IOException {
        if (resourcePath == null) {
            FileResourceOpener.$$$reportNull$$$0(3);
        }
        if (resourcePath.startsWith("apk:")) {
            int prefixLength = "apk:".length();
            int colonPos = resourcePath.lastIndexOf(58);
            if (colonPos < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            ByteArrayInputStream byteArrayInputStream = FileResourceOpener.openZipEntry(resourcePath.substring(prefixLength, colonPos), resourcePath.substring(colonPos + 1));
            if (byteArrayInputStream == null) {
                FileResourceOpener.$$$reportNull$$$0(4);
            }
            return byteArrayInputStream;
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        ByteArrayInputStream byteArrayInputStream = FileResourceOpener.openFile(resourcePath);
        if (byteArrayInputStream == null) {
            FileResourceOpener.$$$reportNull$$$0(5);
        }
        return byteArrayInputStream;
    }

    @NotNull
    private static ByteArrayInputStream openFile(String filePath) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)fileStream, (OutputStream)byteOutputStream);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteOutputStream.toByteArray());
            byteArrayInputStream = byteArrayInputStream2;
        }
        if (byteArrayInputStream == null) {
            FileResourceOpener.$$$reportNull$$$0(6);
        }
        return byteArrayInputStream;
    }

    @NotNull
    private static ByteArrayInputStream openZipEntry(String zipPath, String zipEntryPath) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        try (ZipFile zipFile = new ZipFile(zipPath);){
            ZipEntry entry = zipFile.getEntry(zipEntryPath);
            if (entry == null) {
                throw new FileNotFoundException("Zip entry " + zipPath + ':' + zipEntryPath + " does not exist");
            }
            long size = entry.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new IOException("Zip entry " + zipPath + ':' + zipEntryPath + " is too large");
            }
            byte[] bytes = new byte[(int)size];
            InputStream stream = zipFile.getInputStream(entry);
            if ((long)stream.read(bytes) != size) {
                throw new IOException("Incomplete read from " + zipPath + ':' + zipEntryPath);
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(bytes);
            byteArrayInputStream = byteArrayInputStream2;
        }
        if (byteArrayInputStream == null) {
            FileResourceOpener.$$$reportNull$$$0(7);
        }
        return byteArrayInputStream;
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) {
        if (resourcePath == null) {
            FileResourceOpener.$$$reportNull$$$0(8);
        }
        try {
            ProtoXmlPullParser parser;
            ByteArrayInputStream stream = FileResourceOpener.open(resourcePath);
            int c = stream.read();
            stream.reset();
            if (c == 10) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput(stream, null);
            return parser;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull VirtualFile resourceFile) {
        if (resourceFile == null) {
            FileResourceOpener.$$$reportNull$$$0(9);
        }
        try {
            Object parser;
            byte[] contents = resourceFile.contentsToByteArray();
            if (contents.length != 0 && contents[0] == 10) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput((InputStream)new ByteArrayInputStream(contents), null);
            return parser;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    private FileResourceOpener() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/FileResourceOpener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/FileResourceOpener";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "openFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "openZipEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createXmlPullParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

