/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalResourceRepository
extends AbstractResourceRepository
implements Disposable,
ModificationTracker {
    protected static final Logger LOG = Logger.getInstance(LocalResourceRepository.class);
    protected static final AtomicLong ourModificationCounter = new AtomicLong();
    private final String myDisplayName;
    @Nullable
    private List<MultiResourceRepository> myParents;
    private volatile long myGeneration;
    private final Object RESOURCE_DIRS_LOCK;
    @Nullable
    private Set<VirtualFile> myResourceDirs;

    protected LocalResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            LocalResourceRepository.$$$reportNull$$$0(0);
        }
        this.RESOURCE_DIRS_LOCK = new Object();
        this.myDisplayName = displayName;
        this.setModificationCount(ourModificationCounter.incrementAndGet());
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            LocalResourceRepository.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            LocalResourceRepository.$$$reportNull$$$0(2);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents == null) {
                this.myParents = new ArrayList<MultiResourceRepository>(2);
            }
            this.myParents.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParent(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            LocalResourceRepository.$$$reportNull$$$0(3);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                this.myParents.remove((Object)parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasParents() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myParents != null && !this.myParents.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (MultiResourceRepository parent : this.myParents) {
                    parent.invalidateCache(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateParentCaches(@NotNull ResourceNamespace namespace, ResourceType ... types) {
        if (namespace == null) {
            LocalResourceRepository.$$$reportNull$$$0(4);
        }
        if (types == null) {
            LocalResourceRepository.$$$reportNull$$$0(5);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (MultiResourceRepository parent : this.myParents) {
                    parent.invalidateCache(this, namespace, types);
                }
            }
        }
    }

    protected final void merge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result2) {
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            LocalResourceRepository.$$$reportNull$$$0(7);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(8);
        }
        if (seenQualifiers == null) {
            LocalResourceRepository.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            LocalResourceRepository.$$$reportNull$$$0(10);
        }
        if (visited.contains((Object)this)) {
            return;
        }
        visited.add(this);
        this.doMerge(visited, namespace, type, seenQualifiers, result2);
    }

    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result2) {
        ListMultimap items2;
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(11);
        }
        if (namespace == null) {
            LocalResourceRepository.$$$reportNull$$$0(12);
        }
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(13);
        }
        if (seenQualifiers == null) {
            LocalResourceRepository.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            LocalResourceRepository.$$$reportNull$$$0(15);
        }
        if ((items2 = this.getMap(namespace, type, false)) == null) {
            return;
        }
        for (ResourceItem item : items2.values()) {
            String name = item.getName();
            String qualifiers = item.getConfiguration().getQualifierString();
            if (result2.containsKey((Object)name) && type != ResourceType.DECLARE_STYLEABLE && type != ResourceType.ID && seenQualifiers.containsEntry((Object)name, (Object)qualifiers)) continue;
            result2.put((Object)name, (Object)item);
            seenQualifiers.put((Object)name, (Object)qualifiers);
        }
    }

    protected boolean computeHasResourcesOfType(@NotNull ResourceType type, @NotNull Set<LocalResourceRepository> visited) {
        if (type == null) {
            LocalResourceRepository.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            LocalResourceRepository.$$$reportNull$$$0(17);
        }
        if (!visited.add(this)) {
            return false;
        }
        return this.hasResourcesOfType(type);
    }

    public long getModificationCount() {
        return this.myGeneration;
    }

    protected void setModificationCount(long count) {
        this.myGeneration = count;
    }

    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        return null;
    }

    @Nullable
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        return null;
    }

    public boolean isScanPending(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            LocalResourceRepository.$$$reportNull$$$0(18);
        }
        return false;
    }

    @Nullable
    public static PsiFile getItemPsiFile(@NotNull Project project, @NotNull ResourceItem item) {
        if (project == null) {
            LocalResourceRepository.$$$reportNull$$$0(19);
        }
        if (item == null) {
            LocalResourceRepository.$$$reportNull$$$0(20);
        }
        if (project.isDisposed()) {
            return null;
        }
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getPsiFile();
        }
        VirtualFile virtualFile = ResourceHelper.getSourceAsVirtualFile(item);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            return psiManager.findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static XmlTag getItemTag(@NotNull Project project, @NotNull ResourceItem item) {
        if (project == null) {
            LocalResourceRepository.$$$reportNull$$$0(21);
        }
        if (item == null) {
            LocalResourceRepository.$$$reportNull$$$0(22);
        }
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getTag();
        }
        PsiFile psiFile = LocalResourceRepository.getItemPsiFile(project, item);
        if (psiFile instanceof XmlFile) {
            String resourceName = item.getName();
            XmlFile xmlFile = (XmlFile)psiFile;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null && rootTag.isValid()) {
                XmlTag[] subTags;
                for (XmlTag tag : subTags = rootTag.getSubTags()) {
                    if (!tag.isValid() || !resourceName.equals(tag.getAttributeValue("name")) || item.getType() != AndroidResourceUtil.getType(tag)) continue;
                    return tag;
                }
            }
            assert (FolderTypeRelationship.getRelatedFolders((ResourceType)item.getType()).contains(ResourceFolderType.VALUES)) : item.getType();
        }
        return null;
    }

    @Nullable
    public String getViewTag(@NotNull ResourceItem item) {
        if (item == null) {
            LocalResourceRepository.$$$reportNull$$$0(23);
        }
        if (item instanceof PsiResourceItem) {
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiResourceItem psiItem = (PsiResourceItem)item;
            XmlTag tag = psiItem.getTag();
            String id = item.getName();
            if (tag != null && tag.isValid() && id.equals(Lint.stripIdPrefix((String)tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")))) {
                return tag.getName();
            }
            PsiFile file = psiItem.getPsiFile();
            if (file instanceof XmlFile && file.isValid() && (rootTag = (xmlFile = (XmlFile)file).getRootTag()) != null && rootTag.isValid()) {
                return LocalResourceRepository.findViewTag(rootTag, id);
            }
        }
        return null;
    }

    @Nullable
    private static String findViewTag(XmlTag tag, String target) {
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null && id.endsWith(target) && target.equals(Lint.stripIdPrefix((String)id))) {
            return tag.getName();
        }
        for (XmlTag sub : tag.getSubTags()) {
            String found;
            if (!sub.isValid() || (found = LocalResourceRepository.findViewTag(sub, target)) == null) continue;
            return found;
        }
        return null;
    }

    public void sync() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Set<VirtualFile> getResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirs != null) {
            Set<VirtualFile> set = this.myResourceDirs;
            // MONITOREXIT : object
            if (set != null) return set;
            LocalResourceRepository.$$$reportNull$$$0(24);
            return set;
        }
        Set<VirtualFile> set = this.myResourceDirs = this.computeResourceDirs();
        // MONITOREXIT : object
        if (set != null) return set;
        LocalResourceRepository.$$$reportNull$$$0(25);
        return set;
    }

    @NotNull
    protected abstract Set<VirtualFile> computeResourceDirs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateResourceDirs() {
        Object object = this.RESOURCE_DIRS_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myParents != null) {
                for (LocalResourceRepository localResourceRepository : this.myParents) {
                    localResourceRepository.invalidateResourceDirs();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenQualifiers";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/LocalResourceRepository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 24: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addParent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidateParentCaches";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeHasResourcesOfType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getItemPsiFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getItemTag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getViewTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyRepository
    extends LocalResourceRepository {
        public EmptyRepository() {
            super("");
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                EmptyRepository.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        protected ResourceTable getFullTable() {
            ResourceTable resourceTable = new ResourceTable();
            if (resourceTable == null) {
                EmptyRepository.$$$reportNull$$$0(1);
            }
            return resourceTable;
        }

        @Nullable
        protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create) {
            if (namespace == null) {
                EmptyRepository.$$$reportNull$$$0(2);
            }
            if (type == null) {
                EmptyRepository.$$$reportNull$$$0(3);
            }
            if (create) {
                throw new UnsupportedOperationException();
            }
            return null;
        }

        @NotNull
        public Set<ResourceNamespace> getNamespaces() {
            Set<ResourceNamespace> set = Collections.emptySet();
            if (set == null) {
                EmptyRepository.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/LocalResourceRepository$EmptyRepository";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeResourceDirs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullTable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/LocalResourceRepository$EmptyRepository";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

