/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ModuleResourceRepository
extends MultiResourceRepository
implements SingleNamespaceResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceNamespace myNamespace;
    private final ResourceFolderRegistry myRegistry;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener;
    private final ResourceFolderManager myResourceFolderManager;

    @NotNull
    static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(0);
        }
        ResourceNamespace namespace = ResourceRepositoryManager.getOrCreateInstance(facet).getNamespace();
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        if (!facet.requiresAndroidModel()) {
            VirtualFile primaryResourceDir = ResourceFolderManager.getInstance(facet).getPrimaryFolder();
            if (primaryResourceDir == null) {
                LocalResourceRepository.EmptyRepository emptyRepository = new LocalResourceRepository.EmptyRepository();
                if (emptyRepository == null) {
                    ModuleResourceRepository.$$$reportNull$$$0(1);
                }
                return emptyRepository;
            }
            ResourceFolderRepository resourceFolderRepository = resourceFolderRegistry.get(facet, primaryResourceDir);
            if (resourceFolderRepository == null) {
                ModuleResourceRepository.$$$reportNull$$$0(2);
            }
            return resourceFolderRepository;
        }
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet);
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + 1);
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = resourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, namespace, resources);
        Disposer.register((Disposable)repository, (Disposable)dynamicResources);
        ModuleResourceRepository moduleResourceRepository = repository;
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(3);
        }
        return moduleResourceRepository;
    }

    private ModuleResourceRepository(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(5);
        }
        if (delegates == null) {
            ModuleResourceRepository.$$$reportNull$$$0(6);
        }
        super(facet2.getModule().getName());
        this.myResourceFolderListener = (facet, folders, added, removed) -> this.updateRoots();
        this.myFacet = facet2;
        this.myNamespace = namespace;
        this.setChildren(delegates);
        this.myResourceFolderManager = ResourceFolderManager.getInstance(this.myFacet);
        this.myResourceFolderManager.addListener(this.myResourceFolderListener);
        this.myRegistry = ResourceFolderRegistry.getInstance(facet2.getModule().getProject());
    }

    private void updateRoots() {
        this.updateRoots(this.myResourceFolderManager.getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        ArrayList<LocalResourceRepository> other = null;
        HashMap<VirtualFile, ResourceFolderRepository> map2 = new HashMap<VirtualFile, ResourceFolderRepository>();
        for (LocalResourceRepository repository : this.getChildren()) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map2.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = new ArrayList<LocalResourceRepository>();
            }
            other.add(repository);
        }
        HashSet<VirtualFile> newDirs = new HashSet<VirtualFile>(resourceDirectories);
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(newDirs.size() + (other != null ? other.size() : 0));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map2.get(dir));
            if (repository == null) {
                repository = this.myRegistry.get(this.myFacet, dir);
            } else {
                map2.remove(dir);
            }
            resources.add(repository);
        }
        if (other != null) {
            resources.addAll(other);
        }
        if (resources.equals(this.getChildren())) {
            assert (map2.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map2.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myResourceFolderManager.removeListener(this.myResourceFolderListener);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(7);
        }
        return resourceNamespace;
    }

    @Nullable
    public String getPackageName() {
        if (this.myNamespace.getPackageName() != null) {
            return this.myNamespace.getPackageName();
        }
        return AndroidManifestUtils.getPackageName(this.myFacet);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(8);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(9);
        }
        ModuleResourceRepository moduleResourceRepository = ModuleResourceRepository.createForTest(facet, resourceDirectories, ResourceNamespace.TODO(), null);
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(10);
        }
        return moduleResourceRepository;
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @NotNull ResourceNamespace namespace, @Nullable DynamicResourceValueRepository dynamicResourceValueRepository) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(11);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(12);
        }
        if (namespace == null) {
            ModuleResourceRepository.$$$reportNull$$$0(13);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<LocalResourceRepository> delegates = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + 1);
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(facet.getModule().getProject());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            delegates.add(resourceFolderRegistry.get(facet, resourceDirectory, namespace));
        }
        if (dynamicResourceValueRepository != null) {
            delegates.add(dynamicResourceValueRepository);
        }
        ModuleResourceRepository moduleResourceRepository = new ModuleResourceRepository(facet, namespace, delegates);
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(14);
        }
        return moduleResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

