/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

final class ProjectResourceRepository
extends MultiResourceRepository {
    private AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(0);
        }
        if (delegates == null) {
            ProjectResourceRepository.$$$reportNull$$$0(1);
        }
        super(facet.getModule().getName() + " with modules");
        this.myFacet = facet;
        this.setChildren(delegates);
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(2);
        }
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        ProjectResourceRepository projectResourceRepository = repository;
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(3);
        }
        return projectResourceRepository;
    }

    @NotNull
    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(4);
        }
        LocalResourceRepository main = ResourceRepositoryManager.getModuleResources(facet);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            List<LocalResourceRepository> list = Collections.singletonList(main);
            if (list == null) {
                ProjectResourceRepository.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(dependentFacets.size() + 1);
        for (int i = dependentFacets.size() - 1; i >= 0; --i) {
            resources.add(ResourceRepositoryManager.getModuleResources(dependentFacets.get(i)));
        }
        resources.add(main);
        ArrayList<LocalResourceRepository> arrayList = resources;
        if (arrayList == null) {
            ProjectResourceRepository.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @VisibleForTesting
    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    private void updateRoots(@NotNull List<LocalResourceRepository> resourceDirectories) {
        if (resourceDirectories == null) {
            ProjectResourceRepository.$$$reportNull$$$0(7);
        }
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.getChildren())) {
            this.setChildren(resourceDirectories);
        }
    }

    @Override
    public void dispose() {
        this.myFacet = null;
        super.dispose();
    }

    @VisibleForTesting
    @NotNull
    static ProjectResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(8);
        }
        if (modules == null) {
            ProjectResourceRepository.$$$reportNull$$$0(9);
        }
        ProjectResourceRepository projectResourceRepository = new ProjectResourceRepository(facet, modules);
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(10);
        }
        return projectResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

