/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

public class ProjectResourceRepositoryRootListener {
    private ProjectResourceRepositoryRootListener(final @NotNull Project project) {
        if (project == null) {
            ProjectResourceRepositoryRootListener.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectResourceRepositoryRootListener.moduleRootsChanged(project);
            }
        });
    }

    public static void ensureSubscribed(@NotNull Project project) {
        if (project == null) {
            ProjectResourceRepositoryRootListener.$$$reportNull$$$0(1);
        }
        ServiceManager.getService((Project)project, ProjectResourceRepositoryRootListener.class);
    }

    private static void moduleRootsChanged(final @NotNull Project project) {
        if (project == null) {
            ProjectResourceRepositoryRootListener.$$$reportNull$$$0(2);
        }
        DumbService.getInstance((Project)project).queueTask(new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText("Updating resource repository roots");
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    ProjectResourceRepositoryRootListener.moduleRootsChanged(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/res/ProjectResourceRepositoryRootListener$2", "performInDumbMode"));
            }
        });
    }

    private static void moduleRootsChanged(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ProjectResourceRepositoryRootListener.$$$reportNull$$$0(3);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null) {
            if (facet.requiresAndroidModel() && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
                return;
            }
            ResourceFolderManager.getInstance(facet).invalidate();
            ResourceRepositoryManager repoManager = ResourceRepositoryManager.getOrCreateInstance(facet);
            repoManager.resetVisibility();
            ProjectResourceRepository projectResources = (ProjectResourceRepository)repoManager.getProjectResources(false);
            if (projectResources != null) {
                projectResources.updateRoots();
                AppResourceRepository appResources = (AppResourceRepository)repoManager.getAppResources(false);
                if (appResources != null) {
                    appResources.invalidateCache(projectResources);
                    appResources.updateRoots();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/res/ProjectResourceRepositoryRootListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureSubscribed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleRootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

