/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/res/SampleDataListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "subscribed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "childAdded", "", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childMoved", "childRemoved", "childReplaced", "childrenChanged", "ensureSubscribed", "fileCreated", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileDeleted", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "isPossiblyRelevant", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRelevant", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isSampleDataDirectory", "isSampleDataFile", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "psiFileChanged", "virtualFileChanged", "Companion", "intellij.android.core"})
public final class SampleDataListener
extends PsiTreeChangeAdapter
implements VirtualFileListener {
    private AtomicBoolean subscribed;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void ensureSubscribed() {
        if (this.subscribed.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this, (Disposable)this.project);
            PsiProjectListener.getInstance(this.project).setSampleDataListener(this);
        }
    }

    private final boolean isRelevant(VirtualFile file, AndroidFacet facet) {
        return !facet.isDisposed() && SampleDataResourceRepository.SampleDataRepositoryManager.hasRepository(facet) && this.isSampleDataFile(facet, file);
    }

    private final boolean isPossiblyRelevant(VirtualFile file) {
        FileType fileType = file.getFileType();
        FileType it = fileType;
        return Intrinsics.areEqual((Object)it, (Object)StdFileTypes.JAVA) ^ true && Intrinsics.areEqual((Object)it, (Object)StdFileTypes.XML) ^ true;
    }

    private final boolean isSampleDataFile(AndroidFacet facet, VirtualFile file) {
        boolean bl;
        if (this.isSampleDataDirectory(facet, file)) {
            return true;
        }
        try {
            VirtualFile sampleDataDir = SampleDataResourceRepository.getSampleDataDir(facet, false);
            bl = sampleDataDir != null && VfsUtilCore.isAncestor((VirtualFile)sampleDataDir, (VirtualFile)file, (boolean)false);
        }
        catch (IOException e) {
            SampleDataListener.Companion.getLOG().warn("Error getting sample data directory", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final boolean isSampleDataDirectory(AndroidFacet facet, VirtualFile file) {
        return Intrinsics.areEqual((Object)file.getName(), (Object)"sampledata") && Intrinsics.areEqual((Object)file.getParent(), (Object)AndroidRootUtil.getMainContentRoot(facet));
    }

    private final void virtualFileChanged(VirtualFile file) {
        Object facet;
        VirtualFile virtualFile;
        VirtualFile it;
        if (!this.isPossiblyRelevant(file)) {
            return;
        }
        Object object = file.getParent();
        if (object == null || (object = AndroidFacet.getInstance(it = (virtualFile = object), this.project)) == null) {
            return;
        }
        Object object2 = facet = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"facet");
        if (this.isRelevant(file, (AndroidFacet)((Object)object2))) {
            SampleDataListener.Companion.getLOG().info("Invalidating SampleDataResourceRepository because " + file.getPath() + " was modified.");
            SampleDataResourceRepository.getInstance((AndroidFacet)((Object)facet)).invalidate();
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.virtualFileChanged(virtualFile);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.virtualFileChanged(virtualFile);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.virtualFileChanged(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.virtualFileChanged(virtualFile);
    }

    private final void psiFileChanged(PsiTreeChangeEvent event) {
        block0: {
            PsiFile psiFile;
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block0;
            PsiFile it = psiFile = psiFile2;
            this.virtualFileChanged((VirtualFile)it);
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public SampleDataListener(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.subscribed = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(SampleDataListener.class);
    }

    @JvmStatic
    @NotNull
    public static final SampleDataListener getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void ensureSubscribed(@NotNull Project project) {
        Companion.ensureSubscribed(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/res/SampleDataListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ensureSubscribed", "", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lcom/android/tools/idea/res/SampleDataListener;", "intellij.android.core"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final SampleDataListener getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, SampleDataListener.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (SampleDataListener)((Object)object);
        }

        @JvmStatic
        public final void ensureSubscribed(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.getInstance(project).ensureSubscribed();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

