/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.sampledata.datasource.CombinerDataSource;
import com.android.tools.idea.sampledata.datasource.DateTimeGenerator;
import com.android.tools.idea.sampledata.datasource.LoremIpsumGenerator;
import com.android.tools.idea.sampledata.datasource.NumberGenerator;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

public class SampleDataResourceRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository {
    public static final ResourceNamespace PREDEFINED_SAMPLES_NS = ResourceNamespace.TOOLS;
    private static final ImmutableList<SampleDataResourceItem> PREDEFINED_SOURCES = ImmutableList.of((Object)SampleDataResourceItem.getFromStaticDataSource("full_names", new CombinerDataSource(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/names.txt"), SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("first_names", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/names.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("last_names", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/surnames.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("cities", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/cities.txt")), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("us_zipcodes", new NumberGenerator("%05d", 20000, 99999), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("us_phones", new NumberGenerator("(800) 555-%04d", 0, 9999), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("lorem", new LoremIpsumGenerator(false), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("lorem/random", new LoremIpsumGenerator(true), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("avatars", ResourceContent.fromDirectory("avatars"), SampleDataResourceItem.ContentType.IMAGE), (Object)SampleDataResourceItem.getFromStaticDataSource("backgrounds/scenic", ResourceContent.fromDirectory("backgrounds/scenic"), SampleDataResourceItem.ContentType.IMAGE), (Object)SampleDataResourceItem.getFromStaticDataSource("date/day_of_week", new DateTimeGenerator(DateTimeFormatter.ofPattern("E"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), (Object)SampleDataResourceItem.getFromStaticDataSource("date/ddmmyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("dd-MM-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), (Object[])new SampleDataResourceItem[]{SampleDataResourceItem.getFromStaticDataSource("date/mmddyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("MM-dd-yy"), ChronoUnit.DAYS), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource("date/hhmm", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm"), ChronoUnit.MINUTES), SampleDataResourceItem.ContentType.TEXT), SampleDataResourceItem.getFromStaticDataSource("date/hhmmss", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm:ss"), ChronoUnit.SECONDS), SampleDataResourceItem.ContentType.TEXT)});
    private final ResourceTable myFullTable;
    private AndroidFacet myAndroidFacet;

    public static VirtualFile getSampleDataDir(@NotNull AndroidFacet androidFacet, boolean create) throws IOException {
        VirtualFile contentRoot;
        if (androidFacet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(0);
        }
        if ((contentRoot = AndroidRootUtil.getMainContentRoot(androidFacet)) == null) {
            return null;
        }
        VirtualFile sampleDataDir = contentRoot.findFileByRelativePath("/sampledata");
        if (sampleDataDir == null && create) {
            sampleDataDir = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)androidFacet.getModule().getProject(), () -> {
                if (androidFacet == null) {
                    SampleDataResourceRepository.$$$reportNull$$$0(10);
                }
                return contentRoot.createChildDirectory((Object)androidFacet, "sampledata");
            });
        }
        return sampleDataDir;
    }

    @NotNull
    public static SampleDataResourceRepository getInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(1);
        }
        SampleDataResourceRepository sampleDataResourceRepository = SampleDataRepositoryManager.getInstance(facet).getRepository();
        if (sampleDataResourceRepository == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(2);
        }
        return sampleDataResourceRepository;
    }

    private SampleDataResourceRepository(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(3);
        }
        super("SampleData");
        Disposer.register((Disposable)androidFacet, (Disposable)this);
        this.myFullTable = new ResourceTable();
        this.myAndroidFacet = androidFacet;
        SampleDataListener.ensureSubscribed(androidFacet.getModule().getProject());
        this.invalidate();
    }

    private void addItems(@NotNull PsiFileSystemItem sampleDataFile) {
        if (sampleDataFile == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(4);
        }
        try {
            List<SampleDataResourceItem> fromFile = SampleDataResourceItem.getFromPsiFileSystemItem(sampleDataFile);
            if (!fromFile.isEmpty()) {
                ListMultimap cell = this.myFullTable.getOrPutEmpty(fromFile.get(0).getNamespace(), ResourceType.SAMPLE_DATA);
                fromFile.forEach(item -> cell.put((Object)item.getName(), item));
            }
        }
        catch (IOException e) {
            LOG.warn("Error loading sample data file " + sampleDataFile.getName(), (Throwable)e);
        }
    }

    private void addPredefinedItems() {
        ListMultimap cell = this.myFullTable.getOrPutEmpty(PREDEFINED_SAMPLES_NS, ResourceType.SAMPLE_DATA);
        PREDEFINED_SOURCES.forEach(source -> cell.put((Object)source.getName(), source));
    }

    void invalidate() {
        AndroidFacet facet = this.myAndroidFacet;
        if (facet == null || facet.isDisposed()) {
            return;
        }
        VirtualFile sampleDataDir = null;
        try {
            sampleDataDir = SampleDataResourceRepository.getSampleDataDir(facet, false);
        }
        catch (IOException e) {
            LOG.warn("Error getting 'sampledir'", (Throwable)e);
        }
        this.myFullTable.clear();
        if (sampleDataDir != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)facet.getModule().getProject());
            Stream<VirtualFile> childrenStream = Arrays.stream(sampleDataDir.getChildren());
            ApplicationManager.getApplication().runReadAction(() -> childrenStream.map(vf -> vf.isDirectory() ? psiManager.findDirectory(vf) : psiManager.findFile(vf)).filter(Objects::nonNull).forEach(f -> this.addItems((PsiFileSystemItem)f)));
        }
        this.addPredefinedItems();
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches(PREDEFINED_SAMPLES_NS, ResourceType.SAMPLE_DATA);
    }

    @Override
    public void addParent(MultiResourceRepository parent) {
        AndroidFacet facet = this.myAndroidFacet;
        if (facet == null || facet.isDisposed()) {
            return;
        }
        super.addParent(parent);
    }

    private static boolean isSampleDataFile(@NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        if (facet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(5);
        }
        if (file == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(6);
        }
        VirtualFile sampleDataDir = null;
        try {
            sampleDataDir = SampleDataResourceRepository.getSampleDataDir(facet, false);
        }
        catch (IOException e) {
            LOG.warn("Error getting 'sampledir'", (Throwable)e);
        }
        boolean relevant = sampleDataDir != null && VfsUtilCore.isAncestor((VirtualFile)sampleDataDir, (VirtualFile)file, (boolean)false);
        return relevant || "sampledata".equals(file.getName());
    }

    protected ResourceTable getFullTable() {
        return this.myFullTable;
    }

    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, ResourceType type, boolean create) {
        ListMultimap multimap;
        if (namespace == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(7);
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    public Set<ResourceNamespace> getNamespaces() {
        return this.myFullTable.rowKeySet();
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = PREDEFINED_SAMPLES_NS;
        if (resourceNamespace == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(8);
        }
        return resourceNamespace;
    }

    public String getPackageName() {
        return PREDEFINED_SAMPLES_NS.getPackageName();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(9);
        }
        return immutableSet;
    }

    @Override
    public void dispose() {
        this.myAndroidFacet = null;
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleDataFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSampleDataDir";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSampleDataFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSampleDataDir$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SampleDataRepositoryManager
    extends AndroidFacetScopedService {
        private static final Key<SampleDataRepositoryManager> KEY = Key.create((String)SampleDataRepositoryManager.class.getName());
        private SampleDataResourceRepository repository;

        @NotNull
        public static SampleDataRepositoryManager getInstance(@NotNull AndroidFacet facet) {
            SampleDataRepositoryManager manager;
            if (facet == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(0);
            }
            if ((manager = (SampleDataRepositoryManager)facet.getUserData(KEY)) == null) {
                manager = new SampleDataRepositoryManager(facet);
                facet.putUserData(KEY, manager);
            }
            SampleDataRepositoryManager sampleDataRepositoryManager = manager;
            if (sampleDataRepositoryManager == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(1);
            }
            return sampleDataRepositoryManager;
        }

        private SampleDataRepositoryManager(@NotNull AndroidFacet facet) {
            if (facet == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(2);
            }
            super(facet);
        }

        @NotNull
        public SampleDataResourceRepository getRepository() {
            if (this.isDisposed()) {
                throw new IllegalStateException(this.getClass().getName() + " is disposed");
            }
            if (this.repository == null) {
                this.repository = new SampleDataResourceRepository(this.getFacet());
            }
            SampleDataResourceRepository sampleDataResourceRepository = this.repository;
            if (sampleDataResourceRepository == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(3);
            }
            return sampleDataResourceRepository;
        }

        public static boolean hasRepository(@NotNull AndroidFacet facet) {
            SampleDataRepositoryManager manager;
            if (facet == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(4);
            }
            if ((manager = (SampleDataRepositoryManager)facet.getUserData(KEY)) == null) {
                return false;
            }
            return manager.repository != null;
        }

        @Override
        public void onServiceDisposal(@NotNull AndroidFacet facet) {
            if (facet == null) {
                SampleDataRepositoryManager.$$$reportNull$$$0(5);
            }
            this.repository = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceRepository$SampleDataRepositoryManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository$SampleDataRepositoryManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasRepository";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "onServiceDisposal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

