/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.aar.AarConfiguration;
import com.android.tools.idea.res.aar.AarDensityBasedFileResourceItem;
import com.android.tools.idea.res.aar.AarFileResourceItem;
import com.android.tools.idea.res.aar.AarResourceItem;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.android.tools.idea.res.aar.AarValueResourceItem;
import com.android.tools.idea.res.aar.ProtoConfigurationDecoder;
import com.android.tools.idea.res.aar.ProtoStyledStringDecoder;
import com.android.utils.XmlUtils;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarProtoResourceRepository
extends AarSourceResourceRepository {
    private static final Logger LOG = Logger.getInstance(AarProtoResourceRepository.class);
    private static final String RES_APK = "res.apk";
    private static final String RESOURCE_TABLE_ENTRY = "resources.pb";
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final String[] DIMEN_SUFFIXES = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_SUFFIXES = new String[]{"%", "%p"};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final double[] RADIX_FACTORS = new double[]{1.0, 0.0078125, 3.0517578125E-5, 1.1920928955078125E-7};
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    @NotNull
    private final File myAarDirectory;
    @Nullable
    private URI myResApkUri;
    private String myResourcePathPrefix;
    private String myResourceUrlPrefix;
    private ResourceUrlParser myUrlParser;

    private AarProtoResourceRepository(@NotNull File aarFolder, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (aarFolder == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(1);
        }
        super(new File(aarFolder, "res"), namespace, libraryName);
        this.myAarDirectory = aarFolder;
    }

    @Nullable
    public static AarProtoResourceRepository createIfProtoAar(@NotNull File aarFolder, @Nullable String libraryName) {
        if (aarFolder == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(2);
        }
        DataLoader loader = new DataLoader(aarFolder);
        try {
            loader.load();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return new AarProtoResourceRepository(aarFolder, AarProtoResourceRepository.getNamespace(loader.packageName), libraryName);
        }
        AarProtoResourceRepository repository = new AarProtoResourceRepository(aarFolder, AarProtoResourceRepository.getNamespace(loader.packageName), libraryName);
        repository.load(loader);
        return repository;
    }

    @NotNull
    private static ResourceNamespace getNamespace(@Nullable String packageName) {
        ResourceNamespace resourceNamespace = packageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName);
        if (resourceNamespace == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(3);
        }
        return resourceNamespace;
    }

    private void load(@NotNull DataLoader loader) {
        if (loader == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(4);
        }
        this.loadResourceTable(loader.resourceTableMsg);
        if (loader.loadedFromResApk) {
            try {
                File resApkFile = new File(this.myAarDirectory, RES_APK);
                this.myResApkUri = new URI("apk", resApkFile.getAbsolutePath().replace('\\', '/'), null);
            }
            catch (URISyntaxException e) {
                throw new Error("Internal error", e);
            }
            this.myResourceUrlPrefix = this.myResApkUri.toString() + ':';
        } else {
            this.myResourcePathPrefix = this.myAarDirectory.getAbsolutePath() + File.separator;
            this.myResourceUrlPrefix = "file://" + this.myResourcePathPrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceTable(@NotNull Resources.ResourceTable resourceTableMsg) {
        if (resourceTableMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(5);
        }
        HashMap<ConfigurationOuterClass.Configuration, AarConfiguration> configCache = new HashMap<ConfigurationOuterClass.Configuration, AarConfiguration>();
        this.myUrlParser = new ResourceUrlParser();
        try {
            for (Resources.Package packageMsg : resourceTableMsg.getPackageList()) {
                for (Resources.Type typeMsg : packageMsg.getTypeList()) {
                    ResourceType resourceType = ResourceType.getEnum((String)typeMsg.getName());
                    if (resourceType == null) {
                        LOG.warn("Unexpected resource type: " + typeMsg.getName());
                        continue;
                    }
                    for (Resources.Entry entryMsg : typeMsg.getEntryList()) {
                        String resourceName = entryMsg.getName();
                        Resources.Visibility visibilityMsg = entryMsg.getVisibility();
                        ResourceVisibility visibility = AarProtoResourceRepository.computeVisibility(visibilityMsg);
                        for (Resources.ConfigValue configValueMsg : entryMsg.getConfigValueList()) {
                            AarConfiguration configuration = this.getConfiguration(configValueMsg.getConfig(), configCache);
                            Resources.Value valueMsg = configValueMsg.getValue();
                            AarResourceItem item = this.createResourceItem(valueMsg, resourceType, resourceName, configuration, visibility);
                            if (item == null) continue;
                            this.addResourceItem((ResourceItem)item);
                        }
                    }
                }
            }
        }
        finally {
            this.myUrlParser = null;
        }
    }

    @Nullable
    final PathString getPathString(@Nullable String relativeResourcePath) {
        if (relativeResourcePath == null) {
            return null;
        }
        if (this.myResApkUri != null) {
            return new PathString(this.myResApkUri, relativeResourcePath);
        }
        return new PathString(this.myResourcePathPrefix + relativeResourcePath);
    }

    @Nullable
    final String getResourceUrl(@Nullable String relativeResourcePath) {
        return relativeResourcePath == null ? null : this.myResourceUrlPrefix + relativeResourcePath;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.Value valueMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (valueMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(6);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(7);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(9);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(10);
        }
        switch (valueMsg.getValueCase()) {
            case ITEM: {
                return this.createResourceItem(valueMsg.getItem(), resourceType, resourceName, configuration, visibility);
            }
            case COMPOUND_VALUE: {
                return this.createResourceItem(valueMsg.getCompoundValue(), resourceType, resourceName, configuration, visibility);
            }
        }
        LOG.warn("Unexpected Value message: " + valueMsg);
        return null;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.Item itemMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (itemMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(11);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(12);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(13);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(14);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(15);
        }
        switch (itemMsg.getValueCase()) {
            case FILE: {
                Density densityValue;
                String path = itemMsg.getFile().getPath();
                FolderConfiguration config = configuration.getFolderConfiguration();
                DensityQualifier densityQualifier = config.getDensityQualifier();
                if (densityQualifier != null && (densityValue = densityQualifier.getValue()) != null) {
                    return new AarDensityBasedFileResourceItem(resourceType, resourceName, path, densityValue, configuration, visibility);
                }
                return new AarFileResourceItem(resourceType, resourceName, path, configuration, visibility);
            }
            case REF: {
                String ref = this.decode(itemMsg.getRef());
                return this.createResourceItem(resourceType, resourceName, configuration, visibility, ref);
            }
            case STR: {
                String textValue = itemMsg.getStr().getValue();
                TextResourceValueImpl resourceValue2 = new TextResourceValueImpl(this.getNamespace(), resourceType, resourceName, textValue, null, this.getLibraryName());
                return new AarValueResourceItem((ResourceValue)resourceValue2, configuration, visibility);
            }
            case RAW_STR: {
                String str = itemMsg.getRawStr().getValue();
                return this.createResourceItem(resourceType, resourceName, configuration, visibility, str);
            }
            case PRIM: {
                String str = AarProtoResourceRepository.decode(itemMsg.getPrim());
                return this.createResourceItem(resourceType, resourceName, configuration, visibility, str);
            }
            case STYLED_STR: {
                Resources.StyledString styledStrMsg = itemMsg.getStyledStr();
                String textValue = styledStrMsg.getValue();
                String rawXmlValue = ProtoStyledStringDecoder.getRawXmlValue(styledStrMsg);
                TextResourceValueImpl resourceValue3 = new TextResourceValueImpl(this.getNamespace(), resourceType, resourceName, textValue, rawXmlValue, this.getLibraryName());
                return new AarValueResourceItem((ResourceValue)resourceValue3, configuration, visibility);
            }
            case ID: {
                ResourceValueImpl resourceValue4 = new ResourceValueImpl(this.getNamespace(), resourceType, resourceName, "", this.getLibraryName());
                return new AarValueResourceItem((ResourceValue)resourceValue4, configuration, visibility);
            }
        }
        LOG.warn("Unexpected Item message: " + itemMsg);
        return null;
    }

    @NotNull
    private AarResourceItem createResourceItem(@NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable String value) {
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(16);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(17);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(18);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(19);
        }
        ResourceValueImpl resourceValue2 = new ResourceValueImpl(this.getNamespace(), resourceType, resourceName, value, this.getLibraryName());
        AarValueResourceItem aarValueResourceItem = new AarValueResourceItem((ResourceValue)resourceValue2, configuration, visibility);
        if (aarValueResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(20);
        }
        return aarValueResourceItem;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.CompoundValue compoundValueMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        ResourceValue resourceValue2;
        if (compoundValueMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(21);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(22);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(24);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(25);
        }
        switch (compoundValueMsg.getValueCase()) {
            case ATTR: {
                resourceValue2 = this.createAttrValue(compoundValueMsg.getAttr(), resourceType, resourceName);
                break;
            }
            case STYLE: {
                resourceValue2 = this.createStyleValue(compoundValueMsg.getStyle(), resourceType, resourceName);
                break;
            }
            case STYLEABLE: {
                resourceValue2 = this.createStyleableValue(compoundValueMsg.getStyleable(), resourceName);
                break;
            }
            case ARRAY: {
                resourceValue2 = this.createArrayValue(compoundValueMsg.getArray(), resourceType, resourceName);
                break;
            }
            case PLURAL: {
                resourceValue2 = this.createPluralsValue(compoundValueMsg.getPlural(), resourceType, resourceName);
                break;
            }
            default: {
                LOG.warn("Unexpected CompoundValue message: " + compoundValueMsg);
                return null;
            }
        }
        if (resourceValue2 == null) {
            return null;
        }
        return new AarValueResourceItem(resourceValue2, configuration, visibility);
    }

    @Nullable
    private ResourceValue createAttrValue(@NotNull Resources.Attribute attributeMsg, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        if (attributeMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(26);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(27);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(28);
        }
        AttrResourceValueImpl attrValue = new AttrResourceValueImpl(this.getNamespace(), resourceType, resourceName, this.getLibraryName());
        List symbolList = attributeMsg.getSymbolList();
        if (symbolList.isEmpty() && attributeMsg.getFormatFlags() == Resources.Attribute.FormatFlags.ANY.getNumber()) {
            return null;
        }
        for (Resources.Attribute.Symbol symbolMsg : symbolList) {
            String name = symbolMsg.getName().getName();
            int slashPos = name.lastIndexOf(47);
            if (slashPos >= 0) {
                name = name.substring(slashPos + 1);
            }
            attrValue.addValue(name, Integer.valueOf(symbolMsg.getValue()));
        }
        return attrValue;
    }

    @NotNull
    private ResourceValue createStyleValue(@NotNull Resources.Style styleMsg, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        if (styleMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(29);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(30);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(31);
        }
        String parentStyle = styleMsg.getParent().getName();
        StyleResourceValueImpl styleValue = new StyleResourceValueImpl(this.getNamespace(), resourceType, resourceName, parentStyle, this.getLibraryName());
        for (Resources.Style.Entry entryMsg : styleMsg.getEntryList()) {
            String url = entryMsg.getKey().getName();
            this.myUrlParser.parseResourceUrl(url);
            String name = this.myUrlParser.withoutType();
            String value = this.decode(entryMsg.getItem());
            StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(this.getNamespace(), name, value, this.getLibraryName());
            styleValue.addItem((StyleItemResourceValue)itemValue);
        }
        StyleResourceValueImpl styleResourceValueImpl = styleValue;
        if (styleResourceValueImpl == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(32);
        }
        return styleResourceValueImpl;
    }

    @NotNull
    private ResourceValue createStyleableValue(@NotNull Resources.Styleable styleableMsg, @NotNull String resourceName) {
        if (styleableMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(33);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(34);
        }
        DeclareStyleableResourceValueImpl styleableValue = new DeclareStyleableResourceValueImpl(this.getNamespace(), ResourceType.DECLARE_STYLEABLE, resourceName, null, this.getLibraryName());
        for (Resources.Styleable.Entry entryMsg : styleableMsg.getEntryList()) {
            String url = entryMsg.getAttr().getName();
            this.myUrlParser.parseResourceUrl(url);
            String packageName = this.myUrlParser.getPackageName();
            ResourceNamespace namespace = packageName == null ? this.getNamespace() : ResourceNamespace.fromPackageName((String)packageName);
            AttrResourceValueImpl attrValue = new AttrResourceValueImpl(namespace, ResourceType.ATTR, this.myUrlParser.getName(), this.getLibraryName());
            styleableValue.addValue((AttrResourceValue)attrValue);
        }
        DeclareStyleableResourceValueImpl declareStyleableResourceValueImpl = styleableValue;
        if (declareStyleableResourceValueImpl == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(35);
        }
        return declareStyleableResourceValueImpl;
    }

    @NotNull
    private ResourceValue createArrayValue(@NotNull Resources.Array arrayMsg, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        if (arrayMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(36);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(37);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(38);
        }
        ArrayResourceValueImpl arrayValue = new ArrayResourceValueImpl(this.getNamespace(), resourceType, resourceName, this.getLibraryName());
        for (Resources.Array.Element elementMsg : arrayMsg.getElementList()) {
            String text = this.decode(elementMsg.getItem());
            if (text == null) continue;
            arrayValue.addElement(text);
        }
        ArrayResourceValueImpl arrayResourceValueImpl = arrayValue;
        if (arrayResourceValueImpl == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(39);
        }
        return arrayResourceValueImpl;
    }

    @NotNull
    private ResourceValue createPluralsValue(@NotNull Resources.Plural pluralMsg, @NotNull ResourceType resourceType, @NotNull String resourceName) {
        if (pluralMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(40);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(41);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(42);
        }
        PluralsResourceValueImpl pluralsValue = new PluralsResourceValueImpl(this.getNamespace(), resourceType, resourceName, null, this.getLibraryName());
        for (Resources.Plural.Entry entryMsg : pluralMsg.getEntryList()) {
            String value = this.decode(entryMsg.getItem());
            String quantity = AarProtoResourceRepository.getQuantity(entryMsg.getArity());
            pluralsValue.addPlural(quantity, value);
        }
        PluralsResourceValueImpl pluralsResourceValueImpl = pluralsValue;
        if (pluralsResourceValueImpl == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(43);
        }
        return pluralsResourceValueImpl;
    }

    @NotNull
    private static String getQuantity(@NotNull Resources.Plural.Arity arity) {
        if (arity == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(44);
        }
        switch (arity) {
            case ZERO: {
                if ("zero" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(45);
                }
                return "zero";
            }
            case ONE: {
                if ("one" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(46);
                }
                return "one";
            }
            case TWO: {
                if ("two" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(47);
                }
                return "two";
            }
            case FEW: {
                if ("few" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(48);
                }
                return "few";
            }
            case MANY: {
                if ("many" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(49);
                }
                return "many";
            }
        }
        if ("other" == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(50);
        }
        return "other";
    }

    @NotNull
    private static ResourceVisibility computeVisibility(@NotNull Resources.Visibility visibilityMsg) {
        if (visibilityMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(51);
        }
        switch (visibilityMsg.getLevel()) {
            case UNKNOWN: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE_XML_ONLY;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(52);
                }
                return resourceVisibility;
            }
            case PRIVATE: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(53);
                }
                return resourceVisibility;
            }
            case PUBLIC: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PUBLIC;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(54);
                }
                return resourceVisibility;
            }
        }
        ResourceVisibility resourceVisibility = ResourceVisibility.UNDEFINED;
        if (resourceVisibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(55);
        }
        return resourceVisibility;
    }

    private void addResourceItem(@NotNull ResourceItem item) {
        if (item == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(56);
        }
        ListMultimap multimap = this.getFullTable().getOrPutEmpty(this.getNamespace(), item.getType());
        multimap.put((Object)item.getName(), (Object)item);
    }

    @Nullable
    private String decode(@NotNull Resources.Item itemMsg) {
        if (itemMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(57);
        }
        switch (itemMsg.getValueCase()) {
            case REF: {
                return this.decode(itemMsg.getRef());
            }
            case STR: {
                return itemMsg.getStr().getValue();
            }
            case RAW_STR: {
                return itemMsg.getRawStr().getValue();
            }
            case STYLED_STR: {
                return itemMsg.getStyledStr().getValue();
            }
            case FILE: {
                return itemMsg.getFile().getPath();
            }
            case ID: {
                return null;
            }
            case PRIM: {
                return AarProtoResourceRepository.decode(itemMsg.getPrim());
            }
        }
        return null;
    }

    @NotNull
    private String decode(@NotNull Resources.Reference referenceMsg) {
        String name;
        if (referenceMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(58);
        }
        if ((name = referenceMsg.getName()).isEmpty()) {
            if ("@null" == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(59);
            }
            return "@null";
        }
        if (referenceMsg.getType() == Resources.Reference.Type.ATTRIBUTE) {
            this.myUrlParser.parseResourceUrl(name);
            if (this.myUrlParser.isType(ResourceType.ATTR.getName())) {
                name = this.myUrlParser.withoutType();
            }
            String string = '?' + name;
            if (string == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(60);
            }
            return string;
        }
        String string = '@' + name;
        if (string == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(61);
        }
        return string;
    }

    @Nullable
    private static String decode(@NotNull Resources.Primitive primitiveMsg) {
        if (primitiveMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(62);
        }
        switch (primitiveMsg.getOneofValueCase()) {
            case NULL_VALUE: {
                return null;
            }
            case EMPTY_VALUE: {
                return "";
            }
            case FLOAT_VALUE: {
                return XmlUtils.trimInsignificantZeros((String)Float.toString(primitiveMsg.getFloatValue()));
            }
            case DIMENSION_VALUE: {
                int bits = primitiveMsg.getDimensionValue();
                return AarProtoResourceRepository.decodeComplexDimensionValue(bits, 1.0, DIMEN_SUFFIXES);
            }
            case FRACTION_VALUE: {
                int bits = primitiveMsg.getFractionValue();
                return AarProtoResourceRepository.decodeComplexDimensionValue(bits, 100.0, FRACTION_SUFFIXES);
            }
            case INT_DECIMAL_VALUE: {
                return Integer.toString(primitiveMsg.getIntDecimalValue());
            }
            case INT_HEXADECIMAL_VALUE: {
                return String.format("0x%X", primitiveMsg.getIntHexadecimalValue());
            }
            case BOOLEAN_VALUE: {
                return Boolean.toString(primitiveMsg.getBooleanValue());
            }
            case COLOR_ARGB8_VALUE: {
                return String.format("#%08X", primitiveMsg.getColorArgb8Value());
            }
            case COLOR_RGB8_VALUE: {
                return String.format("#%06X", primitiveMsg.getColorRgb8Value() & 0xFFFFFF);
            }
            case COLOR_ARGB4_VALUE: {
                int argb = primitiveMsg.getColorArgb4Value();
                return String.format("#%X%X%X%X", argb >>> 24 & 0xF, argb >>> 16 & 0xF, argb >>> 8 & 0xF, argb & 0xF);
            }
            case COLOR_RGB4_VALUE: {
                int rgb = primitiveMsg.getColorRgb4Value();
                return String.format("#%X%X%X", rgb >>> 16 & 0xF, rgb >>> 8 & 0xF, rgb & 0xF);
            }
        }
        LOG.warn("Unexpected Primitive message: " + primitiveMsg);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeComplexDimensionValue(int bits, double scaleFactor, @NotNull String[] stringArray) {
        void unitSuffixes;
        int unitCode;
        if (stringArray == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(63);
        }
        void unit = (unitCode = bits & 0xF) < ((void)unitSuffixes).length ? unitSuffixes[unitCode] : " unknown unit: " + unitCode;
        int radix = bits >> 4 & 3;
        int mantissa = bits >> 8;
        double value = (double)mantissa * RADIX_FACTORS[radix] * scaleFactor;
        return XmlUtils.trimInsignificantZeros((String)String.format(Locale.US, "%.5g", value)) + (String)unit;
    }

    @NotNull
    private AarConfiguration getConfiguration(@NotNull ConfigurationOuterClass.Configuration configMsg, @NotNull Map<ConfigurationOuterClass.Configuration, AarConfiguration> cache) {
        AarConfiguration aarConfiguration;
        if (configMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(64);
        }
        if (cache == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(65);
        }
        if ((aarConfiguration = cache.get(configMsg)) != null) {
            AarConfiguration aarConfiguration2 = aarConfiguration;
            if (aarConfiguration2 == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(66);
            }
            return aarConfiguration2;
        }
        FolderConfiguration configuration = ProtoConfigurationDecoder.getConfiguration(configMsg);
        aarConfiguration = new AarConfiguration(this, configuration);
        cache.put(configMsg, aarConfiguration);
        AarConfiguration aarConfiguration3 = aarConfiguration;
        if (aarConfiguration3 == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(67);
        }
        return aarConfiguration3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarFolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceTableMsg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMsg";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 22: 
            case 27: 
            case 30: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 8: 
            case 13: 
            case 17: 
            case 23: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: 
            case 15: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 11: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemMsg";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundValueMsg";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeMsg";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleMsg";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableMsg";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayMsg";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluralMsg";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arity";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityMsg";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceMsg";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveMsg";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSuffixes";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configMsg";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createResourceItem";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyleValue";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyleableValue";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayValue";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluralsValue";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuantity";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVisibility";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIfProtoAar";
                break;
            }
            case 3: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceTable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createResourceItem";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createAttrValue";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createStyleValue";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createStyleableValue";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createArrayValue";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createPluralsValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getQuantity";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computeVisibility";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addResourceItem";
                break;
            }
            case 57: 
            case 58: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "decodeComplexDimensionValue";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 20: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataLoader {
        private final File aarDir;
        Resources.ResourceTable resourceTableMsg;
        String packageName;
        boolean loadedFromResApk;

        DataLoader(@NotNull File aarDir) {
            if (aarDir == null) {
                DataLoader.$$$reportNull$$$0(0);
            }
            this.aarDir = aarDir;
        }

        void load() throws IOException {
            try {
                this.resourceTableMsg = DataLoader.readResourceTableFromResourcesPbFile(this.aarDir);
                this.packageName = AndroidManifestUtils.getPackageNameFromManifestFile(this.aarDir);
            }
            catch (FileNotFoundException e) {
                File resApkFile = new File(this.aarDir, AarProtoResourceRepository.RES_APK);
                try (ZipFile zipFile = new ZipFile(resApkFile);){
                    this.resourceTableMsg = DataLoader.readResourceTableFromResApk(zipFile);
                    this.packageName = AndroidManifestUtils.getPackageNameFromResApk(zipFile);
                }
                this.loadedFromResApk = true;
            }
        }

        @Nullable
        private static Resources.ResourceTable readResourceTableFromResourcesPbFile(@NotNull File aarDir) throws IOException {
            if (aarDir == null) {
                DataLoader.$$$reportNull$$$0(1);
            }
            File file = new File(aarDir, AarProtoResourceRepository.RESOURCE_TABLE_ENTRY);
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)stream);
                return resourceTable;
            }
        }

        @NotNull
        private static Resources.ResourceTable readResourceTableFromResApk(@NotNull ZipFile resApk) throws IOException {
            Resources.ResourceTable resourceTable;
            ZipEntry zipEntry;
            if (resApk == null) {
                DataLoader.$$$reportNull$$$0(2);
            }
            if ((zipEntry = resApk.getEntry(AarProtoResourceRepository.RESOURCE_TABLE_ENTRY)) == null) {
                throw new IOException("\"resources.pb\" not found in " + resApk.getName());
            }
            try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
                Resources.ResourceTable resourceTable2 = Resources.ResourceTable.parseFrom((InputStream)stream);
                resourceTable = resourceTable2;
            }
            if (resourceTable == null) {
                DataLoader.$$$reportNull$$$0(3);
            }
            return resourceTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aarDir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resApk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$DataLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$DataLoader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readResourceTableFromResApk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "readResourceTableFromResourcesPbFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "readResourceTableFromResApk";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourceUrlParser {
        @NotNull
        String resourceUrl = "";
        int prefixEnd;
        int colonPos;
        int slashPos;

        private ResourceUrlParser() {
        }

        void parseResourceUrl(@NotNull String resourceUrl) {
            if (resourceUrl == null) {
                ResourceUrlParser.$$$reportNull$$$0(0);
            }
            this.resourceUrl = resourceUrl;
            this.prefixEnd = resourceUrl.startsWith("@") ? (resourceUrl.startsWith("@+") ? 2 : 1) : (resourceUrl.startsWith("?") ? 1 : 0);
            this.slashPos = resourceUrl.lastIndexOf(47);
            this.colonPos = this.slashPos >= 0 ? resourceUrl.lastIndexOf(58, this.slashPos) : resourceUrl.lastIndexOf(58);
        }

        @Nullable
        String getPackageName() {
            return this.colonPos > this.prefixEnd ? this.resourceUrl.substring(this.prefixEnd, this.colonPos) : null;
        }

        int getTypeStart() {
            return this.colonPos >= 0 ? this.colonPos + 1 : this.prefixEnd;
        }

        boolean isType(@NotNull String type) {
            if (type == null) {
                ResourceUrlParser.$$$reportNull$$$0(1);
            }
            if (this.slashPos < 0) {
                return false;
            }
            int typeStart = this.getTypeStart();
            return this.resourceUrl.startsWith(type) && this.slashPos == typeStart + type.length();
        }

        @NotNull
        String getName() {
            int nameStart = this.slashPos >= 0 ? this.slashPos + 1 : (this.colonPos >= 0 ? this.colonPos + 1 : this.prefixEnd);
            String string = this.resourceUrl.substring(nameStart);
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String withoutType() {
            if (this.slashPos < 0) {
                String string = this.resourceUrl;
                if (string == null) {
                    ResourceUrlParser.$$$reportNull$$$0(3);
                }
                return string;
            }
            int typeStart = this.getTypeStart();
            if (typeStart == 0) {
                String string = this.resourceUrl.substring(this.slashPos + 1);
                if (string == null) {
                    ResourceUrlParser.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.resourceUrl.substring(0, typeStart) + this.resourceUrl.substring(this.slashPos + 1);
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$ResourceUrlParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$ResourceUrlParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withoutType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parseResourceUrl";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

