/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.builder.model.AaptOptions;
import com.android.tools.idea.res.aar.AarProtoResourceRepository;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AarResourceRepositoryCache {
    private final Cache<File, AarSourceResourceRepository> myNamespacedCache = CacheBuilder.newBuilder().softValues().build();
    private final Cache<File, AarSourceResourceRepository> myNonnamespacedCache = CacheBuilder.newBuilder().softValues().build();

    public static AarResourceRepositoryCache getInstance() {
        return (AarResourceRepositoryCache)ServiceManager.getService(AarResourceRepositoryCache.class);
    }

    @NotNull
    public AarSourceResourceRepository get(@NotNull File aarDirectory, @NotNull AaptOptions.Namespacing namespacing, @Nullable String libraryName) {
        AarSourceResourceRepository aarRepository;
        if (aarDirectory == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(0);
        }
        if (namespacing == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(1);
        }
        Cache<File, AarSourceResourceRepository> cache = namespacing == AaptOptions.Namespacing.REQUIRED ? this.myNamespacedCache : this.myNonnamespacedCache;
        AarSourceResourceRepository aarSourceResourceRepository = aarRepository = (AarSourceResourceRepository)((Object)CacheUtils.getAndUnwrap(cache, (Object)aarDirectory, () -> {
            AarSourceResourceRepository repository;
            if (namespacing == null) {
                AarResourceRepositoryCache.$$$reportNull$$$0(4);
            }
            if (aarDirectory == null) {
                AarResourceRepositoryCache.$$$reportNull$$$0(5);
            }
            AarProtoResourceRepository aarProtoResourceRepository = repository = namespacing == AaptOptions.Namespacing.REQUIRED ? AarProtoResourceRepository.createIfProtoAar(aarDirectory, libraryName) : null;
            if (repository == null) {
                if (namespacing == AaptOptions.Namespacing.REQUIRED) {
                    Logger.getInstance(AarResourceRepositoryCache.class).warn("Failed to load AAR proto repository from " + aarDirectory);
                }
                repository = AarSourceResourceRepository.create(aarDirectory, libraryName);
            }
            return repository;
        }));
        if (aarSourceResourceRepository == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(2);
        }
        return aarSourceResourceRepository;
    }

    public void remove(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            AarResourceRepositoryCache.$$$reportNull$$$0(3);
        }
        this.myNamespacedCache.invalidate((Object)aarDirectory);
        this.myNonnamespacedCache.invalidate((Object)aarDirectory);
    }

    public void clear() {
        this.myNamespacedCache.invalidateAll();
        this.myNonnamespacedCache.invalidateAll();
    }

    private AarResourceRepositoryCache() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDirectory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarResourceRepositoryCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarResourceRepositoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$get$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

