/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.resourceExplorer.editor.ResourceExplorer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourceExplorerToolFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/util/Condition;", "", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "shouldBeAvailable", "", "kotlin.jvm.PlatformType", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "value", "o", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "MyFileEditorListener", "intellij.android.core"})
public final class ResourceExplorerToolFactory
implements ToolWindowFactory,
DumbAware,
Condition<Object> {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorListener(project, toolWindow));
    }

    public Boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get();
    }

    public Boolean value(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return (Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourceExplorerToolFactory$MyFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "currentModule", "Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "editorFocused", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "fileClosed", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.android.core"})
    public static final class MyFileEditorListener
    implements FileEditorManagerListener {
        private Module currentModule;
        @NotNull
        private final Project project;
        @NotNull
        private final ToolWindow toolWindow;

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            FileEditor editor;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            FileEditor fileEditor = event.getNewEditor();
            if (fileEditor == null) {
                return;
            }
            FileEditor fileEditor2 = editor = fileEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor2, (String)"editor");
            this.editorFocused(fileEditor2, this.toolWindow, this.project);
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            FileEditor fileEditor = source.getSelectedEditor(file);
            if (fileEditor == null) {
                return;
            }
            this.editorFocused(fileEditor, this.toolWindow, this.project);
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.toolWindow.getContentManager().removeAllContents(true);
            this.currentModule = null;
        }

        private final void editorFocused(FileEditor editor, ToolWindow toolWindow, Project project) {
            block3: {
                AndroidFacet androidFacet;
                VirtualFile virtualFile = editor.getFile();
                if (virtualFile == null) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                if (module == null || Intrinsics.areEqual((Object)module, (Object)this.currentModule)) {
                    return;
                }
                this.currentModule = module;
                Object object = AndroidFacet.getInstance(module);
                if (object == null) break block3;
                AndroidFacet it = androidFacet = object;
                Disposable disposable = (Disposable)editor;
                AndroidFacet androidFacet2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet2), (String)"it");
                object = ResourceExplorer.Companion.createForToolWindow(disposable, androidFacet2);
                if (object != null) {
                    it = androidFacet = object;
                    ContentManager contentManager = toolWindow.getContentManager();
                    contentManager.removeAllContents(true);
                    ContentManager contentManager2 = contentManager;
                    Intrinsics.checkExpressionValueIsNotNull((Object)contentManager2, (String)"contentManager");
                    Content content = contentManager2.getFactory().createContent((JComponent)((Object)it), "Resource Explorer", false);
                    contentManager.addContent(content);
                }
            }
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        public MyFileEditorListener(@NotNull Project project, @NotNull ToolWindow toolWindow) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
            this.project = project;
            this.toolWindow = toolWindow;
        }
    }
}

