/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.plugin;

import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRenderer;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/resourceExplorer/plugin/SVGAssetRenderer;", "Lcom/android/tools/idea/resourceExplorer/plugin/DesignAssetRenderer;", "()V", "getImage", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "dimension", "Ljava/awt/Dimension;", "isFileSupported", "", "logFileNotSupported", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "SVGLoader", "intellij.android.core"})
public final class SVGAssetRenderer
implements DesignAssetRenderer {
    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return StringsKt.equals((String)"svg", (String)file.getExtension(), (boolean)true);
    }

    @Override
    @NotNull
    public ListenableFuture<? extends Image> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dimension2, (String)"dimension");
        ListenableFuture listenableFuture = JdkFutureAdapters.listenInPoolThread((Future)ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<BufferedImage>(this, file, dimension2){
            final /* synthetic */ SVGAssetRenderer this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Dimension $dimension;

            @Nullable
            public final BufferedImage call() {
                BufferedImage bufferedImage;
                try {
                    InputStream inputStream = this.$file.getInputStream();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
                    bufferedImage = new SVGLoader(inputStream, this.$dimension.height, this.$dimension.width).createImage$intellij_android_core();
                }
                catch (SAXParseException saxParserException) {
                    SVGAssetRenderer.access$logFileNotSupported(this.this$0, this.$file, saxParserException);
                    bufferedImage = null;
                }
                catch (IOException saxIOException) {
                    SVGAssetRenderer.access$logFileNotSupported(this.this$0, this.$file, saxIOException);
                    bufferedImage = null;
                }
                return bufferedImage;
            }
            {
                this.this$0 = sVGAssetRenderer;
                this.$file = virtualFile;
                this.$dimension = dimension2;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"JdkFutureAdapters.listen\u2026       }\n        })\n    )");
        return listenableFuture;
    }

    private final void logFileNotSupported(VirtualFile file, Exception ex) {
        Logger.getInstance(SVGAssetRenderer.class).warn("" + file.getPath() + " content is not supported by the SVG Loader\n " + ex.getLocalizedMessage());
    }

    public static final /* synthetic */ void access$logFileNotSupported(SVGAssetRenderer $this, @NotNull VirtualFile file, @NotNull Exception ex) {
        $this.logFileNotSupported(file, ex);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0002\b\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/resourceExplorer/plugin/SVGAssetRenderer$SVGLoader;", "", "inputStream", "Ljava/io/InputStream;", "width", "", "height", "(Ljava/io/InputStream;II)V", "img", "Ljava/awt/image/BufferedImage;", "transcoderInput", "Lorg/apache/batik/transcoder/TranscoderInput;", "createImage", "createImage$intellij_android_core", "MyTranscoder", "intellij.android.core"})
    private static final class SVGLoader {
        private BufferedImage img;
        private final TranscoderInput transcoderInput;
        private final int width;
        private final int height;

        @Nullable
        public final BufferedImage createImage$intellij_android_core() throws TranscoderException {
            MyTranscoder transcoder = new MyTranscoder();
            transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, Float.valueOf(this.width));
            transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, Float.valueOf(this.height));
            transcoder.transcode(this.transcoderInput, null);
            return this.img;
        }

        public SVGLoader(@NotNull InputStream inputStream, int width, int height) {
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            this.width = width;
            this.height = height;
            this.transcoderInput = new TranscoderInput(new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(null, inputStream));
        }

        @Nullable
        public static final /* synthetic */ BufferedImage access$getImg$p(SVGLoader $this) {
            return $this.img;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0017\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/resourceExplorer/plugin/SVGAssetRenderer$SVGLoader$MyTranscoder;", "Lorg/apache/batik/transcoder/image/ImageTranscoder;", "(Lcom/android/tools/idea/resourceExplorer/plugin/SVGAssetRenderer$SVGLoader;)V", "createImage", "Ljava/awt/image/BufferedImage;", "w", "", "h", "writeImage", "", "img", "output", "Lorg/apache/batik/transcoder/TranscoderOutput;", "intellij.android.core"})
        private final class MyTranscoder
        extends ImageTranscoder {
            @NotNull
            public BufferedImage createImage(int w, int h) {
                BufferedImage bufferedImage = UIUtil.createImage((int)w, (int)h, (int)2);
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"UIUtil.createImage(w, h,\u2026feredImage.TYPE_INT_ARGB)");
                return bufferedImage;
            }

            public void writeImage(@NotNull BufferedImage img, @Nullable TranscoderOutput output) throws TranscoderException {
                Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
                SVGLoader.this.img = img;
            }
        }
    }
}

