/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.view;

import com.android.resources.ResourceType;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.view.ColorResourceCellRenderer;
import com.android.tools.idea.resourceExplorer.view.DesignAssetCellRenderer;
import com.android.tools.idea.resourceExplorer.view.DrawableResourceCellRenderer;
import com.android.tools.idea.resourceExplorer.view.ModuleResourceBrowser;
import com.android.tools.idea.resourceExplorer.view.ModuleResourceBrowserKt;
import com.android.tools.idea.resourceExplorer.viewmodel.ModuleResourcesBrowserViewModel;
import com.android.tools.idea.resourceExplorer.widget.Section;
import com.android.tools.idea.resourceExplorer.widget.SectionList;
import com.android.tools.idea.resourceExplorer.widget.SectionListModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u001c\u0010\u001f\u001a\u00020\u0014\"\b\b\u0000\u0010 *\u00020!*\b\u0012\u0004\u0012\u0002H 0\u0017H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/ModuleResourceBrowser;", "Ljavax/swing/JPanel;", "resourcesBrowserViewModel", "Lcom/android/tools/idea/resourceExplorer/viewmodel/ModuleResourcesBrowserViewModel;", "(Lcom/android/tools/idea/resourceExplorer/viewmodel/ModuleResourcesBrowserViewModel;)V", "value", "", "cellWidth", "getCellWidth", "()I", "setCellWidth", "(I)V", "listeners", "", "Lcom/android/tools/idea/resourceExplorer/view/ModuleResourceBrowser$SelectionListener;", "sectionList", "Lcom/android/tools/idea/resourceExplorer/widget/SectionList;", "sectionListModel", "Lcom/android/tools/idea/resourceExplorer/widget/SectionListModel;", "addSelectionListener", "", "listener", "createColorList", "Ljavax/swing/JList;", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "createDrawableList", "createSectionListCellRenderer", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/resourceExplorer/widget/Section;", "populateSectionListModel", "removeSelectionListener", "setupListUI", "T", "", "AssetSection", "SelectionListener", "intellij.android.core"})
public final class ModuleResourceBrowser
extends JPanel {
    private int cellWidth;
    private final List<SelectionListener> listeners;
    private final SectionListModel sectionListModel;
    private final SectionList sectionList;
    private final ModuleResourcesBrowserViewModel resourcesBrowserViewModel;

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final void setCellWidth(int value) {
        this.cellWidth = value;
        Iterable $receiver$iv = this.sectionList.getLists();
        for (Object element$iv : $receiver$iv) {
            JList it = (JList)element$iv;
            this.setupListUI(it);
        }
    }

    private final JList<DesignAssetSet> createColorList() {
        JList<DesignAssetSet> jList;
        JList<DesignAssetSet> $receiver = jList = new JList<DesignAssetSet>();
        $receiver.setModel((ListModel)new CollectionListModel(this.resourcesBrowserViewModel.getResourceValues(ResourceType.COLOR)));
        Module module = this.resourcesBrowserViewModel.getFacet().getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"resourcesBrowserViewModel.facet.module");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"resourcesBrowserViewModel.facet.module.project");
        $receiver.setCellRenderer(new ColorResourceCellRenderer(project, this.resourcesBrowserViewModel.getResourceResolver()));
        this.setupListUI($receiver);
        return jList;
    }

    private final JList<DesignAssetSet> createDrawableList() {
        JList<DesignAssetSet> jList;
        JList<DesignAssetSet> $receiver = jList = new JList<DesignAssetSet>();
        $receiver.setModel((ListModel)new CollectionListModel(this.resourcesBrowserViewModel.getResourceValues(ResourceType.DRAWABLE)));
        $receiver.setCellRenderer(new DrawableResourceCellRenderer(this.resourcesBrowserViewModel, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>($receiver){
            final /* synthetic */ JList receiver$0;

            public final void invoke(int $noName_0) {
                this.receiver$0.repaint();
            }
            {
                this.receiver$0 = jList;
                super(1);
            }
        })));
        this.setupListUI($receiver);
        return jList;
    }

    private final void populateSectionListModel() {
        this.sectionListModel.addSection((Section)new AssetSection<DesignAssetSet>("Drawable", this.createDrawableList()));
        this.sectionListModel.addSection((Section)new AssetSection<DesignAssetSet>("Colors", this.createColorList()));
    }

    private final ListCellRenderer<Section<?>> createSectionListCellRenderer() {
        return createSectionListCellRenderer.1.INSTANCE;
    }

    public final void addSelectionListener(@NotNull SelectionListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Collection collection = this.listeners;
        collection.add(listener2);
    }

    public final void removeSelectionListener(@NotNull SelectionListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Collection collection = this.listeners;
        collection.remove(listener2);
    }

    private final <T> void setupListUI(@NotNull JList<T> $receiver) {
        $receiver.setFixedCellWidth(this.cellWidth);
        $receiver.setFixedCellHeight((int)((float)$receiver.getFixedCellWidth() * 0.75f));
        $receiver.setLayoutOrientation(2);
        $receiver.setVisibleRowCount(0);
        ListCellRenderer<T> renderer = $receiver.getCellRenderer();
        if (renderer instanceof DesignAssetCellRenderer) {
            ((DesignAssetCellRenderer)renderer).setUseSmallMargins(this.cellWidth < 150);
        }
    }

    public ModuleResourceBrowser(@NotNull ModuleResourcesBrowserViewModel resourcesBrowserViewModel) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)resourcesBrowserViewModel, (String)"resourcesBrowserViewModel");
        super(new BorderLayout());
        this.resourcesBrowserViewModel = resourcesBrowserViewModel;
        this.cellWidth = 300;
        ModuleResourceBrowser moduleResourceBrowser = this;
        moduleResourceBrowser.listeners = list = (List)new ArrayList();
        this.sectionListModel = new SectionListModel();
        this.sectionList = new SectionList(this.sectionListModel);
        this.sectionList.setSectionListCellRenderer(this.createSectionListCellRenderer());
        this.populateSectionListModel();
        JBScrollPane mainComponent = this.sectionList.getMainComponent();
        mainComponent.setBorder(JBUI.Borders.empty((int)8));
        this.add((Component)mainComponent);
        JBList<Section<?>> sections = this.sectionList.getSectionsComponent();
        sections.setPreferredSize((Dimension)JBUI.size((int)132, (int)-1));
        sections.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)0, (int)1));
        this.add((Component)sections, "West");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/ModuleResourceBrowser$SelectionListener;", "", "onDesignAssetSetSelected", "", "designAssetSet", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "intellij.android.core"})
    public static interface SelectionListener {
        public void onDesignAssetSetSelected(@Nullable DesignAssetSet var1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\tH\u0002R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/ModuleResourceBrowser$AssetSection;", "T", "Lcom/android/tools/idea/resourceExplorer/widget/Section;", "name", "", "list", "Ljavax/swing/JList;", "(Ljava/lang/String;Ljavax/swing/JList;)V", "header", "Ljavax/swing/JComponent;", "getHeader", "()Ljavax/swing/JComponent;", "setHeader", "(Ljavax/swing/JComponent;)V", "getList", "()Ljavax/swing/JList;", "setList", "(Ljavax/swing/JList;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "createHeaderComponent", "intellij.android.core"})
    public static final class AssetSection<T>
    implements Section<T> {
        @NotNull
        private JComponent header;
        @NotNull
        private String name;
        @NotNull
        private JList<T> list;

        @Override
        @NotNull
        public JComponent getHeader() {
            return this.header;
        }

        @Override
        public void setHeader(@NotNull JComponent jComponent) {
            Intrinsics.checkParameterIsNotNull((Object)jComponent, (String)"<set-?>");
            this.header = jComponent;
        }

        private final JComponent createHeaderComponent() {
            JPanel jPanel;
            JPanel $receiver = jPanel = new JPanel(new BorderLayout());
            JBLabel nameLabel = new JBLabel(this.getName());
            nameLabel.setFont(nameLabel.getFont().deriveFont(24.0f));
            ListModel<T> listModel2 = this.getList().getModel();
            Intrinsics.checkExpressionValueIsNotNull(listModel2, (String)"list.model");
            JBLabel countLabel = new JBLabel(String.valueOf(listModel2.getSize()));
            countLabel.setForeground((Color)ModuleResourceBrowserKt.access$getSECTION_HEADER_SECONDARY_COLOR$p());
            $receiver.add((Component)nameLabel);
            $receiver.add((Component)countLabel, "East");
            $receiver.setBorder(ModuleResourceBrowserKt.access$getSECTION_HEADER_BORDER$p());
            return jPanel;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Override
        @NotNull
        public JList<T> getList() {
            return this.list;
        }

        @Override
        public void setList(@NotNull JList<T> jList) {
            Intrinsics.checkParameterIsNotNull(jList, (String)"<set-?>");
            this.list = jList;
        }

        public AssetSection(@NotNull String name, @NotNull JList<T> list) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            this.name = name;
            this.list = list;
            this.header = this.createHeaderComponent();
        }
    }
}

