/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.viewmodel;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationManager;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRendererManager;
import com.android.tools.idea.resourceExplorer.viewmodel.ModuleResourcesBrowserViewModelKt;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\nH\u0002J \u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/resourceExplorer/viewmodel/ModuleResourcesBrowserViewModel;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "synchronizationManager", "Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationManager;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationManager;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "getResourceResolver", "()Lcom/android/ide/common/resources/ResourceResolver;", "createResourceResolver", "getDrawablePreview", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "dimension", "Ljava/awt/Dimension;", "designAssetSet", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "getLibrariesResources", "", "Lcom/android/ide/common/resources/ResourceItem;", "type", "Lcom/android/resources/ResourceType;", "getModuleResources", "getResourceValues", "resolveValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "intellij.android.core"})
public final class ModuleResourcesBrowserViewModel {
    @NotNull
    private final ResourceResolver resourceResolver;
    @NotNull
    private final AndroidFacet facet;

    @NotNull
    public final ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @NotNull
    public final ListenableFuture<? extends Image> getDrawablePreview(@NotNull Dimension dimension2, @NotNull DesignAssetSet designAssetSet) {
        Intrinsics.checkParameterIsNotNull((Object)dimension2, (String)"dimension");
        Intrinsics.checkParameterIsNotNull((Object)designAssetSet, (String)"designAssetSet");
        ResourceValue resourceValue2 = this.resolveValue(designAssetSet);
        if (resourceValue2 == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return listenableFuture;
        }
        ResourceValue resolveValue = resourceValue2;
        RenderResources renderResources = (RenderResources)this.resourceResolver;
        Module module = this.facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"facet.module.project");
        VirtualFile virtualFile = ResourceHelper.resolveDrawableAsVirtualFile(renderResources, resolveValue, project);
        if (virtualFile == null) {
            virtualFile = designAssetSet.getHighestDensityAsset().getFile();
        }
        VirtualFile file = virtualFile;
        return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DesignAssetSet> getResourceValues(@NotNull ResourceType type) {
        Object object;
        DesignAsset it;
        Object object2;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Object $receiver$iv = CollectionsKt.plus((Collection)this.getModuleResources(type), (Iterable)this.getLibrariesResources(type));
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Object object3 = $receiver$iv$iv.iterator();
        while (object3.hasNext()) {
            Object item$iv$iv = object3.next();
            ResourceItem resourceItem = (ResourceItem)item$iv$iv;
            object2 = destination$iv$iv;
            object = new DesignAsset((ResourceItem)it);
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object3 = $receiver$iv$iv.iterator();
        while (object3.hasNext()) {
            Object object4;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object3.next();
            it = (DesignAsset)element$iv$iv;
            String key$iv$iv = it.getName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object3 = $receiver$iv$iv;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            void $name_assets;
            Map.Entry item$iv$iv;
            Map.Entry $i$a$2$groupBy = item$iv$iv = iterator.next();
            object2 = destination$iv$iv;
            void var9_10 = $name_assets;
            String name = (String)var9_10.getKey();
            var9_10 = $name_assets;
            List assets = (List)var9_10.getValue();
            object = new DesignAssetSet(name, assets);
            object2.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceItem> getModuleResources(ResourceType type) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        LocalResourceRepository moduleRepository;
        LocalResourceRepository localResourceRepository = moduleRepository = ResourceRepositoryManager.getModuleResources(this.facet);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"moduleRepository");
        Set set = localResourceRepository.getNamespaces();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"moduleRepository.namespaces");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            ResourceNamespace namespace = (ResourceNamespace)element$iv$iv;
            Collection collection = moduleRepository.getItemsOfType(namespace, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"moduleRepository.getItemsOfType(namespace, type)");
            Iterable iterable2 = collection;
            void var10_10 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                String resourceItem = (String)element$iv$iv2;
                Iterable list$iv$iv = moduleRepository.getResourceItems(namespace, type, resourceItem);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceItem> getLibrariesResources(ResourceType type) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ResourceRepositoryManager repoManager;
        ResourceRepositoryManager resourceRepositoryManager = repoManager = ResourceRepositoryManager.getOrCreateInstance(this.facet);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceRepositoryManager, (String)"repoManager");
        List<? extends LocalResourceRepository> list = resourceRepositoryManager.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"repoManager.libraries");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            LocalResourceRepository lib;
            LocalResourceRepository localResourceRepository = lib = (LocalResourceRepository)((Object)element$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)localResourceRepository), (String)"lib");
            Set set = localResourceRepository.getNamespaces();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lib.namespaces");
            Iterable iterable2 = $receiver$iv2 = (Iterable)set;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                void $receiver$iv$iv3;
                void $receiver$iv3;
                ResourceNamespace namespace = (ResourceNamespace)element$iv$iv2;
                Collection collection = lib.getItemsOfType(namespace, type);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"lib.getItemsOfType(namespace, type)");
                Iterable iterable3 = collection;
                void var16_16 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                for (Object element$iv$iv3 : $receiver$iv$iv3) {
                    String resourceItem = (String)element$iv$iv3;
                    Iterable list$iv$iv = lib.getResourceItems(namespace, type, resourceItem);
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ResourceResolver createResourceResolver() {
        MergedManifest manifest;
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(this.facet);
        MergedManifest mergedManifest = manifest = MergedManifest.get(this.facet);
        Intrinsics.checkExpressionValueIsNotNull((Object)mergedManifest, (String)"manifest");
        String string = mergedManifest.getManifestTheme();
        if (string == null) {
            string = manifest.getDefaultTheme(null, null, null);
        }
        String theme = string;
        ResourceResolverCache resourceResolverCache = new ResourceResolverCache(configurationManager);
        ConfigurationManager configurationManager2 = configurationManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationManager2, (String)"configurationManager");
        ResourceResolver resourceResolver = resourceResolverCache.getResourceResolver(configurationManager2.getTarget(), theme, FolderConfiguration.createDefault());
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceResolver, (String)"ResourceResolverCache(co\u2026ion.createDefault()\n    )");
        return resourceResolver;
    }

    private final ResourceValue resolveValue(@NotNull DesignAssetSet $receiver) {
        ResourceItem resourceItem = $receiver.getHighestDensityAsset().getResourceItem();
        ResourceValue resolvedValue = this.resourceResolver.resolveResValue(resourceItem.getResourceValue());
        if (resolvedValue == null) {
            ModuleResourcesBrowserViewModelKt.access$getLOG$p().warn("" + resourceItem.getName() + " couldn't be resolved");
        }
        return resolvedValue;
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public ModuleResourcesBrowserViewModel(@NotNull AndroidFacet facet, @NotNull SynchronizationManager synchronizationManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)synchronizationManager, (String)"synchronizationManager");
        this.facet = facet;
        this.resourceResolver = this.createResourceResolver();
    }
}

