/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetChooser {
    private static final Logger LOG = Logger.getInstance(EmulatorTargetChooser.class);
    private final String myAvd;
    @NotNull
    private final AndroidFacet myFacet;

    public EmulatorTargetChooser(@NotNull AndroidFacet facet, @Nullable String avd) {
        if (facet == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        assert (avd == null || !avd.isEmpty());
        this.myAvd = avd;
    }

    @Nullable
    public DeviceFutures getDevices(@NotNull DeviceCount deviceCount) {
        String avd;
        TargetDeviceFilter.EmulatorFilter deviceFilter;
        Collection<IDevice> runningDevices;
        if (deviceCount == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(1);
        }
        if ((runningDevices = DeviceSelectionUtils.chooseRunningDevice(this.myFacet, deviceFilter = new TargetDeviceFilter.EmulatorFilter(this.myFacet, this.myAvd), deviceCount)) == null) {
            return null;
        }
        if (!runningDevices.isEmpty()) {
            return DeviceFutures.forDevices(runningDevices);
        }
        String string = avd = this.myAvd != null ? this.myAvd : this.chooseAvd();
        if (avd == null) {
            return null;
        }
        AvdManager manager = AvdManagerUtils.getAvdManagerSilently(this.myFacet);
        if (manager == null) {
            LOG.warn("Could not obtain AVD Manager.");
            return null;
        }
        AvdInfo avdInfo = manager.getAvd(avd, true);
        if (avdInfo == null) {
            LOG.warn("Unable to obtain info for AVD: " + avd);
            return null;
        }
        LaunchableAndroidDevice androidDevice = new LaunchableAndroidDevice(avdInfo);
        androidDevice.launch(this.myFacet.getModule().getProject());
        return new DeviceFutures(Collections.singletonList(androidDevice));
    }

    @Nullable
    private String chooseAvd() {
        AvdManager manager;
        IAndroidTarget buildTarget = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidTarget();
        assert (buildTarget != null);
        List<AvdInfo> avds = EmulatorTargetChooser.getValidCompatibleAvds(this.myFacet);
        if (!avds.isEmpty()) {
            return avds.get(0).getName();
        }
        Project project = this.myFacet.getModule().getProject();
        try {
            manager = AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(this.myFacet), (ILogger)new AvdManagerLog(){

                @Override
                public void error(Throwable t, String errorFormat, Object ... args) {
                    super.error(t, errorFormat, args);
                    if (errorFormat != null) {
                        String msg = String.format(errorFormat, args);
                        LOG.error(msg);
                    }
                }
            });
        }
        catch (AndroidLocation.AndroidLocationException e) {
            LOG.info((Throwable)e);
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle()));
            return null;
        }
        AvdManager finalManager = manager;
        assert (finalManager != null);
        return (String)UIUtil.invokeAndWaitIfNeeded(() -> {
            AvdOptionsModel avdOptionsModel;
            ModelWizardDialog dialog;
            int result2 = Messages.showDialog((Project)project, (String)"To run using the emulator, you must have an AVD defined.", (String)"Define AVD", (String[])new String[]{"Cancel", "Create AVD"}, (int)1, null);
            AvdInfo createdAvd = null;
            if (result2 == 1 && (dialog = AvdWizardUtils.createAvdWizard(null, project, avdOptionsModel = new AvdOptionsModel(null))).showAndGet()) {
                createdAvd = avdOptionsModel.getCreatedAvd();
            }
            return createdAvd == null ? null : createdAvd.getName();
        });
    }

    @NotNull
    private static List<AvdInfo> getValidCompatibleAvds(@NotNull AndroidFacet facet) {
        AvdManager manager;
        if (facet == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(2);
        }
        if ((manager = AvdManagerUtils.getAvdManagerSilently(facet)) == null || !AvdManagerUtils.reloadAvds(manager, facet.getModule().getProject())) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(3);
            }
            return immutableList;
        }
        AndroidVersion minSdk = AndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            Logger.getInstance(EmulatorTargetChooser.class).error("Android Platform not set for module: " + facet.getModule().getName());
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        List<AvdInfo> list = EmulatorTargetChooser.getCompatibleAvds(manager.getValidAvds(), minSdk, platform);
        if (list == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<AvdInfo> getCompatibleAvds(@NotNull AvdInfo[] allAvds, @NotNull AndroidVersion minSdk, @NotNull AndroidPlatform platform) {
        if (allAvds == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(6);
        }
        if (minSdk == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(7);
        }
        if (platform == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(8);
        }
        List<AvdInfo> list = Arrays.stream(allAvds).filter(info -> {
            ISystemImage systemImage;
            if (minSdk == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(15);
            }
            if (platform == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(16);
            }
            return (systemImage = info.getSystemImage()) != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), systemImage).isCompatible() != ThreeState.NO;
        }).collect(Collectors.toList());
        if (list == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<ValidationError> validate() {
        if (this.myAvd == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(10);
            }
            return immutableList;
        }
        AvdManager avdManager = AvdManagerUtils.getAvdManagerSilently(this.myFacet);
        if (avdManager == null) {
            ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(11);
            }
            return immutableList;
        }
        AvdInfo avdInfo = avdManager.getAvd(this.myAvd, false);
        if (avdInfo == null) {
            ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.myAvd)));
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(12);
            }
            return immutableList;
        }
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            String message = avdInfo.getErrorMessage();
            message = AndroidBundle.message("avd.not.valid.error", this.myAvd) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
            ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message));
            if (immutableList == null) {
                EmulatorTargetChooser.$$$reportNull$$$0(13);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            EmulatorTargetChooser.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCount";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/EmulatorTargetChooser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allAvds";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdk";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/EmulatorTargetChooser";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidCompatibleAvds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibleAvds";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDevices";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValidCompatibleAvds";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleAvds";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompatibleAvds$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

