/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.RetryingInstallerResult;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullApkInstaller {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LaunchOptions myLaunchOptions;
    @NotNull
    private final InstalledApkCache myInstalledApkCache;
    @NotNull
    private final ConsolePrinter myPrinter;

    public FullApkInstaller(@NotNull Project project, @NotNull LaunchOptions options, @NotNull InstalledApkCache installedApkCache, @NotNull ConsolePrinter printer) {
        if (project == null) {
            FullApkInstaller.$$$reportNull$$$0(0);
        }
        if (options == null) {
            FullApkInstaller.$$$reportNull$$$0(1);
        }
        if (installedApkCache == null) {
            FullApkInstaller.$$$reportNull$$$0(2);
        }
        if (printer == null) {
            FullApkInstaller.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myLaunchOptions = options;
        this.myInstalledApkCache = installedApkCache;
        this.myPrinter = printer;
    }

    public boolean uploadAndInstallApk(@NotNull IDevice device, @NotNull String packageName, @NotNull File localFile, @NotNull LaunchStatus launchStatus) {
        if (device == null) {
            FullApkInstaller.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            FullApkInstaller.$$$reportNull$$$0(5);
        }
        if (localFile == null) {
            FullApkInstaller.$$$reportNull$$$0(6);
        }
        if (launchStatus == null) {
            FullApkInstaller.$$$reportNull$$$0(7);
        }
        if (!this.needsInstall(device, localFile, packageName)) {
            return true;
        }
        String remotePath = "/data/local/tmp/" + packageName;
        this.myPrinter.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            this.myPrinter.stderr(e.toString());
            return false;
        }
        String pmInstallOptions = this.getPmInstallOptions(device);
        ApkInstaller installer = new ApkInstaller(this.myPrinter, remotePath, pmInstallOptions);
        RetryingInstaller retryingInstaller = new RetryingInstaller(this.myProject, device, installer, packageName, this.myPrinter, launchStatus);
        RetryingInstallerResult installResult = retryingInstaller.install();
        if (installResult.isSuccess()) {
            this.myPrinter.stdout(String.format("APK installed in %s", StringUtil.formatDuration((long)installResult.getLastInstallDuration().toMillis())));
            try {
                this.myInstalledApkCache.setInstalled(device, localFile, packageName);
            }
            catch (IOException e) {
                Logger.getInstance(FullApkInstaller.class).info("Exception while caching installation state: ", (Throwable)e);
            }
        }
        return installResult.isSuccess();
    }

    String getPmInstallOptions(@NotNull IDevice device) {
        if (device == null) {
            FullApkInstaller.$$$reportNull$$$0(8);
        }
        String pmInstallOptions = this.myLaunchOptions.getPmInstallOptions();
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            pmInstallOptions = StringUtil.trimLeading((String)(StringUtil.notNullize((String)pmInstallOptions) + " -g"));
        }
        return pmInstallOptions;
    }

    boolean needsInstall(@NotNull IDevice device, @NotNull File localFile, @NotNull String packageName) {
        if (device == null) {
            FullApkInstaller.$$$reportNull$$$0(9);
        }
        if (localFile == null) {
            FullApkInstaller.$$$reportNull$$$0(10);
        }
        if (packageName == null) {
            FullApkInstaller.$$$reportNull$$$0(11);
        }
        if (!this.myLaunchOptions.isSkipNoopApkInstallations()) {
            return true;
        }
        try {
            Integer userId = LaunchUtils.getUserIdFromFlags(this.myLaunchOptions.getPmInstallOptions());
            if (!this.myInstalledApkCache.isInstalled(device, localFile, packageName, userId)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        this.myPrinter.stdout("No apk changes detected since last installation, skipping installation of " + localFile.getPath());
        if (this.myLaunchOptions.isForceStopRunningApp()) {
            this.forceStopPackageSilently(device, packageName, true);
        }
        return false;
    }

    private void forceStopPackageSilently(@NotNull IDevice device, @NotNull String packageName, boolean ignoreErrors) {
        block4: {
            if (device == null) {
                FullApkInstaller.$$$reportNull$$$0(12);
            }
            if (packageName == null) {
                FullApkInstaller.$$$reportNull$$$0(13);
            }
            String command = "am force-stop " + packageName;
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver(), 1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (ignoreErrors) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedApkCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/FullApkInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadAndInstallApk";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPmInstallOptions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "needsInstall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "forceStopPackageSilently";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ApkInstaller
    implements RetryingInstaller.Installer {
        private final String myRemotePath;
        private final ConsolePrinter myPrinter;
        private final String myPmInstallOptions;

        public ApkInstaller(@NotNull ConsolePrinter printer, @NotNull String remotePath, @Nullable String pmInstallOptions) {
            if (printer == null) {
                ApkInstaller.$$$reportNull$$$0(0);
            }
            if (remotePath == null) {
                ApkInstaller.$$$reportNull$$$0(1);
            }
            this.myPrinter = printer;
            this.myRemotePath = remotePath;
            this.myPmInstallOptions = pmInstallOptions;
        }

        @Override
        @NotNull
        public InstallResult installApp(@NotNull IDevice device, @NotNull LaunchStatus launchStatus) {
            if (device == null) {
                ApkInstaller.$$$reportNull$$$0(2);
            }
            if (launchStatus == null) {
                ApkInstaller.$$$reportNull$$$0(3);
            }
            ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(launchStatus);
            String command = ApkInstaller.getPmInstallCommand(this.myRemotePath, this.myPmInstallOptions);
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)receiver);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                Logger.getInstance(ApkInstaller.class).info(e);
                InstallResult installResult = new InstallResult(InstallResult.FailureCode.DEVICE_NOT_RESPONDING, "Exception while installing: " + e, null);
                if (installResult == null) {
                    ApkInstaller.$$$reportNull$$$0(4);
                }
                return installResult;
            }
            InstallResult installResult = InstallResult.forLaunchOutput(receiver);
            if (installResult == null) {
                ApkInstaller.$$$reportNull$$$0(5);
            }
            return installResult;
        }

        @NotNull
        static String getPmInstallCommand(@NotNull String remotePath, @Nullable String pmInstallOptions) {
            if (remotePath == null) {
                ApkInstaller.$$$reportNull$$$0(6);
            }
            StringBuilder sb = new StringBuilder(30);
            sb.append("pm install ");
            if (!StringUtil.isEmpty((String)pmInstallOptions)) {
                sb.append(pmInstallOptions);
                sb.append(' ');
            }
            sb.append("-t -r \"");
            sb.append(remotePath);
            sb.append("\"");
            String string = sb.toString();
            if (string == null) {
                ApkInstaller.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchStatus";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/FullApkInstaller$ApkInstaller";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/FullApkInstaller$ApkInstaller";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installApp";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPmInstallCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "installApp";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPmInstallCommand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

