/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.util.LaunchUtils;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;
    private final Set<String> mySupportedAbis;

    public LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget target, @NotNull EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion2 == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(0);
        }
        if (target == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(1);
        }
        if (requiredHardwareFeatures == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(2);
        }
        this.myMinSdkVersion = minSdkVersion2;
        this.myProjectTarget = target;
        this.myRequiredHardwareFeatures = requiredHardwareFeatures;
        this.mySupportedAbis = supportedAbis;
    }

    @Override
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        if (device == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(3);
        }
        LaunchCompatibility launchCompatibility = device.canRun(this.myMinSdkVersion, this.myProjectTarget, this.myRequiredHardwareFeatures, this.mySupportedAbis);
        if (launchCompatibility == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(4);
        }
        return launchCompatibility;
    }

    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            LaunchCompatibilityCheckerImpl.$$$reportNull$$$0(5);
        }
        AndroidVersion minSdkVersion2 = AndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet.getModule().getName());
        }
        EnumSet<IDevice.HardwareFeature> requiredHardwareFeatures = LaunchUtils.isWatchFeatureRequired(facet) ? EnumSet.of(IDevice.HardwareFeature.WATCH) : EnumSet.noneOf(IDevice.HardwareFeature.class);
        Set supportedAbis = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() instanceof AndroidModuleModel ? ((AndroidModuleModel)((AndroidFacetConfiguration)facet.getConfiguration()).getModel()).getSelectedVariant().getMainArtifact().getAbiFilters() : null;
        return new LaunchCompatibilityCheckerImpl(minSdkVersion2, platform.getTarget(), requiredHardwareFeatures, supportedAbis);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdkVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredHardwareFeatures";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/LaunchCompatibilityCheckerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

