/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicFeaturesParameters {
    private static final int PREFERRED_HEIGHT_IN_ROWS = 4;
    @NotNull
    private final DynamicFeaturesTableModel myTableModel;
    @NotNull
    private final Set<String> myDisabledDynamicFeatures;
    private JPanel myRootPanel;
    private JBScrollPane myTableScrollPane;
    private JBTable myTable;
    private JBLabel myAdditionalTextLabel;

    public DynamicFeaturesParameters() {
        this.$$$setupUI$$$();
        this.myTableModel = new DynamicFeaturesTableModel();
        this.myDisabledDynamicFeatures = new HashSet<String>();
        this.myAdditionalTextLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.setTableHeader(null);
        this.myTableScrollPane.setColumnHeaderView(null);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkMarkColumn = columnModel.getColumn(0);
        checkMarkColumn.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        columnModel.getColumn(1).setCellRenderer(new FeatureNameCellRenderer());
        this.disable();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DynamicFeaturesParameters.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    JTable getTableComponent() {
        return this.myTable;
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myDisabledDynamicFeatures);
        if (immutableList == null) {
            DynamicFeaturesParameters.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    public void setActiveModule(@Nullable Module module) {
        this.setDisabledDynamicFeatures(new ArrayList<String>());
        if (module == null) {
            this.disable();
            return;
        }
        List<Module> features = DynamicAppUtils.getDependentFeatureModules(module);
        if (features.isEmpty()) {
            this.disable();
            return;
        }
        this.setFeatureList(features);
    }

    public void setFeatureList(@NotNull List<Module> features) {
        if (features == null) {
            DynamicFeaturesParameters.$$$reportNull$$$0(2);
        }
        this.myTableModel.clear();
        features.stream().sorted((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)).map(f -> new DynamicFeatureRow(f.getName(), this.isFeatureEnabled(f.getName()))).forEach(row -> this.myTableModel.addRow((DynamicFeatureRow)row));
        this.enable();
    }

    public void setDisabledDynamicFeatures(@NotNull List<String> disabledDynamicFeatures) {
        if (disabledDynamicFeatures == null) {
            DynamicFeaturesParameters.$$$reportNull$$$0(3);
        }
        this.myDisabledDynamicFeatures.clear();
        this.myDisabledDynamicFeatures.addAll(disabledDynamicFeatures);
        this.myTableModel.myFeatures.forEach(x -> {
            x.isChecked = this.isFeatureEnabled(x.name);
        });
        this.myTableModel.fireTableDataChanged();
    }

    private boolean isFeatureEnabled(@NotNull String name) {
        if (name == null) {
            DynamicFeaturesParameters.$$$reportNull$$$0(4);
        }
        return !this.myDisabledDynamicFeatures.contains(name);
    }

    private void enable() {
        this.myTableModel.fireTableDataChanged();
        Insets insets = this.myTableScrollPane.getInsets();
        int minHeight = insets.top + this.myTable.getRowHeight() * 4 + insets.bottom;
        this.myTableScrollPane.setMinimumSize(new Dimension(200, minHeight));
        this.myRootPanel.setVisible(true);
    }

    private void disable() {
        this.myTableModel.clear();
        this.myTableModel.fireTableDataChanged();
        this.myRootPanel.setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledDynamicFeatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledDynamicFeatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFeatureList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledDynamicFeatures";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Dynamic features to deploy:");
        jPanel2.add((Component)jBLabel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0), null, 0, 0, null, null));
        this.myAdditionalTextLabel = jBLabel = new JBLabel();
        jBLabel.setText("(for devices that support dynamic features)");
        jPanel3.add((Component)jBLabel, "Center");
        this.myTableScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class EnabledCellRenderer
    extends StripedRowCellRenderer {
        private final TableCellRenderer myDelegate;

        public EnabledCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            component.setEnabled(true);
            return component;
        }
    }

    private class FeatureNameCellRenderer
    extends StripedRowCellRenderer {
        private FeatureNameCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table2 == null) {
                FeatureNameCellRenderer.$$$reportNull$$$0(0);
            }
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table2.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            DynamicFeatureRow featureRow = (DynamicFeatureRow)DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row);
            component.setEnabled(isSelected || featureRow.isChecked);
            Component component2 = component;
            if (component2 == null) {
                FeatureNameCellRenderer.$$$reportNull$$$0(1);
            }
            return component2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters$FeatureNameCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters$FeatureNameCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StripedRowCellRenderer
    extends DefaultTableCellRenderer {
        private StripedRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                component.setBackground(row % 2 == 0 ? UIUtil.getDecoratedRowColor() : UIUtil.getTableBackground());
            }
            return component;
        }
    }

    private class DynamicFeaturesTableModel
    extends AbstractTableModel {
        public static final int CHECK_MARK_COLUMN_INDEX = 0;
        public static final int FEATURE_NAME_COLUMN_INDEX = 1;
        private List<DynamicFeatureRow> myFeatures = new ArrayList<DynamicFeatureRow>();

        public void clear() {
            this.myFeatures.clear();
        }

        public void addRow(@NotNull DynamicFeatureRow row) {
            if (row == null) {
                DynamicFeaturesTableModel.$$$reportNull$$$0(0);
            }
            this.myFeatures.add(row);
        }

        @Override
        public int getRowCount() {
            return this.myFeatures.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.myFeatures.get((int)rowIndex).isChecked;
            }
            if (columnIndex == 1) {
                return this.myFeatures.get((int)rowIndex).name;
            }
            return null;
        }

        @Override
        public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
            DynamicFeatureRow row = this.myFeatures.get(rowIndex);
            if (columnIndex == 0) {
                boolean bl = row.isChecked = aValue == null || (Boolean)aValue != false;
                if (row.isChecked) {
                    DynamicFeaturesParameters.this.myDisabledDynamicFeatures.remove(row.name);
                } else {
                    DynamicFeaturesParameters.this.myDisabledDynamicFeatures.add(row.name);
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                if (Boolean.class == null) {
                    DynamicFeaturesTableModel.$$$reportNull$$$0(1);
                }
                return Boolean.class;
            }
            Class<?> clazz = super.getColumnClass(columnIndex);
            if (clazz == null) {
                DynamicFeaturesTableModel.$$$reportNull$$$0(2);
            }
            return clazz;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters$DynamicFeaturesTableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/editor/DynamicFeaturesParameters$DynamicFeaturesTableModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addRow";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DynamicFeatureRow {
        @NotNull
        public final String name;
        public boolean isChecked;

        public DynamicFeatureRow(@NotNull String name, boolean isChecked) {
            if (name == null) {
                DynamicFeatureRow.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.isChecked = isChecked;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/editor/DynamicFeaturesParameters$DynamicFeatureRow", "<init>"));
        }
    }
}

