/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess, boolean attachToRunningProcess) {
        if (applicationIds == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(2);
        }
        super(applicationIds, debugger, project, monitorRemoteProcess, attachToRunningProcess);
    }

    @NotNull
    protected ProcessHandler createDebugProcessHandler(@NotNull ProcessHandlerLaunchStatus launchStatus) {
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(3);
        }
        AndroidRemoteDebugProcessHandler androidRemoteDebugProcessHandler = new AndroidRemoteDebugProcessHandler(this.myProject, this.myMonitorRemoteProcess);
        if (androidRemoteDebugProcessHandler == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(4);
        }
        return androidRemoteDebugProcessHandler;
    }

    @NotNull
    protected RunContentDescriptor getDescriptor(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        if (currentLaunchInfo == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(5);
        }
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(6);
        }
        RunContentDescriptor descriptor = currentLaunchInfo.env.getContentToReuse();
        assert (descriptor != null) : "Expecting an existing descriptor that will be reused";
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(7);
        }
        return runContentDescriptor;
    }

    @NotNull
    protected ProcessHandler getOldProcessHandler(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        if (currentLaunchInfo == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(8);
        }
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(9);
        }
        ProcessHandler processHandler = this.getDescriptor(currentLaunchInfo, launchStatus).getProcessHandler();
        assert (processHandler != null);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(10);
        }
        return processHandler2;
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        if (currentLaunchInfo == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(11);
        }
        if (client == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(12);
        }
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(13);
        }
        if (printer == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(14);
        }
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        ProcessHandler processHandler = this.getOldProcessHandler(currentLaunchInfo, launchStatus);
        RunContentDescriptor descriptor = this.getDescriptor(currentLaunchInfo, launchStatus);
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final ProcessHandler debugProcessHandler = this.createDebugProcessHandler(launchStatus);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        AndroidDebugState debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        int uniqueId = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
        AndroidSessionInfo value = new AndroidSessionInfo(debugProcessHandler, debugDescriptor, uniqueId, currentLaunchInfo.executor.getId(), currentLaunchInfo.executor.getActionName(), InstantRunUtils.isInstantRunEnabled(currentLaunchInfo.env));
        debugProcessHandler.putUserData(AndroidSessionInfo.KEY, (Object)value);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, (Object)client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, (Object)client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        ConnectJavaDebuggerTask.captureLogcatOutput(client, debugProcessHandler);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private int myTerminationCount = 0;
            private boolean myWillBeDestroyed = true;

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processWillTerminate: " + pkgName + ", willBeDestroyed=" + willBeDestroyed);
                this.myWillBeDestroyed = willBeDestroyed;
                this.processTerminationCallback();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processTerminated: " + pkgName);
                this.processTerminationCallback();
            }

            private void processTerminationCallback() {
                ++this.myTerminationCount;
                if (this.myTerminationCount != 2) {
                    return;
                }
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                if (this.myWillBeDestroyed) {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                    try {
                        device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                    }
                    catch (Exception exception) {}
                } else {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger detaching, leaving process alive: " + pkgName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return debugProcessHandler;
    }

    private static void captureLogcatOutput(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
        if (client == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(15);
        }
        if (debugProcessHandler == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(16);
        }
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isDebugOutputEnabled()) {
            return;
        }
        final IDevice device = client.getDevice();
        final MyLogcatListener logListener = new MyLogcatListener(client, debugProcessHandler);
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\")", device.getName()));
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\"): remove listener", device.getName()));
                AndroidLogcatService.getInstance().removeListener(device, logListener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$2", "processTerminated"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLaunchInfo";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOldProcessHandler";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "launchDebugger";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "captureLogcatOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyLogcatListener
    extends ApplicationLogListener {
        private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
        private final AndroidLogcatFormatter myFormatter;
        private final AtomicBoolean myIsFirstMessage;
        private final ProcessHandler myDebugProcessHandler;

        private MyLogcatListener(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
            if (client == null) {
                MyLogcatListener.$$$reportNull$$$0(0);
            }
            if (debugProcessHandler == null) {
                MyLogcatListener.$$$reportNull$$$0(1);
            }
            super(client.getClientData().getClientDescription(), client.getClientData().getPid());
            this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
            this.myIsFirstMessage = new AtomicBoolean(true);
            this.myDebugProcessHandler = debugProcessHandler;
        }

        @Override
        @NotNull
        protected String formatLogLine(@NotNull LogCatMessage line) {
            if (line == null) {
                MyLogcatListener.$$$reportNull$$$0(2);
            }
            String string = this.myFormatter.formatMessage(SIMPLE_FORMAT, line.getHeader(), line.getMessage());
            if (string == null) {
                MyLogcatListener.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message, @NotNull Key key) {
            if (message == null) {
                MyLogcatListener.$$$reportNull$$$0(4);
            }
            if (key == null) {
                MyLogcatListener.$$$reportNull$$$0(5);
            }
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myDebugProcessHandler.notifyTextAvailable("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myDebugProcessHandler.notifyTextAvailable(message, key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcessHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$MyLogcatListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$MyLogcatListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatLogLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "formatLogLine";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

