/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.InstantAppSideLoader;
import com.android.instantapp.run.RunListener;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.RunStatsService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployInstantAppTask
implements LaunchTask {
    @NotNull
    private final Collection<ApkInfo> myPackages;
    private Project myProject;

    public DeployInstantAppTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages) {
        if (project == null) {
            DeployInstantAppTask.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            DeployInstantAppTask.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPackages = packages;
    }

    DeployInstantAppTask(@NotNull Collection<ApkInfo> packages) {
        if (packages == null) {
            DeployInstantAppTask.$$$reportNull$$$0(2);
        }
        this.myPackages = packages;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uploading and registering Instant App" == null) {
            DeployInstantAppTask.$$$reportNull$$$0(3);
        }
        return "Uploading and registering Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            DeployInstantAppTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            DeployInstantAppTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            DeployInstantAppTask.$$$reportNull$$$0(6);
        }
        if (this.myProject != null) {
            RunStatsService.get(this.myProject).notifyDeployInstantAppStarted(device, this.myPackages);
        }
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (this.myPackages.size() != 1) {
            printer.stderr("Zip file not found or not unique.");
            return false;
        }
        ApkInfo apkInfo = this.myPackages.iterator().next();
        File zipFile = apkInfo.getFile();
        String appId = apkInfo.getApplicationId();
        if (!zipFile.exists()) {
            printer.stderr("The file " + zipFile.getPath() + " does not exist on disk.");
            return false;
        }
        if (!zipFile.getName().endsWith(".zip")) {
            printer.stderr("The file " + zipFile.getPath() + " is not a zip file.");
            return false;
        }
        IDevice onlineDevice = DeployInstantAppTask.getCorrespondingOnlineDevice(device);
        if (onlineDevice == null) {
            printer.stderr("Device \"" + device.getSerialNumber() + "\" is offline.");
            return false;
        }
        return this.install(onlineDevice, launchStatus, printer, appId, zipFile);
    }

    @VisibleForTesting
    boolean install(@NotNull IDevice device, final @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer, @NotNull String appId, @NotNull File zipFile) {
        if (device == null) {
            DeployInstantAppTask.$$$reportNull$$$0(7);
        }
        if (launchStatus == null) {
            DeployInstantAppTask.$$$reportNull$$$0(8);
        }
        if (printer == null) {
            DeployInstantAppTask.$$$reportNull$$$0(9);
        }
        if (appId == null) {
            DeployInstantAppTask.$$$reportNull$$$0(10);
        }
        if (zipFile == null) {
            DeployInstantAppTask.$$$reportNull$$$0(11);
        }
        RunListener listener2 = new RunListener(){

            public void printMessage(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                printer.stdout(message);
            }

            public void logMessage(@NotNull String message, @Nullable InstantAppRunException e) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e == null) {
                    DeployInstantAppTask.this.getLogger().info(message);
                } else {
                    DeployInstantAppTask.this.getLogger().warn(message, (Throwable)e);
                }
            }

            public boolean isCancelled() {
                return launchStatus.isLaunchTerminated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployInstantAppTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logMessage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        InstantAppSideLoader installer = InstantApps.isPostO(device) ? new InstantAppSideLoader(appId, DeployInstantAppTask.extractApks(zipFile), listener2) : new InstantAppSideLoader(appId, zipFile, listener2);
        AtomicBoolean tryAgain = new AtomicBoolean(true);
        AtomicBoolean result2 = new AtomicBoolean(false);
        while (tryAgain.get()) {
            try {
                installer.install(device);
                tryAgain.set(false);
                result2.set(true);
            }
            catch (InstantAppRunException e) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    int choice = Messages.showYesNoDialog((String)("Side loading failed with message: " + e.getMessage() + " Do you want to retry?"), (String)"Instant Apps", null);
                    if (choice != 0) {
                        if (e.getErrorType() != InstantAppRunException.ErrorType.NO_GOOGLE_ACCOUNT && e.getErrorType() != InstantAppRunException.ErrorType.CANCELLED) {
                            this.getLogger().error((Throwable)e);
                        }
                        tryAgain.set(false);
                        result2.set(false);
                    }
                });
            }
        }
        boolean resultBoolean = result2.get();
        if (this.myProject != null) {
            RunStatsService.get(this.myProject).notifyDeployFinished(resultBoolean);
        }
        return resultBoolean;
    }

    @NotNull
    private static List<File> extractApks(@NotNull File zip) {
        if (zip == null) {
            DeployInstantAppTask.$$$reportNull$$$0(12);
        }
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.extract((File)zip, (File)tempDir, null);
        }
        catch (IOException e) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                DeployInstantAppTask.$$$reportNull$$$0(13);
            }
            return list;
        }
        File[] apks = tempDir.listFiles();
        List<Object> list = apks == null ? Collections.emptyList() : Arrays.asList(apks);
        if (list == null) {
            DeployInstantAppTask.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private static IDevice getCorrespondingOnlineDevice(@NotNull IDevice device) {
        if (device == null) {
            DeployInstantAppTask.$$$reportNull$$$0(15);
        }
        if (device.isOnline()) {
            return device;
        }
        List<IDevice> devices = DeviceSelectionUtils.getAllCompatibleDevices((Predicate<IDevice>)((Predicate)input -> {
            if (device == null) {
                DeployInstantAppTask.$$$reportNull$$$0(17);
            }
            return input != null && input.getSerialNumber().compareTo(device.getSerialNumber()) == 0;
        }));
        return devices.size() == 1 ? devices.get(0) : null;
    }

    @NotNull
    private Logger getLogger() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            DeployInstantAppTask.$$$reportNull$$$0(16);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/DeployInstantAppTask";
                break;
            }
            case 4: 
            case 7: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployInstantAppTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractApks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractApks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOnlineDevice";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCorrespondingOnlineDevice$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

