/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.android.instantapps.sdk.api.HandlerResult;
import com.google.android.instantapps.sdk.api.ProgressIndicator;
import com.google.android.instantapps.sdk.api.ResultStream;
import com.google.android.instantapps.sdk.api.RunHandler;
import com.google.android.instantapps.sdk.api.Sdk;
import com.google.android.instantapps.sdk.api.StatusCode;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInstantAppTask
implements LaunchTask {
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @Nullable
    private final String myDeepLink;
    @NotNull
    private final InstantAppSdks mySdk;

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link) {
        if (packages == null) {
            RunInstantAppTask.$$$reportNull$$$0(0);
        }
        this.myPackages = packages;
        this.myDeepLink = link;
        this.mySdk = InstantAppSdks.getInstance();
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uploading and launching Instant App" == null) {
            RunInstantAppTask.$$$reportNull$$$0(1);
        }
        return "Uploading and launching Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer) {
        if (device == null) {
            RunInstantAppTask.$$$reportNull$$$0(2);
        }
        if (launchStatus == null) {
            RunInstantAppTask.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            RunInstantAppTask.$$$reportNull$$$0(4);
        }
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (!this.mySdk.shouldUseSdkLibraryToRun()) {
            printer.stderr("The Instant Apps SDK is not available or this task has been disabled");
            return false;
        }
        if (this.myPackages.size() != 1) {
            printer.stderr("Zip file not found or not unique.");
            return false;
        }
        ApkInfo apkInfo = this.myPackages.iterator().next();
        File zipFile = apkInfo.getFile();
        URL url = null;
        if (this.myDeepLink != null && !this.myDeepLink.isEmpty()) {
            try {
                url = new URL(this.myDeepLink);
            }
            catch (MalformedURLException e) {
                printer.stderr("Invalid launch URL: " + this.myDeepLink);
                return false;
            }
        }
        try {
            Sdk aiaSdk = this.mySdk.loadLibrary();
            assert (aiaSdk != null);
            StatusCode status = aiaSdk.getRunHandler().runInstantApp(url, zipFile, device.getSerialNumber(), RunHandler.SetupBehavior.SET_UP_IF_NEEDED, new ResultStream(){

                public void write(HandlerResult result2) {
                    if (result2.isError()) {
                        printer.stderr(result2.toString());
                        RunInstantAppTask.getLogger().error((Throwable)new RunInstantAppException(result2.getMessage()));
                    } else {
                        printer.stdout(result2.toString());
                    }
                }
            }, new ProgressIndicator(){

                public void setProgress(double v) {
                }
            });
            return status == StatusCode.SUCCESS;
        }
        catch (Exception e) {
            printer.stderr(e.toString());
            RunInstantAppTask.getLogger().error((Throwable)new RunInstantAppException(e));
            return false;
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(RunInstantAppTask.class);
        if (logger == null) {
            RunInstantAppTask.$$$reportNull$$$0(5);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/RunInstantAppTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/RunInstantAppTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunInstantAppException
    extends Exception {
        private RunInstantAppException(@NotNull String message) {
            if (message == null) {
                RunInstantAppException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private RunInstantAppException(@NotNull Throwable t) {
            if (t == null) {
                RunInstantAppException.$$$reportNull$$$0(1);
            }
            super(t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "t";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/tasks/RunInstantAppTask$RunInstantAppException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

