/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.IotInstallChecker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class UninstallIotLauncherAppsTask
implements LaunchTask {
    private final String myPackageName;
    private final RetryingInstaller.Prompter myPrompter;
    private final IotInstallChecker myChecker;

    public UninstallIotLauncherAppsTask(Project project, String packageName) {
        this(packageName, new IotInstallChecker(), new RetryingInstaller.UserPrompter(project));
    }

    UninstallIotLauncherAppsTask(String packageName, IotInstallChecker checker, RetryingInstaller.Prompter prompter) {
        this.myPackageName = packageName;
        this.myPrompter = prompter;
        this.myChecker = checker;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Uninstalling other IoT apps" == null) {
            UninstallIotLauncherAppsTask.$$$reportNull$$$0(0);
        }
        return "Uninstalling other IoT apps";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            UninstallIotLauncherAppsTask.$$$reportNull$$$0(1);
        }
        if (launchStatus == null) {
            UninstallIotLauncherAppsTask.$$$reportNull$$$0(2);
        }
        if (printer == null) {
            UninstallIotLauncherAppsTask.$$$reportNull$$$0(3);
        }
        if (!device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            return true;
        }
        Set installedIotLauncherApps = this.myChecker.getInstalledIotLauncherApps(device);
        installedIotLauncherApps.remove(this.myPackageName);
        if (!installedIotLauncherApps.isEmpty()) {
            String otherApplicationIds = StringUtil.join((Collection)installedIotLauncherApps, (String)"\n");
            String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.androidthings.text", otherApplicationIds);
            if (this.myPrompter.showQuestionPrompt(reason)) {
                TreeMap<String, InstallException> failedUninstallApps = new TreeMap<String, InstallException>();
                for (Object app : installedIotLauncherApps) {
                    try {
                        device.uninstallPackage((String)app);
                    }
                    catch (InstallException installException) {
                        failedUninstallApps.put((String)app, installException);
                    }
                }
                if (!failedUninstallApps.isEmpty()) {
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry entry : failedUninstallApps.entrySet()) {
                        sb.append(entry.getKey());
                        sb.append(": ");
                        sb.append(entry.getValue());
                        sb.append("\n");
                    }
                    String errorMessage = AndroidBundle.message("deployment.failed.uninstall.prompt.androidthings.errortext", sb.toString());
                    this.myPrompter.showErrorMessage(errorMessage);
                    return false;
                }
            } else {
                printer.stdout("Installation aborted");
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/UninstallIotLauncherAppsTask";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/UninstallIotLauncherAppsTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

