/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    private static final Topic<IdeSdkChangeListener> IDE_SYNC_TOPIC = new Topic("IDE SDKs", IdeSdkChangeListener.class);
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final MessageBus myMessageBus;

    @NotNull
    public static IdeSdks getInstance() {
        IdeSdks ideSdks = (IdeSdks)ServiceManager.getService(IdeSdks.class);
        if (ideSdks == null) {
            IdeSdks.$$$reportNull$$$0(0);
        }
        return ideSdks;
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull IdeSdkChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            IdeSdks.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            IdeSdks.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(IDE_SYNC_TOPIC, (Object)listener2);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            IdeSdks.$$$reportNull$$$0(3);
        }
        return messageBusConnection;
    }

    public IdeSdks(@NotNull AndroidSdks androidSdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo, @NotNull MessageBus messageBus) {
        if (androidSdks == null) {
            IdeSdks.$$$reportNull$$$0(4);
        }
        if (jdks == null) {
            IdeSdks.$$$reportNull$$$0(5);
        }
        if (embeddedDistributionPaths == null) {
            IdeSdks.$$$reportNull$$$0(6);
        }
        if (ideInfo == null) {
            IdeSdks.$$$reportNull$$$0(7);
        }
        if (messageBus == null) {
            IdeSdks.$$$reportNull$$$0(8);
        }
        this.myAndroidSdks = androidSdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
        this.myMessageBus = messageBus;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        File candidate2;
        String sdkHome = null;
        Sdk sdk = this.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null && this.isValidAndroidSdkPath(candidate2 = FilePaths.toSystemDependentPath((String)sdkHome))) {
            return candidate2;
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        return ndk == null ? null : ndk.getLocation();
    }

    @Nullable
    public File getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private File doGetJdkPath(boolean createJdkIfNeeded) {
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (androidSdks.isEmpty() && createJdkIfNeeded) {
            String jdkPath;
            Sdk jdk = this.myJdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkPath = jdk.getHomePath()) != null) {
                return FilePaths.toSystemDependentPath((String)jdkPath);
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return FilePaths.toSystemDependentPath((String)jdkHomePath);
            }
        }
        return null;
    }

    @Nullable
    private Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = this.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public void setJdkPath(@NotNull File path) {
        if (path == null) {
            IdeSdks.$$$reportNull$$$0(9);
        }
        if (JdkUtil.checkForJdk((File)path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path);
            Sdk chosenJdk = null;
            if (this.myIdeInfo.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                Iterator iterator = jdks.iterator();
                while (iterator.hasNext()) {
                    Sdk jdk = (Sdk)iterator.next();
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    Project[] openProjects;
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path.getPath() + "'");
                    }
                    this.setJdkOfAndroidSdks(chosenJdk);
                    ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
                    for (Project project : openProjects = projectManager.getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
        }
    }

    private void setJdkOfAndroidSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeSdks.$$$reportNull$$$0(10);
        }
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Project currentProject) {
        if (path == null) {
            IdeSdks.$$$reportNull$$$0(11);
        }
        List<Sdk> list = this.setAndroidSdkPath(path, null, currentProject);
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path == null) {
            IdeSdks.$$$reportNull$$$0(13);
        }
        if (this.isValidAndroidSdkPath(path)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            this.updateSdkData(path);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            File resolved = IdeSdks.resolvePath(path);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved);
            ((IdeSdkChangeListener)this.myMessageBus.syncPublisher(IDE_SYNC_TOPIC)).sdkPathChanged(path);
            List<Sdk> list = sdks;
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(15);
        }
        return list;
    }

    private void updateSdkData(@NotNull File path) {
        if (path == null) {
            IdeSdks.$$$reportNull$$$0(16);
        }
        AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path);
        this.myAndroidSdks.setSdkData(oldSdkData);
    }

    public void updateFromAndroidSdkPath(@Nullable Project currentProject) {
        String sdkPath;
        File sdkDir = null;
        if (currentProject != null && !currentProject.isDisposed() && (sdkPath = PropertiesComponent.getInstance((Project)currentProject).getValue(ANDROID_SDK_PATH_KEY)) != null) {
            sdkDir = new File(sdkPath);
        }
        if (sdkDir == null) {
            sdkDir = this.getAndroidSdkPath();
        }
        assert (sdkDir != null);
        assert (this.isValidAndroidSdkPath(sdkDir));
        this.updateSdkData(sdkDir);
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null || !homeDir.exists()) {
                jdkTable.removeJdk(sdk);
                continue;
            }
            IAndroidTarget target = IdeSdks.getTarget(sdk);
            File targetFile = new File(target.getLocation());
            if (targetFile.exists()) continue;
            jdkTable.removeJdk(sdk);
        }
        File resolved = IdeSdks.resolvePath(sdkDir);
        this.createAndroidSdkPerAndroidTarget(resolved);
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        ProjectManager projectManager;
        Project[] openProjects;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(17);
        }
        if ((openProjects = (projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class)).getOpenProjects()).length == 0) {
            return;
        }
        AndroidSdkEventListener[] eventListeners = (AndroidSdkEventListener[])AndroidSdkEventListener.EP_NAME.getExtensions();
        for (Project project : openProjects) {
            if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) continue;
            for (AndroidSdkEventListener listener2 : eventListeners) {
                listener2.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path) {
        if (path == null) {
            IdeSdks.$$$reportNull$$$0(18);
        }
        return SdkPaths.validateAndroidSdk((File)path, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(19);
        }
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        AnAction sdkManagerAction = ActionManager.getInstance().getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(null);
        }
        List<Sdk> list = sdks;
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        AndroidSdkData sdkData;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(21);
        }
        if ((sdkData = AndroidSdkData.getSdkData(androidSdkPath)) == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(22);
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform() || this.doesIdeAndroidSdkExist(target)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target);
                Sdk sdk2 = this.myAndroidSdks.create(target, sdkData.getLocation(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            IdeSdks.$$$reportNull$$$0(25);
        }
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version2 = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeSdks.$$$reportNull$$$0(26);
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            IdeSdks.$$$reportNull$$$0(27);
        }
        return iAndroidTarget;
    }

    @NotNull
    private static File resolvePath(@NotNull File path) {
        File file;
        block4: {
            if (path == null) {
                IdeSdks.$$$reportNull$$$0(28);
            }
            try {
                String resolvedPath = FileUtil.resolveShortWindowsName((String)path.getPath());
                file = new File(resolvedPath);
                if (file != null) break block4;
            }
            catch (IOException iOException) {
                File file2 = path;
                if (file2 == null) {
                    IdeSdks.$$$reportNull$$$0(30);
                }
                return file2;
            }
            IdeSdks.$$$reportNull$$$0(29);
        }
        return file;
    }

    public boolean isUsingEmbeddedJdk() {
        File jdkPath = this.doGetJdkPath(false);
        return jdkPath != null && FileUtil.filesEqual((File)jdkPath, (File)this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.myIdeInfo.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        this.setJdkPath(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
    }

    @Nullable
    public Sdk getJdk() {
        return this.getJdk(JavaSdkVersion.JDK_1_8);
    }

    @Nullable
    private Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            jdk = data.getJavaSdk();
            if (IdeSdks.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            jdk = jdks.iterator();
            while (jdk.hasNext()) {
                Sdk jdk2 = (Sdk)jdk.next();
                if (!IdeSdks.isJdkCompatible(jdk2, preferredVersion)) continue;
                return jdk2;
            }
        }
        if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (IdeSdks.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            if (JdkUtil.checkForJdk((File)jdkPath)) {
                Sdk jdk3 = this.createJdk(jdkPath);
                return IdeSdks.isJdkCompatible(jdk3, preferredVersion) ? jdk3 : null;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk4;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((File)child) || !IdeSdks.isJdkCompatible(jdk4 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk4;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        jdkPaths.add(0, System.getenv("JDK_HOME"));
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        ArrayList arrayList = virtualFiles;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        return JavaSdk.getInstance().isOfVersionOrHigher(jdk, preferredVersion);
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @Nullable
    private Sdk createJdk(@NotNull File homeDirectory) {
        if (homeDirectory == null) {
            IdeSdks.$$$reportNull$$$0(33);
        }
        return this.myJdks.createJdk(homeDirectory.getPath());
    }

    public boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            Revision revision;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(Jdks.class);
            LocalPackage info = sdkData.getSdkHandler().getLocalPackage("platform-tools", (ProgressIndicator)progress);
            if (info != null && (revision = info.getVersion()).getMajor() >= 19) {
                JavaSdkVersion version2;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version2 = jdk.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeJdksOn(@NotNull Disposable disposable) {
        if (disposable == null) {
            IdeSdks.$$$reportNull$$$0(34);
        }
        Disposer.register((Disposable)disposable, () -> WriteAction.run(() -> {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedDistributionPaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setAndroidSdkPath";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialJdkPaths";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEligibleAndroidSdks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJdkPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setJdkOfAndroidSdks";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidSdkPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "afterAndroidSdkPathUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isValidAndroidSdkPath";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doesIdeAndroidSdkExist";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeJdksOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IdeSdkChangeListener {
        public void sdkPathChanged(@NotNull File var1);
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

