/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.Run;
import com.android.tools.idea.stats.RunStatsService;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ArtifactDetail;
import com.google.wireless.android.sdk.stats.StudioRunEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J>\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010,\u001a\u00020\u001cH\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010.\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J0\u00100\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001eH\u0016J \u00104\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u00067"}, d2={"Lcom/android/tools/idea/stats/RunStatsServiceImpl;", "Lcom/android/tools/idea/stats/RunStatsService;", "()V", "lock", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "calcDuration", "", "finishTime", "startTime", "(Ljava/lang/Long;Ljava/lang/Long;)J", "determineBuildMode", "Lcom/google/wireless/android/sdk/stats/StudioRunEvent$BuildMode;", "buildMode", "Lcom/android/tools/idea/gradle/util/BuildMode;", "determineRunType", "Lcom/google/wireless/android/sdk/stats/StudioRunEvent$RunType;", "runType", "", "getEventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "studioRunEvent", "Lcom/google/wireless/android/sdk/stats/StudioRunEvent;", "packageName", "notifyDeployFinished", "", "isSuccessful", "", "notifyDeployStarted", "deployTask", "Lcom/google/wireless/android/sdk/stats/StudioRunEvent$DeployTask;", "device", "Lcom/android/ddmlib/IDevice;", "artifacts", "", "Lcom/google/wireless/android/sdk/stats/ArtifactDetail;", "isPatchBuild", "dontKill", "disabledDynamicFeaturesCount", "", "notifyEmulatorStarted", "notifyEmulatorStarting", "notifyGradleFinished", "notifyGradleStarted", "notifyRunFinished", "notifyRunStarted", "isDebuggable", "forceColdswap", "instantRunEnabled", "notifyStudioSectionFinished", "isInstantRun", "userSelectedDeployTarget", "intellij.android.core"})
public final class RunStatsServiceImpl
extends RunStatsService {
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRunStarted(@NotNull String packageName, @NotNull String runType, boolean isDebuggable, boolean forceColdswap, boolean instantRunEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)runType, (String)"runType");
        this.getLogger().info("notifyRunStarted: myRun=" + this.getMyRun() + ", packageName=" + packageName + ", isDebuggable=" + isDebuggable + ", " + "forceColdSwap=" + forceColdswap + ", instanceRunEnabled=" + instantRunEnabled);
        Object object = this.lock;
        synchronized (object) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
            this.setMyRun(new Run(uUID, packageName, this.determineRunType(runType), System.currentTimeMillis()));
            Unit unit = Unit.INSTANCE;
        }
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.TOTAL).setEventType(StudioRunEvent.EventType.START).setDebuggable(isDebuggable).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
        UsageTracker usageTracker2 = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent2 = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.STUDIO).setEventType(StudioRunEvent.EventType.START).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent2, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker2.log(this.getEventBuilder(studioRunEvent2, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStudioSectionFinished(boolean isSuccessful, boolean isInstantRun, boolean userSelectedDeployTarget) {
        this.getLogger().info("notifyStudioSectionFinished: myRun=" + this.getMyRun() + ", isSuccessful=" + isSuccessful + ", " + "isInstantRun=" + isInstantRun + ", userSelectedDeployTarget=" + userSelectedDeployTarget);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setStudioProcessFinishedTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.STUDIO).setEventType(StudioRunEvent.EventType.FINISH).setDurationMs((int)this.calcDuration(currentRun.getStudioProcessFinishedTimestamp(), currentRun.getStartTimestamp())).setInstantRun(isInstantRun).setIsSuccessful(isSuccessful).setUserSelectedTarget(userSelectedDeployTarget).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyGradleStarted(@Nullable BuildMode buildMode) {
        this.getLogger().info("notifyGradleStarted: myRun=" + this.getMyRun() + ", buildMode=" + buildMode);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setGradleInvokeTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.GRADLE).setEventType(StudioRunEvent.EventType.START).setBuildMode(this.determineBuildMode(buildMode)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyGradleFinished(boolean isSuccessful) {
        this.getLogger().info("notifyGradleFinished: myRun=" + this.getMyRun() + ", isSuccessful=" + isSuccessful);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setGradleFinishedTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.GRADLE).setEventType(StudioRunEvent.EventType.FINISH).setDurationMs((int)this.calcDuration(currentRun.getGradleFinishedTimestamp(), currentRun.getGradleInvokeTimestamp())).setIsSuccessful(isSuccessful).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEmulatorStarting() {
        this.getLogger().info("notifyEmulatorStarting: myRun=" + this.getMyRun());
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setEmulatorStartTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.EMULATOR).setEventType(StudioRunEvent.EventType.START).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEmulatorStarted(boolean isSuccessful) {
        this.getLogger().info("notifyEmulatorStarted: myRun=" + this.getMyRun() + ", isSuccessful=" + isSuccessful);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Run run3 = this.getMyRun();
        if ((run3 != null ? run3.getEmulatorStartTimestamp() : null) == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            currentRun.setEmulatorFinishTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.EMULATOR).setDurationMs((int)this.calcDuration(currentRun.getEmulatorFinishTimestamp(), currentRun.getEmulatorStartTimestamp())).setIsSuccessful(isSuccessful).setEventType(StudioRunEvent.EventType.FINISH).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDeployStarted(@NotNull StudioRunEvent.DeployTask deployTask, @NotNull IDevice device, @NotNull Collection<ArtifactDetail> artifacts, boolean isPatchBuild, boolean dontKill, int disabledDynamicFeaturesCount) {
        Intrinsics.checkParameterIsNotNull((Object)deployTask, (String)"deployTask");
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull(artifacts, (String)"artifacts");
        this.getLogger().info("notifyDeployStarted: myRun=" + this.getMyRun() + ", deployTask=" + deployTask + ", device=" + device + ", " + "artifacts=" + artifacts.size() + ", isPatchBuild=" + isPatchBuild + ", dontKill=" + dontKill + ", " + "disabledDynamicFeaturesCount=" + disabledDynamicFeaturesCount);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setDeployStartTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.DEPLOY).setEventType(StudioRunEvent.EventType.START).setArtifactCount(artifacts.size()).addAllArtifactDetails((Iterable)artifacts).setDeployTask(deployTask).setDisabledDynamicFeaturesCount(disabledDynamicFeaturesCount).setPatchBuild(isPatchBuild).setDoNotRestart(dontKill).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026Restart(dontKill).build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDeployFinished(boolean isSuccessful) {
        this.getLogger().info("notifyDeployFinished: myRun=" + this.getMyRun() + ", isSuccessful=" + isSuccessful);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setDeployFinishTimestamp(System.currentTimeMillis());
            Unit unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.DEPLOY).setEventType(StudioRunEvent.EventType.FINISH).setDurationMs((int)this.calcDuration(currentRun.getDeployFinishTimestamp(), currentRun.getDeployStartTimestamp())).setIsSuccessful(isSuccessful).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRunFinished(boolean isSuccessful) {
        Unit unit;
        this.getLogger().info("notifyRunFinished: myRun=" + this.getMyRun() + ", isSuccessful=" + isSuccessful);
        Run run2 = this.getMyRun();
        if (run2 == null) {
            return;
        }
        Run currentRun = run2;
        Object object = this.lock;
        synchronized (object) {
            currentRun.setRunFinishTimestamp(System.currentTimeMillis());
            unit = Unit.INSTANCE;
        }
        UsageTracker usageTracker = UsageTracker.getInstance();
        StudioRunEvent studioRunEvent = StudioRunEvent.newBuilder().setRunId(currentRun.getRunId().toString()).setRunType(currentRun.getRunType()).setSectionType(StudioRunEvent.SectionType.TOTAL).setEventType(StudioRunEvent.EventType.FINISH).setDurationMs((int)this.calcDuration(currentRun.getRunFinishTimestamp(), currentRun.getStartTimestamp())).setIsSuccessful(isSuccessful).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)studioRunEvent, (String)"StudioRunEvent.newBuilde\u2026                 .build()");
        usageTracker.log(this.getEventBuilder(studioRunEvent, currentRun.getPackageName()));
        object = this.lock;
        synchronized (object) {
            this.setMyRun(null);
            unit = Unit.INSTANCE;
        }
    }

    private final long calcDuration(Long finishTime, Long startTime) {
        if (finishTime == null || startTime == null || Intrinsics.compare((long)finishTime, (long)startTime) < 0) {
            return 0L;
        }
        return finishTime - startTime;
    }

    private final StudioRunEvent.RunType determineRunType(String runType) {
        StudioRunEvent.RunType runType2;
        switch (runType) {
            case "Run": {
                runType2 = StudioRunEvent.RunType.RUN;
                break;
            }
            case "Debug": {
                runType2 = StudioRunEvent.RunType.DEBUG;
                break;
            }
            case "Android Profiler": {
                runType2 = StudioRunEvent.RunType.PROFILE;
                break;
            }
            default: {
                runType2 = StudioRunEvent.RunType.UNKNOWN;
            }
        }
        return runType2;
    }

    private final StudioRunEvent.BuildMode determineBuildMode(BuildMode buildMode) {
        if (buildMode == null) {
            return StudioRunEvent.BuildMode.UNKNOWN_BUILD_MODE;
        }
        return StudioRunEvent.BuildMode.valueOf((String)buildMode.toString());
    }

    private final AndroidStudioEvent.Builder getEventBuilder(StudioRunEvent studioRunEvent, String packageName) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_RUN_EVENT).setProjectId(AnonymizerUtil.anonymizeUtf8((String)packageName)).setRawProjectId(packageName).setStudioRunEvent(studioRunEvent);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AndroidStudioEvent.newBu\u2026oRunEvent(studioRunEvent)");
        return builder;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(RunStatsServiceImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(RunSt\u2026sServiceImpl::class.java)");
        return logger;
    }
}

