/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioToolWindowActionStats;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "(Lcom/intellij/openapi/wm/ToolWindowManager;)V", "myProject", "Lcom/intellij/openapi/project/Project;", "stateMap", "Ljava/util/HashMap;", "", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState;", "Lkotlin/collections/HashMap;", "queryToolWindowState", "id", "stateChanged", "", "toolWindowRegistered", "Companion", "ToolWindowState", "intellij.android.core"})
public final class ToolWindowTrackerService
implements ToolWindowManagerListener {
    private final HashMap<String, ToolWindowState> stateMap;
    private Project myProject;
    private final ToolWindowManager toolWindowManager;
    public static final Companion Companion = new Companion(null);

    public void toolWindowRegistered(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Map map2 = this.stateMap;
        ToolWindowState toolWindowState = this.queryToolWindowState(id);
        map2.put(id, toolWindowState);
    }

    public void stateChanged() {
        this.stateMap.forEach(new BiConsumer<String, ToolWindowState>(this){
            final /* synthetic */ ToolWindowTrackerService this$0;

            public final void accept(@NotNull String id, @NotNull ToolWindowState previousState) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull((Object)previousState, (String)"previousState");
                ToolWindowState currentState = ToolWindowTrackerService.access$queryToolWindowState(this.this$0, id);
                if (Intrinsics.areEqual((Object)currentState, (Object)previousState) ^ true) {
                    StudioToolWindowActionStats.EventType eventType;
                    UsageTracker usageTracker = UsageTracker.getInstance();
                    AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_TOOL_WINDOW_ACTION_STATS);
                    StudioToolWindowActionStats.Builder builder2 = StudioToolWindowActionStats.newBuilder().setToolWindowId(id);
                    Object object = currentState;
                    if (Intrinsics.areEqual((Object)object, (Object)ToolWindowState.UNKNOWN.INSTANCE)) {
                        eventType = StudioToolWindowActionStats.EventType.UNKNOWN_EVENT_TYPE;
                    } else if (Intrinsics.areEqual((Object)object, (Object)ToolWindowState.OPENED.INSTANCE)) {
                        eventType = StudioToolWindowActionStats.EventType.OPEN;
                    } else if (Intrinsics.areEqual((Object)object, (Object)ToolWindowState.CLOSED.INSTANCE)) {
                        eventType = StudioToolWindowActionStats.EventType.CLOSED;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    usageTracker.log(builder.setStudioToolWindowActionStats(builder2.setEventType(eventType)));
                    object = ToolWindowTrackerService.access$getStateMap$p(this.this$0);
                    String string = id;
                    ToolWindowState toolWindowState = currentState;
                    object.put(string, toolWindowState);
                }
            }
            {
                this.this$0 = toolWindowTrackerService;
            }
        });
    }

    private final ToolWindowState queryToolWindowState(String id) {
        ToolWindowManager toolWindowManager = this.toolWindowManager;
        if (toolWindowManager == null) {
            Project project = this.myProject;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
            }
            toolWindowManager = ToolWindowManager.getInstance((Project)project);
        }
        ToolWindowManager manager = toolWindowManager;
        ToolWindow window = manager.getToolWindow(id);
        if (window != null) {
            return window.isActive() ? (ToolWindowState)ToolWindowState.OPENED.INSTANCE : (ToolWindowState)ToolWindowState.CLOSED.INSTANCE;
        }
        return ToolWindowState.UNKNOWN.INSTANCE;
    }

    public ToolWindowTrackerService(@Nullable ToolWindowManager toolWindowManager) {
        this.toolWindowManager = toolWindowManager;
        this.stateMap = new HashMap();
    }

    @NotNull
    public static final /* synthetic */ ToolWindowState access$queryToolWindowState(ToolWindowTrackerService $this, @NotNull String id) {
        return $this.queryToolWindowState(id);
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getStateMap$p(ToolWindowTrackerService $this) {
        return $this.stateMap;
    }

    @NotNull
    public static final /* synthetic */ Project access$getMyProject$p(ToolWindowTrackerService $this) {
        Project project = $this.myProject;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myProject");
        }
        return project;
    }

    @JvmStatic
    @NotNull
    public static final ToolWindowTrackerService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState;", "", "()V", "CLOSED", "OPENED", "UNKNOWN", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$UNKNOWN;", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$OPENED;", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$CLOSED;", "intellij.android.core"})
    public static abstract class ToolWindowState {
        private ToolWindowState() {
        }

        public /* synthetic */ ToolWindowState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$UNKNOWN;", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState;", "()V", "intellij.android.core"})
        public static final class UNKNOWN
        extends ToolWindowState {
            public static final UNKNOWN INSTANCE;

            private UNKNOWN() {
                super(null);
            }

            static {
                UNKNOWN uNKNOWN;
                INSTANCE = uNKNOWN = new UNKNOWN();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$OPENED;", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState;", "()V", "intellij.android.core"})
        public static final class OPENED
        extends ToolWindowState {
            public static final OPENED INSTANCE;

            private OPENED() {
                super(null);
            }

            static {
                OPENED oPENED;
                INSTANCE = oPENED = new OPENED();
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState$CLOSED;", "Lcom/android/tools/idea/stats/ToolWindowTrackerService$ToolWindowState;", "()V", "intellij.android.core"})
        public static final class CLOSED
        extends ToolWindowState {
            public static final CLOSED INSTANCE;

            private CLOSED() {
                super(null);
            }

            static {
                CLOSED cLOSED;
                INSTANCE = cLOSED = new CLOSED();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/stats/ToolWindowTrackerService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/stats/ToolWindowTrackerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ToolWindowTrackerService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ToolWindowTrackerService service = (ToolWindowTrackerService)ServiceManager.getService((Project)project, ToolWindowTrackerService.class);
            service.myProject = project;
            ToolWindowTrackerService toolWindowTrackerService = service;
            Intrinsics.checkExpressionValueIsNotNull((Object)toolWindowTrackerService, (String)"service");
            return toolWindowTrackerService;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

