/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.idea.structure.dialog.CounterDisplayConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidePanel
extends JPanel {
    @NotNull
    private final JBList myList;
    @NotNull
    private final DefaultListModel<Place> myListModel;
    @NotNull
    private final Place.Navigator myNavigator;
    @NotNull
    private final List<Place> myPlaces;
    @NotNull
    private final Map<Integer, String> mySeparatorByIndex;
    @NotNull
    private final Map<Place, Presentation> myPresentationByPlace;
    @NotNull
    private final History myHistory;
    @NotNull
    private final ListItemDescriptor<Place> myDescriptor;

    public SidePanel(@NotNull Place.Navigator navigator, @NotNull History history) {
        if (navigator == null) {
            SidePanel.$$$reportNull$$$0(0);
        }
        if (history == null) {
            SidePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myPlaces = Lists.newArrayList();
        this.mySeparatorByIndex = Maps.newHashMap();
        this.myPresentationByPlace = Maps.newHashMap();
        this.myHistory = history;
        this.myNavigator = navigator;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myList.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        this.myDescriptor = new ListItemDescriptor<Place>(){

            public String getTextFor(Place place) {
                return ((Presentation)SidePanel.this.myPresentationByPlace.get(place)).getText();
            }

            public String getTooltipFor(Place place) {
                return this.getTextFor(place);
            }

            public Icon getIconFor(Place place) {
                return JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16, (int)20));
            }

            public boolean hasSeparatorAboveOf(Place value) {
                return SidePanel.this.getSeparatorAbove(value) != null;
            }

            public String getCaptionAboveOf(Place value) {
                return SidePanel.this.getSeparatorAbove(value);
            }
        };
        this.myList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer(this.myDescriptor){
            JPanel myExtraPanel;
            SidePanelCountLabel myCountLabel;
            CellRendererPane myValidationParent;
            {
                this.myValidationParent = new CellRendererPane();
                this.mySeparatorComponent.setCaptionCentered(false);
                SidePanel.this.myList.add((Component)this.myValidationParent);
            }

            protected Color getForeground() {
                return new JBColor((Color)Gray._60, (Color)Gray._140);
            }

            protected SeparatorWithText createSeparator() {
                return new SidePanelSeparator();
            }

            protected void layout() {
                this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                this.myExtraPanel.add((Component)this.myComponent, "Center");
                this.myExtraPanel.add((Component)this.myCountLabel, "East");
                this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CounterDisplayConfigurable configurable;
                int count;
                Place place;
                Object category;
                this.layout();
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Place && (category = (place = (Place)value).getPath("category")) instanceof CounterDisplayConfigurable && (count = (configurable = (CounterDisplayConfigurable)category).getCount()) > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(count > 100 ? "100+" : String.valueOf(count));
                }
                return component;
            }

            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new SidePanelCountLabel();
                JComponent component = super.createItemComponent();
                this.myTextLabel.setForeground((Color)Gray._240);
                this.myTextLabel.setOpaque(true);
                return component;
            }

            protected Color getBackground() {
                return UIUtil.SIDE_PANEL_BACKGROUND;
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList, (boolean)true), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object value = this.myList.getSelectedValue();
            if (value != null) {
                this.myNavigator.navigateTo((Place)value, false);
            }
        });
    }

    @NotNull
    public JBList getList() {
        JBList jBList = this.myList;
        if (jBList == null) {
            SidePanel.$$$reportNull$$$0(2);
        }
        return jBList;
    }

    public void addPlace(@NotNull Place place, @NotNull Presentation presentation) {
        if (place == null) {
            SidePanel.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            SidePanel.$$$reportNull$$$0(4);
        }
        this.myListModel.addElement(place);
        this.myPlaces.add(place);
        this.myPresentationByPlace.put(place, presentation);
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.myListModel.clear();
        this.myPlaces.clear();
        this.myPresentationByPlace.clear();
        this.mySeparatorByIndex.clear();
    }

    public void addSeparator(@NotNull String text) {
        if (text == null) {
            SidePanel.$$$reportNull$$$0(5);
        }
        this.mySeparatorByIndex.put(this.myPlaces.size(), text);
    }

    @Nullable
    public String getSeparatorAbove(@NotNull Place place) {
        if (place == null) {
            SidePanel.$$$reportNull$$$0(6);
        }
        return this.mySeparatorByIndex.get(this.myPlaces.indexOf(place));
    }

    @NotNull
    public Collection<Place> getPlaces() {
        List<Place> list = this.myPlaces;
        if (list == null) {
            SidePanel.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void select(@NotNull Place place) {
        if (place == null) {
            SidePanel.$$$reportNull$$$0(8);
        }
        this.myList.setSelectedValue((Object)place, true);
    }

    @NotNull
    public ListItemDescriptor<Place> getDescriptor() {
        ListItemDescriptor<Place> listItemDescriptor = this.myDescriptor;
        if (listItemDescriptor == null) {
            SidePanel.$$$reportNull$$$0(9);
        }
        return listItemDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/dialog/SidePanel";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/dialog/SidePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPlace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSeparatorAbove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

