/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.FmUtil;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.module.Module;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class FmHasDependencyMethod
implements TemplateMethodModelEx {
    private final Map<String, Object> myParamMap;

    public FmHasDependencyMethod(Map<String, Object> paramMap) {
        this.myParamMap = paramMap;
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        AndroidModuleModel androidModel;
        AndroidFacet facet;
        Module module;
        String modulePath;
        Object untyped;
        if (args.size() < 1 || args.size() > 2) {
            throw new TemplateModelException("Wrong arguments");
        }
        String artifact = ((TemplateScalarModel)args.get(0)).getAsString();
        if (artifact.isEmpty()) {
            return TemplateBooleanModel.FALSE;
        }
        String[] configurations = args.size() > 1 ? new String[]{((TemplateScalarModel)args.get(1)).getAsString()} : new String[]{"compile", "implementation", "api"};
        if (this.myParamMap.containsKey("dependenciesMultimap") && (untyped = this.myParamMap.get("dependenciesMultimap")) instanceof SetMultimap) {
            SetMultimap dependencies = (SetMultimap)untyped;
            for (String configuration : configurations) {
                for (String dependency : dependencies.get((Object)configuration)) {
                    if (!dependency.contains(artifact)) continue;
                    return TemplateBooleanModel.TRUE;
                }
            }
        }
        if ((modulePath = (String)this.myParamMap.get("projectOut")) != null && (module = FmUtil.findModule(modulePath)) != null && (facet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidModuleModel.get(facet)) != null) {
            boolean dependsOn;
            switch (configurations[0]) {
                case "compile": 
                case "implementation": 
                case "api": {
                    dependsOn = GradleUtil.dependsOn(androidModel, artifact) || GradleUtil.dependsOnJavaLibrary(androidModel, artifact);
                    break;
                }
                case "androidTestCompile": 
                case "androidTestImplementation": 
                case "androidTestApi": {
                    dependsOn = GradleUtil.dependsOnAndroidTest(androidModel, artifact);
                    break;
                }
                default: {
                    throw new TemplateModelException("Unknown dependency configuration " + configurations[0]);
                }
            }
            return dependsOn ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (artifact.contains("com.android.support:appcompat-v7") || artifact.contains("com.android.support:support-v4")) {
            Object buildApiObject = this.myParamMap.get("buildApi");
            Object minApiObject = this.myParamMap.get("minApiLevel");
            if (buildApiObject instanceof Integer && minApiObject instanceof Integer) {
                int buildApi = (Integer)buildApiObject;
                int minApi = (Integer)minApiObject;
                return minApi >= 8 && (buildApi >= 21 && minApi < 21 || minApi < 14) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
        return TemplateBooleanModel.FALSE;
    }
}

