/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.KotlinSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Template {
    public static final String TEMPLATE_XML_NAME = "template.xml";
    public static final String TAG_EXECUTE = "execute";
    public static final String TAG_GLOBALS = "globals";
    public static final String TAG_GLOBAL = "global";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_THUMB = "thumb";
    public static final String TAG_THUMBS = "thumbs";
    public static final String TAG_DEPENDENCY = "dependency";
    public static final String TAG_ICONS = "icons";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_HELP = "help";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_ENABLED = "enabled";
    public static final String CATEGORY_ACTIVITIES = "activities";
    public static final String CATEGORY_PROJECTS = "gradle-projects";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_APPLICATION = "Application";
    public static final String ANDROID_MODULE_TEMPLATE = "Android Module";
    public static final String ANDROID_PROJECT_TEMPLATE = "Android Project";
    static final int CURRENT_FORMAT = 5;
    static final int RELATIVE_FILES_FORMAT = 5;
    private static final int MAX_WARNINGS = 10;
    private static final String GOOGLE_GLASS_PATH_19 = "/addon-google_gdk-google-19/";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Template");
    private final File myTemplateRoot;
    private TemplateMetadata myMetadata;

    private Template(@NotNull File templateRoot) {
        if (templateRoot == null) {
            Template.$$$reportNull$$$0(0);
        }
        this.myTemplateRoot = templateRoot;
    }

    @NotNull
    public static Template createFromPath(@NotNull File rootPath) {
        if (rootPath == null) {
            Template.$$$reportNull$$$0(1);
        }
        Template template = new Template(rootPath);
        if (template == null) {
            Template.$$$reportNull$$$0(2);
        }
        return template;
    }

    @NotNull
    public static Template createFromName(@NotNull String category, @NotNull String name) {
        if (category == null) {
            Template.$$$reportNull$$$0(3);
        }
        if (name == null) {
            Template.$$$reportNull$$$0(4);
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            Template template = new Template(file);
            if (template == null) {
                Template.$$$reportNull$$$0(5);
            }
            return template;
        }
        Template template = new Template(new File(TemplateManager.getTemplateRootFolder(), category + File.separator + name));
        if (template == null) {
            Template.$$$reportNull$$$0(6);
        }
        return template;
    }

    private static void enforceParameterTypes(@NotNull TemplateMetadata metadata, @NotNull Map<String, Object> args) {
        if (metadata == null) {
            Template.$$$reportNull$$$0(7);
        }
        if (args == null) {
            Template.$$$reportNull$$$0(8);
        }
        for (Parameter p : metadata.getParameters()) {
            Object o = args.get(p.id);
            if (o == null) continue;
            switch (p.type) {
                case STRING: {
                    if (o instanceof String) break;
                    args.put(p.id, o.toString());
                    break;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) break;
                    args.put(p.id, Boolean.parseBoolean(o.toString()));
                    break;
                }
                case ENUM: {
                    break;
                }
            }
        }
        Template.convertApisToInt(args);
    }

    public static void convertApisToInt(@NotNull Map<String, Object> args) {
        if (args == null) {
            Template.$$$reportNull$$$0(9);
        }
        Template.convertToInt("buildApi", args);
        Template.convertToInt("minApiLevel", args);
        Template.convertToInt("targetApi", args);
    }

    private static void convertToInt(@NotNull String key, @NotNull Map<String, Object> args) {
        Object value;
        if (key == null) {
            Template.$$$reportNull$$$0(10);
        }
        if (args == null) {
            Template.$$$reportNull$$$0(11);
        }
        if ((value = args.get(key)) instanceof String) {
            Integer result2;
            try {
                result2 = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                result2 = SdkVersionInfo.getApiByPreviewName((String)((String)value), (boolean)true);
            }
            args.put(key, result2);
        }
    }

    public boolean render(@NotNull RenderingContext context, boolean dryRun) {
        Project project;
        if (context == null) {
            Template.$$$reportNull$$$0(12);
        }
        boolean success = (project = context.getProject()).isInitialized() ? this.doRender(context) : ((Boolean)PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> {
            if (context == null) {
                Template.$$$reportNull$$$0(31);
            }
            return this.doRender(context);
        })).booleanValue();
        String title = this.myMetadata.getTitle();
        if (!dryRun && title != null) {
            Map<String, Object> paramMap = context.getParamMap();
            Object kotlinSupport = paramMap.get("includeKotlinSupport");
            Object kotlinVersion = paramMap.get("kotlinVersion");
            AndroidStudioEvent.Builder aseBuilder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEMPLATE).setKind(AndroidStudioEvent.EventKind.TEMPLATE_RENDER).setTemplateRenderer(Template.titleToTemplateRenderer(title)).setKotlinSupport(KotlinSupport.newBuilder().setIncludeKotlinSupport(kotlinSupport instanceof Boolean ? (Boolean)kotlinSupport : false).setKotlinSupportVersion(kotlinVersion instanceof String ? (String)kotlinVersion : "unknown"));
            UsageTracker.getInstance().log(aseBuilder);
            if (paramMap.get("hasInstantAppWrapper") instanceof Boolean && ((Boolean)paramMap.get("hasInstantAppWrapper")).booleanValue()) {
                aseBuilder.setTemplateRenderer(AndroidStudioEvent.TemplateRenderer.ANDROID_INSTANT_APP_PROJECT);
                UsageTracker.getInstance().log(aseBuilder);
            }
        }
        if (context.shouldReformat()) {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (context == null) {
                    Template.$$$reportNull$$$0(30);
                }
                TemplateUtils.reformatAndRearrange(project, context.getTargetFiles());
            });
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ((PsiDocumentManager)PsiDocumentManager.getInstance((Project)project)).commitAllDocuments());
        return success;
    }

    static AndroidStudioEvent.TemplateRenderer titleToTemplateRenderer(String title) {
        switch (title) {
            case "": {
                return AndroidStudioEvent.TemplateRenderer.UNKNOWN_TEMPLATE_RENDERER;
            }
            case "Android Module": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_MODULE;
            }
            case "Android Project": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_PROJECT;
            }
            case "Empty Activity": {
                return AndroidStudioEvent.TemplateRenderer.EMPTY_ACTIVITY;
            }
            case "Blank Activity": {
                return AndroidStudioEvent.TemplateRenderer.BLANK_ACTIVITY;
            }
            case "Layout XML File": {
                return AndroidStudioEvent.TemplateRenderer.LAYOUT_XML_FILE;
            }
            case "Fragment (Blank)": {
                return AndroidStudioEvent.TemplateRenderer.FRAGMENT_BLANK;
            }
            case "Navigation Drawer Activity": {
                return AndroidStudioEvent.TemplateRenderer.NAVIGATION_DRAWER_ACTIVITY;
            }
            case "Values XML File": {
                return AndroidStudioEvent.TemplateRenderer.VALUES_XML_FILE;
            }
            case "Google Maps Activity": {
                return AndroidStudioEvent.TemplateRenderer.GOOGLE_MAPS_ACTIVITY;
            }
            case "Login Activity": {
                return AndroidStudioEvent.TemplateRenderer.LOGIN_ACTIVITY;
            }
            case "Assets Folder": {
                return AndroidStudioEvent.TemplateRenderer.ASSETS_FOLDER;
            }
            case "Tabbed Activity": {
                return AndroidStudioEvent.TemplateRenderer.TABBED_ACTIVITY;
            }
            case "Scrolling Activity": {
                return AndroidStudioEvent.TemplateRenderer.SCROLLING_ACTIVITY;
            }
            case "Fullscreen Activity": {
                return AndroidStudioEvent.TemplateRenderer.FULLSCREEN_ACTIVITY;
            }
            case "Service": {
                return AndroidStudioEvent.TemplateRenderer.SERVICE;
            }
            case "Java Library": {
                return AndroidStudioEvent.TemplateRenderer.JAVA_LIBRARY;
            }
            case "Settings Activity": {
                return AndroidStudioEvent.TemplateRenderer.SETTINGS_ACTIVITY;
            }
            case "Fragment (List)": {
                return AndroidStudioEvent.TemplateRenderer.FRAGMENT_LIST;
            }
            case "Master/Detail Flow": {
                return AndroidStudioEvent.TemplateRenderer.MASTER_DETAIL_FLOW;
            }
            case "Wear OS Module": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_WEAR_MODULE;
            }
            case "Broadcast Receiver": {
                return AndroidStudioEvent.TemplateRenderer.BROADCAST_RECEIVER;
            }
            case "AIDL File": {
                return AndroidStudioEvent.TemplateRenderer.AIDL_FILE;
            }
            case "Service (IntentService)": {
                return AndroidStudioEvent.TemplateRenderer.INTENT_SERVICE;
            }
            case "JNI Folder": {
                return AndroidStudioEvent.TemplateRenderer.JNI_FOLDER;
            }
            case "Java Folder": {
                return AndroidStudioEvent.TemplateRenderer.JAVA_FOLDER;
            }
            case "Custom View": {
                return AndroidStudioEvent.TemplateRenderer.CUSTOM_VIEW;
            }
            case "Android TV Module": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_TV_MODULE;
            }
            case "Google AdMob Ads Activity": {
                return AndroidStudioEvent.TemplateRenderer.GOOGLE_ADMOBS_ADS_ACTIVITY;
            }
            case "Always On Wear Activity": {
                return AndroidStudioEvent.TemplateRenderer.ALWAYS_ON_WEAR_ACTIVITY;
            }
            case "Res Folder": {
                return AndroidStudioEvent.TemplateRenderer.RES_FOLDER;
            }
            case "Android TV Activity": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_TV_ACTIVITY;
            }
            case "Blank Wear Activity": {
                return AndroidStudioEvent.TemplateRenderer.BLANK_WEAR_ACTIVITY;
            }
            case "Basic Activity": {
                return AndroidStudioEvent.TemplateRenderer.BASIC_ACTIVITIY;
            }
            case "App Widget": {
                return AndroidStudioEvent.TemplateRenderer.APP_WIDGET;
            }
            case "Instant App Project": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_INSTANT_APP_PROJECT;
            }
            case "Instant App": {
                return AndroidStudioEvent.TemplateRenderer.ANDROID_INSTANT_APP_MODULE;
            }
        }
        return AndroidStudioEvent.TemplateRenderer.CUSTOM_TEMPLATE_RENDERER;
    }

    private static <T, E extends Throwable> T runWriteCommandAction(@NotNull Project project, @NotNull String commandName, final @NotNull ThrowableComputable<T, E> computable) throws E {
        if (project == null) {
            Template.$$$reportNull$$$0(13);
        }
        if (commandName == null) {
            Template.$$$reportNull$$$0(14);
        }
        if (computable == null) {
            Template.$$$reportNull$$$0(15);
        }
        RunResult result2 = new WriteCommandAction<T>(project, commandName, new PsiFile[0]){

            protected void run(@NotNull Result<T> result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.setResult(computable.compute());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/templates/Template$1", "run"));
            }
        }.execute();
        return (T)result2.throwException().getResultObject();
    }

    private boolean doRender(@NotNull RenderingContext context) {
        if (context == null) {
            Template.$$$reportNull$$$0(16);
        }
        TemplateMetadata metadata = this.getMetadata();
        assert (metadata != null);
        Template.enforceParameterTypes(metadata, context.getParamMap());
        try {
            Template.runWriteCommandAction(context.getProject(), context.getCommandName(), () -> {
                if (context == null) {
                    Template.$$$reportNull$$$0(29);
                }
                this.processFile(context, new File(TEMPLATE_XML_NAME));
                return null;
            });
            if (context.getWarnings().isEmpty()) {
                return true;
            }
            if (!context.showWarnings()) {
                LOG.warn("WARNING: " + context.getWarnings());
                return true;
            }
            if (!context.getProject().isInitialized() && this.myTemplateRoot.getPath().contains(GOOGLE_GLASS_PATH_19)) {
                return true;
            }
            int result2 = Messages.showOkCancelDialog((Project)context.getProject(), (String)Template.formatWarningMessage(context), (String)String.format("%1$s %2$s", context.getCommandName(), StringUtil.pluralize((String)"Warning")), (String)"Proceed Anyway", (String)"Cancel", (Icon)Messages.getWarningIcon());
            return result2 == 0;
        }
        catch (FreemarkerUtils.TemplateUserVisibleException e) {
            if (!context.showErrors()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((Project)context.getProject(), (String)Template.formatErrorMessage(context, e), (String)String.format("%1$s Failed", context.getCommandName()));
            return false;
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String formatWarningMessage(@NotNull RenderingContext context) {
        if (context == null) {
            Template.$$$reportNull$$$0(17);
        }
        int warningCount = context.getWarnings().size();
        List<String> messages = Lists.newArrayList(context.getWarnings());
        if (warningCount > 11) {
            messages = messages.subList(0, 10);
            messages.add(String.format("And %1$d more warnings...", warningCount - 10));
        }
        messages.add("\nIf you proceed the resulting project may not compile or not work as intended.");
        return Joiner.on((String)"\n\n").join((Iterable)messages);
    }

    private static String formatErrorMessage(@NotNull RenderingContext context, @NotNull FreemarkerUtils.TemplateUserVisibleException ex) {
        if (context == null) {
            Template.$$$reportNull$$$0(18);
        }
        if (ex == null) {
            Template.$$$reportNull$$$0(19);
        }
        if (!context.canCausePartialRendering()) {
            return ex.getMessage();
        }
        return ex.getMessage() + String.format("\n\n%1$s was only partially completed.", context.getCommandName()) + "\nYour project may not compile." + "\nYou may want to Undo to get back to the original state.";
    }

    @NotNull
    public File getRootPath() {
        File file = this.myTemplateRoot;
        if (file == null) {
            Template.$$$reportNull$$$0(20);
        }
        return file;
    }

    @Nullable
    public TemplateMetadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = TemplateManager.getInstance().getTemplateMetadata(this.myTemplateRoot);
        }
        return this.myMetadata;
    }

    private void processFile(final @NotNull RenderingContext context, @NotNull File file) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            Template.$$$reportNull$$$0(21);
        }
        if (file == null) {
            Template.$$$reportNull$$$0(22);
        }
        if (TemplateUtils.hasExtension(file, ".xml")) {
            String xml = TemplateUtils.readTextFromDisk(this.getTemplateFile(file));
            if (xml == null) {
                return;
            }
            this.processXml(context, xml);
        } else {
            FreemarkerUtils.processFreemarkerTemplate(context, file, new FreemarkerUtils.TemplatePostProcessor(){

                @Override
                public void process(@NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
                    if (xml == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Template.this.processXml(context, xml);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/Template$2", "process"));
                }
            });
        }
    }

    private void processXml(final @NotNull RenderingContext context, @NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            Template.$$$reportNull$$$0(23);
        }
        if (xml == null) {
            Template.$$$reportNull$$$0(24);
        }
        try {
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    try {
                        Map<String, Object> paramMap = context.getParamMap();
                        if (Template.TAG_PARAMETER.equals(name)) {
                            String id = attributes.getValue(Template.ATTR_ID);
                            if (!paramMap.containsKey(id)) {
                                String type;
                                String value = attributes.getValue(Template.ATTR_DEFAULT);
                                Object mapValue = value;
                                if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(Template.ATTR_TYPE))) {
                                    mapValue = Boolean.valueOf(value);
                                }
                                paramMap.put(id, mapValue);
                            }
                        } else if (Template.TAG_GLOBAL.equals(name)) {
                            String id = attributes.getValue(Template.ATTR_ID);
                            if (!paramMap.containsKey(id)) {
                                paramMap.put(id, TypedVariable.parseGlobal(attributes));
                            }
                        } else if (Template.TAG_GLOBALS.equals(name)) {
                            File globalsFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                            if (globalsFile != null) {
                                Template.this.processFile(context, globalsFile);
                            }
                        } else if (Template.TAG_EXECUTE.equals(name)) {
                            File recipeFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                            if (recipeFile != null) {
                                Template.this.executeRecipeFile(context, recipeFile);
                            }
                        } else if (!(name.equals("template") || name.equals("category") || name.equals("option") || name.equals(Template.TAG_THUMBS) || name.equals(Template.TAG_THUMB) || name.equals(Template.TAG_ICONS) || name.equals(Template.TAG_DEPENDENCY) || name.equals("formfactor"))) {
                            LOG.error("WARNING: Unknown template directive " + name);
                        }
                    }
                    catch (FreemarkerUtils.TemplateProcessingException e) {
                        throw new SAXException(e);
                    }
                }
            });
        }
        catch (SAXException ex) {
            if (ex.getCause() instanceof FreemarkerUtils.TemplateProcessingException) {
                throw (FreemarkerUtils.TemplateProcessingException)ex.getCause();
            }
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (IOException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
    }

    private void executeRecipeFile(final @NotNull RenderingContext context, @NotNull File fileRecipe) throws FreemarkerUtils.TemplateProcessingException {
        if (context == null) {
            Template.$$$reportNull$$$0(25);
        }
        if (fileRecipe == null) {
            Template.$$$reportNull$$$0(26);
        }
        FreemarkerUtils.processFreemarkerTemplate(context, fileRecipe, new FreemarkerUtils.TemplatePostProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(@NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
                block8: {
                    if (xml == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    try {
                        xml = XmlUtils.stripBom((String)xml);
                        Recipe recipe = Recipe.parse(new StringReader(xml));
                        RecipeExecutor recipeExecutor = context.getRecipeExecutor();
                        TemplateMetadata metadata = Template.this.getMetadata();
                        assert (metadata != null);
                        if (!metadata.useImplicitRootFolder()) {
                            recipe.execute(recipeExecutor);
                            break block8;
                        }
                        StudioTemplateLoader loader = context.getLoader();
                        try {
                            loader.pushTemplateFolder(new File(Template.this.getRootPath(), "root"));
                            recipe.execute(recipeExecutor);
                        }
                        finally {
                            loader.popTemplateFolder();
                        }
                    }
                    catch (JAXBException ex) {
                        throw new FreemarkerUtils.TemplateProcessingException((Exception)((Object)ex));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/Template$4", "process"));
            }
        });
    }

    @NotNull
    private File getTemplateFile(@NotNull File relativeFile) {
        if (relativeFile == null) {
            Template.$$$reportNull$$$0(27);
        }
        File file = new File(this.myTemplateRoot, relativeFile.getPath());
        if (file == null) {
            Template.$$$reportNull$$$0(28);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 20: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 20: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/Template";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTR_NAME;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTR_FILE;
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRecipe";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/Template";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFromPath";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 20: 
            case 28: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enforceParameterTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertApisToInt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToInt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRender";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatWarningMessage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processXml";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeRecipeFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doRender$2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$render$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$render$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 20: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

