/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.ide.common.repository.GradleVersion;
import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.templates.FmGetConfigurationNameMethod;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.base.Strings;
import com.google.common.collect.SetMultimap;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.LineSeparator;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRecipeExecutor
implements RecipeExecutor {
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final String LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
    private final FindReferencesRecipeExecutor myReferences;
    private final RenderingContext myContext;
    private final RecipeIO myIO;
    private final ReadonlyStatusHandler myReadonlyStatusHandler;
    private boolean myNeedsSync;

    public DefaultRecipeExecutor(@NotNull RenderingContext context, boolean dryRun) {
        if (context == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(0);
        }
        this.myReferences = new FindReferencesRecipeExecutor(context);
        this.myContext = context;
        this.myIO = dryRun ? new DryRunRecipeIO() : new RecipeIO();
        this.myReadonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)context.getProject());
    }

    @NotNull
    private static GradleBuildModel getBuildModel(@NotNull File buildFile, @NotNull Project project) {
        VirtualFile virtualFile;
        if (buildFile == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(2);
        }
        if ((virtualFile = VfsUtil.findFileByIoFile((File)buildFile, (boolean)true)) == null) {
            throw new RuntimeException("Failed to find " + buildFile.getPath());
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.parseBuildFile(virtualFile, project, project.getName());
        if (gradleBuildModel == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(3);
        }
        return gradleBuildModel;
    }

    @Override
    public void applyPlugin(@NotNull String plugin) {
        if (plugin == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(4);
        }
        String name = plugin.trim();
        this.myReferences.applyPlugin(name);
        Project project = this.myContext.getProject();
        File buildFile = DefaultRecipeExecutor.getBuildFilePath(this.myContext);
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(buildFile, project);
            if (buildModel.plugins().stream().noneMatch(x -> x.name().forceString().equals(name))) {
                buildModel.applyPlugin(name);
                this.myIO.applyChanges(buildModel);
            }
        } else {
            String destinationContents = buildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(buildFile)) : "";
            String applyPluginStatement = "apply plugin: '" + name + "'";
            String result2 = destinationContents.isEmpty() ? applyPluginStatement : destinationContents + LINE_SEPARATOR + applyPluginStatement;
            try {
                this.myIO.writeFile(this, result2, buildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsSync = true;
    }

    @Override
    public void addClasspath(@NotNull String mavenUrl) {
        if (mavenUrl == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(5);
        }
        mavenUrl = mavenUrl.trim();
        this.myReferences.addClasspath(mavenUrl);
        ArtifactDependencySpec toBeAddedDependency = ArtifactDependencySpec.create(mavenUrl);
        if (toBeAddedDependency == null) {
            throw new RuntimeException(mavenUrl + " is not a valid classpath dependency");
        }
        Project project = this.myContext.getProject();
        File rootBuildFile = GradleUtil.getGradleBuildFilePath(Projects.getBaseDirPath((Project)project));
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(rootBuildFile, project);
            DependenciesModel buildscriptDependencies = buildModel.buildscript().dependencies();
            ArtifactDependencyModel targetDependencyModel = null;
            for (ArtifactDependencyModel dependencyModel : buildscriptDependencies.artifacts(CLASSPATH_CONFIGURATION_NAME)) {
                if (!toBeAddedDependency.equalsIgnoreVersion(ArtifactDependencySpec.create(dependencyModel))) continue;
                targetDependencyModel = dependencyModel;
            }
            if (targetDependencyModel == null) {
                buildscriptDependencies.addArtifact(CLASSPATH_CONFIGURATION_NAME, toBeAddedDependency);
            } else {
                GradleVersion existingDependencyVersion;
                GradleVersion toBeAddedDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)toBeAddedDependency.getVersion()));
                if (toBeAddedDependencyVersion.compareTo(existingDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)targetDependencyModel.version().toString()))) > 0) {
                    targetDependencyModel.version().setValue(Strings.nullToEmpty((String)toBeAddedDependency.getVersion()));
                }
            }
            this.myIO.applyChanges(buildModel);
        } else {
            String destinationContents = rootBuildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(rootBuildFile)) : "";
            String result2 = this.myIO.mergeBuildFiles(DefaultRecipeExecutor.formatClasspath(mavenUrl), destinationContents, project, "");
            try {
                this.myIO.writeFile(this, result2, rootBuildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsSync = true;
    }

    @NotNull
    private static String formatClasspath(@NotNull String dependency) {
        if (dependency == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(6);
        }
        String string = "buildscript {" + LINE_SEPARATOR + "  dependencies {" + LINE_SEPARATOR + "    classpath '" + dependency + "'" + LINE_SEPARATOR + "  }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR;
        if (string == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static File getBuildFilePath(@NotNull RenderingContext context) {
        Module module;
        if (context == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(8);
        }
        VirtualFile moduleBuildFile = (module = context.getModule()) == null ? null : GradleUtil.getGradleBuildFile(module);
        File file = moduleBuildFile == null ? GradleUtil.getGradleBuildFilePath(context.getModuleRoot()) : VfsUtilCore.virtualToIoFile((VirtualFile)moduleBuildFile);
        if (file == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(9);
        }
        return file;
    }

    @Override
    public void addDependency(@NotNull String configuration, @NotNull String mavenUrl) {
        if (configuration == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(10);
        }
        if (mavenUrl == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(11);
        }
        configuration = FmGetConfigurationNameMethod.convertConfiguration(this.getParamMap(), configuration);
        this.myReferences.addDependency(configuration, mavenUrl);
        SetMultimap dependencyList = (SetMultimap)this.getParamMap().get("dependenciesMultimap");
        dependencyList.put((Object)configuration, (Object)mavenUrl);
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        if (file == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(12);
        }
        this.myReferences.addFilesToOpen(file);
    }

    private void addWarning(@NotNull String warning) {
        if (warning == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(13);
        }
        this.myContext.getWarnings().add(warning);
    }

    @NotNull
    private Map<String, Object> getParamMap() {
        Map<String, Object> map2 = this.myContext.getParamMap();
        if (map2 == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NotNull
    Configuration getFreemarker() {
        Configuration configuration = this.myContext.getFreemarkerConfiguration();
        if (configuration == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(15);
        }
        return configuration;
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        if (from == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(16);
        }
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(17);
        }
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(18);
        }
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(19);
        }
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                File sourceFile = this.myContext.getLoader().getSourceFile(from);
                File targetFile = this.getTargetFile(to);
                String content = FreemarkerUtils.processFreemarkerTemplate(this.myContext, sourceFile, null);
                content = this.extractFullyQualifiedNames(to, content);
                if (targetFile.exists()) {
                    if (!this.compareTextFile(targetFile, content)) {
                        this.addFileAlreadyExistWarning(targetFile);
                    }
                } else {
                    this.myIO.writeFile(this, content, targetFile);
                    this.myReferences.addSourceFile(sourceFile);
                    this.myReferences.addTargetFile(targetFile);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        if (from == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(20);
        }
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(21);
        }
        try {
            String contents;
            String sourceText;
            String targetText = null;
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(targetFile, ".xml") && !TemplateUtils.hasExtension(targetFile, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + targetFile);
            }
            if (targetFile.exists()) {
                VirtualFile toFile;
                ReadonlyStatusHandler.OperationStatus status;
                if (this.myContext.getProject().isInitialized() && (status = this.myReadonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{toFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)})).hasReadonlyFiles()) {
                    throw new FreemarkerUtils.TemplateUserVisibleException(String.format("Attempt to update file that is readonly: %1$s", targetFile.getAbsolutePath()));
                }
                targetText = this.readTextFile(targetFile);
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, targetFile);
                } else {
                    this.copyTemplateResource(from, targetFile);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myContext, from, null);
            } else {
                sourceText = TemplateUtils.readTextFromDisk(sourceFile);
                if (sourceText == null) {
                    return;
                }
            }
            if (targetFile.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsSync = true;
            } else if (targetFile.getName().equals("build.gradle")) {
                String compileSdkVersion2 = (String)this.getParamMap().get("buildApiString");
                contents = this.myIO.mergeBuildFiles(sourceText, targetText, this.myContext.getProject(), compileSdkVersion2);
                this.myNeedsSync = true;
            } else if (TemplateUtils.hasExtension(targetFile, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myContext, sourceText, targetText, targetFile);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + targetFile);
            }
            this.myIO.writeFile(this, contents, targetFile);
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(@NotNull File from, @NotNull File to) {
        if (from == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(22);
        }
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(23);
        }
        try {
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            String sourceText = TemplateUtils.readTextFromDisk(sourceFile);
            if (sourceText == null) {
                return;
            }
            if (targetFile.exists()) {
                String targetContents = TemplateUtils.readTextFromDisk(targetFile);
                String resultContents = (targetContents == null ? "" : targetContents + LINE_SEPARATOR) + sourceText;
                this.myIO.writeFile(this, resultContents, targetFile);
            } else {
                this.myIO.writeFile(this, sourceText, targetFile);
            }
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkDir(@NotNull File at) {
        if (at == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(24);
        }
        try {
            this.myIO.mkDir(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAndSync() {
        if (!this.myContext.getDependencies().isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Project project = this.myContext.getProject();
        if (this.myNeedsSync && this.myContext.performSync() && !project.isDefault() && GradleProjects.isBuildWithGradle(project)) {
            this.myIO.requestSync(project);
        }
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        if (folder == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(25);
        }
        try {
            this.myContext.getLoader().pushTemplateFolder(folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void popFolder() {
        this.myContext.getLoader().popTemplateFolder();
    }

    @NotNull
    private File getTargetFile(@NotNull File file) throws IOException {
        if (file == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(26);
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                DefaultRecipeExecutor.$$$reportNull$$$0(27);
            }
            return file2;
        }
        File file3 = new File(this.myContext.getOutputRoot(), file.getPath());
        if (file3 == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(28);
        }
        return file3;
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        String baseFeatureRoot = (String)this.getParamMap().getOrDefault("baseFeatureDir", "");
        File featureBuildFile = DefaultRecipeExecutor.getBuildFilePath(this.myContext);
        if (Strings.isNullOrEmpty((String)baseFeatureRoot)) {
            this.writeDependencies(featureBuildFile, x -> true);
        } else {
            String configName = FmGetConfigurationNameMethod.convertConfiguration(this.getParamMap(), "compile");
            if ("implementation".equals(configName)) {
                for (String apiDependency : this.myContext.getDependencies().removeAll((Object)"implementation")) {
                    this.myContext.getDependencies().put((Object)"api", (Object)apiDependency);
                }
                configName = "api";
            }
            File baseBuildFile = GradleUtil.getGradleBuildFilePath(new File(baseFeatureRoot));
            String configuration = configName;
            this.writeDependencies(baseBuildFile, x -> x.equals(configuration));
            this.writeDependencies(featureBuildFile, x -> !x.equals(configuration));
        }
        this.myNeedsSync = true;
    }

    private void writeDependencies(File buildFile, Predicate<String> configurationFilter) throws IOException {
        String destinationContents = buildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(buildFile)) : "";
        Object buildApi = this.getParamMap().get("buildApi");
        String supportLibVersionFilter = buildApi != null ? buildApi.toString() : "";
        String result2 = this.myIO.mergeBuildFiles(this.formatDependencies(configurationFilter), destinationContents, this.myContext.getProject(), supportLibVersionFilter);
        this.myIO.writeFile(this, result2, buildFile);
    }

    private boolean useAndroidX(@NotNull Project project, @Nullable Module module) {
        Object buildApiObj;
        int buildApi;
        if (project == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(29);
        }
        int n = buildApi = (buildApiObj = this.getParamMap().get("buildApi")) == null ? 0 : Integer.parseInt(buildApiObj.toString());
        if (buildApi < 28) {
            return false;
        }
        if (MigrateToAndroidxUtil.hasAndroidxProperty(project)) {
            return MigrateToAndroidxUtil.isAndroidx(project);
        }
        if (module != null && DependencyManagementUtil.dependsOnOldSupportLib(module)) {
            return false;
        }
        return (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get();
    }

    private String formatDependencies(Predicate<String> configurationFilter) {
        StringBuilder dependencies = new StringBuilder();
        dependencies.append("dependencies {\n");
        boolean useAndroidX = this.useAndroidX(this.myContext.getProject(), this.myContext.getModule());
        for (Map.Entry dependency : this.myContext.getDependencies().entries()) {
            if (!configurationFilter.test((String)dependency.getKey())) continue;
            dependencies.append("  ").append((String)dependency.getKey()).append(" ");
            String dependencyValue = useAndroidX ? AndroidxNameUtils.getVersionedCoordinateMapping((String)((String)dependency.getValue())) : (String)dependency.getValue();
            boolean isInterpolated = dependencyValue.contains("$");
            dependencies.append(isInterpolated ? (char)'\"' : '\'').append(dependencyValue).append(isInterpolated ? (char)'\"' : '\'').append("\n");
        }
        dependencies.append("}\n");
        return dependencies.toString();
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull File dest) throws IOException {
        if (src == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(30);
        }
        if (dest == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(31);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    return DefaultRecipeExecutor.this.copyFile(file, src, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$1", "visitFile"));
            }
        }, IOException.class);
    }

    private void copyTemplateResource(@NotNull File from, @NotNull File to) throws IOException {
        File destPath;
        if (from == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(32);
        }
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(33);
        }
        File source = this.myContext.getLoader().getSourceFile(from);
        File target = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)source, (boolean)true);
        assert (sourceFile != null) : source;
        sourceFile.refresh(false, false);
        File file = destPath = source.isDirectory() ? target : target.getParentFile();
        if (source.isDirectory()) {
            this.copyDirectory(sourceFile, destPath);
        } else if (target.exists()) {
            if (!this.compareFile(sourceFile, target)) {
                this.addFileAlreadyExistWarning(target);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.myIO.writeFile(this, document.getText(), target);
            } else {
                this.myIO.copyFile(this, sourceFile, destPath, target.getName());
            }
            this.myReferences.addSourceFile(source);
            this.myReferences.addTargetFile(target);
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            throw new RuntimeException(String.format("%1$s is not a child of %2$s", file.getPath(), src));
        }
        if (file.isDirectory()) {
            this.myIO.mkDir(new File(destinationFile, relativePath));
        } else {
            File target = new File(destinationFile, relativePath);
            if (target.exists()) {
                if (!this.compareFile(file, target)) {
                    this.addFileAlreadyExistWarning(target);
                }
            } else {
                this.myIO.copyFile(this, file, target);
                this.myReferences.addSourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                this.myReferences.addTargetFile(target);
            }
        }
        return true;
    }

    private String readTextFile(@NotNull File file) {
        if (file == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(34);
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(file);
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String readTextFile(@NotNull VirtualFile file) {
        if (file == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(35);
        }
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String extractFullyQualifiedNames(@NotNull File to, @NotNull String content) {
        if (to == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(36);
        }
        if (content == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(37);
        }
        if (ResourceFolderType.getFolderType((String)to.getParentFile().getName()) != ResourceFolderType.LAYOUT) {
            return content;
        }
        String packageName = (String)this.getParamMap().get("applicationPackage");
        if (packageName == null) {
            packageName = (String)this.getParamMap().get("packageName");
        }
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)this.myContext.getProject());
        XmlTag root = factory.createTagFromText((CharSequence)content);
        XmlAttribute contextAttr = root.getAttribute("context", "http://schemas.android.com/tools");
        if (packageName == null || contextAttr == null) {
            return content;
        }
        String context = contextAttr.getValue();
        if (context == null || !context.startsWith(packageName + '.')) {
            return content;
        }
        String newContext = context.substring(packageName.length());
        root.setAttribute("context", "http://schemas.android.com/tools", newContext);
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + root.getText();
    }

    public boolean compareFile(@NotNull VirtualFile sourceVFile, @NotNull File targetFile) throws IOException {
        VirtualFile targetVFile;
        if (sourceVFile == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(38);
        }
        if (targetFile == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(39);
        }
        if ((targetVFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)) == null) {
            return false;
        }
        if (sourceVFile.getFileType().isBinary()) {
            byte[] source = sourceVFile.contentsToByteArray();
            byte[] target = targetVFile.contentsToByteArray();
            return Arrays.equals(source, target);
        }
        String source = this.readTextFile(sourceVFile);
        String target = this.readTextFile(targetVFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)source, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public boolean compareTextFile(@NotNull File targetFile, @NotNull String content) {
        if (targetFile == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(40);
        }
        if (content == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(41);
        }
        String target = this.readTextFile(targetFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)content, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private void addFileAlreadyExistWarning(@NotNull File targetFile) {
        if (targetFile == null) {
            DefaultRecipeExecutor.$$$reportNull$$$0(42);
        }
        this.addWarning(String.format("The following file could not be created since it already exists: %1$s", targetFile.getName()));
    }

    private static Logger getLog() {
        return Logger.getInstance(DefaultRecipeExecutor.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 2: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: 
            case 26: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceVFile";
                break;
            }
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClasspath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreemarker";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuildModel";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 27: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addClasspath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatClasspath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuildFilePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToOpen";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addWarning";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "mkDir";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pushFolder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "useAndroidX";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectory";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplateResource";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readTextFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "extractFullyQualifiedNames";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "compareFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "compareTextFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addFileAlreadyExistWarning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DryRunRecipeIO
    extends RecipeIO {
        private DryRunRecipeIO() {
        }

        @Override
        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                DryRunRecipeIO.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DryRunRecipeIO.$$$reportNull$$$0(1);
            }
            TemplateUtils.checkDirectoryIsWriteable(to.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                DryRunRecipeIO.$$$reportNull$$$0(2);
            }
            if (toFile == null) {
                DryRunRecipeIO.$$$reportNull$$$0(3);
            }
            TemplateUtils.checkDirectoryIsWriteable(toFile.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @Nullable String newName2) throws IOException {
            if (file == null) {
                DryRunRecipeIO.$$$reportNull$$$0(4);
            }
            if (toFileDir == null) {
                DryRunRecipeIO.$$$reportNull$$$0(5);
            }
            TemplateUtils.checkDirectoryIsWriteable(toFileDir);
        }

        @Override
        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                DryRunRecipeIO.$$$reportNull$$$0(6);
            }
            TemplateUtils.checkDirectoryIsWriteable(directory);
        }

        @Override
        public void applyChanges(@NotNull GradleBuildModel buildModel) {
            if (buildModel == null) {
                DryRunRecipeIO.$$$reportNull$$$0(7);
            }
        }

        @Override
        public String mergeBuildFiles(@NotNull String dependencies, @NotNull String destinationContents, Project project, String compileSdkVersion2) {
            if (dependencies == null) {
                DryRunRecipeIO.$$$reportNull$$$0(8);
            }
            if (destinationContents == null) {
                DryRunRecipeIO.$$$reportNull$$$0(9);
            }
            return destinationContents;
        }

        @Override
        public void requestSync(@NotNull Project project) {
            if (project == null) {
                DryRunRecipeIO.$$$reportNull$$$0(10);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toFileDir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildModel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destinationContents";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$DryRunRecipeIO";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copyFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mkDir";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChanges";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeBuildFiles";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestSync";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RecipeIO {
        private RecipeIO() {
        }

        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            if (requestor == null) {
                RecipeIO.$$$reportNull$$$0(0);
            }
            if (to == null) {
                RecipeIO.$$$reportNull$$$0(1);
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            TemplateUtils.writeTextFile(this, contents, to);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            if (file == null) {
                RecipeIO.$$$reportNull$$$0(2);
            }
            if (toFile == null) {
                RecipeIO.$$$reportNull$$$0(3);
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFile.getParentFile());
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)toDir);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @NotNull String newName2) throws IOException {
            if (file == null) {
                RecipeIO.$$$reportNull$$$0(4);
            }
            if (toFileDir == null) {
                RecipeIO.$$$reportNull$$$0(5);
            }
            if (newName2 == null) {
                RecipeIO.$$$reportNull$$$0(6);
            }
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFileDir);
            VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)toDir, (String)newName2);
        }

        public void mkDir(@NotNull File directory) throws IOException {
            if (directory == null) {
                RecipeIO.$$$reportNull$$$0(7);
            }
            TemplateUtils.checkedCreateDirectoryIfMissing(directory);
        }

        public void applyChanges(@NotNull GradleBuildModel buildModel) {
            if (buildModel == null) {
                RecipeIO.$$$reportNull$$$0(8);
            }
            buildModel.applyChanges();
        }

        public String mergeBuildFiles(@NotNull String dependencies, @NotNull String destinationContents, @NotNull Project project, @Nullable String supportLibVersionFilter) {
            if (dependencies == null) {
                RecipeIO.$$$reportNull$$$0(9);
            }
            if (destinationContents == null) {
                RecipeIO.$$$reportNull$$$0(10);
            }
            if (project == null) {
                RecipeIO.$$$reportNull$$$0(11);
            }
            return ProjectSystemUtil.getProjectSystem(project).mergeBuildFiles(dependencies, destinationContents, supportLibVersionFilter);
        }

        public void requestSync(@NotNull Project project) {
            ProjectSystemSyncManager syncManager;
            if (project == null) {
                RecipeIO.$$$reportNull$$$0(12);
            }
            if ((syncManager = ProjectSystemUtil.getProjectSystem(project).getSyncManager()).isSyncInProgress()) {
                DefaultRecipeExecutor.getLog().error("Added new files with Project Sync in progress");
            }
            syncManager.syncProject(project.isInitialized() ? ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED : ProjectSystemSyncManager.SyncReason.PROJECT_LOADED, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toFileDir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildModel";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destinationContents";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/templates/recipe/DefaultRecipeExecutor$RecipeIO";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copyFile";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mkDir";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChanges";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeBuildFiles";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestSync";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

