/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeModel
implements TreeModel {
    @NotNull
    private final File myRoot;
    @NotNull
    private Node myRootNode;
    private boolean myHideIrrelevantFiles;

    public FileTreeModel(@NotNull File root, boolean hideIrrelevantFiles) {
        if (root == null) {
            FileTreeModel.$$$reportNull$$$0(0);
        }
        this(root);
        this.myHideIrrelevantFiles = hideIrrelevantFiles;
    }

    public FileTreeModel(@NotNull File root) {
        if (root == null) {
            FileTreeModel.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myRootNode = FileTreeModel.makeTree(root);
    }

    @Override
    public Object getRoot() {
        if (this.myHideIrrelevantFiles && !this.myRootNode.isProposedFile) {
            return null;
        }
        return this.myRootNode;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Node n = (Node)parent;
        if (!this.myHideIrrelevantFiles) {
            return n.children.get(index);
        }
        for (int i = 0; i < n.children.size(); ++i) {
            Node child = n.children.get(i);
            if (child.isProposedFile && index == 0) {
                return child;
            }
            if (!child.isProposedFile) continue;
            --index;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)parent).children.size();
        }
        int count = 0;
        for (Node n : ((Node)parent).children) {
            if (!n.isProposedFile) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)node).children.isEmpty();
        }
        for (Node n : ((Node)node).children) {
            if (!n.isProposedFile) continue;
            return false;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!this.myHideIrrelevantFiles) {
            return ((Node)parent).children.indexOf(child);
        }
        Node n = (Node)parent;
        int index = 0;
        for (int i = 0; i < n.children.size(); ++i) {
            Node candidate = n.children.get(i);
            if (candidate.equals(child)) {
                return index;
            }
            if (!candidate.isProposedFile) continue;
            ++index;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public boolean hasConflicts() {
        return FileTreeModel.treeHasConflicts(this.myRootNode);
    }

    private static boolean treeHasConflicts(@NotNull Node root) {
        if (root == null) {
            FileTreeModel.$$$reportNull$$$0(2);
        }
        if (root.isConflicted) {
            return true;
        }
        for (Node n : root.children) {
            if (!FileTreeModel.treeHasConflicts(n)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Node addFile(@NotNull File f) {
        if (f == null) {
            FileTreeModel.$$$reportNull$$$0(3);
        }
        return this.addFile(f, null);
    }

    @Nullable
    public Node addFile(@NotNull File f, @Nullable Icon ic) {
        String s;
        if (f == null) {
            FileTreeModel.$$$reportNull$$$0(4);
        }
        if (FileUtil.filesEqual((File)f, (File)this.myRoot)) {
            return null;
        }
        String string = s = f.isAbsolute() ? FileUtil.getRelativePath((File)this.myRoot, (File)f) : f.getPath();
        if (s != null) {
            LinkedList parts = Lists.newLinkedList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)s));
            return FileTreeModel.makeNode(this.myRootNode, parts, ic, false);
        }
        return null;
    }

    @Nullable
    public Node forceAddFile(@NotNull File f, @Nullable Icon ic) {
        String s;
        if (f == null) {
            FileTreeModel.$$$reportNull$$$0(5);
        }
        String string = s = f.isAbsolute() ? FileUtil.getRelativePath((File)this.myRoot, (File)f) : f.getPath();
        if (s != null) {
            LinkedList parts = Lists.newLinkedList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)s));
            return FileTreeModel.makeNode(this.myRootNode, parts, ic, true);
        }
        return null;
    }

    public void sort(@NotNull Comparator<File> comparator2) {
        if (comparator2 == null) {
            FileTreeModel.$$$reportNull$$$0(6);
        }
        FileTreeModel.sort(this.myRoot, this.myRootNode, comparator2);
    }

    private static void sort(@NotNull File rootFile, @NotNull Node rootNode, @NotNull Comparator<File> comparator2) {
        if (rootFile == null) {
            FileTreeModel.$$$reportNull$$$0(7);
        }
        if (rootNode == null) {
            FileTreeModel.$$$reportNull$$$0(8);
        }
        if (comparator2 == null) {
            FileTreeModel.$$$reportNull$$$0(9);
        }
        rootNode.children = rootNode.children.stream().sorted((o1, o2) -> {
            if (comparator2 == null) {
                FileTreeModel.$$$reportNull$$$0(23);
            }
            if (rootFile == null) {
                FileTreeModel.$$$reportNull$$$0(24);
            }
            return comparator2.compare(new File(rootFile, o1.name), new File(rootFile, o2.name));
        }).collect(Collectors.toList());
        rootNode.children.forEach(childNode -> {
            if (rootFile == null) {
                FileTreeModel.$$$reportNull$$$0(21);
            }
            if (comparator2 == null) {
                FileTreeModel.$$$reportNull$$$0(22);
            }
            FileTreeModel.sort(new File(rootFile, childNode.name), childNode, comparator2);
        });
    }

    @NotNull
    private static Node makeNode(@NotNull Node root, @NotNull List<String> path, @Nullable Icon ic, boolean markConflict) {
        if (root == null) {
            FileTreeModel.$$$reportNull$$$0(10);
        }
        if (path == null) {
            FileTreeModel.$$$reportNull$$$0(11);
        }
        root.isProposedFile = true;
        if (path.isEmpty()) {
            Node node = root;
            if (node == null) {
                FileTreeModel.$$$reportNull$$$0(12);
            }
            return node;
        }
        String name = path.get(0);
        if (markConflict && path.size() == 1 && root.name.equals(name)) {
            root.isConflicted = true;
            Node node = root;
            if (node == null) {
                FileTreeModel.$$$reportNull$$$0(13);
            }
            return node;
        }
        if (root.name.equals(name)) {
            Node node = FileTreeModel.makeNode(root, FileTreeModel.rest(path), ic, markConflict);
            if (node == null) {
                FileTreeModel.$$$reportNull$$$0(14);
            }
            return node;
        }
        if (root.hasChild(name)) {
            if (markConflict && path.size() == 1) {
                Node targetNode = root.getChild(name);
                assert (targetNode != null);
                targetNode.isConflicted = true;
                targetNode.icon = ic;
                targetNode.isProposedFile = true;
                Node node = targetNode;
                if (node == null) {
                    FileTreeModel.$$$reportNull$$$0(15);
                }
                return node;
            }
            Node node = FileTreeModel.makeNode(root.getChild(name), FileTreeModel.rest(path), ic, markConflict);
            if (node == null) {
                FileTreeModel.$$$reportNull$$$0(16);
            }
            return node;
        }
        Node newNode = new Node();
        newNode.name = name;
        root.children.add(newNode);
        if (path.size() != 1) {
            Node node = FileTreeModel.makeNode(newNode, FileTreeModel.rest(path), ic, markConflict);
            if (node == null) {
                FileTreeModel.$$$reportNull$$$0(17);
            }
            return node;
        }
        newNode.icon = ic;
        newNode.isProposedFile = true;
        Node node = newNode;
        if (node == null) {
            FileTreeModel.$$$reportNull$$$0(18);
        }
        return node;
    }

    @NotNull
    private static Node makeTree(@NotNull File root) {
        File[] children;
        if (root == null) {
            FileTreeModel.$$$reportNull$$$0(19);
        }
        Node n = new Node();
        n.name = root.getName();
        n.existsOnDisk = root.exists();
        if (root.isDirectory() && (children = root.listFiles()) != null) {
            for (File f : children) {
                if (f.isHidden()) continue;
                n.children.add(FileTreeModel.makeTree(f));
            }
        }
        Node node = n;
        if (node == null) {
            FileTreeModel.$$$reportNull$$$0(20);
        }
        return node;
    }

    private static <T> List<T> rest(List<T> list) {
        return list.subList(1, list.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, this.myRootNode);
        return sb.toString();
    }

    private void toString(StringBuilder sb, Node root) {
        sb.append('(');
        sb.append(root.name);
        if (!this.isLeaf(root)) {
            sb.append(' ');
        }
        for (Node child : root.children) {
            this.toString(sb, child);
        }
        sb.append(')');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 6: 
            case 9: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/FileTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/FileTreeModel";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "treeHasConflicts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceAddFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeTree";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sort$1";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sort$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Node {
        public String name;
        public List<Node> children = Lists.newLinkedList();
        public boolean existsOnDisk;
        public boolean isConflicted;
        public boolean isProposedFile;
        public Icon icon;

        public String toString() {
            return this.name;
        }

        public boolean hasChild(String name) {
            for (Node child : this.children) {
                if (!child.name.equals(name)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Node getChild(String name) {
            for (Node child : this.children) {
                if (!child.name.equals(name)) continue;
                return child;
            }
            return null;
        }
    }
}

