/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.adtui.util.GraphicsUtil;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceSwatchComponent
extends JPanel {
    private static final String PRIVATE_ERROR_PATTERN = "%s is a private framework resource";
    private static final String NON_EXISTENT_ERROR_PATTERN = "The resource %s does not exist";
    private static final String API_ERROR_TEXT = "This resource requires at least an API level of %d";
    private static final int PADDING = JBUI.scale((int)3);
    private static final int TEXT_PADDING = JBUI.scale((int)8);
    private static final int ARC_SIZE = JBUI.scale((int)2);
    private static final Color DEFAULT_BORDER_COLOR = Gray._170;
    private static final Color WARNING_BORDER_COLOR = JBColor.ORANGE;
    public static final SwatchIcon WARNING_ICON = new SwatchIcon(){

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                1.$$$reportNull$$$0(0);
            }
            if (g == null) {
                1.$$$reportNull$$$0(1);
            }
            Icon QUESTION_ICON = AndroidIcons.GreyQuestionMark;
            int horizontalMargin = (w + JBUI.scale((int)1) - QUESTION_ICON.getIconWidth()) / 2;
            int verticalMargin = (h + JBUI.scale((int)3) - QUESTION_ICON.getIconHeight()) / 2;
            QUESTION_ICON.paintIcon(c, g, x + horizontalMargin, y + verticalMargin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$1";
            objectArray[2] = "paintSwatch";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @Nullable
    private final TextFieldWithAutoCompletion<String> myTextField;
    @Nullable
    private final JLabel myTextLabel;
    private final ClickableLabel mySwatchButton;
    private final List<ActionListener> myTextListeners;
    private Color myBorderColor;
    @NotNull
    private final Project myProject;

    public ResourceSwatchComponent(@NotNull Project project, boolean isEditor) {
        if (project == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(0);
        }
        super(new BorderLayout(PADDING, 0));
        this.myTextListeners = Lists.newArrayList();
        this.setBorder(null);
        this.myProject = project;
        this.myBorderColor = DEFAULT_BORDER_COLOR;
        this.mySwatchButton = new ClickableLabel();
        this.add((Component)this.mySwatchButton, "Before");
        if (isEditor) {
            this.myTextField = new TextFieldWithAutoCompletion<String>(project, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null), true, null){

                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    if (e.getKeyCode() == 10) {
                        ActionEvent event = new ActionEvent(ResourceSwatchComponent.this.myTextField, 1001, null);
                        for (ActionListener listener2 : ResourceSwatchComponent.this.myTextListeners) {
                            listener2.actionPerformed(event);
                        }
                        return true;
                    }
                    return false;
                }

                protected void updateBorder(@NotNull EditorEx editor) {
                    if (editor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    editor.setBorder((Border)((Object)new PaddedRoundedBorder(ResourceSwatchComponent.this.myBorderColor)));
                }

                protected EditorEx createEditor() {
                    EditorEx editor = super.createEditor();
                    editor.getScrollPane().setOpaque(false);
                    return editor;
                }

                public void removeNotify() {
                    Editor editor = this.getEditor();
                    if (editor != null && !editor.isDisposed()) {
                        EditorFactory.getInstance().releaseEditor(editor);
                    }
                    super.removeNotify();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$2", "updateBorder"));
                }
            };
            this.myTextField.setOneLineMode(true);
            this.myTextField.setBackground((Color)JBColor.WHITE);
            this.add((Component)this.myTextField, "Center");
            this.myTextLabel = null;
        } else {
            this.myTextLabel = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    g.setColor((Color)JBColor.WHITE);
                    g.fillRect(TEXT_PADDING, TEXT_PADDING, this.getWidth() - 2 * TEXT_PADDING, this.getHeight() - 2 * TEXT_PADDING);
                    super.paintComponent(g);
                }
            };
            this.myTextLabel.setBorder((Border)((Object)new PaddedRoundedBorder(this.myBorderColor)));
            this.add((Component)this.myTextLabel, "Center");
            this.myTextField = null;
        }
        this.setSwatchIcon(WARNING_ICON);
    }

    public void setSwatchIcon(@NotNull SwatchIcon icon) {
        if (icon == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(1);
        }
        int iconSize = this.getMinimumSize().height;
        icon.setSize(iconSize);
        icon.setBackgroundColor(this.getBackground());
        this.mySwatchButton.setIcon((Icon)icon);
    }

    public void setWarningBorder(boolean isWarning) {
        this.myBorderColor = isWarning ? WARNING_BORDER_COLOR : DEFAULT_BORDER_COLOR;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myTextField != null) {
            this.myTextField.setFont(font);
        } else if (this.myTextLabel != null) {
            this.myTextLabel.setFont(font);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isPreferredSizeSet()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            return new Dimension(0, fm.getHeight() + 2 * TEXT_PADDING);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(2);
        }
        if (this.myTextField != null) {
            this.myTextField.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
            this.myTextField.setText(text);
            this.myTextField.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)false);
        } else {
            assert (this.myTextLabel != null);
            this.myTextLabel.setText(text);
        }
    }

    @NotNull
    public String getText() {
        if (this.myTextField != null) {
            String string = this.myTextField.getText();
            if (string == null) {
                ResourceSwatchComponent.$$$reportNull$$$0(3);
            }
            return string;
        }
        assert (this.myTextLabel != null);
        String string = this.myTextLabel.getText();
        if (string == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void addSwatchListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(5);
        }
        this.mySwatchButton.addActionListener(listener2);
    }

    public void addTextListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(6);
        }
        this.myTextListeners.add(listener2);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(7);
        }
        assert (this.myTextField != null);
        this.myTextField.addDocumentListener(listener2);
    }

    public void addTextFocusListener(@NotNull FocusListener listener2) {
        if (listener2 == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(8);
        }
        assert (this.myTextField != null);
        this.myTextField.addFocusListener(listener2);
    }

    public boolean hasWarningIcon() {
        return WARNING_ICON.equals(this.mySwatchButton.getIcon());
    }

    public void setCompletionStrings(@NotNull List<String> completionStrings) {
        if (completionStrings == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(9);
        }
        assert (this.myTextField != null);
        this.myTextField.setVariants(completionStrings);
    }

    @Nullable
    public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
        if (androidTargetData == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(10);
        }
        String resourceValue2 = this.getText();
        String errorText = null;
        if (this.hasWarningIcon()) {
            errorText = NON_EXISTENT_ERROR_PATTERN;
        } else if (ResourceSwatchComponent.isResourcePrivate(resourceValue2, androidTargetData)) {
            errorText = PRIVATE_ERROR_PATTERN;
        }
        if (errorText != null) {
            return new ValidationInfo(String.format(errorText, resourceValue2), (JComponent)this);
        }
        int resourceApi = ResolutionUtils.getOriginalApiLevel(this.getText(), this.myProject);
        if (resourceApi > minApi) {
            return new ValidationInfo(String.format(API_ERROR_TEXT, resourceApi), (JComponent)this);
        }
        return null;
    }

    private static boolean isResourcePrivate(@NotNull String resourceValue2, @NotNull AndroidTargetData targetData) {
        ResourceUrl url;
        if (resourceValue2 == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(11);
        }
        if (targetData == null) {
            ResourceSwatchComponent.$$$reportNull$$$0(12);
        }
        return (url = ResourceUrl.parse((String)resourceValue2)) != null && url.isFramework() && !targetData.isResourcePublic(url.type.getName(), url.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionStrings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidTargetData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSwatchIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSwatchListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTextListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTextDocumentListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTextFocusListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionStrings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePrivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PaddedRoundedBorder
    extends RoundedLineBorder {
        public PaddedRoundedBorder(@NotNull Color color) {
            if (color == null) {
                PaddedRoundedBorder.$$$reportNull$$$0(0);
            }
            super(color, ARC_SIZE);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TEXT_PADDING, TEXT_PADDING, TEXT_PADDING, TEXT_PADDING);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = TEXT_PADDING;
            insets.top = TEXT_PADDING;
            insets.right = TEXT_PADDING;
            insets.bottom = TEXT_PADDING;
            return insets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor((Color)JBColor.WHITE);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width - 1, height - 1, ARC_SIZE, ARC_SIZE));
            area.subtract(new Area(new Rectangle(x + TEXT_PADDING, y + TEXT_PADDING, width - 2 * TEXT_PADDING, height - 2 * TEXT_PADDING)));
            ((Graphics2D)g).fill(area);
            super.paintBorder(c, g, x, y, width, height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$PaddedRoundedBorder", "<init>"));
        }
    }

    public static abstract class SwatchIcon
    implements Icon {
        private static final int SPACING = JBUI.scale((int)3);
        private static final int TRIANGLE_SIZE = JBUI.scale((int)13);
        private int mySize;
        private boolean myIsStack;
        private Color myBackgroundColor;

        @Override
        public void paintIcon(Component c, Graphics graphics, int x, int y) {
            com.intellij.util.ui.GraphicsUtil.setupAAPainting((Graphics)graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (this.myIsStack) {
                this.paintStack(c, g);
            } else {
                this.paintSingleIcon(c, g);
            }
        }

        protected abstract void paintSwatch(@NotNull Component var1, @NotNull Graphics var2, int var3, int var4, int var5, int var6);

        private void paintSingleIcon(@NotNull Component c, @NotNull Graphics2D g) {
            if (c == null) {
                SwatchIcon.$$$reportNull$$$0(0);
            }
            if (g == null) {
                SwatchIcon.$$$reportNull$$$0(1);
            }
            g.setColor(this.myBackgroundColor);
            g.fillRect(0, 0, this.mySize - 1, this.mySize - 1);
            Shape savedClip = g.getClip();
            RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double(0.0, 0.0, this.mySize - 1, this.mySize - 1, ARC_SIZE, ARC_SIZE);
            g.clip(clipRectangle);
            this.paintSwatch(c, g, 0, 0, this.mySize - 1, this.mySize - 1);
            g.setColor((Color)JBColor.WHITE);
            g.fillPolygon(new int[]{this.mySize - TRIANGLE_SIZE, this.mySize - 1, this.mySize - 1}, new int[]{this.mySize - 1, this.mySize - 1, this.mySize - TRIANGLE_SIZE}, 3);
            g.setClip(savedClip);
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(0, 0, this.mySize - 1, this.mySize - 1, ARC_SIZE, ARC_SIZE);
            g.drawLine(this.mySize - 1 - TRIANGLE_SIZE, this.mySize - 1, this.mySize - 1, this.mySize - 1 - TRIANGLE_SIZE);
        }

        private void paintStack(@NotNull Component c, @NotNull Graphics2D g) {
            if (c == null) {
                SwatchIcon.$$$reportNull$$$0(2);
            }
            if (g == null) {
                SwatchIcon.$$$reportNull$$$0(3);
            }
            g.setColor(this.myBackgroundColor);
            g.fillRect(0, 0, this.mySize - 1, this.mySize - 1);
            Shape savedClip = g.getClip();
            int smallSize = this.mySize - 2 * SPACING - 1;
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(2 * SPACING, 0, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.drawRoundRect(SPACING, SPACING, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.setColor(this.myBackgroundColor);
            g.fillRoundRect(SPACING + 1, SPACING + 1, smallSize - 1, smallSize - 1, ARC_SIZE, ARC_SIZE);
            RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double(0.0, 2 * SPACING, smallSize + 1, smallSize + 1, ARC_SIZE, ARC_SIZE);
            g.clip(clipRectangle);
            this.paintSwatch(c, g, 0, 2 * SPACING, smallSize, smallSize);
            g.setColor((Color)JBColor.WHITE);
            g.fillPolygon(new int[]{smallSize + 1 - TRIANGLE_SIZE + SPACING, smallSize, smallSize}, new int[]{this.mySize - 1, this.mySize - 1, this.mySize - TRIANGLE_SIZE + SPACING}, 3);
            g.setClip(savedClip);
            g.setColor(DEFAULT_BORDER_COLOR);
            g.drawRoundRect(0, 2 * SPACING, smallSize, smallSize, ARC_SIZE, ARC_SIZE);
            g.drawLine(smallSize - TRIANGLE_SIZE + SPACING, this.mySize - 1, smallSize, this.mySize - 1 - TRIANGLE_SIZE + SPACING);
        }

        @Override
        public int getIconWidth() {
            return this.mySize;
        }

        @Override
        public int getIconHeight() {
            return this.mySize;
        }

        public void setSize(int size) {
            this.mySize = size;
        }

        public void setIsStack(boolean isStack) {
            this.myIsStack = isStack;
        }

        public void setBackgroundColor(@Nullable Color backgroundColor) {
            this.myBackgroundColor = backgroundColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$SwatchIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintSingleIcon";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintStack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextIcon
    extends SwatchIcon {
        private final Font myFont;
        private final String myText;

        public TextIcon(String text, @NotNull Font font) {
            if (font == null) {
                TextIcon.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myFont = font;
        }

        @Override
        protected void paintSwatch(@NotNull Component c, @NotNull Graphics graphics, int x, int y, int w, int h) {
            if (c == null) {
                TextIcon.$$$reportNull$$$0(1);
            }
            if (graphics == null) {
                TextIcon.$$$reportNull$$$0(2);
            }
            Graphics2D g = (Graphics2D)graphics;
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.fillRect(x, y, w, h);
            g.setColor((Color)JBColor.DARK_GRAY);
            g.setFont(this.myFont);
            GraphicsUtil.drawCenteredString((Graphics2D)g, (Rectangle)new Rectangle(x, y, w, h), (String)this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "font";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphics";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$TextIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintSwatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SquareImageIcon
    extends SwatchIcon {
        private final ImageIcon myImageIcon;

        public SquareImageIcon(@NotNull BufferedImage image) {
            if (image == null) {
                SquareImageIcon.$$$reportNull$$$0(0);
            }
            this.myImageIcon = new ImageIcon(image);
        }

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                SquareImageIcon.$$$reportNull$$$0(1);
            }
            if (g == null) {
                SquareImageIcon.$$$reportNull$$$0(2);
            }
            Image image = this.myImageIcon.getImage();
            GraphicsUtil.paintCheckeredBackground((Graphics)g, (Shape)new Rectangle(x, y, w, h));
            g.drawImage(image, x, y, w, h, c);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$SquareImageIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintSwatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ColorIcon
    extends SwatchIcon {
        private final Color myColor;

        public ColorIcon(@NotNull Color color) {
            if (color == null) {
                ColorIcon.$$$reportNull$$$0(0);
            }
            this.myColor = color;
        }

        @NotNull
        public Color getColor() {
            Color color = this.myColor;
            if (color == null) {
                ColorIcon.$$$reportNull$$$0(1);
            }
            return color;
        }

        @Override
        public void paintSwatch(@NotNull Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (c == null) {
                ColorIcon.$$$reportNull$$$0(2);
            }
            if (g == null) {
                ColorIcon.$$$reportNull$$$0(3);
            }
            if (this.myColor.getAlpha() != 255) {
                GraphicsUtil.paintCheckeredBackground((Graphics)g, (Shape)new Rectangle(x, y, w, h));
            }
            g.setColor(this.myColor);
            g.fillRect(x, y, w, h);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$ColorIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceSwatchComponent$ColorIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "paintSwatch";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

