/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorDocument;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorLabel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilderKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorValueField;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorValuePanelKt;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.Alarm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bH\u0002J\u0012\u0010&\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010'\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J \u0010(\u001a\u00020\u0018*\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorValuePanel;", "Ljavax/swing/JPanel;", "Ljavax/swing/event/DocumentListener;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;)V", "aField", "Ljavax/swing/JTextField;", "getAField", "()Ljavax/swing/JTextField;", "bField", "getBField", "gField", "getGField", "hexField", "getHexField", "rField", "getRField", "updateAlarm", "Lcom/intellij/util/Alarm;", "getUpdateAlarm", "()Lcom/intellij/util/Alarm;", "changedUpdate", "", "e", "Ljavax/swing/event/DocumentEvent;", "colorChanged", "color", "Ljava/awt/Color;", "source", "", "insertUpdate", "removeUpdate", "setListenersToColorField", "field", "update", "src", "updateColorToColorModel", "updateTextField", "setTextIfNeeded", "newText", "", "intellij.android.core"})
public final class ColorValuePanel
extends JPanel
implements DocumentListener,
ColorListener {
    @NotNull
    private final Alarm updateAlarm;
    @NotNull
    private final JTextField aField;
    @NotNull
    private final JTextField rField;
    @NotNull
    private final JTextField gField;
    @NotNull
    private final JTextField bField;
    @NotNull
    private final JTextField hexField;
    private final ColorPickerModel model;

    @NotNull
    public final Alarm getUpdateAlarm() {
        return this.updateAlarm;
    }

    @NotNull
    public final JTextField getAField() {
        return this.aField;
    }

    @NotNull
    public final JTextField getRField() {
        return this.rField;
    }

    @NotNull
    public final JTextField getGField() {
        return this.gField;
    }

    @NotNull
    public final JTextField getBField() {
        return this.bField;
    }

    @NotNull
    public final JTextField getHexField() {
        return this.hexField;
    }

    private final void setListenersToColorField(JTextField field2) {
        field2.getDocument().addDocumentListener(this);
        field2.addFocusListener(new FocusAdapter(field2){
            final /* synthetic */ JTextField $field;

            public void focusGained(@Nullable FocusEvent e) {
                this.$field.selectAll();
            }
            {
                this.$field = $captured_local_variable$0;
            }
        });
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.updateTextField(color, source);
    }

    private final void updateTextField(Color color, Object source) {
        this.setTextIfNeeded(this.aField, String.valueOf(color.getAlpha()), source);
        this.setTextIfNeeded(this.rField, String.valueOf(color.getRed()), source);
        this.setTextIfNeeded(this.gField, String.valueOf(color.getGreen()), source);
        this.setTextIfNeeded(this.bField, String.valueOf(color.getBlue()), source);
        this.setTextIfNeeded(this.hexField, Integer.toHexString(color.getRGB()), source);
        this.updateAlarm.cancelAllRequests();
    }

    private final void setTextIfNeeded(@NotNull JTextField $receiver, String newText, Object source) {
        if (Intrinsics.areEqual((Object)$receiver.getText(), (Object)newText) ^ true && (Intrinsics.areEqual((Object)source, (Object)this) ^ true || !$receiver.isFocusOwner())) {
            $receiver.setText(newText);
        }
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Document document = e.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorDocument");
        }
        this.update(((ColorDocument)document).getSrc$intellij_android_core());
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Document document = e.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorDocument");
        }
        this.update(((ColorDocument)document).getSrc$intellij_android_core());
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
    }

    private final void update(JTextField src) {
        this.updateAlarm.cancelAllRequests();
        this.updateAlarm.addRequest(new Runnable(this, src){
            final /* synthetic */ ColorValuePanel this$0;
            final /* synthetic */ JTextField $src;

            public final void run() {
                ColorValuePanel.access$updateColorToColorModel(this.this$0, this.$src);
            }
            {
                this.this$0 = colorValuePanel;
                this.$src = jTextField;
            }
        }, 300);
    }

    private final void updateColorToColorModel(JTextField src) {
        Color color;
        if (Intrinsics.areEqual((Object)src, (Object)this.hexField)) {
            String string = this.hexField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hexField.text");
            color = ColorValuePanelKt.access$convertHexToColor(string);
        } else {
            int a = Intrinsics.areEqual((Object)this.aField.getText(), (Object)"") ? 0 : Integer.parseInt(this.aField.getText());
            int r = Intrinsics.areEqual((Object)this.rField.getText(), (Object)"") ? 0 : Integer.parseInt(this.rField.getText());
            int g = Intrinsics.areEqual((Object)this.gField.getText(), (Object)"") ? 0 : Integer.parseInt(this.gField.getText());
            int b = Intrinsics.areEqual((Object)this.bField.getText(), (Object)"") ? 0 : Integer.parseInt(this.bField.getText());
            color = new Color(r, g, b, a);
        }
        Color color2 = color;
        this.model.setColor(color2, this);
    }

    public ColorValuePanel(@NotNull ColorPickerModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        super(new GridBagLayout());
        this.model = model;
        this.updateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.aField = new ColorValueField(false, 1, null);
        this.rField = new ColorValueField(false, 1, null);
        this.gField = new ColorValueField(false, 1, null);
        this.bField = new ColorValueField(false, 1, null);
        this.hexField = new ColorValueField(true);
        this.setBorder((Border)ColorValuePanelKt.access$getPANEL_BORDER$p());
        this.setPreferredSize((Dimension)ColorValuePanelKt.access$getPREFERRED_PANEL_SIZE$p());
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.12;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new ColorLabel("A"), c);
        c.gridy = 1;
        this.add((Component)this.aField, c);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)new ColorLabel("R"), c);
        c.gridy = 1;
        this.add((Component)this.rField, c);
        c.gridx = 2;
        c.gridy = 0;
        this.add((Component)new ColorLabel("G"), c);
        c.gridy = 1;
        this.add((Component)this.gField, c);
        c.gridx = 3;
        c.gridy = 0;
        this.add((Component)new ColorLabel("B"), c);
        c.gridy = 1;
        this.add((Component)this.bField, c);
        c.weightx = 0.51;
        c.gridx = 4;
        c.gridy = 0;
        this.add((Component)new ColorLabel("Hex"), c);
        c.gridy = 1;
        this.add((Component)this.hexField, c);
        this.setListenersToColorField(this.aField);
        this.setListenersToColorField(this.rField);
        this.setListenersToColorField(this.gField);
        this.setListenersToColorField(this.bField);
        this.setListenersToColorField(this.hexField);
        this.model.addListener(this);
    }

    public static final /* synthetic */ void access$updateColorToColorModel(ColorValuePanel $this, @Nullable JTextField src) {
        $this.updateColorToColorModel(src);
    }
}

