/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessComponentKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessImageProducer;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.UtilsKt;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0014J(\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0007H\u0002R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/picker/ColorListener;", "myModel", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;)V", "<set-?>", "", "alpha", "getAlpha", "()I", "setAlpha", "(I)V", "", "brightness", "getBrightness", "()F", "setBrightness", "(F)V", "hue", "getHue", "setHue", "saturation", "getSaturation", "setSaturation", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "paintComponent", "g", "Ljava/awt/Graphics;", "setHSBAValue", "h", "s", "b", "a", "intellij.android.core"})
public final class SaturationBrightnessComponent
extends JComponent
implements ColorListener {
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private final ColorPickerModel myModel;

    public final float getBrightness() {
        return this.brightness;
    }

    private final void setBrightness(float f) {
        this.brightness = f;
    }

    public final float getHue() {
        return this.hue;
    }

    private final void setHue(float f) {
        this.hue = f;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    private final void setSaturation(float f) {
        this.saturation = f;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    private final void setAlpha(int n) {
        this.alpha = n;
    }

    private final void handleMouseEvent(MouseEvent e) {
        int x = Math.max(0, Math.min(e.getX(), this.getSize().width));
        int y = Math.max(0, Math.min(e.getY(), this.getSize().height));
        float saturation = (float)x / (float)this.getSize().width;
        float brightness = 1.0f - (float)y / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        this.myModel.setColor(new Color(argb, true), this);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)300, (int)150);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(PICKER_PREFERRED_WIDTH, 150)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)140);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(150, 140)");
        return (Dimension)jBDimension;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Rectangle component = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Image image = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image, component.x, component.y, null);
        int knobX = Math.round(this.saturation * (float)component.width);
        int knobY = Math.round((float)component.height * (1.0f - this.brightness));
        g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        g.drawOval(knobX - JBUI.scale((int)4), knobY - JBUI.scale((int)4), JBUI.scale((int)8), JBUI.scale((int)8));
        g.drawOval(knobX - JBUI.scale((int)3), knobY - JBUI.scale((int)3), JBUI.scale((int)6), JBUI.scale((int)6));
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
        this.repaint();
    }

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        Intrinsics.checkParameterIsNotNull((Object)myModel, (String)"myModel");
        this.myModel = myModel;
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.myModel.addListener(this);
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, @NotNull MouseEvent e) {
        $this.handleMouseEvent(e);
    }
}

