/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.SliderComponentKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010'\u001a\u00020\u00132\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u0012J \u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u000200H\u0016J\u0015\u00103\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0007H$\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H$J\u0010\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>H\u0016J\u0015\u0010?\u001a\u00020\u00072\u0006\u0010#\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010@R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR$\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR`\u0010\u0010\u001aT\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u0012 \u0014*(\u0012$\u0012\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u00120\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000fR\u001a\u0010\u001e\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\rR$\u0010#\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010\u0005\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/SliderComponent;", "T", "", "Ljavax/swing/JComponent;", "initialValue", "(Ljava/lang/Number;)V", "_knobPosition", "", "_value", "Ljava/lang/Number;", "newPointerValue", "knobPosition", "getKnobPosition", "()I", "setKnobPosition", "(I)V", "listeners", "", "Lkotlin/Function1;", "", "kotlin.jvm.PlatformType", "", "myLeftMargin", "getMyLeftMargin", "setMyLeftMargin", "myPolygonToDraw", "Ljava/awt/Polygon;", "myRightMargin", "getMyRightMargin", "setMyRightMargin", "sliderWidth", "sliderWidth$annotations", "()V", "getSliderWidth", "newValue", "value", "getValue", "()Ljava/lang/Number;", "setValue", "addListener", "listener", "drawKnob", "g2d", "Ljava/awt/Graphics2D;", "x", "y", "fireValueChanged", "getMaximumSize", "Ljava/awt/Dimension;", "getMinimumSize", "getPreferredSize", "knobPositionToValue", "(I)Ljava/lang/Number;", "paintComponent", "g", "Ljava/awt/Graphics;", "paintSlider", "processMouse", "e", "Ljava/awt/event/MouseEvent;", "setToolTipText", "text", "", "valueToKnobPosition", "(Ljava/lang/Number;)I", "intellij.android.core"})
public abstract class SliderComponent<T extends Number>
extends JComponent {
    private int myLeftMargin;
    private int myRightMargin;
    private int _knobPosition;
    private T _value;
    private final Polygon myPolygonToDraw;
    private final List<Function1<T, Unit>> listeners;

    protected final int getMyLeftMargin() {
        return this.myLeftMargin;
    }

    protected final void setMyLeftMargin(int n) {
        this.myLeftMargin = n;
    }

    protected final int getMyRightMargin() {
        return this.myRightMargin;
    }

    protected final void setMyRightMargin(int n) {
        this.myRightMargin = n;
    }

    public final int getKnobPosition() {
        return this._knobPosition;
    }

    public final void setKnobPosition(int newPointerValue) {
        this._knobPosition = newPointerValue;
        this._value = this.knobPositionToValue(newPointerValue);
    }

    @NotNull
    public final T getValue() {
        return this._value;
    }

    public final void setValue(@NotNull T newValue) {
        Intrinsics.checkParameterIsNotNull(newValue, (String)"newValue");
        this._value = newValue;
        this._knobPosition = this.valueToKnobPosition(newValue);
    }

    public static /* synthetic */ void sliderWidth$annotations() {
    }

    public final int getSliderWidth() {
        int n = 0;
        int n2 = this.getWidth() - this.myLeftMargin - this.myRightMargin;
        return Math.max(n, n2);
    }

    private final void processMouse(MouseEvent e) {
        int knobPosition = Math.max(0, Math.min(e.getX() - this.myLeftMargin, this.getSliderWidth()));
        this.setValue(this.knobPositionToValue(knobPosition));
        this.repaint();
        this.fireValueChanged();
    }

    public final void addListener(@NotNull Function1<? super T, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    private final void fireValueChanged() {
        List<Function1<T, Unit>> list = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"listeners");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Function1 it = (Function1)element$iv;
            it.invoke(this.getValue());
        }
    }

    @NotNull
    protected abstract T knobPositionToValue(int var1);

    protected abstract int valueToKnobPosition(@NotNull T var1);

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)100, (int)22);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(100, 22)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)50, (int)22);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(50, 22)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    @Override
    public void setToolTipText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        this.paintSlider(g2d);
        this.drawKnob(g2d, this.myLeftMargin + this.valueToKnobPosition(this.getValue()), JBUI.scale((int)7));
    }

    protected abstract void paintSlider(@NotNull Graphics2D var1);

    private final void drawKnob(Graphics2D g2d, int x, int y) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int shadowOffset = JBUI.scale((int)1);
        this.myPolygonToDraw.reset();
        this.myPolygonToDraw.addPoint(x - JBUI.scale((int)6) + shadowOffset, y - JBUI.scale((int)6) + shadowOffset);
        this.myPolygonToDraw.addPoint(x + JBUI.scale((int)6) + shadowOffset, y - JBUI.scale((int)6) + shadowOffset);
        this.myPolygonToDraw.addPoint(x + shadowOffset, y + JBUI.scale((int)6) + shadowOffset);
        g2d.setColor(SliderComponentKt.access$getKNOB_SHADOW_COLOR$p());
        g2d.fill(this.myPolygonToDraw);
        this.myPolygonToDraw.reset();
        this.myPolygonToDraw.addPoint(x - JBUI.scale((int)6), y - JBUI.scale((int)6));
        this.myPolygonToDraw.addPoint(x + JBUI.scale((int)6), y - JBUI.scale((int)6));
        this.myPolygonToDraw.addPoint(x, y + JBUI.scale((int)6));
        g2d.setColor(SliderComponentKt.access$getKNOB_COLOR$p());
        g2d.fill(this.myPolygonToDraw);
    }

    public SliderComponent(@NotNull T initialValue) {
        Intrinsics.checkParameterIsNotNull(initialValue, (String)"initialValue");
        this.myLeftMargin = SliderComponentKt.access$getDEFAULT_HORIZONTAL_MARGIN$p();
        this.myRightMargin = SliderComponentKt.access$getDEFAULT_HORIZONTAL_MARGIN$p();
        this._value = initialValue;
        this.myPolygonToDraw = new Polygon();
        this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.processMouse(e);
                e.consume();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public final void mouseWheelMoved(MouseWheelEvent e) {
                MouseWheelEvent mouseWheelEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseWheelEvent, (String)"e");
                int amount = mouseWheelEvent.getScrollType() == 0 ? e.getUnitsToScroll() * e.getScrollAmount() : (e.getWheelRotation() < 0 ? -e.getScrollAmount() : e.getScrollAmount());
                int knobPosition = this.valueToKnobPosition(this.getValue());
                int newKnobPosition = Math.max(0, Math.min(knobPosition + amount, this.getSliderWidth()));
                this.setValue(this.knobPositionToValue(newKnobPosition));
                this.repaint();
                this.fireValueChanged();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.repaint();
            }
        });
    }
}

