/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.groups;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroup;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceChooserGroups {
    private static final boolean FILTER_OUT_PRIVATE_ITEMS = true;
    private static ImmutableList<ResourceNamespace> SAMPLE_DATA_NS = ImmutableList.of((Object)ResourceNamespace.TOOLS, (Object)ResourceNamespace.TODO());
    private static final Comparator<ResourceChooserItem> ITEM_COMPARATOR = (resource1, resource2) -> {
        int framework2;
        int framework1 = resource1.isFramework() ? 1 : 0;
        int delta = framework1 - (framework2 = resource2.isFramework() ? 1 : 0);
        if (delta != 0) {
            return delta;
        }
        return resource1.getName().compareTo(resource2.getName());
    };
    private static final EnumSet<ResourceType> IMAGE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.COLOR);
    private static final Predicate<SampleDataResourceItem> ONLY_IMAGES_FILTER = item -> item.getContentType() == SampleDataResourceItem.ContentType.IMAGE;
    private static final Predicate<SampleDataResourceItem> NOT_IMAGES_FILTER = ONLY_IMAGES_FILTER.negate();

    private ResourceChooserGroups() {
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getFrameworkItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull AbstractResourceRepository frameworkResources, @NotNull ResourceType asType) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(0);
        }
        if (frameworkResources == null) {
            ResourceChooserGroups.$$$reportNull$$$0(1);
        }
        if (asType == null) {
            ResourceChooserGroups.$$$reportNull$$$0(2);
        }
        HashMap<String, ArrayList<ResourceItem>> itemsByName = new HashMap<String, ArrayList<ResourceItem>>();
        Collection publicItems = frameworkResources.getPublicResourcesOfType(type);
        for (ResourceItem item : publicItems) {
            String name = item.getName();
            ArrayList<ResourceItem> list = (ArrayList<ResourceItem>)itemsByName.get(name);
            if (list == null) {
                list = new ArrayList<ResourceItem>();
                itemsByName.put(name, list);
            }
            list.add(item);
        }
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (Map.Entry entry : itemsByName.entrySet()) {
            List items2 = (List)entry.getValue();
            String resourceName = (String)entry.getKey();
            if (!includeFileResources && ((ResourceItem)items2.get(0)).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createFrameworkItem(asType, resourceName, items2));
        }
        ImmutableList immutableList = chooserItems.build();
        if (immutableList == null) {
            ResourceChooserGroups.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getProjectItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull LocalResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(4);
        }
        if (repository == null) {
            ResourceChooserGroups.$$$reportNull$$$0(5);
        }
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (String resourceName : repository.getItemsOfType(type)) {
            List items2;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items2 = repository.getResourceItem(type, resourceName)) == null || items2.isEmpty() || !includeFileResources && ((ResourceItem)items2.get(0)).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createProjectItem(type, resourceName, items2));
        }
        ImmutableList immutableList = chooserItems.build();
        if (immutableList == null) {
            ResourceChooserGroups.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @Nullable
    private static AbstractResourceRepository getFrameworkResources(@NotNull AndroidFacet facet, boolean withLocale) {
        AndroidPlatform androidPlatform;
        if (facet == null) {
            ResourceChooserGroups.$$$reportNull$$$0(7);
        }
        if ((androidPlatform = AndroidPlatform.getInstance(facet.getModule())) == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
        return targetData.getFrameworkResources(withLocale);
    }

    @NotNull
    public static ResourceChooserGroup createResourceItemsGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, boolean framework, boolean includeFileResources) {
        if (label == null) {
            ResourceChooserGroups.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(9);
        }
        if (facet == null) {
            ResourceChooserGroups.$$$reportNull$$$0(10);
        }
        assert (type != ResourceType.MIPMAP);
        ImmutableList.Builder items2 = ImmutableList.builder();
        if (framework) {
            AbstractResourceRepository frameworkResources = ResourceChooserGroups.getFrameworkResources(facet, type == ResourceType.STRING);
            if (frameworkResources != null) {
                items2.addAll(ResourceChooserGroups.getFrameworkItems(type, includeFileResources, frameworkResources, type));
                if (type == ResourceType.DRAWABLE) {
                    items2.addAll(ResourceChooserGroups.getFrameworkItems(ResourceType.MIPMAP, includeFileResources, frameworkResources, type));
                }
            }
        } else {
            ResourceRepositoryManager repoManager = ResourceRepositoryManager.getOrCreateInstance(facet);
            LocalResourceRepository appResources = repoManager.getAppResources(true);
            ResourceVisibilityLookup lookup = repoManager.getResourceVisibility();
            items2.addAll(ResourceChooserGroups.getProjectItems(type, includeFileResources, appResources, lookup));
            if (type == ResourceType.DRAWABLE) {
                items2.addAll(ResourceChooserGroups.getProjectItems(ResourceType.MIPMAP, includeFileResources, appResources, lookup));
            }
        }
        ResourceChooserGroup resourceChooserGroup = new ResourceChooserGroup(label, type, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2.build()));
        if (resourceChooserGroup == null) {
            ResourceChooserGroups.$$$reportNull$$$0(11);
        }
        return resourceChooserGroup;
    }

    @NotNull
    public static ResourceChooserGroup createThemeAttributesGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet, @NotNull Collection<String> attrs) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(12);
        }
        if (facet == null) {
            ResourceChooserGroups.$$$reportNull$$$0(13);
        }
        if (attrs == null) {
            ResourceChooserGroups.$$$reportNull$$$0(14);
        }
        ResourceVisibilityLookup lookup = ResourceRepositoryManager.getOrCreateInstance(facet).getResourceVisibility();
        ArrayList<ResourceChooserItem.AttrItem> items2 = new ArrayList<ResourceChooserItem.AttrItem>();
        for (String name : attrs) {
            String simpleName;
            boolean framework = name.startsWith("android:");
            String string = simpleName = framework ? ResolutionUtils.getNameFromQualifiedName(name) : name;
            if (!framework && lookup != null && lookup.isPrivate(ResourceType.ATTR, simpleName)) continue;
            items2.add(new ResourceChooserItem.AttrItem(type, framework, simpleName));
        }
        ResourceChooserGroup resourceChooserGroup = new ResourceChooserGroup("Theme attributes", type, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, items2));
        if (resourceChooserGroup == null) {
            ResourceChooserGroups.$$$reportNull$$$0(15);
        }
        return resourceChooserGroup;
    }

    @NotNull
    public static ResourceChooserGroup createSampleDataGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(16);
        }
        if (facet == null) {
            ResourceChooserGroups.$$$reportNull$$$0(17);
        }
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet);
        Predicate<SampleDataResourceItem> filter2 = IMAGE_RESOURCE_TYPES.contains(type) ? ONLY_IMAGES_FILTER : NOT_IMAGES_FILTER;
        ImmutableList items2 = (ImmutableList)SAMPLE_DATA_NS.stream().flatMap(namespace -> repository.getResourceItems((ResourceNamespace)namespace, ResourceType.SAMPLE_DATA).stream()).map(item -> (SampleDataResourceItem)item).filter(filter2).map(item -> new ResourceChooserItem.SampleDataItem((SampleDataResourceItem)item)).collect(ImmutableList.toImmutableList());
        ResourceChooserGroup resourceChooserGroup = new ResourceChooserGroup("Sample data", ResourceType.SAMPLE_DATA, (ImmutableList<ResourceChooserItem>)ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2));
        if (resourceChooserGroup == null) {
            ResourceChooserGroups.$$$reportNull$$$0(18);
        }
        return resourceChooserGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkResources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asType";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/groups/ResourceChooserGroups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/groups/ResourceChooserGroups";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectItems";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createResourceItemsGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createThemeAttributesGroup";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSampleDataGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkItems";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectItems";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkResources";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResourceItemsGroup";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createThemeAttributesGroup";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSampleDataGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

