/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.preview;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HideableDecorator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceEditorTab {
    private JPanel myFullPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private JPanel myEditorPanel;
    private HideableDecorator myExpertDecorator;
    @NotNull
    private CreateXmlResourcePanel myLocationSettings;
    @NotNull
    private ChooseResourceDialog.ResourceNameVisibility myResourceNameVisibility;
    @NotNull
    private final String myTabTitle;

    public ResourceEditorTab(@NotNull Module module, @NotNull String tabTitle, @NotNull Component centerPanel, @NotNull ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility, @NotNull ResourceFolderType folderType, boolean changeFileNameVisible, @NotNull ResourceType resourceType) {
        if (module == null) {
            ResourceEditorTab.$$$reportNull$$$0(0);
        }
        if (tabTitle == null) {
            ResourceEditorTab.$$$reportNull$$$0(1);
        }
        if (centerPanel == null) {
            ResourceEditorTab.$$$reportNull$$$0(2);
        }
        if (resourceNameVisibility == null) {
            ResourceEditorTab.$$$reportNull$$$0(3);
        }
        if (folderType == null) {
            ResourceEditorTab.$$$reportNull$$$0(4);
        }
        if (resourceType == null) {
            ResourceEditorTab.$$$reportNull$$$0(5);
        }
        this.myResourceNameVisibility = resourceNameVisibility;
        this.myTabTitle = tabTitle;
        this.$$$setupUI$$$();
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Device Configuration", true){

            private void pack() {
                ApplicationManager.getApplication().invokeLater(() -> SwingUtilities.getWindowAncestor(ResourceEditorTab.this.myExpertPlaceholder).pack(), ModalityState.any());
            }

            protected void on() {
                super.on();
                this.pack();
            }

            protected void off() {
                super.off();
                this.pack();
            }
        };
        this.myExpertDecorator.setContentComponent((JComponent)this.myExpertPanel);
        this.myEditorPanel.add(centerPanel);
        this.myFullPanel.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(module.getProject());
        Function<Module, IdeResourceNameValidator> nameValidatorFactory = selectedModule -> {
            if (resourceType == null) {
                ResourceEditorTab.$$$reportNull$$$0(12);
            }
            return IdeResourceNameValidator.forResourceName(resourceType, ResourceRepositoryManager.getAppResources(selectedModule));
        };
        this.myLocationSettings = newResourceHandler.createNewResourceValuePanel(module, resourceType, folderType, "", "", false, false, changeFileNameVisible, null, null, nameValidatorFactory);
        this.myExpertPanel.add(this.myLocationSettings.getPanel());
    }

    @NotNull
    public JPanel getFullPanel() {
        JPanel jPanel = this.myFullPanel;
        if (jPanel == null) {
            ResourceEditorTab.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public void setLocationSettingsOpen(boolean open) {
        this.myExpertDecorator.setOn(open);
    }

    @NotNull
    public CreateXmlResourcePanel getLocationSettings() {
        CreateXmlResourcePanel createXmlResourcePanel = this.myLocationSettings;
        if (createXmlResourcePanel == null) {
            ResourceEditorTab.$$$reportNull$$$0(7);
        }
        return createXmlResourcePanel;
    }

    @NotNull
    public ChooseResourceDialog.ResourceNameVisibility getResourceNameVisibility() {
        ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = this.myResourceNameVisibility;
        if (resourceNameVisibility == null) {
            ResourceEditorTab.$$$reportNull$$$0(8);
        }
        return resourceNameVisibility;
    }

    @Nullable
    public ValidationInfo doValidate() {
        return this.getLocationSettings().doValidate();
    }

    @NotNull
    public abstract String doSave();

    @NotNull
    public Module getSelectedModule() {
        Module module = this.getLocationSettings().getModule();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            ResourceEditorTab.$$$reportNull$$$0(9);
        }
        return module2;
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        return this.getLocationSettings().getResourceDirectory();
    }

    @NotNull
    public IdeResourceNameValidator getValidator() {
        IdeResourceNameValidator ideResourceNameValidator = this.getLocationSettings().getResourceNameValidator();
        if (ideResourceNameValidator == null) {
            ResourceEditorTab.$$$reportNull$$$0(10);
        }
        return ideResourceNameValidator;
    }

    @NotNull
    public String getTabTitle() {
        String string = this.myTabTitle;
        if (string == null) {
            ResourceEditorTab.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceNameVisibility";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceEditorTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceEditorTab";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNameVisibility";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myFullPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myEditorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myExpertPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        this.myExpertPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myFullPanel;
    }
}

