/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.preview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceTablePanel
implements HyperlinkListener {
    private final Consumer<Integer> myDialogClose;
    private final int myRowHeight;
    private final Module myModule;
    private HyperlinkLabel myEditTranslationsLink;
    private JBLabel myNameLabel;
    private JBTable myTable;
    private JPanel myPanel;
    private JBScrollPane myScrollPane;

    public ResourceTablePanel(@NotNull Module module, @NotNull Consumer<Integer> dialogClose, int rowHeight) {
        if (module == null) {
            ResourceTablePanel.$$$reportNull$$$0(0);
        }
        if (dialogClose == null) {
            ResourceTablePanel.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        this.myDialogClose = dialogClose;
        this.myRowHeight = rowHeight;
        this.$$$setupUI$$$();
        this.myTable.setTableHeader(null);
        this.myTable.setBackground(UIUtil.getLabelBackground());
        this.myTable.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.getViewport().setBorder(null);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
        this.myTable.setName("valueTable");
        TableSpeedSearch speedSearch = new TableSpeedSearch((JTable)this.myTable);
        speedSearch.setClearSearchOnNavigateNoMatch(true);
    }

    private void createUIComponents() {
        this.myEditTranslationsLink = new HyperlinkLabel("EDIT TRANSLATIONS");
        this.myEditTranslationsLink.addHyperlinkListener((HyperlinkListener)this);
        this.myEditTranslationsLink.setVisible(false);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ResourceTablePanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void select(@Nullable ResourceChooserItem item) {
        if (item != null) {
            this.myTable.setModel((TableModel)new ResourceTableModel(item));
            TableColumn valueColumn = this.myTable.getColumnModel().getColumn(1);
            valueColumn.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                    if (column == 1) {
                        String s = value.toString();
                        component.setFont(FontUtil.getFontAbleToDisplay((String)s, (Font)table2.getFont()));
                    } else {
                        component.setFont(table2.getFont());
                    }
                    return component;
                }
            });
            this.myNameLabel.setText(item.getName());
            this.myTable.setRowHeight(this.myRowHeight);
            this.myEditTranslationsLink.setVisible(item.getType() == ResourceType.STRING && !item.isFramework());
        } else {
            this.myNameLabel.setText("");
            this.myTable.setModel((TableModel)new DefaultTableModel(0, 2));
            this.myEditTranslationsLink.setVisible(false);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.myDialogClose.consume((Object)1);
        StringResourceEditorProvider.openEditor(this.myModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogClose";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceTablePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/preview/ResourceTablePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(12, 12, 11, 11), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.myTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
        HyperlinkLabel hyperlinkLabel = this.myEditTranslationsLink;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ResourceTableModel
    extends AbstractTableModel {
        private final List<Pair<FolderConfiguration, String>> myPairs;
        private final ResourceChooserItem myItem;

        public ResourceTableModel(@NotNull ResourceChooserItem item) {
            if (item == null) {
                ResourceTableModel.$$$reportNull$$$0(0);
            }
            this.myItem = item;
            this.myPairs = item.getQualifiersAndValues();
        }

        @Override
        public int getRowCount() {
            return this.myPairs.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String qualifierString;
            LocaleQualifier locale;
            Pair<FolderConfiguration, String> pair = this.myPairs.get(rowIndex);
            if (columnIndex == 1) {
                return pair.getSecond();
            }
            assert (columnIndex == 0) : columnIndex;
            FolderConfiguration configuration = (FolderConfiguration)pair.getFirst();
            if (configuration.isDefault()) {
                return "Default";
            }
            if (this.myItem.getType() == ResourceType.STRING && (locale = configuration.getLocaleQualifier()) != null && locale.hasLanguage()) {
                assert (locale.getLanguage() != null);
                String language = LocaleManager.getLanguageName((String)locale.getLanguage());
                if (language != null) {
                    if (locale.hasRegion()) {
                        assert (locale.getRegion() != null);
                        String region = LocaleManager.getRegionName((String)locale.getRegion());
                        if (region != null) {
                            return language + ", " + region;
                        }
                    }
                    return language;
                }
            }
            if ((qualifierString = configuration.getQualifierString()).isEmpty()) {
                qualifierString = "Default";
            }
            return qualifierString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/ui/resourcechooser/preview/ResourceTablePanel$ResourceTableModel", "<init>"));
        }
    }
}

