/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.adtui.validation.Validator;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WizardUtils {
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent == null) {
            String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
            File file = new File(SystemProperties.getUserHome(), child);
            if (file == null) {
                WizardUtils.$$$reportNull$$$0(0);
            }
            return file;
        }
        File file = new File(parent.replace('/', File.separatorChar));
        if (file == null) {
            WizardUtils.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        String string = packageName = packageName == null ? "" : packageName;
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text) {
        if (text == null) {
            WizardUtils.$$$reportNull$$$0(2);
        }
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            text = text.trim().replaceAll("\n", "<br>");
            String string = String.format("<html>%1$s</html>", text);
            if (string == null) {
                WizardUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            WizardUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        if (urlAsString == null) {
            WizardUtils.$$$reportNull$$$0(5);
        }
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL uRL = url;
        if (uRL == null) {
            WizardUtils.$$$reportNull$$$0(6);
        }
        return uRL;
    }

    public static String getUniqueName(String initialValue, Validator<String> validator) {
        String uniqueName = initialValue;
        for (int i = 2; i <= 100 && validator.validate((Object)uniqueName).getSeverity() == Validator.Severity.ERROR; ++i) {
            uniqueName = initialValue + Integer.toString(i);
        }
        return uniqueName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLocationParent";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

