/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutForm;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutDirectConvert;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToConstraintLayoutAction
extends AnAction {
    public static final String TITLE = "Convert to ConstraintLayout";
    public static final boolean ENABLED = true;
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH = "layout_conversion_absoluteWidth";
    public static final String ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT = "layout_conversion_absoluteHeight";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_WIDTH = "layout_conversion_wrapWidth";
    public static final String ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT = "layout_conversion_wrapHeight";
    private static final HashSet<String> ourExcludedTags = new HashSet<String>(Arrays.asList("layout", "data", "variable", "import"));
    private final NlDesignSurface mySurface;

    public ConvertToConstraintLayoutAction(@NotNull NlDesignSurface surface) {
        if (surface == null) {
            ConvertToConstraintLayoutAction.$$$reportNull$$$0(0);
        }
        super(TITLE, TITLE, null);
        this.mySurface = surface;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        SceneView screenView = this.mySurface.getCurrentSceneView();
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target != null) {
            String tagName = target.getTagName();
            if (NlComponentHelperKt.isOrHasSuperclass(target, SdkConstants.CONSTRAINT_LAYOUT)) {
                presentation.setVisible(false);
                return;
            }
            if (ourExcludedTags.contains(tagName)) {
                presentation.setVisible(false);
                return;
            }
            presentation.setVisible(true);
            tagName = tagName.substring(tagName.lastIndexOf(46) + 1);
            presentation.setText("Convert " + tagName + " to ConstraintLayout");
            presentation.setEnabled(true);
        } else {
            presentation.setText(TITLE);
            presentation.setEnabled(false);
            presentation.setVisible(true);
        }
    }

    @Nullable
    private static NlComponent findTarget(@Nullable SceneView screenView) {
        ImmutableList<NlComponent> selection;
        if (screenView != null && (selection = screenView.getSelectionModel().getSelection()).size() == 1) {
            NlComponent selected;
            for (selected = (NlComponent)selection.get(0); selected != null && !selected.isRoot() && selected.getChildren().isEmpty(); selected = selected.getParent()) {
            }
            return selected;
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null) {
            return;
        }
        assert (sceneView instanceof ScreenView);
        ScreenView screenView = (ScreenView)sceneView;
        NlComponent target = ConvertToConstraintLayoutAction.findTarget(screenView);
        if (target == null) {
            return;
        }
        Project project = this.mySurface.getProject();
        ConvertToConstraintLayoutForm dialog = new ConvertToConstraintLayoutForm(project);
        if (!dialog.showAndGet()) {
            return;
        }
        boolean flatten = dialog.getFlattenHierarchy();
        boolean includeIds = dialog.getFlattenReferenced();
        boolean includeCustomViews = dialog.getIncludeCustomViews();
        GoogleMavenArtifactId artifact = (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false ? GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT : GoogleMavenArtifactId.CONSTRAINT_LAYOUT;
        List<GradleCoordinate> notAdded = DependencyManagementUtil.addDependencies(screenView.getModel().getModule(), Collections.singletonList(artifact.getCoordinate("+")), false);
        if (!notAdded.isEmpty()) {
            return;
        }
        ConstraintLayoutConverter converter = new ConstraintLayoutConverter(screenView, target, flatten, includeIds, includeCustomViews);
        converter.execute();
    }

    private static void inferConstraints(@NotNull NlComponent target) {
        if (target == null) {
            ConvertToConstraintLayoutAction.$$$reportNull$$$0(1);
        }
        try {
            Scout.inferConstraintsFromConvert(target);
            ArrayList<NlComponent> list = new ArrayList<NlComponent>(target.getChildren());
            list.add(0, target);
            for (NlComponent component : list) {
                AttributesTransaction transaction = component.startAttributeTransaction();
                transaction.commit();
            }
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(target);
        }
        catch (Throwable t) {
            Logger.getInstance(ConvertToConstraintLayoutAction.class).warn(t);
        }
    }

    private static void removeAbsolutePositionAndSizes(NlComponent component) {
        for (NlComponent child : component.getChildren()) {
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            child.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, null);
            child.setAttribute("http://schemas.android.com/tools", ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, null);
            ConvertToConstraintLayoutAction.removeAbsolutePositionAndSizes(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "inferConstraints";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConstraintLayoutConverter
    extends WriteCommandAction {
        private static final boolean DIRECT_INFERENCE = true;
        private final ScreenView myScreenView;
        private final boolean myFlatten;
        private final boolean myIncludeIds;
        private final boolean myIncludeCustomViews;
        private ViewEditorImpl myEditor;
        private List<NlComponent> myToBeFlattened;
        private NlComponent myRoot;
        private NlComponent myLayout;

        public ConstraintLayoutConverter(@NotNull ScreenView screenView, @NotNull NlComponent target, boolean flatten, boolean includeIds, boolean includeCustomViews) {
            if (screenView == null) {
                ConstraintLayoutConverter.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ConstraintLayoutConverter.$$$reportNull$$$0(1);
            }
            super(screenView.getSurface().getProject(), ConvertToConstraintLayoutAction.TITLE, new PsiFile[]{screenView.getModel().getFile()});
            this.myScreenView = screenView;
            this.myFlatten = flatten;
            this.myIncludeIds = includeIds;
            this.myIncludeCustomViews = includeCustomViews;
            this.myLayout = target;
            this.myRoot = (NlComponent)this.myScreenView.getModel().getComponents().get(0);
            this.myEditor = new ViewEditorImpl(this.myScreenView);
        }

        protected void run(@NotNull Result result2) throws Throwable {
            if (result2 == null) {
                ConstraintLayoutConverter.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myLayout == null) {
                return;
            }
            this.myLayout.ensureId();
            boolean directConvert = true;
            if (this.myFlatten) {
                for (NlComponent child : this.myLayout.getChildren()) {
                    if (!this.isLayout(child)) continue;
                    directConvert = false;
                }
            }
            if (directConvert && ScoutDirectConvert.directProcess(this.myLayout)) {
                return;
            }
            this.myToBeFlattened = Lists.newArrayList();
            this.processComponent(this.myLayout);
            this.flatten();
            NlModel model = this.myLayout.getModel();
            XmlTag layoutTag = this.myLayout.getTag();
            XmlTag rootTag = this.myRoot.getTag();
            PsiElement tag = this.myLayout.getTag().setName(DependencyManagementUtil.mapAndroidxName(model.getModule(), SdkConstants.CLASS_CONSTRAINT_LAYOUT));
            final LayoutlibSceneManager manager = this.myScreenView.getSurface().getSceneManager();
            assert (manager != null);
            manager.layout(false);
            this.myRoot = model.findViewByTag(rootTag);
            this.myLayout = model.findViewByTag(layoutTag);
            tag = CodeStyleManager.getInstance((Project)this.getProject()).reformat(tag);
            this.myLayout.getModel().syncWithPsi((XmlTag)tag, Collections.emptyList());
            final String id = this.myLayout.getId();
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    assert (id != null);
                    NlComponent layout2 = myScreenView.getModel().find(id);
                    NlWriteCommandAction action2 = new NlWriteCommandAction(Collections.singletonList(layout2), "Infer Constraints", () -> {
                        if (layout2 != null) {
                            Map<NlComponent, Dimension> sizes = myEditor.measureChildren(layout2, null);
                            assert (sizes != null);
                            for (NlComponent component : sizes.keySet()) {
                                Dimension d = sizes.get(component);
                                component.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_WIDTH, Integer.toString(d.width));
                                component.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_WRAP_HEIGHT, Integer.toString(d.height));
                            }
                            ConvertToConstraintLayoutAction.inferConstraints(layout2);
                            manager.removeRenderListener(this);
                        }
                    });
                    ApplicationManager.getApplication().invokeLater((Runnable)action2);
                }
            });
        }

        private void processComponent(NlComponent component) {
            for (NlComponent child : component.getChildren()) {
                int dpx = this.myEditor.pxToDp(NlComponentHelperKt.getX(child) - NlComponentHelperKt.getX(this.myRoot));
                int dpy = this.myEditor.pxToDp(NlComponentHelperKt.getY(child) - NlComponentHelperKt.getY(this.myRoot));
                int dpw = this.myEditor.pxToDp(NlComponentHelperKt.getW(child));
                int dph = this.myEditor.pxToDp(NlComponentHelperKt.getH(child));
                AttributesTransaction transaction = child.startAttributeTransaction();
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_WIDTH, String.format(Locale.ROOT, "%ddp", dpw));
                transaction.setAttribute("http://schemas.android.com/tools", ConvertToConstraintLayoutAction.ATTR_LAYOUT_CONVERSION_ABSOLUTE_HEIGHT, String.format(Locale.ROOT, "%ddp", dph));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format(Locale.ROOT, "%ddp", dpx));
                transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format(Locale.ROOT, "%ddp", dpy));
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
                transaction.commit();
                List toDelete = null;
                for (AttributeSnapshot attribute : child.getAttributes()) {
                    String name = attribute.name;
                    if (!name.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || name.equals("layout_width") || name.equals("layout_height")) continue;
                    if (toDelete == null) {
                        toDelete = Lists.newArrayList();
                    }
                    toDelete.add(name);
                }
                if (toDelete != null) {
                    for (String name : toDelete) {
                        child.setAttribute("http://schemas.android.com/apk/res/android", name, null);
                    }
                }
                if (this.isLayout(child)) {
                    if (!this.myFlatten || !this.shouldFlatten(child)) continue;
                    this.myToBeFlattened.add(child);
                }
                this.processComponent(child);
            }
        }

        private void flatten() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
            Document document = documentManager.getDocument((PsiFile)this.myScreenView.getModel().getFile());
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ArrayList ranges = Lists.newArrayList();
            for (NlComponent component : this.myToBeFlattened) {
                XmlTag tag = component.getTag();
                PsiElement openStart = null;
                PsiElement openEnd = null;
                PsiElement closeStart = null;
                PsiElement closeEnd = null;
                for (PsiElement curr = tag.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    IElementType elementType = curr.getNode().getElementType();
                    if (elementType == XmlTokenType.XML_START_TAG_START) {
                        openStart = curr;
                        continue;
                    }
                    if (elementType == XmlTokenType.XML_TAG_END) {
                        if (closeStart == null) {
                            openEnd = curr;
                            continue;
                        }
                        closeEnd = curr;
                        break;
                    }
                    if (elementType == XmlTokenType.XML_END_TAG_START) {
                        closeStart = curr;
                        continue;
                    }
                    if (elementType != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
                    openEnd = curr;
                    break;
                }
                if (openStart == null || openEnd == null || closeStart == null || closeEnd == null) continue;
                ranges.add(new TextRange(openStart.getTextOffset(), openEnd.getTextOffset() + openEnd.getTextLength()));
                ranges.add(new TextRange(closeStart.getTextOffset(), closeEnd.getTextOffset() + closeEnd.getTextLength()));
            }
            ranges.sort((o1, o2) -> o2.getStartOffset() - o1.getStartOffset());
            for (TextRange range : ranges) {
                document.deleteString(range.getStartOffset(), range.getEndOffset());
            }
            documentManager.commitDocument(document);
        }

        private boolean isLayout(@NotNull NlComponent component) {
            Object viewObject;
            NlComponent child;
            if (component == null) {
                ConstraintLayoutConverter.$$$reportNull$$$0(3);
            }
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component)) {
                return false;
            }
            List<NlComponent> children = component.getChildren();
            if (children.size() > 1) {
                return true;
            }
            if (children.size() == 1 && !"requestFocus".equals((child = children.get(0)).getTagName())) {
                return true;
            }
            ViewInfo info = NlComponentHelperKt.getViewInfo(component);
            if (info != null && (viewObject = info.getViewObject()) != null) {
                for (Class<?> cls = viewObject.getClass(); cls != null; cls = cls.getSuperclass()) {
                    String fqcn = cls.getName();
                    if ("android.widget.AdapterView".equals(fqcn)) {
                        return false;
                    }
                    if (fqcn.startsWith("android.webkit.") && fqcn.endsWith("WebView")) {
                        return false;
                    }
                    if (!"android.view.ViewGroup".equals(fqcn)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isCustomView(NlComponent component) {
            String tag = component.getTagName();
            return tag.indexOf(46) != -1;
        }

        private boolean shouldFlatten(@NotNull NlComponent component) {
            XmlAttributeValue valueElement;
            XmlAttribute attribute;
            if (component == null) {
                ConstraintLayoutConverter.$$$reportNull$$$0(4);
            }
            if (!this.myIncludeCustomViews && ConstraintLayoutConverter.isCustomView(component)) {
                return false;
            }
            if (component.getAttribute("http://schemas.android.com/apk/res/android", "background") != null || component.getAttribute("http://schemas.android.com/apk/res/android", "foreground") != null) {
                return false;
            }
            String id = component.getAttribute("http://schemas.android.com/apk/res/android", "id");
            if (id == null) {
                return true;
            }
            if (!this.myIncludeIds && (attribute = component.getTag().getAttribute("id", "http://schemas.android.com/apk/res/android")) != null && (valueElement = attribute.getValueElement()) != null && valueElement.isValid()) {
                UsageInfo[] usages;
                RenameProcessor processor = new RenameProcessor(this.myScreenView.getSurface().getProject(), (PsiElement)valueElement, "NONEXISTENT_ID12345", false, false);
                processor.setPreviewUsages(false);
                XmlFile layoutFile = this.myScreenView.getModel().getFile();
                for (UsageInfo info : usages = processor.findUsages()) {
                    PsiFile file = info.getFile();
                    if (layoutFile.equals(file)) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/actions/ConvertToConstraintLayoutAction$ConstraintLayoutConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLayout";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldFlatten";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

