/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MorphPanel
extends JPanel {
    public static final String MORPH_DIALOG_NAME = "MorphPanel";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final JComponent myEditor;
    private JPanel myCodePreview;
    private JBLabel myNewTagLabel;
    private TextFieldWithCompletion myNewTagText;
    private JPanel myRoot;
    private JButton myOkButton;
    private JList<Palette.Item> mySuggestionsList;
    private JBLabel myShowMoreLabel;
    private Consumer<String> myOkAction;
    @Nullable
    private Consumer<String> myNameChangeConsumer;

    public MorphPanel(@NotNull AndroidFacet facet, @NotNull Project project, @NotNull JComponent codePreviewEditor, @NotNull String oldTag, @NotNull List<String> tagSuggestions) {
        if (facet == null) {
            MorphPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MorphPanel.$$$reportNull$$$0(1);
        }
        if (codePreviewEditor == null) {
            MorphPanel.$$$reportNull$$$0(2);
        }
        if (oldTag == null) {
            MorphPanel.$$$reportNull$$$0(3);
        }
        if (tagSuggestions == null) {
            MorphPanel.$$$reportNull$$$0(4);
        }
        this.myFacet = facet;
        this.myProject = project;
        this.myEditor = codePreviewEditor;
        this.$$$setupUI$$$();
        this.myEditor.setVisible(false);
        this.myCodePreview.add((Component)this.myEditor, "Center");
        this.setName(MORPH_DIALOG_NAME);
        this.setFocusable(true);
        this.myOkButton.addActionListener(e -> this.doOkAction());
        this.setupTextTagField(oldTag);
        this.setupButtonList(tagSuggestions);
        this.myShowMoreLabel.setIcon(AllIcons.General.ComboArrowRight);
        this.myShowMoreLabel.setText("Show XML preview");
        this.myShowMoreLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MorphPanel.this.myEditor.setVisible(!MorphPanel.this.myEditor.isVisible());
                MorphPanel.this.myShowMoreLabel.setIcon(MorphPanel.this.myEditor.isVisible() ? AllIcons.General.ComboArrowDown : AllIcons.General.ComboArrowRight);
                Window window = UIUtil.getWindow((Component)e.getComponent());
                if (window != null) {
                    window.pack();
                }
            }
        });
    }

    private void setupButtonList(List<String> suggestions) {
        DefaultListModel<Palette.Item> model = new DefaultListModel<Palette.Item>();
        ViewHandlerManager manager = ViewHandlerManager.get(this.myProject);
        for (String tagSuggestion : suggestions) {
            ViewHandler handler = manager.getHandlerOrDefault(tagSuggestion);
            model.addElement(new Palette.Item(tagSuggestion, handler));
        }
        this.mySuggestionsList.setModel(model);
        this.mySuggestionsList.setSelectionMode(0);
        this.mySuggestionsList.setLayoutOrientation(2);
        this.mySuggestionsList.setCellRenderer((ListCellRenderer<Palette.Item>)new ColoredListCellRenderer<Palette.Item>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Palette.Item> list, Palette.Item value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setIcon(value.getIcon());
                String name = value.getTagName();
                int i = name.lastIndexOf(46);
                if (i > -1 && i < name.length() - 1) {
                    name = name.substring(i + 1);
                }
                this.append(name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/actions/MorphPanel$2", "customizeCellRenderer"));
            }
        });
        this.mySuggestionsList.setBackground(this.getBackground().brighter());
        this.mySuggestionsList.setVisibleRowCount(5);
        this.mySuggestionsList.setSelectedIndex(0);
        this.mySuggestionsList.addListSelectionListener(e -> {
            String tag = this.mySuggestionsList.getSelectedValue().getTagName();
            this.myNewTagText.setText(tag);
        });
    }

    private void setupTextTagField(@NotNull String oldTag) {
        if (oldTag == null) {
            MorphPanel.$$$reportNull$$$0(5);
        }
        this.myNewTagText.addDocumentListener((DocumentListener)this.createDocumentListener());
        this.myNewTagText.setText(oldTag);
        this.myNewTagText.registerKeyboardAction(e -> this.doOkAction(), KeyStroke.getKeyStroke(10, 0), 2);
        this.myNewTagText.setRequestFocusEnabled(true);
        this.myNewTagText.requestFocusInWindow();
        this.myNewTagText.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MorphPanel.this.myNewTagText.selectAll();
            }
        });
    }

    private void doOkAction() {
        if (this.myOkAction != null) {
            this.myOkAction.consume((Object)this.myNewTagText.getText());
        }
    }

    @NotNull
    private DocumentAdapter createDocumentListener() {
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (MorphPanel.this.myNameChangeConsumer != null) {
                    MorphPanel.this.myNameChangeConsumer.consume((Object)e.getDocument().getText());
                }
            }
        };
        if (documentAdapter == null) {
            MorphPanel.$$$reportNull$$$0(6);
        }
        return documentAdapter;
    }

    public void createUIComponents() {
        this.myRoot = this;
        this.myNewTagText = this.createAutoCompleteTagField();
    }

    @NotNull
    private TextFieldWithCompletion createAutoCompleteTagField() {
        List<String> possibleRoots = AndroidLayoutUtil.getPossibleRoots(this.myFacet);
        Collections.sort(possibleRoots);
        TextFieldWithAutoCompletion.StringsCompletionProvider completionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider(possibleRoots, null);
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
        if (textFieldWithAutoCompletion == null) {
            MorphPanel.$$$reportNull$$$0(7);
        }
        return textFieldWithAutoCompletion;
    }

    public void setOkAction(@Nullable Consumer<String> okAction) {
        this.myOkAction = okAction;
    }

    public void setTagNameChangeConsumer(@Nullable Consumer<String> consumer) {
        this.myNameChangeConsumer = consumer;
    }

    @NotNull
    public Component getPreferredFocusComponent() {
        TextFieldWithCompletion textFieldWithCompletion = this.myNewTagText;
        if (textFieldWithCompletion == null) {
            MorphPanel.$$$reportNull$$$0(8);
        }
        return textFieldWithCompletion;
    }

    void setTagNameText(String name) {
        this.myNewTagLabel.setText(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codePreviewEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagSuggestions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/actions/MorphPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/actions/MorphPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAutoCompleteTagField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupTextTagField";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JButton jButton;
        JBLabel jBLabel2;
        this.createUIComponents();
        JPanel jPanel2 = this.myRoot;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myNewTagLabel = jBLabel2 = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel2.getFont());
        if (font != null) {
            jBLabel2.setFont(font);
        }
        jBLabel2.setText("Convert View to:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myNewTagText;
        jPanel2.add((Component)textFieldWithCompletion, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, new Dimension(200, -1), null, null));
        this.myOkButton = jButton = new JButton();
        jButton.setText("Apply");
        jPanel2.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        JList jList = new JList();
        this.mySuggestionsList = jList;
        jList.setName("suggestionList");
        jPanel2.add(jList, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myCodePreview = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setEnabled(false);
        ((Component)jPanel).setVisible(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 7, null, null, null));
        this.myShowMoreLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

