/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

class AnimationToolbarSliderUI
extends BasicSliderUI {
    private final JBColor myTickColor = new JBColor(Color.BLACK, Color.WHITE);
    private final JBColor myTrackPlayedColor = new JBColor(Color.decode("#1A237E"), Color.decode("#B2EBF2"));
    private final JBColor myTrackBackgroundColor = JBColor.GRAY;
    private final Rectangle myTrackRectangle = new Rectangle();

    public AnimationToolbarSliderUI(JSlider b) {
        super(b);
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 1) {
            return;
        }
        int trackHeight = this.thumbRect.height / 4;
        this.myTrackRectangle.x = this.trackRect.x;
        this.myTrackRectangle.y = this.trackRect.y + this.trackRect.height / 2 - trackHeight / 2;
        this.myTrackRectangle.width = this.trackRect.width;
        this.myTrackRectangle.height = trackHeight;
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintThumb(g);
            return;
        }
        g.setColor(ColorUtil.toAlpha((Color)this.myTrackPlayedColor, (int)255));
        int side = Math.min(this.thumbRect.width, this.thumbRect.height);
        int midX = this.thumbRect.x + this.thumbRect.width / 2;
        int midY = this.thumbRect.y + this.thumbRect.height / 2;
        g.fillRect(midX - side / 2, midY - side / 2, side / 2, side);
    }

    private void paintHorizontalTrack(Graphics g) {
        int thumbMidX = this.thumbRect.x + this.thumbRect.width / 2;
        int playedX = thumbMidX - this.trackRect.x;
        g.setColor(ColorUtil.toAlpha((Color)this.myTrackBackgroundColor, (int)100));
        g.fillRect(this.myTrackRectangle.x, this.myTrackRectangle.y, this.myTrackRectangle.width, this.myTrackRectangle.height);
        g.setColor((Color)this.myTrackPlayedColor);
        g.fillRect(this.myTrackRectangle.x, this.myTrackRectangle.y, playedX, this.myTrackRectangle.height);
    }

    @Override
    public void paintTrack(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintTrack(g);
            return;
        }
        this.paintHorizontalTrack(g);
    }

    @Override
    public void paintTicks(Graphics g) {
        if (this.slider.getOrientation() == 1) {
            super.paintTicks(g);
            return;
        }
        if (this.slider.getMajorTickSpacing() > 0) {
            g.setColor((Color)this.myTickColor);
            for (int value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                int xPos = this.xPositionForValue(value);
                g.fillRect(xPos - 1, this.myTrackRectangle.y, 3, this.myTrackRectangle.height);
                if (Integer.MAX_VALUE - this.slider.getMajorTickSpacing() < value) break;
            }
        }
    }
}

