/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.analytics.NlUsageTracker;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ActionTarget;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.util.ImageUtilKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.graphics.NlIcon;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintReferenceManagement;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.WidgetDraw;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.WidgetDecorator;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ClearConstraintsTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintResizeTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintLayoutHandler
extends ViewGroupHandler
implements ComponentProvider {
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String AUTO_CONNECT_PREF_KEY = "ConstraintLayoutPreferenceAutoConnect";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    public static final String SHOW_MARGINS_PREF_KEY = "ConstraintLayoutPreferenceShowMargins";
    public static final String FADE_UNSELECTED_VIEWS = "ConstraintLayoutPreferenceFadeUnselected";
    private static final NlIcon BASELINE_ICON = new NlIcon(StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT);
    private static boolean ourAutoConnect;
    private static final String ADD_VERTICAL_BARRIER = "Add Vertical Barrier";
    private static final String ADD_HORIZONTAL_BARRIER = "Add Horizontal Barrier";
    private static final String ADD_TO_BARRIER = "Add to Barrier";
    private static final String ADD_LAYER = "Add Layer";
    private static final String ADD_GROUP = "Add Group";
    private static final String ADD_CONSTRAINTS_SET = "Add Set of Constraints";
    @VisibleForTesting
    public static final String EDIT_BASELINE_ACTION_TOOLTIP = "Edit Baseline";
    private static HashMap<String, Boolean> ourVisibilityFlags;
    private static HashSet<String> ourHorizontalBarriers;

    public ConstraintLayoutHandler() {
        ConstraintLayoutHandler.loadWidgetDecoratorImages();
    }

    private static void loadWidgetDecoratorImages() {
        if (WidgetDecorator.sLockImageIcon == null) {
            WidgetDecorator.sLockImageIcon = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.LOCK);
        }
        if (WidgetDecorator.sUnlockImageIcon == null) {
            WidgetDecorator.sUnlockImageIcon = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.UNLOCK);
        }
        if (WidgetDecorator.sDeleteConnectionsImageIcon == null) {
            WidgetDecorator.sDeleteConnectionsImageIcon = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS);
        }
        if (WidgetDecorator.sPackChainImageIcon == null) {
            WidgetDecorator.sPackChainImageIcon = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_PACKED);
        }
        if (WidgetDraw.sGuidelineArrowLeft == null) {
            WidgetDraw.sGuidelineArrowLeft = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.ARROW_LEFT);
        }
        if (WidgetDraw.sGuidelineArrowRight == null) {
            WidgetDraw.sGuidelineArrowRight = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.ARROW_RIGHT);
        }
        if (WidgetDraw.sGuidelineArrowUp == null) {
            WidgetDraw.sGuidelineArrowUp = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.ARROW_UP);
        }
        if (WidgetDraw.sGuidelineArrowDown == null) {
            WidgetDraw.sGuidelineArrowDown = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.ARROW_DOWN);
        }
        if (WidgetDraw.sGuidelinePercent == null) {
            WidgetDraw.sGuidelinePercent = ImageUtilKt.iconToImage(StudioIcons.LayoutEditor.Toolbar.PERCENT);
        }
    }

    @Override
    @NotNull
    public Map<String, Map<String, String>> getEnumPropertyValues(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(0);
        }
        ImmutableMap values2 = ImmutableMap.of((Object)"0dp", (Object)"match_constraint", (Object)"wrap_content", (Object)"wrap_content");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"layout_width", (Object)values2, (Object)"layout_height", (Object)values2);
        if (immutableMap == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    @Override
    @NotNull
    public CustomPanel getLayoutCustomPanel() {
        WidgetConstraintPanel widgetConstraintPanel = new WidgetConstraintPanel((List<NlComponent>)ImmutableList.of());
        if (widgetConstraintPanel == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(2);
        }
        return widgetConstraintPanel;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        if (actions2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(3);
        }
        actions2.add(new NestedViewActionMenu("View Options", StudioIcons.Common.VISIBILITY_INLINE, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new ToggleVisibilityAction(SHOW_CONSTRAINTS_PREF_KEY, "Show Constraints", true), new ToggleVisibilityAction(SHOW_MARGINS_PREF_KEY, "Show Margins", true), new ToggleVisibilityAction(FADE_UNSELECTED_VIEWS, "Fade Unselected Views ", false)})})));
        actions2.add(new ToggleAutoConnectAction());
        actions2.add(new MarginSelector());
        actions2.add(new ViewActionSeparator());
        actions2.add(new ClearConstraintsAction());
        actions2.add(new InferAction());
        if (((Boolean)StudioFlags.ENABLE_NEW_SCOUT.get()).booleanValue()) {
            actions2.add(new ScoutAction());
        }
        actions2.add(new ViewActionSeparator());
        actions2.add(new NestedViewActionMenu("Pack", StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, (List)Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new ViewAction[]{new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"), new ViewActionSeparator(), new AlignAction(Scout.Arrange.DistributeHorizontally, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL_CONSTRAINT, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL_CONSTRAINT, "Distribute Vertically")})})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (component == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (selectedChildren == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.updatePresentation(presentation, editor, handler, component, selectedChildren, modifiers);
                presentation.setVisible(ConstraintLayoutHandler.isConstraintLayoutChild(selectedChildren));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selectedChildren";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$1";
                objectArray[2] = "updatePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions2.add(new NestedViewActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, (List)Lists.newArrayList((Object[])new List[]{Stream.of(ConstraintViewActions.ALIGN_HORIZONTALLY_ACTIONS, ConstraintViewActions.ALIGN_VERTICALLY_ACTIONS, ImmutableList.of((Object)new ViewActionSeparator()), ConstraintViewActions.CENTER_ACTIONS).flatMap(list -> list.stream()).collect(Collectors.toList())})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
                if (presentation == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (component == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (selectedChildren == null) {
                    2.$$$reportNull$$$0(4);
                }
                super.updatePresentation(presentation, editor, handler, component, selectedChildren, modifiers);
                presentation.setVisible(ConstraintLayoutHandler.isConstraintLayoutChild(selectedChildren));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "handler";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selectedChildren";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$2";
                objectArray[2] = "updatePresentation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions2.add(new NestedViewActionMenu("Guidelines", StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, Lists.newArrayList((Object[])new List[]{ConstraintViewActions.HELPER_ACTIONS})));
        ViewActionSeparator.setupFollowingActions(actions2);
    }

    private static boolean isConstraintLayoutChild(List<NlComponent> children) {
        for (NlComponent child : children) {
            NlComponent parent = child.getParent();
            if (parent == null || !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addPopupMenuActions(@NotNull NlComponent component, @NotNull List<ViewAction> actions2) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(4);
        }
        if (actions2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(5);
        }
        actions2.add(new DisappearingActionMenu("Organize", StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.ORGANIZE_ACTIONS));
        actions2.add(new DisappearingActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, (List<ViewAction>)ConstraintViewActions.ALIGN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Chains", StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, (List<ViewAction>)ConstraintViewActions.CHAIN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Center", StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, (List<ViewAction>)ConstraintViewActions.CENTER_ACTIONS));
        actions2.add(new DisappearingActionMenu("Helpers", StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, (List<ViewAction>)ConstraintViewActions.HELPER_ACTIONS));
        return true;
    }

    @Override
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent component) {
        if (screenView == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(6);
        }
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(7);
        }
        return new ConstraintSceneInteraction(screenView, component);
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(8);
        }
        sceneComponent.setNotchProvider(new ConstraintLayoutNotchProvider());
        ImmutableList immutableList = ImmutableList.of((Object)new LassoTarget(), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.LEFT, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.TOP, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.RIGHT, false), (Object)new ConstraintAnchorTarget(AnchorTarget.Type.BOTTOM, false));
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        if (parentComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(10);
        }
        if (childComponent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(11);
        }
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        NlComponent nlComponent = childComponent.getAuthoritativeNlComponent();
        ViewInfo vi = NlComponentHelperKt.getViewInfo(nlComponent);
        if (vi != null) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
                String orientation = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                boolean isHorizontal = true;
                if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
                    isHorizontal = false;
                }
                listBuilder.add((Object)new GuidelineTarget(isHorizontal)).add((Object)(isHorizontal ? new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true) : new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false))).add((Object)new GuidelineCycleTarget(isHorizontal));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(12);
                }
                return immutableList;
            }
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                String side = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
                boolean isHorizontal = side == null || ourHorizontalBarriers.contains(side.toLowerCase());
                listBuilder.add((Object)new BarrierAnchorTarget(isHorizontal ? AnchorTarget.Type.TOP : AnchorTarget.Type.RIGHT, BarrierTarget.parseDirection(side))).add((Object)new BarrierTarget(BarrierTarget.parseDirection(side)));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    ConstraintLayoutHandler.$$$reportNull$$$0(13);
                }
                return immutableList;
            }
        }
        childComponent.setComponentProvider(this);
        childComponent.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        listBuilder.add((Object[])new Target[]{new ConstraintDragTarget(), new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT), new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT), new ConstraintResizeTarget(ResizeBaseTarget.Type.TOP), new ConstraintResizeTarget(ResizeBaseTarget.Type.BOTTOM), new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_TOP), new ConstraintResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM), new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP), new ConstraintResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM), new ConstraintAnchorTarget(AnchorTarget.Type.LEFT, true), new ConstraintAnchorTarget(AnchorTarget.Type.TOP, true), new ConstraintAnchorTarget(AnchorTarget.Type.RIGHT, true), new ConstraintAnchorTarget(AnchorTarget.Type.BOTTOM, true)});
        ClearConstraintsTarget previousAction = new ClearConstraintsTarget();
        listBuilder.add((Object)previousAction);
        int baseline = NlComponentHelperKt.getBaseline(childComponent.getNlComponent());
        ViewInfo info = NlComponentHelperKt.getViewInfo(childComponent.getNlComponent());
        if (baseline <= 0 && info != null) {
            baseline = info.getBaseLine();
        }
        if (baseline > 0) {
            listBuilder.add((Object)new ConstraintAnchorTarget(AnchorTarget.Type.BASELINE, true));
            ActionTarget baselineActionTarget = new ActionTarget(BASELINE_ICON, c -> c.setShowBaseline(!c.canShowBaseline())){

                @Override
                @NotNull
                public String getToolTipText() {
                    if (ConstraintLayoutHandler.EDIT_BASELINE_ACTION_TOOLTIP == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return ConstraintLayoutHandler.EDIT_BASELINE_ACTION_TOOLTIP;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$3", "getToolTipText"));
                }
            };
            listBuilder.add((Object)baselineActionTarget);
        }
        listBuilder.add((Object)new ChainCycleTarget(null));
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @Override
    public void cleanUpAttributes(@NotNull NlComponent component, @NotNull NlAttributesHolder attributes) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(15);
        }
        if (attributes == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(16);
        }
        ConstraintComponentUtilities.cleanup(attributes, component);
    }

    @Override
    public void clearAttributes(@NotNull NlComponent component) {
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(17);
        }
        ConstraintComponentUtilities.clearAttributes(component);
    }

    @Override
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(18);
        }
        if (layout2 == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(19);
        }
        if (components == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(20);
        }
        if (type == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(21);
        }
        return new ConstraintDragHandler(editor, this, layout2, components, type);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    private static void ensureLayersAreShown(@NotNull ViewEditor editor, int duration) {
        if (editor == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(22);
        }
        NlDesignSurface designSurface = (NlDesignSurface)editor.getScene().getDesignSurface();
        designSurface.forceLayersPaint(true);
        designSurface.repaint();
        Timer timer2 = new Timer(duration, actionEvent -> designSurface.forceLayersPaint(false));
        timer2.setRepeats(false);
        timer2.start();
    }

    public static boolean getVisualProperty(String prop) {
        if (ourVisibilityFlags.containsKey(prop)) {
            return ourVisibilityFlags.get(prop);
        }
        boolean selected = PropertiesComponent.getInstance().getBoolean(prop);
        ourVisibilityFlags.put(prop, selected);
        return selected;
    }

    public static void forceDefaultVisualProperties() {
        ourVisibilityFlags.put(SHOW_CONSTRAINTS_PREF_KEY, true);
        ourVisibilityFlags.put(SHOW_MARGINS_PREF_KEY, true);
        ourVisibilityFlags.put(FADE_UNSELECTED_VIEWS, false);
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull Collection<NlComponent> deleted) {
        if (parent == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(23);
        }
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(24);
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            NlComponent component = parent.getChild(i);
            if (deleted.contains(component)) continue;
            ConstraintLayoutHandler.willDelete(component, deleted);
        }
        return false;
    }

    private static void willDelete(NlComponent component, @NotNull Collection<NlComponent> deleted) {
        if (deleted == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(25);
        }
        for (NlComponent deletedComponent : deleted) {
            String id = deletedComponent.getId();
            ConstraintComponentUtilities.updateOnDelete(component, id);
            NlComponent parent = deletedComponent.getParent();
            if (parent == null || id == null) continue;
            ConstraintHelperHandler.willDelete(parent, id);
        }
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"minWidth", (Object)"maxWidth", (Object)"minHeight", (Object)"maxHeight");
        if (immutableList == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(26);
        }
        return immutableList;
    }

    @Override
    public ComponentProvider getComponentProvider(@NotNull SceneComponent component) {
        String attribute;
        SceneComponent parent;
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(27);
        }
        if ((parent = component.getParent()) == null) {
            return null;
        }
        NlComponent nlComponent = parent.getNlComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CLASS_CONSTRAINT_LAYOUT) && (attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraints")) != null) {
            return this;
        }
        return null;
    }

    @Override
    public NlComponent getComponent(@NotNull SceneComponent component) {
        SceneComponent parent;
        if (component == null) {
            ConstraintLayoutHandler.$$$reportNull$$$0(28);
        }
        if ((parent = component.getParent()) == null) {
            return component.getNlComponent();
        }
        NlComponent nlComponent = parent.getNlComponent();
        String attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
        if ((attribute = NlComponent.extractId(attribute)) == null) {
            return component.getNlComponent();
        }
        NlComponent constraints = null;
        for (SceneComponent sceneComponent : parent.getChildren()) {
            String childId = sceneComponent.getNlComponent().getId();
            if (!Objects.equals(attribute, childId)) continue;
            constraints = sceneComponent.getNlComponent();
            break;
        }
        if (constraints == null) {
            return component.getNlComponent();
        }
        for (NlComponent nlComponent2 : constraints.getChildren()) {
            String reference2 = nlComponent2.getLiveAttribute("http://schemas.android.com/apk/res/android", "id");
            if ((reference2 = NlComponent.extractId(reference2)) == null || !reference2.equals(component.getNlComponent().getId())) continue;
            return nlComponent2;
        }
        return component.getNlComponent();
    }

    public static boolean isAutoconnectOn() {
        return PropertiesComponent.getInstance().getBoolean(AUTO_CONNECT_PREF_KEY, false);
    }

    static {
        ourVisibilityFlags = new HashMap();
        ourAutoConnect = PropertiesComponent.getInstance().getBoolean(AUTO_CONNECT_PREF_KEY, false);
        ourHorizontalBarriers = new HashSet<String>(Arrays.asList("top", "bottom"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childComponent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumPropertyValues";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutCustomPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildTargets";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEnumPropertyValues";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildTargets";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearAttributes";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureLayersAreShown";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "willDelete";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getComponentProvider";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstraintViewActions {
        private static final ImmutableList<ViewAction> ALIGN_HORIZONTALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignHorizontallyLeft, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, "Left Edges"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyCenter, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED_CONSTRAINT, "Horizontal Centers"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyRight, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED_CONSTRAINT, "Right Edges"));
        private static final ImmutableList<ViewAction> ALIGN_VERTICALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignVerticallyTop, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED_CONSTRAINT, "Top Edges"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyMiddle, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED_CONSTRAINT, "Vertical Centers"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyBottom, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED_CONSTRAINT, "Bottom Edges"), (Object)new AlignAction(Scout.Arrange.AlignBaseline, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, "Baselines"));
        private static final ImmutableList<ViewAction> ALIGN_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).build();
        private static final ImmutableList<ViewAction> CHAIN_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CreateHorizontalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, "Create Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.CreateVerticalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, "Create Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertHorizontal, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, "Insert in Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertVertical, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, "Insert in Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, "Remove from Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, "Remove from Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveUp, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, "Move Up Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveDown, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, "Move Down Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveLeft, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, "Move Left Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveRight, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, "Move Right Horizontal Chain"));
        private static final ImmutableList<ViewAction> CENTER_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CenterHorizontally, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_CONSTRAINT, "Horizontally"), (Object)new AlignAction(Scout.Arrange.CenterVertically, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_CONSTRAINT, "Vertically"), (Object)new AlignAction(Scout.Arrange.CenterHorizontallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT_CONSTRAINT, "Horizontally in Parent"), (Object)new AlignAction(Scout.Arrange.CenterVerticallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT_CONSTRAINT, "Vertically in Parent"));
        private static final ImmutableList<ViewAction> ORGANIZE_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), (Object)new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), (Object)new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), (Object)new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"));
        private static final ImmutableList<ViewAction> HELPER_ACTIONS = ImmutableList.of((Object)new AddElementAction(1, StudioIcons.LayoutEditor.Toolbar.VERTICAL_GUIDE, "Add Vertical Guideline"), (Object)new AddElementAction(0, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_GUIDE, "Add Horizontal Guideline"), (Object)new AddElementAction(3, StudioIcons.LayoutEditor.Toolbar.BARRIER_VERTICAL, "Add Vertical Barrier"), (Object)new AddElementAction(2, StudioIcons.LayoutEditor.Toolbar.BARRIER_HORIZONTAL, "Add Horizontal Barrier"), (Object)new AddElementAction(4, AndroidIcons.SherpaIcons.Layer, "Add Group"), (Object)new AddElementAction(5, AndroidIcons.SherpaIcons.Layer, "Add Set of Constraints"), (Object)new AddElementAction(6, AndroidIcons.SherpaIcons.Layer, "Add Layer"));
        private static final ImmutableList<ViewAction> ALL_POPUP_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).addAll(ORGANIZE_ACTIONS).addAll(CENTER_ACTIONS).addAll(HELPER_ACTIONS).build();

        private ConstraintViewActions() {
        }
    }

    private static class MarginSelector
    extends DirectViewAction {
        MarginPopup myMarginPopup = new MarginPopup();
        private int myMarginIconValue;
        private Icon myMarginIcon;

        public MarginSelector() {
            this.setLabel("Default Margins");
            this.myMarginPopup.setActionListener(e -> this.setMargin());
        }

        public void setMargin() {
            Scout.setMargin(this.myMarginPopup.getValue());
        }

        private void updateIcon() {
            final int margin = this.myMarginPopup.getValue();
            if (this.myMarginIconValue != margin) {
                this.myMarginIconValue = margin;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setColor(JBColor.foreground());
                        g.setFont(g.getFont().deriveFont(0, 12.0f));
                        String m = Integer.toString(margin) + "dp";
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY - 1);
                        g.setColor(JBColor.foreground().darker());
                        int marginRight = 6;
                        g.drawLine(x + 1, y + this.getIconHeight() - 1, x + this.getIconWidth() - 1, y + this.getIconHeight() - 1);
                        g.drawLine(x + 1, y + this.getIconHeight(), x + 1, y + this.getIconHeight() - marginRight);
                        g.drawLine(x + this.getIconWidth() - 1, y + this.getIconHeight(), x + this.getIconWidth() - 1, y + this.getIconHeight() - marginRight);
                    }

                    @Override
                    public int getIconWidth() {
                        return 36;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(1);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(3);
            }
            DesignSurface surface = editor.getScene().getDesignSurface();
            NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEFAULT_MARGINS);
            RelativePoint relativePoint = new RelativePoint((Component)((Object)surface), new Point(0, 0));
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).createPopup().show(relativePoint);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                MarginSelector.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                MarginSelector.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                MarginSelector.$$$reportNull$$$0(6);
            }
            if (component == null) {
                MarginSelector.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                MarginSelector.$$$reportNull$$$0(8);
            }
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ourAutoConnect || (2 & modifiers) == 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$MarginSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AlignAction
    extends DirectViewAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        boolean isEnabled(List<NlComponent> selected) {
            int count = selected.size();
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case CreateHorizontalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case CreateVerticalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
                case ChainHorizontalMoveLeft: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainVerticalMoveDown: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainVerticalMoveUp: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainHorizontalMoveRight: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainHorizontalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case ChainVerticalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ChainInsertHorizontal: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearHorizontalChain);
                }
                case ChainInsertVertical: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearVerticalChain);
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.ALIGN);
            Scout.arrangeWidgetsAndCommit(this.myActionType, selectedChildren, (modifiers &= 2) == 0 || ourAutoConnect);
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AlignAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AlignAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AlignAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AlignAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AlignAction.$$$reportNull$$$0(8);
            }
            Icon icon = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ourAutoConnect || (2 & modifiers) == 0)) {
                icon = this.myConstrainIcon;
            }
            presentation.setVisible(this.isEnabled(selectedChildren));
            presentation.setEnabled(this.isEnabled(selectedChildren));
            presentation.setIcon(icon);
            presentation.setLabel(this.myToolTip);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AlignAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        public static final int HORIZONTAL_BARRIER = 2;
        public static final int VERTICAL_BARRIER = 3;
        public static final int GROUP = 4;
        public static final int CONSTRAINT_SET = 5;
        public static final int LAYER = 6;
        final int myType;

        public AddElementAction(int type, Icon icon, String text) {
            super(icon, text);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(3);
            }
            for (parent = component; parent != null && !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT); parent = parent.getParent()) {
            }
            if (parent != null) {
                boolean useAndroidx = NlComponentHelperKt.isOrHasAndroidxSuperclass(parent);
                ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
                switch (this.myType) {
                    case 0: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        NlUsageTracker tracker = NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface());
                        tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_HORIZONTAL_GUIDELINE);
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                        break;
                    }
                    case 1: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        NlUsageTracker tracker = NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface());
                        tracker.logAction(LayoutEditorEvent.LayoutEditorEventType.ADD_VERTICAL_GUIDELINE);
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                        break;
                    }
                    case 4: {
                        NlComponent group = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.oldName(), null, InsertType.CREATE);
                        assert (group != null);
                        group.ensureId();
                        break;
                    }
                    case 5: {
                        NlComponent constraints = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.oldName(), null, InsertType.CREATE);
                        assert (constraints != null);
                        constraints.ensureId();
                        ConstraintReferenceManagement.populateConstraints(constraints);
                        break;
                    }
                    case 6: {
                        NlComponent layer = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.oldName(), null, InsertType.CREATE);
                        assert (layer != null);
                        layer.ensureId();
                        break;
                    }
                    case 2: {
                        NlComponent barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        barrier.ensureId();
                        barrier.setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "top");
                        break;
                    }
                    case 3: {
                        Object barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        ((NlComponent)barrier).ensureId();
                        ((NlComponent)barrier).setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "left");
                    }
                }
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                AddElementAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                AddElementAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                AddElementAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                AddElementAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                AddElementAction.$$$reportNull$$$0(8);
            }
            boolean show = true;
            if ((this.myType == 3 || this.myType == 2) && (show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor, 1, 0))) {
                int barriers = 0;
                int other = 0;
                for (NlComponent child : selectedChildren) {
                    if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                        ++barriers;
                    }
                    if (ConstraintComponentUtilities.isLine(child)) continue;
                    ++other;
                }
                if (barriers == 1 && other > 0) {
                    presentation.setLabel(ConstraintLayoutHandler.ADD_TO_BARRIER);
                } else {
                    presentation.setLabel(this.myType == 3 ? ConstraintLayoutHandler.ADD_VERTICAL_BARRIER : ConstraintLayoutHandler.ADD_HORIZONTAL_BARRIER);
                }
            }
            if (this.myType == 4) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor, 1, 0);
            }
            if (this.myType == 5) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor, 1, 9);
            }
            if (this.myType == 6) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor, 1, 9);
            }
            presentation.setVisible(show);
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$AddElementAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ControlIcon
    implements Icon {
        public static final Color HIGHLIGHT_COLOR = new Color(240116);
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon) {
            this.myIcon = icon;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(HIGHLIGHT_COLOR);
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private static class ToggleVisibilityAction
    extends ToggleViewAction {
        String mType;

        public ToggleVisibilityAction(String type, String text, boolean defaultValue) {
            super(null, AllIcons.Actions.Checked, text, text);
            this.mType = type;
            ourVisibilityFlags.put(this.mType, PropertiesComponent.getInstance().getBoolean(type, defaultValue));
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(3);
            }
            return (Boolean)ourVisibilityFlags.get(this.mType);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleVisibilityAction.$$$reportNull$$$0(7);
            }
            ourVisibilityFlags.put(this.mType, selected);
            PropertiesComponent.getInstance().setValue(this.mType, selected);
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleVisibilityAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ScoutAction
    extends DirectViewAction {
        private ScoutAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                ScoutAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ScoutAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ScoutAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ScoutAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.INFER_CONSTRAINS);
            try {
                Scout.findConstraintSetAndCommit(component);
                ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                ScoutAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                ScoutAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                ScoutAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ScoutAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ScoutAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.INFER_CONSTRAINTS);
            presentation.setLabel("Infer Constraints (new)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ScoutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InferAction
    extends DirectViewAction {
        private InferAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                InferAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.INFER_CONSTRAINS);
            try {
                Scout.inferConstraintsAndCommit(component);
                ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
            }
            catch (Exception e) {
                Logger.getInstance(ConstraintLayoutHandler.class).warn("Error in inferring constraints", (Throwable)e);
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                InferAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                InferAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                InferAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                InferAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                InferAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.INFER_CONSTRAINTS);
            presentation.setLabel("Infer Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$InferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private ClearConstraintsAction() {
        }

        @Override
        public void perform(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ClearConstraintsAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(3);
            }
            NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface()).logAction(LayoutEditorEvent.LayoutEditorEventType.CLEAR_ALL_CONSTRAINTS);
            ViewEditorImpl viewEditor = (ViewEditorImpl)editor;
            Scene scene = viewEditor.getScene();
            scene.clearAttributes();
            ConstraintLayoutHandler.ensureLayersAreShown(editor, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                ClearConstraintsAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                ClearConstraintsAction.$$$reportNull$$$0(5);
            }
            if (handler == null) {
                ClearConstraintsAction.$$$reportNull$$$0(6);
            }
            if (component == null) {
                ClearConstraintsAction.$$$reportNull$$$0(7);
            }
            if (selectedChildren == null) {
                ClearConstraintsAction.$$$reportNull$$$0(8);
            }
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS);
            presentation.setLabel("Clear All Constraints");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ClearConstraintsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleAutoConnectAction
    extends ToggleViewAction
    implements Enableable {
        public ToggleAutoConnectAction() {
            super(StudioIcons.LayoutEditor.Toolbar.AUTO_CORRECT_OFF, StudioIcons.LayoutEditor.Toolbar.AUTO_CONNECT, "Turn On Autoconnect", "Turn Off Autoconnect");
        }

        @Override
        public void enable(List<NlComponent> selection) {
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(2);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(3);
            }
            return PropertiesComponent.getInstance().getBoolean(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, false);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            if (editor == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(5);
            }
            if (parent == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(6);
            }
            if (selectedChildren == null) {
                ToggleAutoConnectAction.$$$reportNull$$$0(7);
            }
            NlUsageTrackerManager.getInstance(editor.getScene().getDesignSurface()).logAction(selected ? LayoutEditorEvent.LayoutEditorEventType.TURN_ON_AUTOCONNECT : LayoutEditorEvent.LayoutEditorEventType.TURN_OFF_AUTOCONNECT);
            PropertiesComponent.getInstance().setValue(ConstraintLayoutHandler.AUTO_CONNECT_PREF_KEY, selected, false);
        }

        @Override
        public boolean affectsUndo() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$ToggleAutoConnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Enableable {
        public void enable(List<NlComponent> var1);
    }

    static class DisappearingActionMenu
    extends ViewActionMenu {
        public DisappearingActionMenu(@NotNull String menuName, @Nullable Icon icon, @NotNull List<ViewAction> actions2) {
            if (menuName == null) {
                DisappearingActionMenu.$$$reportNull$$$0(0);
            }
            if (actions2 == null) {
                DisappearingActionMenu.$$$reportNull$$$0(1);
            }
            super(menuName, icon, actions2);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            if (presentation == null) {
                DisappearingActionMenu.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                DisappearingActionMenu.$$$reportNull$$$0(3);
            }
            if (handler == null) {
                DisappearingActionMenu.$$$reportNull$$$0(4);
            }
            if (component == null) {
                DisappearingActionMenu.$$$reportNull$$$0(5);
            }
            if (selectedChildren == null) {
                DisappearingActionMenu.$$$reportNull$$$0(6);
            }
            presentation.setLabel(this.myLabel);
            boolean enable = false;
            for (ViewAction action2 : this.myActions) {
                if (action2 instanceof AlignAction) {
                    AlignAction aa = (AlignAction)action2;
                    if (!aa.isEnabled(selectedChildren)) continue;
                    enable = true;
                    continue;
                }
                enable = true;
            }
            presentation.setVisible(enable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "menuName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChildren";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintLayoutHandler$DisappearingActionMenu";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

