/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class ConstraintReferenceManagement {
    ConstraintReferenceManagement() {
    }

    private static void ensurePresence(@NotNull NlComponent component, @NotNull NlComponent constraints) {
        if (component == null) {
            ConstraintReferenceManagement.$$$reportNull$$$0(0);
        }
        if (constraints == null) {
            ConstraintReferenceManagement.$$$reportNull$$$0(1);
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.isEquals(component.getTagName()) || NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE.isEquals(component.getTagName())) {
            return;
        }
        if (ConstraintReferenceManagement.exists(component, constraints)) {
            return;
        }
        boolean useAndroidx = NlComponentHelperKt.isOrHasAndroidxSuperclass(component);
        component.ensureId();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (constraints == null) {
                ConstraintReferenceManagement.$$$reportNull$$$0(5);
            }
            if (component == null) {
                ConstraintReferenceManagement.$$$reportNull$$$0(6);
            }
            XmlTag parentTag = constraints.getTag();
            XmlTag childTag = parentTag.createChildTag(useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE.oldName(), null, null, false);
            childTag.setAttribute("android:id", "@+id/" + component.getId());
            for (Pair<String, String> pair : ConstraintComponentUtilities.ourLayoutAttributes) {
                String value = component.getLiveAttribute((String)pair.getFirst(), (String)pair.getSecond());
                String prefix = ConstraintComponentUtilities.ourLayoutUriToPrefix.get(pair.getFirst());
                childTag.setAttribute(prefix + (String)pair.getSecond(), value);
            }
            NlModel model = constraints.getModel();
            NlComponent c = model.createComponent(childTag);
            model.addTags(Arrays.asList(c), constraints, null, InsertType.CREATE);
        });
    }

    private static boolean exists(NlComponent component, NlComponent parent) {
        for (NlComponent child : parent.getChildren()) {
            String reference2 = child.getLiveAttribute("http://schemas.android.com/apk/res/android", "id");
            if ((reference2 = NlComponent.extractId(reference2)) == null || !reference2.equals(component.getId())) continue;
            return true;
        }
        return false;
    }

    public static void populateConstraints(@NotNull NlComponent constraints) {
        NlComponent parent;
        if (constraints == null) {
            ConstraintReferenceManagement.$$$reportNull$$$0(2);
        }
        if ((parent = constraints.getParent()) == null) {
            return;
        }
        String attribute = parent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
        if ((attribute = NlComponent.extractId(attribute)) == null) {
            return;
        }
        for (NlComponent child : parent.getChildren()) {
            if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) continue;
            ConstraintReferenceManagement.ensurePresence(child, constraints);
        }
    }

    public static void updateConstraints(@NotNull NlComponent primary, @NotNull Scene scene) {
        SceneComponent component;
        if (primary == null) {
            ConstraintReferenceManagement.$$$reportNull$$$0(3);
        }
        if (scene == null) {
            ConstraintReferenceManagement.$$$reportNull$$$0(4);
        }
        if ((component = scene.getSceneComponent(primary)) == null) {
            return;
        }
        SceneComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        NlComponent nlComponent = parent.getNlComponent();
        String attribute = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraintSet");
        if ((attribute = NlComponent.extractId(attribute)) == null) {
            return;
        }
        NlComponent constraints = null;
        for (SceneComponent sceneComponent : parent.getChildren()) {
            String childId = sceneComponent.getNlComponent().getId();
            if (childId == null || !childId.equals(attribute)) continue;
            constraints = sceneComponent.getNlComponent();
            break;
        }
        if (constraints == null) {
            return;
        }
        for (NlComponent nlComponent2 : nlComponent.getChildren()) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent2, SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) continue;
            ConstraintReferenceManagement.ensurePresence(nlComponent2, constraints);
        }
        ArrayList<NlComponent> toRemove = null;
        for (NlComponent child : constraints.getChildren()) {
            if (ConstraintReferenceManagement.exists(child, nlComponent)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<NlComponent>();
            }
            toRemove.add(child);
        }
        if (toRemove == null) {
            return;
        }
        constraints.getModel().delete(toRemove);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primary";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintReferenceManagement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensurePresence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "populateConstraints";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateConstraints";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$ensurePresence$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

