/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SingleWidgetView
extends JPanel {
    public static final int RATIO_UNLOCK = 0;
    private static final int RATIO_LOCK = 1;
    public static final int RATIO_LOCK_HEIGHT = 2;
    public static final int RATIO_LOCK_WIDTH = 3;
    public static final String TOP_MARGIN_WIDGET = "topMarginWidget";
    public static final String LEFT_MARGIN_WIDGET = "leftMarginWidget";
    public static final String BOTTOM_MARGIN_WIDGET = "bottomMarginWidget";
    public static final String RIGHT_MARGIN_WIDGET = "rightMarginWidget";
    private WidgetConstraintPanel mWidgetConstraintPanel;
    public static final int MATCH_CONSTRAINT = 1;
    public static final int WRAP_CONTENT = 2;
    public static final int FIXED = 0;
    private static final int UNCONNECTED = -1;
    private final ColorSet mColorSet;
    private int mCacheBottom;
    private int mCacheTop;
    private int mCacheLeft;
    private int mCacheRight;
    private boolean mCacheBaseline;
    private int mCacheWidth;
    private int mCacheHeight;
    private String mRatioString;
    private float mDimensionRatio;
    private int mDimensionRatioSide;
    private int mRatioHeight;
    private int mRatioWidth;
    private int mRatioLock;
    private int mWidth;
    private int mHeight;
    private int mBoxSize;
    private WidgetRender mWidgetRender = new WidgetRender();
    private ArrayList<Graphic> mGraphicList = new ArrayList();
    private MarginWidget mTopMargin;
    private MarginWidget mLeftMargin;
    private MarginWidget mRightMargin;
    private MarginWidget mBottomMargin;
    private HConstraintDisplay mHbar1;
    private HConstraintDisplay mHbar2;
    private VConstraintDisplay mVbar1;
    private VConstraintDisplay mVbar2;
    private ConnectButton mTopConnect;
    private ConnectButton mLeftConnect;
    private ConnectButton mRightConnect;
    private ConnectButton mBottomConnect;
    private static final int mConnectRadius = 7;
    private static final int mConnectSize = 15;
    private KillButton mTopKill;
    private KillButton mLeftKill;
    private KillButton mRightKill;
    private KillButton mBottomKill;
    private KillButton mBaselineKill;
    private AspectButton mAspectButton;
    private JLabel mAspectLabel;
    private JTextField mAspectText;
    private String[] statusString = new String[]{"Fixed", "Match Constraints", "Wrap Content"};
    public static final int DROP_DOWN_WIDTH = JBUI.scale((int)55);
    public static final int DROPDOWN_HEIGHT = JBUI.scale((int)25);
    public static final int DROPDOWN_OFFSET = JBUI.scale((int)12);
    private static int[][] ratios = new int[][]{{1, 1}, {4, 3}, {3, 2}, {5, 3}, {16, 9}, {2, 1}, {21, 9}, {5, 2}, {3, 1}, {4, 1}};

    public SingleWidgetView(WidgetConstraintPanel constraintPanel, ColorSet colorSet) {
        super(null);
        this.mColorSet = colorSet;
        this.mTopMargin = new MarginWidget(TOP_MARGIN_WIDGET);
        this.mLeftMargin = new MarginWidget(LEFT_MARGIN_WIDGET);
        this.mRightMargin = new MarginWidget(BOTTOM_MARGIN_WIDGET);
        this.mBottomMargin = new MarginWidget(RIGHT_MARGIN_WIDGET);
        this.mTopMargin.setToolTipText("Top Margin");
        this.mLeftMargin.setToolTipText("Left Margin");
        this.mRightMargin.setToolTipText("Right Margin");
        this.mBottomMargin.setToolTipText("Bottom Margin");
        this.mHbar1 = new HConstraintDisplay(this.mColorSet, true);
        this.mHbar2 = new HConstraintDisplay(this.mColorSet, false);
        this.mVbar1 = new VConstraintDisplay(this.mColorSet, true);
        this.mVbar2 = new VConstraintDisplay(this.mColorSet, false);
        this.mTopKill = new KillButton(this.mColorSet);
        this.mLeftKill = new KillButton(this.mColorSet);
        this.mRightKill = new KillButton(this.mColorSet);
        this.mBottomKill = new KillButton(this.mColorSet);
        this.mBaselineKill = new KillButton(this.mColorSet);
        this.mTopConnect = new ConnectButton(this.mColorSet);
        this.mLeftConnect = new ConnectButton(this.mColorSet);
        this.mRightConnect = new ConnectButton(this.mColorSet);
        this.mBottomConnect = new ConnectButton(this.mColorSet);
        this.mAspectButton = new AspectButton(this.mColorSet);
        this.mAspectText = new JTextField();
        this.mAspectLabel = new JLabel("ratio");
        this.mTopKill.setToolTipText("Delete Top Constraint");
        this.mLeftKill.setToolTipText("Delete Left Constraint");
        this.mRightKill.setName("deleteRightConstraintButton");
        this.mRightKill.setToolTipText("Delete Right Constraint");
        this.mBottomKill.setToolTipText("Delete Bottom Constraint");
        this.mBaselineKill.setToolTipText("Delete Baseline Constraint");
        this.mTopConnect.setToolTipText("Create a connection above");
        this.mLeftConnect.setToolTipText("Create a connection to the left");
        this.mRightConnect.setToolTipText("Create a connection to the right");
        this.mBottomConnect.setToolTipText("Create a connection below");
        this.mAspectButton.setToolTipText("Toggle Aspect Ratio Constraint");
        this.mHbar1.setSister(this.mHbar2);
        this.mHbar2.setSister(this.mHbar1);
        this.mVbar1.setSister(this.mVbar2);
        this.mVbar2.setSister(this.mVbar1);
        this.mWidgetConstraintPanel = constraintPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SingleWidgetView.this.resize();
            }
        });
        this.add((Component)((Object)this.mTopMargin));
        this.add((Component)((Object)this.mLeftMargin));
        this.add((Component)((Object)this.mRightMargin));
        this.add((Component)((Object)this.mBottomMargin));
        this.mTopMargin.addActionListener(e -> this.mWidgetConstraintPanel.setTopMargin(this.mTopMargin.getMargin()));
        this.mLeftMargin.addActionListener(e -> this.mWidgetConstraintPanel.setLeftMargin(this.mLeftMargin.getMargin()));
        this.mRightMargin.addActionListener(e -> this.mWidgetConstraintPanel.setRightMargin(this.mRightMargin.getMargin()));
        this.mBottomMargin.addActionListener(e -> this.mWidgetConstraintPanel.setBottomMargin(this.mBottomMargin.getMargin()));
        this.add(this.mTopKill);
        this.add(this.mLeftKill);
        this.add(this.mRightKill);
        this.add(this.mBottomKill);
        this.add(this.mTopConnect);
        this.add(this.mLeftConnect);
        this.add(this.mRightConnect);
        this.add(this.mBottomConnect);
        this.add(this.mBaselineKill);
        this.add(this.mAspectButton);
        this.add(this.mAspectText);
        this.add(this.mAspectLabel);
        this.add(this.mHbar1);
        this.add(this.mHbar2);
        this.add(this.mVbar1);
        this.add(this.mVbar2);
        this.mTopKill.addActionListener(e -> this.topKill());
        this.mLeftKill.addActionListener(e -> this.leftKill());
        this.mRightKill.addActionListener(e -> this.rightKill());
        this.mBottomKill.addActionListener(e -> this.bottomKill());
        this.mBaselineKill.addActionListener(e -> this.baselineKill());
        this.mTopConnect.addActionListener(e -> this.connectConstraint(Scout.Arrange.ConnectTop));
        this.mLeftConnect.addActionListener(e -> this.connectConstraint(Scout.Arrange.ConnectStart));
        this.mRightConnect.addActionListener(e -> this.connectConstraint(Scout.Arrange.ConnectEnd));
        this.mBottomConnect.addActionListener(e -> this.connectConstraint(Scout.Arrange.ConnectBottom));
        this.mAspectButton.addActionListener(e -> this.toggleAspect());
        this.mAspectText.addActionListener(e -> this.setAspectString());
        this.mAspectText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SingleWidgetView.this.setAspectString();
            }
        });
        this.mHbar1.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar1));
        this.mHbar2.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar2));
        this.mVbar1.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar1));
        this.mVbar2.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar2));
        this.mGraphicList.add(this.mWidgetRender);
    }

    private void setAspectString() {
        String sideRatioString = "";
        if (this.mRatioString != null && this.mRatioString.contains(",")) {
            sideRatioString = this.mRatioString.substring(0, this.mRatioString.indexOf(44) + 1);
        }
        this.mRatioString = sideRatioString + this.mAspectText.getText();
        this.mWidgetConstraintPanel.setAspect(this.mRatioString);
        this.update();
    }

    private static String getRatioPart(String str) {
        if (str == null) {
            return "1:1";
        }
        int index = str.indexOf(44);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    private void toggleAspect() {
        int[] order = new int[4];
        int count = 0;
        order[count++] = 0;
        if (this.mCacheHeight == 1 && this.mCacheWidth == 1) {
            order[count++] = 1;
        }
        if (this.mCacheHeight == 1) {
            order[count++] = 2;
        }
        if (this.mCacheWidth == 1) {
            order[count++] = 3;
        }
        int lock = 0;
        for (int i = 0; i < count; ++i) {
            if (this.mRatioLock != order[i]) continue;
            lock = order[(i + 1) % count];
            break;
        }
        this.mRatioLock = lock;
        switch (this.mRatioLock) {
            case 3: {
                this.mRatioString = "w," + SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 1: {
                this.mRatioString = SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 2: {
                this.mRatioString = "h," + SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 0: {
                this.mRatioString = null;
            }
        }
        this.mWidgetConstraintPanel.setAspect(this.mRatioString);
        this.update();
    }

    private void setHorizontalState(HConstraintDisplay state) {
        if (state == this.mHbar1) {
            this.mHbar2.setState(state.getState());
        } else {
            this.mHbar1.setState(state.getState());
        }
        this.updateTriangle();
        this.mHbar1.setToolTipText(this.statusString[state.getState()]);
        this.mHbar2.setToolTipText(this.statusString[state.getState()]);
        this.mWidgetConstraintPanel.setHorizontalConstraint(state.getState());
    }

    private void setVerticalState(VConstraintDisplay state) {
        if (state == this.mVbar1) {
            this.mVbar2.setState(state.getState());
        } else {
            this.mVbar1.setState(state.getState());
        }
        this.updateTriangle();
        this.mVbar1.setToolTipText(this.statusString[state.getState()]);
        this.mVbar2.setToolTipText(this.statusString[state.getState()]);
        this.mWidgetConstraintPanel.setVerticalConstraint(state.getState());
    }

    private void updateTriangle() {
        boolean show = this.mVbar1.getState() == 1 || this.mHbar1.getState() == 1;
        this.mWidgetRender.mAspectLock.setShowTriangle(show);
    }

    private void topKill() {
        this.mWidgetConstraintPanel.killTopConstraint();
        this.mCacheTop = -1;
        this.update();
    }

    private void leftKill() {
        this.mWidgetConstraintPanel.killLeftConstraint();
        this.mCacheLeft = -1;
        this.update();
    }

    private void rightKill() {
        this.mWidgetConstraintPanel.killRightConstraint();
        this.mCacheRight = -1;
        this.update();
    }

    private void bottomKill() {
        this.mWidgetConstraintPanel.killBottomConstraint();
        this.mCacheBottom = -1;
        this.update();
    }

    private void baselineKill() {
        this.mWidgetConstraintPanel.killBaselineConstraint();
        this.mCacheBaseline = false;
        this.update();
    }

    private void connectConstraint(Scout.Arrange bottom) {
        NlComponent component = this.mWidgetConstraintPanel.mComponent;
        if (component != null) {
            component.clearTransaction();
            Scout.arrangeWidgets(bottom, Collections.singletonList(component), false);
            ComponentModification modification = new ComponentModification(component, "Connect Constraint");
            component.startAttributeTransaction().applyToModification(modification);
            modification.commit();
        }
    }

    static int baselinePos(int height) {
        return 9 * height / 10;
    }

    private void resize() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.mBoxSize = Math.min(this.mWidth, this.mHeight) / 2 - DROPDOWN_OFFSET - 8;
        int boxLeft = (this.mWidth - this.mBoxSize) / 2;
        int boxTop = (this.mHeight - this.mBoxSize) / 2;
        int boxRight = boxLeft + this.mBoxSize;
        this.mWidgetRender.build(boxLeft, boxTop, this.mBoxSize);
        this.mTopMargin.setBounds(this.mWidth / 2 - DROP_DOWN_WIDTH / 2, boxTop - DROPDOWN_OFFSET - DROPDOWN_HEIGHT, DROP_DOWN_WIDTH, DROPDOWN_HEIGHT);
        this.mLeftMargin.setBounds(boxLeft - DROPDOWN_OFFSET - DROP_DOWN_WIDTH, (this.mHeight - DROPDOWN_HEIGHT) / 2, DROP_DOWN_WIDTH, DROPDOWN_HEIGHT);
        this.mRightMargin.setBounds(boxRight + DROPDOWN_OFFSET, (this.mHeight - DROPDOWN_HEIGHT) / 2, DROP_DOWN_WIDTH, DROPDOWN_HEIGHT);
        this.mBottomMargin.setBounds(this.mWidth / 2 - DROP_DOWN_WIDTH / 2, boxTop + this.mBoxSize + DROPDOWN_OFFSET, DROP_DOWN_WIDTH, DROPDOWN_HEIGHT);
        int rad = KillButton.sCircleRadius;
        int size = rad * 2;
        int centerX = boxLeft + this.mBoxSize / 2;
        int centerY = boxTop + this.mBoxSize / 2;
        this.mTopKill.setBounds(centerX - rad, boxTop - rad, size, size);
        this.mLeftKill.setBounds(boxLeft - rad, centerY - rad, size, size);
        this.mRightKill.setBounds(boxRight - rad, centerY - rad, size, size);
        this.mBottomKill.setBounds(centerX - rad, boxTop + this.mBoxSize - rad, size, size);
        this.mBaselineKill.setBounds(centerX - rad, boxTop + SingleWidgetView.baselinePos(this.mBoxSize) - rad, size, size);
        rad = 7;
        size = 15;
        this.mTopConnect.setBounds(centerX - rad, boxTop - size - DROPDOWN_OFFSET, size, size);
        this.mLeftConnect.setBounds(boxLeft - size - DROPDOWN_OFFSET, centerY - rad, size, size);
        this.mRightConnect.setBounds(boxRight + size, centerY - rad, size, size);
        this.mBottomConnect.setBounds(centerX - rad, boxTop + this.mBoxSize + DROPDOWN_OFFSET, size, size);
        this.mAspectButton.setBounds(boxLeft, boxTop, this.mBoxSize / 6, this.mBoxSize / 6);
        int tmpx = boxRight + 4;
        int tmpy = boxTop + this.mBoxSize + DROPDOWN_OFFSET;
        this.mAspectText.setBounds(boxRight + DROPDOWN_OFFSET, tmpy, Math.min(70, this.mWidth - tmpx), this.mAspectText.getPreferredSize().height);
        Dimension labelSize = this.mAspectLabel.getPreferredSize();
        this.mAspectLabel.setBounds(boxRight + DROPDOWN_OFFSET, tmpy - labelSize.height, labelSize.width, labelSize.height);
        int barMargin = rad + 2;
        int middleSpace = 8;
        int barSize = 9;
        int barLong = this.mBoxSize / 2 - barMargin - middleSpace;
        centerY = boxTop + (this.mBoxSize - barSize) / 2;
        centerX = boxLeft + (this.mBoxSize - barSize) / 2;
        this.mHbar1.setBounds(boxLeft + barMargin, centerY, barLong, barSize);
        this.mHbar2.setBounds(boxRight - barLong - barMargin, centerY, barLong, barSize);
        this.mVbar1.setBounds(centerX, boxTop + barMargin, barSize, barLong);
        if (this.mCacheBaseline) {
            int top = boxTop + this.mBoxSize / 2 + barSize;
            int height = boxTop + SingleWidgetView.baselinePos(this.mBoxSize) - top - 2;
            this.mVbar2.setBounds(centerX, top, barSize + 1, height);
        } else {
            this.mVbar2.setBounds(centerX, boxTop + this.mBoxSize - barMargin - barLong, barSize, barLong);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mWidth != this.getWidth() || this.mHeight != this.getHeight()) {
            this.resize();
        }
        Graphics2D g2d = (Graphics2D)g;
        boolean redraw = false;
        for (Graphic graphic : this.mGraphicList) {
            redraw |= graphic.paint(g2d, this.mColorSet);
        }
        if (redraw) {
            this.repaint();
        }
    }

    private void update() {
        this.configureUi(this.mCacheBottom, this.mCacheTop, this.mCacheLeft, this.mCacheRight, this.mCacheBaseline, this.mCacheWidth, this.mCacheHeight, this.mRatioString);
    }

    public void configureUi(int bottom, int top, int left, int right, boolean baseline, int width, int height, String ratioString) {
        int[] split;
        this.mRatioString = ratioString;
        this.parseDimensionRatio(ratioString);
        String aspectText = "";
        if (ratioString != null) {
            if (ratioString.contains(",")) {
                aspectText = ratioString.substring(ratioString.indexOf(44) + 1);
                this.mRatioLock = Character.toLowerCase(ratioString.charAt(0)) == 'w' ? 3 : 2;
            } else {
                aspectText = ratioString;
                this.mRatioLock = 1;
            }
        } else {
            this.mRatioLock = 0;
        }
        if (this.mRatioHeight == -1 && this.mDimensionRatio > 0.0f && (split = SingleWidgetView.splitRatio(this.mDimensionRatio)) != null) {
            this.mRatioWidth = split[1];
            this.mRatioHeight = split[0];
        }
        this.mAspectText.setText(aspectText);
        this.configureUi(bottom, top, left, right, baseline, width, height);
    }

    private void configureUi(int bottom, int top, int left, int right, boolean baseline, int width, int height) {
        this.mCacheBottom = bottom;
        this.mCacheTop = top;
        this.mCacheLeft = left;
        this.mCacheRight = right;
        this.mCacheBaseline = baseline;
        this.mCacheWidth = width;
        this.mCacheHeight = height;
        this.mTopMargin.setVisible(top != -1);
        this.mLeftMargin.setVisible(left != -1);
        this.mRightMargin.setVisible(right != -1);
        this.mBottomMargin.setVisible(bottom != -1);
        this.mTopMargin.setMargin(top);
        this.mLeftMargin.setMargin(left);
        this.mRightMargin.setMargin(right);
        this.mBottomMargin.setMargin(bottom);
        this.mWidgetRender.setConstraints(left, top, right, bottom);
        this.mWidgetRender.mBaseline = baseline;
        this.mTopKill.setVisible(top != -1);
        this.mLeftKill.setVisible(left != -1);
        this.mRightKill.setVisible(right != -1);
        this.mBottomKill.setVisible(bottom != -1);
        this.mTopConnect.setVisible(top == -1);
        this.mLeftConnect.setVisible(left == -1);
        this.mRightConnect.setVisible(right == -1);
        this.mBottomConnect.setVisible(bottom == -1);
        this.mBaselineKill.setVisible(baseline);
        this.mAspectButton.setVisible(true);
        this.mAspectText.setVisible(this.mRatioString != null);
        this.mAspectLabel.setVisible(this.mRatioString != null);
        this.mHbar1.setState(width);
        this.mHbar2.setState(width);
        this.mVbar1.setState(height);
        this.mVbar2.setState(height);
        this.mHbar1.setVisible(this.mDimensionRatioSide != 0);
        this.mHbar2.setVisible(this.mDimensionRatioSide != 0);
        this.mVbar1.setVisible(this.mDimensionRatioSide != 1);
        this.mVbar2.setVisible(this.mDimensionRatioSide != 1);
        this.mVbar1.setToolTipText(this.statusString[height]);
        this.mVbar2.setToolTipText(this.statusString[height]);
        this.mHbar1.setToolTipText(this.statusString[width]);
        this.mHbar2.setToolTipText(this.statusString[width]);
        this.resize();
        this.repaint();
    }

    private void parseDimensionRatio(String ratio) {
        this.mRatioHeight = -1;
        this.mRatioWidth = -1;
        if (ratio == null || ratio.isEmpty()) {
            this.mDimensionRatio = 0.0f;
            this.mDimensionRatioSide = -1;
            return;
        }
        int dimensionRatioSide = -1;
        float dimensionRatio = 0.0f;
        int len = ratio.length();
        int commaIndex = ratio.indexOf(44);
        if (commaIndex > 0 && commaIndex < len - 1) {
            String dimension2 = ratio.substring(0, commaIndex);
            if (dimension2.equalsIgnoreCase("W")) {
                dimensionRatioSide = 0;
            } else if (dimension2.equalsIgnoreCase("H")) {
                dimensionRatioSide = 1;
            }
            ++commaIndex;
        } else {
            commaIndex = 0;
        }
        int colonIndex = ratio.indexOf(58);
        if (colonIndex >= 0 && colonIndex < len - 1) {
            String nominator = ratio.substring(commaIndex, colonIndex);
            String denominator = ratio.substring(colonIndex + 1);
            if (!nominator.isEmpty() && !denominator.isEmpty()) {
                try {
                    float nominatorValue = Float.parseFloat(nominator);
                    float denominatorValue = Float.parseFloat(denominator);
                    dimensionRatio = Math.abs(nominatorValue / denominatorValue);
                    this.mRatioHeight = (int)nominatorValue;
                    this.mRatioWidth = (int)denominatorValue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            String r = ratio.substring(commaIndex);
            if (!r.isEmpty()) {
                try {
                    dimensionRatio = Float.parseFloat(r);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (dimensionRatio > 0.0f) {
            this.mDimensionRatio = dimensionRatio;
            this.mDimensionRatioSide = dimensionRatioSide;
        }
    }

    private static int[] splitRatio(float ratio) {
        if (ratio >= 1.0f) {
            for (int[] r : ratios) {
                if (!((float)r[0] / (float)r[1] >= ratio)) continue;
                return r;
            }
        } else {
            for (int[] r : ratios) {
                if (!((float)r[1] / (float)r[0] <= ratio)) continue;
                return r;
            }
        }
        return null;
    }

    private static void drawCircle(Graphics2D g, int x, int y, boolean fill2) {
        if (fill2) {
            g.fillRoundRect(x - 5, y - 5, 10, 10, 10, 10);
        } else {
            g.drawRoundRect(x - 5, y - 5, 10, 10, 10, 10);
        }
    }

    static {
        Arrays.sort(ratios, (a, b) -> Float.compare((float)a[0] / (float)a[1], (float)b[0] / (float)b[1]));
    }

    static class VConstraintDisplay
    extends TriStateControl {
        boolean mDirection;

        VConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
            this.setPreferredSize(new Dimension(30, 200));
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 0;
            int pos = width / 2;
            switch (this.mState) {
                case 0: {
                    VConstraintDisplay.drawFixedVerticalConstraint(g, start, pos, height);
                    break;
                }
                case 1: {
                    VConstraintDisplay.drawSpringVerticalConstraint(g, start, pos, height);
                    break;
                }
                case 2: {
                    VConstraintDisplay.drawWrapVerticalConstraint(g, start, pos, height, this.mDirection);
                }
            }
        }

        private static void drawSpringVerticalConstraint(Graphics g, int t, int x, int b) {
            int m = 4;
            int d = 3;
            int h = b - t;
            int ni = h / (2 * d) - 1;
            int margin = (h - ni * 2 * d) / 2;
            g.drawLine(x - m, t, x + m, t);
            g.drawLine(x, t, x, t + margin);
            for (int i = t + margin; i <= b - margin - 2 * d; i += 2 * d) {
                g.drawLine(x, i, x + d, i + d);
                g.drawLine(x + d, i + d, x - d, i + d);
                g.drawLine(x - d, i + d, x, i + 2 * d);
            }
            g.drawLine(x, b - margin, x, b);
            g.drawLine(x - m, b, x + m, b);
        }

        private static void drawFixedVerticalConstraint(Graphics g, int t, int x, int b) {
            int m = 2;
            g.drawLine(x - m, t, x + m, t);
            g.drawLine(x, t, x, b);
            g.drawLine(x - m, b, x + m, b);
        }

        private static void drawWrapVerticalConstraint(Graphics g, int t, int x, int b, boolean topToBottom) {
            int d = 3;
            int spacing = d + 3;
            if (topToBottom) {
                for (int y = t; y <= b - d; y += spacing) {
                    g.drawLine(x - d, y, x, y + d);
                    g.drawLine(x + d, y, x, y + d);
                }
            } else {
                for (int y = b; y >= t + d; y -= spacing) {
                    g.drawLine(x - d, y, x, y - d);
                    g.drawLine(x + d, y, x, y - d);
                }
            }
        }
    }

    static class HConstraintDisplay
    extends TriStateControl {
        boolean mDirection;

        HConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
            this.setPreferredSize(new Dimension(200, 30));
        }

        @Override
        void resize() {
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 0;
            int pos = height / 2;
            switch (this.mState) {
                case 0: {
                    HConstraintDisplay.drawFixedHorizontalConstraint(g, start, pos, width);
                    break;
                }
                case 1: {
                    HConstraintDisplay.drawSpringHorizontalConstraint(g, start, pos, width);
                    break;
                }
                case 2: {
                    HConstraintDisplay.drawWrapHorizontalConstraint(g, start, pos, width, this.mDirection);
                }
            }
        }

        private static void drawSpringHorizontalConstraint(Graphics g, int l, int y, int r) {
            int m = 7;
            int d = 3;
            int w = r - l;
            int ni = w / (2 * d) - 1;
            int margin = (w - ni * 2 * d) / 2;
            g.drawLine(l, y - m, l, y + m);
            g.drawLine(l, y, l + margin, y);
            for (int i = l + margin; i <= r - margin - 2 * d; i += 2 * d) {
                g.drawLine(i, y, i + d, y - d);
                g.drawLine(i + d, y - d, i + d, y + d);
                g.drawLine(i + d, y + d, i + 2 * d, y);
            }
            g.drawLine(r - margin, y, r, y);
            g.drawLine(r, y - m, r, y + m);
        }

        private static void drawWrapHorizontalConstraint(Graphics g, int l, int y, int r, boolean directionLeftToRight) {
            int d = 3;
            int spacing = d + 3;
            Graphics2D g2 = (Graphics2D)g;
            if (directionLeftToRight) {
                for (int x = l; x <= r - d; x += spacing) {
                    g2.drawLine(x, y - d, x + d, y);
                    g2.drawLine(x + d, y, x, y + d);
                }
            } else {
                for (int x = r; x >= l + d; x -= spacing) {
                    g2.drawLine(x, y - d, x - d, y);
                    g2.drawLine(x - d, y, x, y + d);
                }
            }
        }

        private static void drawFixedHorizontalConstraint(Graphics g, int l, int y, int r) {
            int m = 2;
            g.drawLine(l, y - m, l, y + m);
            g.drawLine(l, y, r, y);
            g.drawLine(r, y - m, r, y + m);
        }
    }

    static class TriStateControl
    extends JComponent {
        boolean mMouseIn;
        int mState;
        Color mBackground;
        Color mLineColor;
        Color mMouseOverColor;
        TriStateControl mSisterControl;
        public static final String STATE = "state";

        TriStateControl(ColorSet colorSet) {
            this.mBackground = colorSet.getInspectorFillColor();
            this.mLineColor = colorSet.getInspectorStrokeColor();
            this.mMouseOverColor = colorSet.getInspectorConstraintColor();
            this.setPreferredSize(new Dimension(200, 30));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int oldValue = mState;
                    mState = (mState + 1) % 3;
                    this.firePropertyChange(TriStateControl.STATE, oldValue, mState);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mMouseIn = false;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = mMouseIn;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    mMouseIn = true;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = mMouseIn;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.resize();
                }
            });
        }

        public void setSister(TriStateControl sister) {
            this.mSisterControl = sister;
        }

        public int getState() {
            return this.mState;
        }

        public void setState(int state) {
            this.mState = state;
            this.repaint();
        }

        void resize() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth() - 1;
            int height = this.getHeight() - 1;
            g.setColor(this.mBackground);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.mMouseIn ? this.mMouseOverColor : this.mLineColor);
            this.drawState(g, width, height);
        }

        void drawState(Graphics g, int width, int height) {
        }
    }

    class WidgetRender
    implements Graphic {
        int mMarginLeft;
        int mMarginTop;
        int mMarginRight;
        int mMarginBottom;
        boolean mBaseline;
        Box mWidgetCenter;
        Line mTopArrow;
        Line mLeftArrow;
        Line mRightArrow;
        Line mBottomArrow;
        LineArrow mBaselineArrow;
        AspectLock mAspectLock;

        WidgetRender() {
        }

        void setConstraints(int left, int top, int right, int bottom) {
            this.mMarginTop = top;
            this.mMarginLeft = left;
            this.mMarginRight = right;
            this.mMarginBottom = bottom;
        }

        public void build(int boxLeft, int boxTop, int boxSize) {
            this.mWidgetCenter = new BaseLineBox(null, boxLeft, boxTop, boxSize, boxSize, this.mBaseline, true);
            this.mAspectLock = new AspectLock(boxLeft, boxTop, boxSize, boxSize, SingleWidgetView.this.mRatioLock, SingleWidgetView.this.mRatioWidth, SingleWidgetView.this.mRatioHeight);
            int baseArrowX = boxLeft + boxSize / 2;
            this.mBaselineArrow = new LineArrow(baseArrowX, boxTop + SingleWidgetView.baselinePos(boxSize), baseArrowX, boxTop + boxSize / 2, this.mBaseline);
            int centerY = boxTop + boxSize / 2;
            int centerX = boxLeft + boxSize / 2;
            this.mTopArrow = new Line(centerX, boxTop, centerX, boxTop - DROPDOWN_OFFSET, this.mMarginTop >= 0);
            this.mLeftArrow = new Line(boxLeft, centerY, boxLeft - DROPDOWN_OFFSET, centerY, this.mMarginLeft >= 0);
            this.mRightArrow = new Line(boxLeft + boxSize, centerY, boxLeft + boxSize + DROPDOWN_OFFSET, centerY, this.mMarginRight >= 0);
            this.mBottomArrow = new Line(centerX, boxTop + boxSize, centerX, boxTop + boxSize + DROPDOWN_OFFSET, this.mMarginBottom >= 0);
            SingleWidgetView.this.updateTriangle();
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorBackgroundColor());
            g.fillRect(0, 0, SingleWidgetView.this.getWidth(), SingleWidgetView.this.getHeight());
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorStrokeColor());
            this.mWidgetCenter.paint(g, colorSet);
            this.mAspectLock.paint(g, colorSet);
            this.mTopArrow.paint(g, colorSet);
            this.mLeftArrow.paint(g, colorSet);
            this.mRightArrow.paint(g, colorSet);
            this.mBottomArrow.paint(g, colorSet);
            this.mBaselineArrow.paint(g, colorSet);
            return false;
        }
    }

    static class LineArrow
    implements Graphic {
        int mX1;
        int mY1;
        int mX2;
        int mY2;
        boolean mDisplay;
        int[] mXArrow = new int[3];
        int[] mYArrow = new int[3];

        LineArrow(int x1, int y1, int x2, int y2, boolean display2) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display2;
            this.mXArrow[0] = x2;
            this.mYArrow[0] = y2;
            this.mXArrow[1] = x2 - 3;
            this.mYArrow[1] = y2 - 5;
            this.mXArrow[2] = x2 + 3;
            this.mYArrow[2] = y2 - 5;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2 - 2);
                g.fillPolygon(this.mXArrow, this.mYArrow, 3);
                SingleWidgetView.drawCircle(g, this.mX1, this.mY1, this.mDisplay);
            }
            return false;
        }
    }

    static class Line
    implements Graphic {
        int mX1;
        int mY1;
        int mX2;
        int mY2;
        boolean mDisplay;
        static final float[] dash1 = new float[]{1.0f, 3.0f};
        private static final Stroke sDashStroke = new BasicStroke(1.0f, 0, 0, 2.0f, dash1, 0.0f);

        Line(int x1, int y1, int x2, int y2, boolean display2) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display2;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                SingleWidgetView.drawCircle(g, this.mX1, this.mY1, this.mDisplay);
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
            } else {
                Stroke stroke = g.getStroke();
                g.setStroke(sDashStroke);
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
                g.setStroke(stroke);
            }
            return false;
        }
    }

    static class AspectLock
    implements Graphic {
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        int mLock;
        private int mRatioHeight;
        private int mRatioWidth;
        int[] mXPoints = new int[3];
        int[] mYPoints = new int[3];
        BasicStroke mStroke = new BasicStroke(2.0f);
        private boolean mShowTriangle;

        AspectLock(int x, int y, int w, int h, int lock, int ratioWidth, int ratioHeight) {
            this.mX = x;
            this.mY = y;
            this.mHeight = h;
            this.mWidth = w;
            this.mLock = lock;
            this.mXPoints[0] = this.mX;
            this.mYPoints[0] = this.mY;
            this.mXPoints[1] = this.mX + this.mWidth / 6;
            this.mYPoints[1] = this.mY;
            this.mXPoints[2] = this.mX;
            this.mYPoints[2] = this.mY + this.mHeight / 6;
            this.mRatioHeight = ratioHeight;
            this.mRatioWidth = ratioWidth;
        }

        public void setShowTriangle(boolean show) {
            this.mShowTriangle = show;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            Rectangle2D bounds;
            String str;
            if (this.mShowTriangle) {
                g.setColor(colorSet.getInspectorHighlightsStrokeColor());
                g.drawPolygon(this.mXPoints, this.mYPoints, 3);
            }
            if (this.mLock == 0) {
                return false;
            }
            g.setColor(colorSet.getInspectorStrokeColor());
            g.fillPolygon(this.mXPoints, this.mYPoints, 3);
            FontMetrics fm = g.getFontMetrics();
            if (this.mRatioHeight != -1) {
                str = Integer.toString(this.mRatioHeight);
                bounds = fm.getStringBounds(str, g);
                g.drawString(str, this.mX + this.mWidth / 12 - (int)(bounds.getWidth() / 2.0), this.mY - fm.getDescent());
            }
            if (this.mRatioWidth != -1) {
                str = Integer.toString(this.mRatioWidth);
                bounds = fm.getStringBounds(str, g);
                g.drawString(str, this.mX - (int)bounds.getWidth() - 2, this.mY + fm.getAscent());
            }
            Stroke prevStroke = g.getStroke();
            g.setStroke(this.mStroke);
            if (this.mLock == 3) {
                g.drawLine(this.mX, this.mY + 1, this.mX, this.mY + this.mHeight - 1);
                g.drawLine(this.mX + this.mWidth, this.mY + 1, this.mX + this.mWidth, this.mY + this.mHeight - 1);
                g.drawLine(this.mX + 1, this.mY + this.mHeight / 2, this.mX + this.mWidth - 1, this.mY + this.mHeight / 2);
            } else if (this.mLock == 2) {
                g.drawLine(this.mX + 1, this.mY, this.mX + this.mWidth - 1, this.mY);
                g.drawLine(this.mX + 1, this.mY + this.mHeight, this.mX + this.mWidth - 1, this.mY + this.mHeight);
                g.drawLine(this.mX + this.mWidth / 2, this.mY + 1, this.mX + this.mWidth / 2, this.mY + this.mHeight - 1);
            }
            g.setStroke(prevStroke);
            return false;
        }
    }

    static class BaseLineBox
    extends Box {
        String mTitle = null;
        boolean mBaseline;
        boolean mDisplay;

        BaseLineBox(String title, int x, int y, int w, int h, boolean baseline, boolean display2) {
            super(x, y, w, h, display2 ? 15 : 0, true);
            this.mTitle = title;
            this.mBaseline = baseline;
            this.mDisplay = display2;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                Stroke defaultStroke = g.getStroke();
                g.setColor(colorSet.getInspectorFillColor());
                g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
                g.setColor(colorSet.getInspectorStrokeColor());
                if (this.mBaseline) {
                    g.drawLine(this.mX, this.mY, this.mX, this.mY + this.mWidth);
                    g.drawLine(this.mX + this.mWidth, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
                    int y = this.mY + SingleWidgetView.baselinePos(this.mHeight);
                    g.setStroke(defaultStroke);
                    g.drawLine(this.mX, y, this.mX + this.mWidth, y);
                } else {
                    g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
                }
                if (this.mTitle != null) {
                    int decent = g.getFontMetrics().getDescent();
                    g.drawString(this.mTitle, this.mX + 2, this.mY + this.mHeight - decent);
                }
            }
            return false;
        }
    }

    static class Box
    implements Graphic {
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        int mEdges;
        public static final int TOP = 1;
        public static final int BOTTOM = 2;
        public static final int LEFT = 4;
        public static final int RIGHT = 8;
        public static final int ALL = 15;
        public boolean mDisplay;

        Box(int x, int y, int w, int h, int edges, boolean display2) {
            this.mX = x;
            this.mY = y;
            this.mHeight = h;
            this.mWidth = w;
            this.mEdges = edges;
            this.mDisplay = display2;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mEdges == 0 || !this.mDisplay) {
                return false;
            }
            g.setColor(colorSet.getInspectorFillColor());
            g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
            g.setColor(colorSet.getInspectorStrokeColor());
            if (this.mEdges == 15) {
                g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
            } else {
                if ((this.mEdges & 1) != 0) {
                    g.setColor(colorSet.getInspectorConstraintColor());
                    g.drawLine(this.mX, this.mY, this.mX + this.mWidth, this.mY);
                }
                if ((this.mEdges & 2) != 0) {
                    g.setColor(colorSet.getInspectorConstraintColor());
                    g.drawLine(this.mX, this.mY + this.mHeight, this.mX + this.mWidth, this.mY + this.mHeight);
                }
                if ((this.mEdges & 4) != 0) {
                    g.setColor(colorSet.getInspectorConstraintColor());
                    g.drawLine(this.mX, this.mY, this.mX, this.mY + this.mWidth);
                }
                if ((this.mEdges & 8) != 0) {
                    g.setColor(colorSet.getInspectorConstraintColor());
                    g.drawLine(this.mX + this.mWidth, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
                }
            }
            return false;
        }
    }

    static interface Graphic {
        public boolean paint(Graphics2D var1, ColorSet var2);
    }

    public static class KillButton
    extends JComponent {
        boolean mMouseIn;
        boolean mShow = true;
        ColorSet mColorSet;
        public static int sCircleRadius = 5;
        private ActionListener mListener;
        static Dimension size = new Dimension(sCircleRadius * 2, sCircleRadius * 2);
        Icon icon = new Icon(){
            private final BasicStroke myStroke = new BasicStroke(1.0f);

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor((Color)JBColor.BLUE);
                if (mMouseIn) {
                    this.drawCircle((Graphics2D)g, x + sCircleRadius, y + sCircleRadius, sCircleRadius);
                }
            }

            private void drawCircle(Graphics2D g, int x, int y, int radius) {
                g.setColor(mColorSet.getInspectorConstraintColor());
                g.drawRoundRect(x - radius, y - radius, radius * 2, radius * 2, radius * 2, radius * 2);
                g.fillRoundRect(x - radius, y - radius, radius * 2, radius * 2, radius * 2, radius * 2);
                g.setColor(mColorSet.getInspectorBackgroundColor());
                g.setStroke(this.myStroke);
                g.drawLine(x - 4, y - 4, x + 4, y + 4);
                g.drawLine(x - 4, y + 4, x + 4, y - 4);
            }

            @Override
            public int getIconWidth() {
                return sCircleRadius * 2 + 2;
            }

            @Override
            public int getIconHeight() {
                return sCircleRadius * 2;
            }
        };

        @Override
        public void paint(Graphics g) {
            if (this.mMouseIn && this.mShow) {
                this.icon.paintIcon(this, g, 0, 0);
            }
        }

        public void setShown(boolean show) {
            this.mShow = show;
        }

        public KillButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.setPreferredSize(size);
            this.setSize(size);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }
    }

    static class ConnectButton
    extends JComponent {
        boolean mMouseIn;
        boolean mShow = true;
        ColorSet mColorSet;
        public static int sCircleRadius = 5;
        static Dimension size = new Dimension(sCircleRadius * 2, sCircleRadius * 2);
        private ActionListener mListener;

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }

        public void setShown(boolean show) {
            this.mShow = show;
        }

        public ConnectButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.setPreferredSize(size);
            this.setSize(size);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            StudioIcons.LayoutEditor.Properties.ADD_CONNECTION.paintIcon(this, g, 0, 0);
        }
    }

    static class AspectButton
    extends JComponent {
        boolean mMouseIn;
        boolean mShow = true;
        ColorSet mColorSet;
        Color mColor;
        int[] mXPoints = new int[3];
        int[] mYPoints = new int[3];
        public static int sCircleRadius = 5;
        private ActionListener mListener;
        static Dimension size = new Dimension(sCircleRadius * 2, sCircleRadius * 2);
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor((Color)JBColor.BLUE);
                mXPoints[0] = 1;
                mYPoints[0] = 1;
                mXPoints[1] = this.getIconWidth();
                mYPoints[1] = 1;
                mXPoints[2] = 1;
                mYPoints[2] = this.getIconHeight();
                if (mMouseIn) {
                    g.setColor(mColor);
                    g.fillPolygon(mXPoints, mYPoints, 3);
                }
            }

            @Override
            public int getIconWidth() {
                return this.getWidth();
            }

            @Override
            public int getIconHeight() {
                return this.getHeight();
            }
        };

        @Override
        public void paint(Graphics g) {
            if (this.mMouseIn && this.mShow) {
                this.icon.paintIcon(this, g, 0, 0);
            }
        }

        public void setShown(boolean show) {
            this.mShow = show;
        }

        public AspectButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.mColor = new Color(this.mColorSet.getInspectorFillColor().getRGB() & 0x88FFFFFF, true);
            this.setPreferredSize(size);
            this.setSize(size);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }
    }
}

