/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetConstraintPanel
extends AdtSecondaryPanel
implements CustomPanel {
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    private static final Color mSliderColor = new JBColor(0xC9C9C9, 2369063);
    @NotNull
    private final SingleWidgetView mMain;
    private final JSlider mVerticalSlider;
    private final JSlider mHorizontalSlider;
    private boolean mConfiguringUI;
    @Nullable
    NlComponent mComponent;
    private static final int UNCONNECTED = -1;
    private ComponentModification myModification;
    private static final int SLIDER_DEFAULT = 50;
    public static final String VERTICAL_BIAS_SLIDER = "verticalBiasSlider";
    public static final String HORIZONTAL_BIAS_SLIDER = "horizontalBiasSlider";
    private static final int DELAY_BEFORE_COMMIT = 400;
    @Nullable
    private final Timer myTimer;
    @NotNull
    private final ChangeListener myChangeLiveListener;
    @NotNull
    MouseListener mDoubleClickListener;
    private static final int CONNECTION_LEFT = 0;
    private static final int CONNECTION_RIGHT = 1;
    private static final int CONNECTION_TOP = 2;
    private static final int CONNECTION_BOTTOM = 3;
    private static final int CONNECTION_BASELINE = 4;
    private static final String[][] ourConstraintString_ltr = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourConstraintString_rtl = new String[][]{{"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourMarginString_ltr = new String[][]{{"layout_marginLeft", "layout_marginStart"}, {"layout_marginRight", "layout_marginEnd"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourMarginString_rtl = new String[][]{{"layout_marginLeft", "layout_marginEnd"}, {"layout_marginRight", "layout_marginStart"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] ourDeleteAttributes = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static final String[][] ourDeleteNamespace = new String[][]{{"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto"}};
    public static final int UNKNOWN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public void setAspect(String aspect) {
        this.setSherpaAttribute("layout_constraintDimensionRatio", aspect);
    }

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new GridBagLayout());
        this.mVerticalSlider = new JSlider(1);
        this.mHorizontalSlider = new JSlider(0);
        this.mConfiguringUI = false;
        this.myTimer = new Timer(400, c -> {
            if (this.myModification != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WidgetConstraintPanel.this.myModification.commit();
                        WidgetConstraintPanel.this.myModification = null;
                    }
                });
            }
        });
        this.myChangeLiveListener = e -> this.configureUI();
        this.mDoubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ((JSlider)e.getSource()).setValue(50);
                }
            }
        };
        this.setBorder((Border)JBUI.Borders.empty((int)18, (int)0, (int)0, (int)18));
        InspectorColorSet colorSet = new InspectorColorSet();
        this.mMain = new SingleWidgetView(this, colorSet);
        this.setPreferredSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)216)));
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setName(VERTICAL_BIAS_SLIDER);
        this.mHorizontalSlider.setName(HORIZONTAL_BIAS_SLIDER);
        this.updateComponent(components.isEmpty() ? null : components.get(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.add(this.mVerticalSlider, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        this.add(this.mMain, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add(this.mHorizontalSlider, gbc);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, colorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, colorSet));
        this.mHorizontalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mVerticalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mHorizontalSlider.setForeground(mSliderColor);
        this.mVerticalSlider.setForeground(mSliderColor);
        this.mHorizontalSlider.addChangeListener(e -> this.setHorizontalBias());
        this.mVerticalSlider.addChangeListener(e -> this.setVerticalBias());
        this.mHorizontalSlider.addMouseListener(this.mDoubleClickListener);
        this.mVerticalSlider.addMouseListener(this.mDoubleClickListener);
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        WidgetConstraintPanel widgetConstraintPanel = this;
        if (widgetConstraintPanel == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(1);
        }
        return widgetConstraintPanel;
    }

    @Override
    public void useComponent(@Nullable NlComponent component) {
        this.updateComponent(component);
    }

    @Override
    public void refresh() {
        this.configureUI();
    }

    private int getMargin(int type) {
        if (this.mComponent == null) {
            return 0;
        }
        boolean rtl = ConstraintUtilities.isInRTL(this.mComponent);
        String[][] marginsAttr = rtl ? ourMarginString_rtl : ourMarginString_ltr;
        String marginString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][0]);
        for (int i = 1; marginString == null && marginsAttr[type].length > i; ++i) {
            marginString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][i]);
        }
        int margin = 0;
        if (marginString != null) {
            margin = ConstraintUtilities.getDpValue(this.mComponent, marginString);
        }
        String[][] ourConstraintString = rtl ? ourConstraintString_rtl : ourConstraintString_ltr;
        String connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][0]);
        for (int i = 1; connection == null && i < ourConstraintString[type].length; ++i) {
            connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][i]);
        }
        if (connection == null) {
            margin = -1;
        }
        return margin;
    }

    private void configureUI() {
        float bias;
        NlComponent source;
        boolean showHorizontalSlider;
        if (this.mComponent == null) {
            return;
        }
        this.mConfiguringUI = true;
        String sherpaNamespace = "http://schemas.android.com/apk/res-auto";
        int top = this.getMargin(2);
        int left = this.getMargin(0);
        int right = this.getMargin(1);
        int bottom = this.getMargin(3);
        String ratioString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
        boolean baseline = this.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            source = WidgetConstraintPanel.findInHorizontalChain(this.mComponent);
            if (source == null) {
                source = this.mComponent;
            }
            String horizontalBias = source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
            bias = WidgetConstraintPanel.parseFloat(horizontalBias, 0.5f);
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            source = WidgetConstraintPanel.findInVerticalChain(this.mComponent);
            if (source == null) {
                source = this.mComponent;
            }
            String verticalBias = source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
            bias = WidgetConstraintPanel.parseFloat(verticalBias, 0.5f);
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthValue = this.convertFromNL("layout_width");
        int heightValue = this.convertFromNL("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthValue, heightValue, ratioString);
        this.mConfiguringUI = false;
    }

    private static float parseFloat(@Nullable String string, float defaultValue) {
        if (string != null && !string.isEmpty()) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static int getDimension(@NotNull NlComponent component, @NotNull String attribute) {
        String v;
        if (component == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(2);
        }
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(3);
        }
        if ("wrap_content".equalsIgnoreCase(v = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute))) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component, v);
    }

    private void setDimension(@Nullable NlComponent component, @Nullable String attribute, int currentValue) {
        if (component == null) {
            return;
        }
        attribute = ConstraintComponentUtilities.mapStartEndStrings(component, attribute);
        String marginString = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = ConstraintComponentUtilities.getDpValue(component, component.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute));
        }
        if (marginValue != -1 && marginValue == currentValue) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    private void setAndroidAttribute(@NotNull String attribute, @Nullable String value) {
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(4);
        }
        this.setAttribute("http://schemas.android.com/apk/res/android", attribute, value);
    }

    private void setSherpaAttribute(@NotNull String attribute, @Nullable String value) {
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(5);
        }
        this.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value);
    }

    private void setAttribute(@NotNull String nameSpace, @NotNull String attribute, @Nullable String value) {
        if (nameSpace == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(6);
        }
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(7);
        }
        if (this.mComponent != null) {
            this.setAttribute(this.mComponent, nameSpace, attribute, value);
        }
    }

    private void setAttribute(@NotNull NlComponent component, @NotNull String nameSpace, @NotNull String attribute, @Nullable String value) {
        if (component == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(8);
        }
        if (nameSpace == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(9);
        }
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(10);
        }
        if (this.mConfiguringUI) {
            return;
        }
        NlModel model = component.getModel();
        if (this.myModification == null || this.myModification.getComponent() != component) {
            this.myModification = new ComponentModification(component, "Change Widget");
        }
        this.myModification.setAttribute(nameSpace, attribute, value);
        this.myModification.apply();
        model.notifyLiveUpdate(false);
        this.myTimer.setRepeats(false);
        this.myTimer.restart();
    }

    private void removeAttribute(int type) {
        if (this.mComponent == null) {
            return;
        }
        String label = "Constraint Disconnected";
        String[] attribute = ourDeleteAttributes[type];
        String[] namespace = ourDeleteNamespace[type];
        ComponentModification modification = new ComponentModification(this.mComponent, label);
        for (int i = 0; i < attribute.length; ++i) {
            modification.setAttribute(namespace[i], attribute[i], null);
        }
        ConstraintComponentUtilities.ensureHorizontalPosition(this.mComponent, modification);
        ConstraintComponentUtilities.ensureVerticalPosition(this.mComponent, modification);
        modification.apply();
        modification.commit();
    }

    private int convertFromNL(@NotNull String attribute) {
        if (attribute == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(11);
        }
        if (this.mComponent == null) {
            return 2;
        }
        int dimen = WidgetConstraintPanel.getDimension(this.mComponent, attribute);
        switch (dimen) {
            default: {
                return 0;
            }
            case -1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private boolean hasBaseline() {
        return this.mComponent != null && this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    private void updateComponent(@Nullable NlComponent component) {
        if (this.mComponent != null) {
            this.mComponent.removeLiveChangeListener(this.myChangeLiveListener);
        }
        NlComponent nlComponent = this.mComponent = WidgetConstraintPanel.isApplicable(component) ? component : null;
        if (this.mComponent != null) {
            this.mComponent.addLiveChangeListener(this.myChangeLiveListener);
            this.configureUI();
        }
    }

    private static boolean isApplicable(@Nullable NlComponent component) {
        if (component == null) {
            return false;
        }
        NlComponent parent = component.getParent();
        return parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT);
    }

    private void killConstraint(ConstraintAnchor.Type type) {
        switch (type) {
            case LEFT: {
                this.removeAttribute(0);
                break;
            }
            case TOP: {
                this.removeAttribute(2);
                break;
            }
            case RIGHT: {
                this.removeAttribute(1);
                break;
            }
            case BOTTOM: {
                this.removeAttribute(3);
                break;
            }
            case BASELINE: {
                this.removeAttribute(4);
                break;
            }
        }
    }

    private void setHorizontalBias() {
        if (this.mComponent == null) {
            return;
        }
        int biasVal = this.mHorizontalSlider.getValue();
        float bias = (float)biasVal / 100.0f;
        String biasString = biasVal == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintPanel.findInHorizontalChain(this.mComponent);
        if (chain != null && chain != this.mComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintHorizontal_bias", biasString);
        }
    }

    @Nullable
    private static NlComponent findInHorizontalChain(@NotNull NlComponent component) {
        if (component == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(12);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
        }
        return null;
    }

    @Nullable
    private static NlComponent findInVerticalChain(@NotNull NlComponent component) {
        if (component == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(13);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component)) {
            return ConstraintComponentUtilities.findChainHead(component, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes);
        }
        return null;
    }

    private void setVerticalBias() {
        if (this.mComponent == null) {
            return;
        }
        int biasVal = this.mVerticalSlider.getValue();
        float bias = 1.0f - (float)biasVal / 100.0f;
        String biasString = biasVal == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintPanel.findInVerticalChain(this.mComponent);
        if (chain != null && chain != this.mComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintVertical_bias", biasString);
        }
    }

    public void setTopMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginTop", margin);
    }

    public void setLeftMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginStart", margin);
        this.setDimension(this.mComponent, "layout_marginLeft", margin);
    }

    public void setRightMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginEnd", margin);
        this.setDimension(this.mComponent, "layout_marginRight", margin);
    }

    public void setBottomMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginBottom", margin);
    }

    public void killTopConstraint() {
        this.killConstraint(ConstraintAnchor.Type.TOP);
    }

    public void killLeftConstraint() {
        this.killConstraint(ConstraintAnchor.Type.LEFT);
    }

    public void killRightConstraint() {
        this.killConstraint(ConstraintAnchor.Type.RIGHT);
    }

    public void killBottomConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BOTTOM);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        if (this.mComponent == null) {
            return;
        }
        String width = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        assert (width != null);
        if (width.endsWith("dp") && !width.equals("0dp")) {
            this.mComponent.putClientProperty("layout_width", width);
        }
        switch (horizontalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_width", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_width");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.mComponent.getModel(), NlComponentHelperKt.getW(this.mComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_width", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_width", "wrap_content");
            }
        }
    }

    public void setVerticalConstraint(int verticalConstraint) {
        if (this.mComponent == null) {
            return;
        }
        String height = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        assert (height != null);
        if (height.endsWith("dp") && !height.equals("0dp")) {
            this.mComponent.putClientProperty("layout_height", height);
        }
        switch (verticalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_height", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_height");
                if (oldValue == null) {
                    oldValue = Coordinates.pxToDp(this.mComponent.getModel(), NlComponentHelperKt.getH(this.mComponent)) + "dp";
                }
                this.setAndroidAttribute("layout_height", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_height", "wrap_content");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameSpace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDimension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSherpaAttribute";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertFromNL";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findInHorizontalChain";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInVerticalChain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        static final int thumbSize = 18;
        @NotNull
        private static Font sSmallFont = new Font("Helvetica", 0, 10);
        ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.mColorSet = colorSet;
        }

        @Override
        @NotNull
        protected Dimension getThumbSize() {
            Dimension dimension2 = new Dimension(18, 18);
            if (dimension2 == null) {
                WidgetSliderUI.$$$reportNull$$$0(0);
            }
            return dimension2;
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getForeground());
                int trackThickness = 5;
                if (this.slider.getOrientation() == 1) {
                    int offset = this.trackRect.width / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x + offset, this.trackRect.y, trackThickness, this.trackRect.height, 5, 5);
                } else {
                    int offset = this.trackRect.height / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x, this.trackRect.y + offset, this.trackRect.width, trackThickness, 5, 5);
                }
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        @NotNull
        protected Color getFocusColor() {
            Color color = new Color(0, 0, 0, 0);
            if (color == null) {
                WidgetSliderUI.$$$reportNull$$$0(1);
            }
            return color;
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = this.slider.getOrientation() == 1 ? Integer.toString(100 - this.slider.getValue()) : Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor().brighter());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, this.thumbRect.width, this.thumbRect.height);
            g.setColor(StudioColorsKt.getBorder());
            g.drawRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, this.thumbRect.width, this.thumbRect.height);
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2;
            g.setFont(sSmallFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(percentText, g);
            double tw = bounds.getWidth();
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel$WidgetSliderUI";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThumbSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFocusColor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorFillColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorHighlightsStrokeColor = new JBColor(0xB0B0B0, 7303537);
            this.mInspectorStrokeColor = new JBColor(0x8A8A8A, 0x808080);
            this.mInspectorConstraintColor = new JBColor(4489688, 4751560);
        }
    }
}

