/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.ConstraintHandle;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.SnapCandidate;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.WidgetInteractionTargets;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Guideline;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class SnapDraw {
    private static final int OVER = 20;
    private static final int OVER_MARGIN = 8;
    public static Stroke sDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
    static Stroke sLongDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{8.0f}, 0.0f);
    public static Stroke sThinDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 8.0f}, 0.0f);
    public static Stroke sNormalStroke = new BasicStroke(1.0f);
    private static Font sFont = new Font("Helvetica", 0, 12);
    static final int CONNECTION_ARROW_SIZE = 3;

    public static void drawSnapIndicator(ViewTransform transform2, Graphics2D g, SnapCandidate candidate) {
        if (candidate.source == null || candidate.target == null) {
            return;
        }
        if (candidate.source.isVerticalAnchor()) {
            SnapDraw.drawSnapVerticalIndicator(transform2, g, candidate);
        } else {
            SnapDraw.drawSnapHorizontalIndicator(transform2, g, candidate);
        }
    }

    private static void drawSnapHorizontalIndicator(ViewTransform transform2, Graphics2D g, SnapCandidate candidate) {
        ConstraintAnchor source = candidate.source;
        ConstraintAnchor target = candidate.target;
        ConstraintHandle sourceHandle = WidgetInteractionTargets.constraintHandle(source);
        ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(target);
        int x = transform2.getSwingX(candidate.x);
        if (targetHandle != null) {
            x = transform2.getSwingX(targetHandle.getDrawX());
        }
        int y1 = transform2.getSwingY(source.getOwner().getDrawY());
        int y2 = transform2.getSwingY(source.getOwner().getDrawY() + source.getOwner().getHeight());
        int y3 = transform2.getSwingY(target.getOwner().getDrawY());
        int y4 = transform2.getSwingY(target.getOwner().getDrawY() + target.getOwner().getHeight());
        int minY = Math.min(y1, y3);
        int maxY = Math.max(y2, y4);
        if (candidate.margin != 0) {
            int x2 = transform2.getSwingX(sourceHandle.getDrawX());
            String textMargin = String.valueOf(Math.abs(candidate.margin));
            int yS = y2;
            int yT = y4 + 4;
            int mY = yS + 8;
            boolean textOver = false;
            if (y1 < y3) {
                yS = y1;
                yT = y3 - 4;
                mY = yS - 8;
                textOver = true;
            }
            SnapDraw.drawSnapHorizontalMargin(transform2, g, x, x2, mY, textMargin, textOver);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(sDashedStroke);
            g2.drawLine(x, yS, x, yT);
            g2.dispose();
        } else {
            boolean insideIndicator;
            Graphics2D g2 = (Graphics2D)g.create();
            boolean bl = insideIndicator = source.getOwner().getParent() == candidate.target.getOwner() || candidate.target.getOwner() instanceof Guideline;
            if (insideIndicator) {
                g2.setStroke(sLongDashedStroke);
                g2.drawLine(x, minY, x, maxY);
            } else {
                g2.setStroke(sDashedStroke);
                g2.drawLine(x, minY - 20, x, maxY + 20);
            }
            g2.dispose();
        }
    }

    private static void drawSnapVerticalIndicator(ViewTransform transform2, Graphics2D g, SnapCandidate candidate) {
        ConstraintAnchor source = candidate.source;
        ConstraintAnchor target = candidate.target;
        ConstraintHandle sourceHandle = WidgetInteractionTargets.constraintHandle(source);
        ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(target);
        int y = transform2.getSwingY(candidate.y);
        if (targetHandle != null) {
            y = transform2.getSwingY(targetHandle.getDrawY());
        }
        int x1 = transform2.getSwingX(source.getOwner().getDrawX());
        int x2 = transform2.getSwingX(source.getOwner().getDrawX() + source.getOwner().getDrawWidth());
        int x3 = transform2.getSwingX(target.getOwner().getDrawX());
        int x4 = transform2.getSwingX(target.getOwner().getDrawX() + target.getOwner().getDrawWidth());
        int minX = Math.min(x1, x3);
        int maxX = Math.max(x2, x4);
        if (candidate.margin != 0) {
            int y2 = transform2.getSwingY(sourceHandle.getDrawY());
            String textMargin = "" + Math.abs(candidate.margin);
            int xS = x2;
            int xT = x4 + 4;
            int mX = xS + 8;
            if (x1 < x3) {
                xS = x1;
                xT = x3 - 4;
                mX = xS - 8;
            }
            SnapDraw.drawSnapVerticalMargin(transform2, g, mX, y, y2, textMargin);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(sDashedStroke);
            g2.drawLine(xS, y, xT, y);
            g2.dispose();
        } else {
            boolean insideIndicator;
            Graphics2D g2 = (Graphics2D)g.create();
            boolean bl = insideIndicator = source.getOwner().getParent() == candidate.target.getOwner() || candidate.target.getOwner() instanceof Guideline;
            if (insideIndicator) {
                g2.setStroke(sLongDashedStroke);
                g2.drawLine(minX, y, maxX, y);
            } else {
                g2.setStroke(sDashedStroke);
                g2.drawLine(minX - 20, y, maxX + 20, y);
            }
            g2.dispose();
        }
    }

    public static void drawSnapHorizontalMargin(ViewTransform transform2, Graphics2D g, int x1, int x2, int y1, String text, boolean textOver) {
        int w;
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        g.setFont(sFont);
        int padding = transform2.getSwingDimension(4);
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int tw = (int)bounds.getWidth();
        int offset = 18;
        if (x1 > x2) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if ((w = (x2 - x1 - (tw + 2 * padding)) / 2) <= padding) {
            g.drawLine(x1, y1, x2, y1);
            if (textOver) {
                offset = -1 * offset / 2;
            }
            g.drawString(text, x1 + w + padding, y1 + offset);
        } else {
            g.drawLine(x1, y1, x1 + w, y1);
            g.drawLine(x2 - w, y1, x2, y1);
            g.drawString(text, x1 + w + padding, (int)((double)y1 + bounds.getHeight() / 2.0));
        }
        g.drawLine(x1, y1 - 3, x1, y1 + 3);
        g.drawLine(x2, y1 - 3, x2, y1 + 3);
    }

    public static void drawSnapVerticalMargin(ViewTransform transform2, Graphics2D g, int x1, int y1, int y2, String text) {
        int h;
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        g.setFont(sFont);
        int padding = transform2.getSwingDimension(4);
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int th = (int)bounds.getHeight();
        int offset = 18;
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if ((h = (y2 - y1 - (th + 2 * padding)) / 2) <= padding) {
            g.drawLine(x1, y1, x1, y2);
            g.drawString(text, (int)((double)x1 - bounds.getWidth() / 2.0) + offset, y2 - h - padding);
        } else {
            g.drawLine(x1, y1, x1, y1 + h);
            g.drawLine(x1, y2 - h, x1, y2);
            g.drawString(text, (int)((double)x1 - bounds.getWidth() / 2.0), y2 - h - padding);
        }
        g.drawLine(x1 - 3, y1, x1 + 3, y1);
        g.drawLine(x1 - 3, y2, x1 + 3, y2);
    }
}

