/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.interaction;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.WidgetInteractionTargets;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import java.awt.Rectangle;

public class ResizeHandle {
    private static final int SLOPE = 12;
    private final WidgetInteractionTargets mOwner;
    private final Type mType;
    private Rectangle mBounds = new Rectangle();

    public ResizeHandle(WidgetInteractionTargets owner, Type type) {
        this.mOwner = owner;
        this.mType = type;
    }

    public ConstraintWidget getOwner() {
        return this.mOwner.getConstraintWidget();
    }

    public Type getType() {
        return this.mType;
    }

    public Rectangle getBounds() {
        return this.mBounds;
    }

    public void updatePosition(ViewTransform viewTransform) {
        if (this.mOwner == null) {
            this.mBounds.setBounds(0, 0, 0, 0);
            return;
        }
        int x = this.getOwner().getDrawX();
        int y = this.getOwner().getDrawY();
        int w = this.getOwner().getDrawWidth();
        int h = this.getOwner().getDrawHeight();
        int slope = (int)(1.0f + 12.0f / viewTransform.getScale());
        switch (this.mType) {
            case LEFT_TOP: {
                this.mBounds.setBounds(x - slope / 2, y - slope / 2, slope, slope);
                break;
            }
            case LEFT_BOTTOM: {
                this.mBounds.setBounds(x - slope / 2, y + h - slope / 2, slope, slope);
                break;
            }
            case RIGHT_TOP: {
                this.mBounds.setBounds(x + w - slope / 2, y - slope / 2, slope, slope);
                break;
            }
            case RIGHT_BOTTOM: {
                this.mBounds.setBounds(x + w - slope / 2, y + h - slope / 2, slope, slope);
                break;
            }
            case LEFT_SIDE: {
                this.mBounds.setBounds(x - slope / 2, y + slope / 2, slope, h - slope);
                break;
            }
            case RIGHT_SIDE: {
                this.mBounds.setBounds(x + w - slope / 2, y + slope / 2, slope, h - slope);
                break;
            }
            case TOP_SIDE: {
                this.mBounds.setBounds(x + slope / 2, y - slope / 2, w - slope, slope);
                break;
            }
            case BOTTOM_SIDE: {
                this.mBounds.setBounds(x + slope / 2, y + h - slope / 2, w - slope, slope);
            }
        }
    }

    public Rectangle getSwingBounds(ViewTransform transform2) {
        Rectangle bounds = new Rectangle();
        if (this.mOwner == null) {
            bounds.setBounds(0, 0, 0, 0);
            return bounds;
        }
        bounds.setBounds(transform2.getSwingX(this.mBounds.x), transform2.getSwingY(this.mBounds.y), transform2.getSwingDimension(this.mBounds.width), transform2.getSwingDimension(this.mBounds.height));
        return bounds;
    }

    public boolean isSideHandle() {
        switch (this.mType) {
            case LEFT_SIDE: 
            case RIGHT_SIDE: 
            case TOP_SIDE: 
            case BOTTOM_SIDE: {
                return true;
            }
            case LEFT_TOP: 
            case LEFT_BOTTOM: 
            case RIGHT_TOP: 
            case RIGHT_BOTTOM: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean hit(float x, float y) {
        return this.mBounds.contains(x, y);
    }

    public static enum Type {
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM,
        LEFT_SIDE,
        RIGHT_SIDE,
        TOP_SIDE,
        BOTTOM_SIDE;

    }
}

