/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.interaction.tests;

import com.android.tools.idea.uibuilder.handlers.constraint.interaction.DrawPicker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CheckSelection
extends JPanel {
    private static final boolean DEBUG = false;
    DrawPicker selector = new DrawPicker();
    Random mRandom = new Random();
    int mMaxX = 512;
    int mMaxY = 512;
    ArrayList<Drawable> list = new ArrayList();
    Drawable[] mOver = new Drawable[10];
    int count;
    int mouseX;
    int mouseY;

    CheckSelection() {
        this.buildMarks(25);
        this.selector.setSelectListener(new DrawPicker.HitElementListener(){

            @Override
            public void over(Object over, double dist) {
                if (CheckSelection.this.count == CheckSelection.this.mOver.length) {
                    return;
                }
                CheckSelection.this.mOver[CheckSelection.this.count] = (Drawable)over;
                CheckSelection.this.mOver[CheckSelection.this.count].hover = true;
                ++CheckSelection.this.count;
                CheckSelection.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CheckSelection.this.list.clear();
                CheckSelection.this.selector.reset();
                CheckSelection.this.mMaxX = CheckSelection.this.getWidth();
                CheckSelection.this.mMaxY = CheckSelection.this.getHeight();
                long time2 = System.nanoTime();
                CheckSelection.this.buildMarks(CheckSelection.this.mMaxX / 8);
                CheckSelection.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                CheckSelection.this.mouseX = e.getX();
                CheckSelection.this.mouseY = e.getY();
                CheckSelection.this.select(CheckSelection.this.mouseX, CheckSelection.this.mouseY);
            }
        });
        Timer t = new Timer(16, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckSelection.this.selector.reset();
                for (Drawable drawable : CheckSelection.this.list) {
                    drawable.move();
                    CheckSelection.this.repaint();
                }
                CheckSelection.this.select(CheckSelection.this.mouseX, CheckSelection.this.mouseY);
            }
        });
        t.start();
    }

    void select(int x, int y) {
        long time2 = System.nanoTime();
        for (int i = 0; i < this.mOver.length && this.mOver[i] != null; ++i) {
            this.mOver[i].hover = false;
        }
        this.count = 0;
        this.selector.find(x, y);
    }

    void buildMarks(int size) {
        int i;
        for (i = 0; i < size * 8; ++i) {
            this.list.add(new Point());
        }
        for (i = 0; i < size * 2; ++i) {
            this.list.add(new Line());
        }
        for (i = 0; i < size; ++i) {
            this.list.add(new Rect());
        }
        for (i = 0; i < size * 2; ++i) {
            this.list.add(new Curve());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, height);
        Graphics2D g2d = (Graphics2D)g;
        for (Drawable drawable : this.list) {
            drawable.draw(g2d);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CurveToDistance");
        f.setBounds(new Rectangle(623, 660));
        f.setDefaultCloseOperation(3);
        CheckSelection p = new CheckSelection();
        f.setContentPane(p);
        f.validate();
        f.setVisible(true);
    }

    class Curve
    extends Drawable {
        int x1;
        int y1;
        int x2;
        int y2;
        int x3;
        int y3;
        int x4;
        int y4;

        @Override
        public void move() {
            if (this.x1 > CheckSelection.this.mMaxX) {
                this.dx = -Math.abs(this.dx);
            }
            if (this.y1 > CheckSelection.this.mMaxY) {
                this.dy = -Math.abs(this.dy);
            }
            if (this.x1 < 0) {
                this.dx = Math.abs(this.dx);
            }
            if (this.y1 < 0) {
                this.dy = Math.abs(this.dy);
            }
            this.x1 += this.dx;
            this.y1 += this.dy;
            this.x2 += this.dx;
            this.y2 += this.dy;
            this.x3 += this.dx;
            this.y3 += this.dy;
            this.x4 += this.dx;
            this.y4 += this.dy;
            CheckSelection.this.selector.addCurveTo(this, 10, this.x1, this.y1, this.x2, this.y2, this.x3, this.y3, this.x4, this.y4);
        }

        Curve() {
            this.x1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxX);
            this.y1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxY);
            int size = 200;
            int half = size / 2;
            this.x2 = this.x1 + CheckSelection.this.mRandom.nextInt(size) - half;
            this.y2 = this.y1 + CheckSelection.this.mRandom.nextInt(size) - half;
            this.x3 = this.x1 + CheckSelection.this.mRandom.nextInt(size) - half;
            this.y3 = this.y1 + CheckSelection.this.mRandom.nextInt(size) - half;
            this.x4 = this.x1 + CheckSelection.this.mRandom.nextInt(size) - half;
            this.y4 = this.y1 + CheckSelection.this.mRandom.nextInt(size) - half;
            CheckSelection.this.selector.addCurveTo(this, 10, this.x1, this.y1, this.x2, this.y2, this.x3, this.y3, this.x4, this.y4);
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.hover ? Color.WHITE : Color.RED);
            GeneralPath path = new GeneralPath();
            path.moveTo(this.x1, this.y1);
            path.curveTo(this.x2, this.y2, this.x3, this.y3, this.x4, this.y4);
            g.draw(path);
        }
    }

    class Rect
    extends Drawable {
        int x1;
        int y1;
        int x2;
        int y2;

        @Override
        public void move() {
            if (this.x1 > CheckSelection.this.mMaxX) {
                this.dx = -Math.abs(this.dx);
            }
            if (this.y1 > CheckSelection.this.mMaxY) {
                this.dy = -Math.abs(this.dy);
            }
            if (this.x1 < 0) {
                this.dx = Math.abs(this.dx);
            }
            if (this.y1 < 0) {
                this.dy = Math.abs(this.dy);
            }
            this.x1 += this.dx;
            this.y1 += this.dy;
            this.x2 += this.dx;
            this.y2 += this.dy;
            CheckSelection.this.selector.addRect(this, 10, this.x1, this.y1, this.x2, this.y2);
        }

        Rect() {
            this.x1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxX);
            this.y1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxY);
            this.x2 = this.x1 + 70;
            this.y2 = this.y1 + 32;
            CheckSelection.this.selector.addRect(this, 10, this.x1, this.y1, this.x2, this.y2);
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.hover ? Color.WHITE : Color.RED);
            g.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }

    class Line
    extends Drawable {
        int x1;
        int y1;
        int x2;
        int y2;

        @Override
        public void move() {
            if (this.x1 > CheckSelection.this.mMaxX) {
                this.dx = -Math.abs(this.dx);
            }
            if (this.y1 > CheckSelection.this.mMaxY) {
                this.dy = -Math.abs(this.dy);
            }
            if (this.x1 < 0) {
                this.dx = Math.abs(this.dx);
            }
            if (this.y1 < 0) {
                this.dy = Math.abs(this.dy);
            }
            this.x1 += this.dx;
            this.y1 += this.dy;
            this.x2 += this.dx;
            this.y2 += this.dy;
            CheckSelection.this.selector.addLine(this, 10, this.x1, this.y1, this.x2, this.y2);
        }

        Line() {
            int size = CheckSelection.this.mMaxX / 2;
            this.x1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxX);
            this.y1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxY);
            this.x2 = this.x1 + CheckSelection.this.mRandom.nextInt(size) - size / 2;
            this.y2 = this.y1 + CheckSelection.this.mRandom.nextInt(size) - size / 2;
            CheckSelection.this.selector.addLine(this, 10, this.x1, this.y1, this.x2, this.y2);
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.hover ? Color.WHITE : Color.RED);
            g.drawLine(this.x1, this.y1, this.x2, this.y2);
        }
    }

    class Point
    extends Drawable {
        int x1;
        int y1;

        @Override
        public void move() {
            if (this.x1 > CheckSelection.this.mMaxX) {
                this.dx = -Math.abs(this.dx);
            }
            if (this.y1 > CheckSelection.this.mMaxY) {
                this.dy = -Math.abs(this.dy);
            }
            if (this.x1 < 0) {
                this.dx = Math.abs(this.dx);
            }
            if (this.y1 < 0) {
                this.dy = Math.abs(this.dy);
            }
            this.x1 += this.dx;
            this.y1 += this.dy;
            CheckSelection.this.selector.addPoint(this, 10, this.x1, this.y1);
        }

        Point() {
            this.x1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxX);
            this.y1 = CheckSelection.this.mRandom.nextInt(CheckSelection.this.mMaxY);
            CheckSelection.this.selector.addPoint(this, 10, this.x1, this.y1);
        }

        @Override
        public void draw(Graphics2D g) {
            g.setColor(this.hover ? Color.WHITE : Color.RED);
            g.drawRoundRect(this.x1 - 3, this.y1 - 3, 6, 6, 6, 6);
        }
    }

    abstract class Drawable {
        boolean hover;
        int dx;
        int dy;

        Drawable() {
            int speed = 4;
            this.dx = CheckSelection.this.mRandom.nextInt(speed) - speed / 2;
            this.dy = CheckSelection.this.mRandom.nextInt(speed) - speed / 2;
        }

        public abstract void draw(Graphics2D var1);

        public abstract void move();
    }
}

