/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.grid.CellInfo;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.InsetsAttributes;
import com.android.tools.idea.uibuilder.model.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\n*\u00020\b2\u0006\u0010\u001b\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"MARGIN_ATTRIBUTES", "Lcom/android/tools/idea/uibuilder/handlers/grid/InsetsAttributes;", "PADDING_ATTRIBUTES", "UNDEFINED_COLUMN", "", "UNDEFINED_ROW", "getDpValue", "nlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "value", "", "getGridBarriers", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "gridComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "retrieveCellData", "Lcom/android/tools/idea/uibuilder/handlers/grid/CellInfo;", "isSupportLibrary", "", "retrieveInsets", "Lcom/android/tools/idea/uibuilder/model/Insets;", "attrs", "retrieveMargins", "retrievePaddings", "getLiveAndroidAttribute", "androidAttribute", "intellij.android.designer"})
public final class GridUtilsKt {
    private static final int UNDEFINED_ROW = -1;
    private static final int UNDEFINED_COLUMN = -1;
    private static final InsetsAttributes PADDING_ATTRIBUTES = new InsetsAttributes("padding", (Pair<String, String>)new Pair((Object)"paddingStart", (Object)"paddingLeft"), "paddingTop", (Pair<String, String>)new Pair((Object)"paddingEnd", (Object)"paddingRight"), "paddingBottom");
    private static final InsetsAttributes MARGIN_ATTRIBUTES = new InsetsAttributes("layout_margin", (Pair<String, String>)new Pair((Object)"layout_marginStart", (Object)"layout_marginLeft"), "layout_marginTop", (Pair<String, String>)new Pair((Object)"layout_marginEnd", (Object)"layout_marginRight"), "layout_marginBottom");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GridBarriers getGridBarriers(@NotNull SceneContext sceneContext, @NotNull SceneComponent gridComponent) {
        Integer n;
        Integer[] integerArray;
        void var29_43;
        int cellBottom;
        int cellRight;
        int cellTop;
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)gridComponent, (String)"gridComponent");
        NlComponent nlComponent = gridComponent.getNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"gridComponent.nlComponent");
        boolean isSupportLibrary = SdkConstants.GRID_LAYOUT_V7.isEquals(nlComponent.getTagName());
        Function1<Integer, Integer> toSwingX$ = new Function1<Integer, Integer>(sceneContext){
            final /* synthetic */ SceneContext $sceneContext;

            public final int invoke(int x) {
                return this.$sceneContext.getSwingXDip(x);
            }
            {
                this.$sceneContext = sceneContext;
                super(1);
            }
        };
        Function1<Integer, Integer> toSwingY$ = new Function1<Integer, Integer>(sceneContext){
            final /* synthetic */ SceneContext $sceneContext;

            public final int invoke(int y) {
                return this.$sceneContext.getSwingYDip(y);
            }
            {
                this.$sceneContext = sceneContext;
                super(1);
            }
        };
        Function1<Integer, Integer> pxToSwing$ = new Function1<Integer, Integer>(sceneContext){
            final /* synthetic */ SceneContext $sceneContext;

            public final int invoke(int px) {
                return (int)(this.$sceneContext.pxToDp(px) + 0.5f);
            }
            {
                this.$sceneContext = sceneContext;
                super(1);
            }
        };
        NlComponent nlComponent2 = gridComponent.getAuthoritativeNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent2, (String)"gridComponent.authoritativeNlComponent");
        Insets padding = GridUtilsKt.retrievePaddings(nlComponent2);
        int left = toSwingX$.invoke(gridComponent.getDrawX()) + pxToSwing$.invoke(padding.left);
        int top = toSwingY$.invoke(gridComponent.getDrawY()) + pxToSwing$.invoke(padding.top);
        int right = toSwingX$.invoke(gridComponent.getDrawX() + gridComponent.getDrawWidth()) - pxToSwing$.invoke(padding.right);
        int bottom = toSwingY$.invoke(gridComponent.getDrawY() + gridComponent.getDrawHeight()) - pxToSwing$.invoke(padding.bottom);
        List<SceneComponent> children = gridComponent.getChildren();
        HashMap<Integer, Integer> rowMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> columnMap = new HashMap<Integer, Integer>();
        int previousRow = 0;
        int previousColumn = -1;
        Iterator<SceneComponent> iterator = children.iterator();
        while (iterator.hasNext()) {
            Integer n2;
            Integer n3;
            Object object;
            Map map2;
            SceneComponent child;
            SceneComponent sceneComponent = child = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"child");
            NlComponent nlComponent3 = sceneComponent.getAuthoritativeNlComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent3, (String)"child.authoritativeNlComponent");
            CellInfo cellData = GridUtilsKt.retrieveCellData(nlComponent3, isSupportLibrary);
            if (cellData.getColumn() == -1) {
                cellData.setColumn(previousColumn + 1);
            }
            if (cellData.getRow() == -1) {
                cellData.setRow(previousRow);
            }
            NlComponent nlComponent4 = child.getAuthoritativeNlComponent();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent4, (String)"child.authoritativeNlComponent");
            Insets marginInsets = GridUtilsKt.retrieveMargins(nlComponent4);
            int cellLeft = toSwingX$.invoke(child.getDrawX()) - pxToSwing$.invoke(marginInsets.left);
            cellTop = toSwingY$.invoke(child.getDrawY()) - pxToSwing$.invoke(marginInsets.top);
            cellRight = toSwingX$.invoke(child.getDrawX() + child.getDrawWidth()) + pxToSwing$.invoke(marginInsets.right);
            cellBottom = toSwingY$.invoke(child.getDrawY() + child.getDrawHeight()) + pxToSwing$.invoke(marginInsets.bottom);
            if (cellData.getColumn() != 0) {
                map2 = columnMap;
                object = cellData.getColumn();
                Integer n4 = (Integer)columnMap.get(cellData.getColumn());
                if (n4 == null) {
                    n4 = Integer.MAX_VALUE;
                }
                int n5 = n4;
                n3 = Math.min(cellLeft, n5);
                map2.put(object, n3);
            }
            if (cellData.getRow() != 0) {
                map2 = rowMap;
                object = cellData.getRow();
                Integer n6 = (Integer)rowMap.get(cellData.getRow());
                if (n6 == null) {
                    n6 = Integer.MAX_VALUE;
                }
                int n7 = n6;
                n3 = Math.min(cellTop, n7);
                map2.put(object, n3);
            }
            if (cellData.getColumn() != -1 && cellData.getColumnSpan() != 0) {
                int rightIndex = cellData.getColumn() + cellData.getColumnSpan();
                object = columnMap;
                n3 = rightIndex;
                Integer n8 = (Integer)columnMap.get(rightIndex);
                if (n8 == null) {
                    n8 = Integer.MIN_VALUE;
                }
                int n9 = n8;
                n2 = Math.max(cellRight, n9);
                object.put(n3, n2);
            }
            if (cellData.getRow() != -1 && cellData.getRowSpan() != 0) {
                int bottomIndex = cellData.getRow() + cellData.getRowSpan();
                object = rowMap;
                n3 = bottomIndex;
                Integer n10 = (Integer)rowMap.get(bottomIndex);
                if (n10 == null) {
                    n10 = Integer.MIN_VALUE;
                }
                int n11 = n10;
                n2 = Math.max(cellBottom, n11);
                object.put(n3, n2);
            }
            previousRow = cellData.getRow();
            previousColumn = cellData.getColumn();
        }
        Set set = columnMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"columnMap.keys");
        Integer n12 = (Integer)CollectionsKt.max((Iterable)set);
        int columnCount = n12 != null ? n12 + 1 : 1;
        Set set2 = rowMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"rowMap.keys");
        Integer n13 = (Integer)CollectionsKt.max((Iterable)set2);
        int rowCount = n13 != null ? n13 + 1 : 1;
        columnMap.put(0, left);
        columnMap.put(columnCount, right);
        rowMap.put(0, top);
        rowMap.put(rowCount, bottom);
        int size$iv = columnCount + 1;
        Integer[] result$iv = new Integer[size$iv];
        cellTop = 0;
        cellRight = result$iv.length;
        while (cellTop < cellRight) {
            void it;
            void i$iv;
            cellBottom = i$iv;
            var29_43 = i$iv;
            integerArray = result$iv;
            Integer n14 = (Integer)columnMap.get((int)it);
            if (n14 == null) {
                n14 = Integer.MIN_VALUE;
            }
            integerArray[var29_43] = n = n14;
            ++i$iv;
        }
        Integer[] columnArray = result$iv;
        int size$iv2 = rowCount + 1;
        Integer[] result$iv2 = new Integer[size$iv2];
        cellRight = 0;
        int n15 = result$iv2.length;
        while (cellRight < n15) {
            void it;
            void i$iv;
            void $i$a$1$<init> = i$iv;
            var29_43 = i$iv;
            integerArray = result$iv2;
            Integer n16 = (Integer)rowMap.get((int)it);
            if (n16 == null) {
                n16 = Integer.MIN_VALUE;
            }
            integerArray[var29_43] = n = n16;
            ++i$iv;
        }
        Integer[] rowArray = result$iv2;
        return new GridBarriers(sceneContext, left, top, right, bottom, rowArray, columnArray);
    }

    private static final CellInfo retrieveCellData(NlComponent nlComponent, boolean isSupportLibrary) {
        Function2 getAttribute2 = (Function2)new Function2<String, Integer, Integer>(isSupportLibrary, nlComponent){
            final /* synthetic */ boolean $isSupportLibrary;
            final /* synthetic */ NlComponent $nlComponent;

            public final int invoke(@NotNull String name, int defaultValue) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                String nameSpace = this.$isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
                Object object = this.$nlComponent.getLiveAttribute(nameSpace, name);
                return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
            }
            {
                this.$isSupportLibrary = bl;
                this.$nlComponent = nlComponent;
                super(2);
            }
        };
        return new CellInfo(((Number)getAttribute2.invoke((Object)"layout_row", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_column", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_rowSpan", (Object)1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_columnSpan", (Object)1)).intValue());
    }

    private static final String getLiveAndroidAttribute(@NotNull NlComponent $receiver, String androidAttribute) {
        return $receiver.getLiveAttribute("http://schemas.android.com/apk/res/android", androidAttribute);
    }

    private static final Insets retrieveMargins(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, MARGIN_ATTRIBUTES);
    }

    private static final Insets retrievePaddings(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, PADDING_ATTRIBUTES);
    }

    private static final Insets retrieveInsets(NlComponent nlComponent, InsetsAttributes attrs) {
        int bottom;
        int right;
        int top;
        int left;
        String valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getAll());
        if (valueString != null) {
            int padding;
            left = padding = GridUtilsKt.getDpValue(nlComponent, valueString);
            top = padding;
            right = padding;
            bottom = padding;
        } else {
            String string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getFirst());
            if (string == null) {
                string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getSecond());
            }
            valueString = string;
            left = GridUtilsKt.getDpValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getTop());
            top = GridUtilsKt.getDpValue(nlComponent, valueString);
            String string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getFirst());
            if (string2 == null) {
                string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getSecond());
            }
            valueString = string2;
            right = GridUtilsKt.getDpValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getBottom());
            bottom = GridUtilsKt.getDpValue(nlComponent, valueString);
        }
        return new Insets(left, top, right, bottom);
    }

    private static final int getDpValue(NlComponent nlComponent, String value) {
        if (value != null) {
            Configuration configuration;
            NlModel nlModel = nlComponent.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlModel, (String)"nlComponent.model");
            Configuration configuration2 = configuration = nlModel.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
            ResourceResolver resourceResolver = configuration2.getResourceResolver();
            if (resourceResolver != null) {
                Integer n = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
                return n != null ? n : 0;
            }
        }
        return 0;
    }
}

