/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentDelegate;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.property2.TimelineListener;
import com.android.tools.idea.uibuilder.handlers.motion.property2.TimelineOwner;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttCommands;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MotionLayoutTimelinePanel
implements AccessoryPanelInterface,
GanttEventListener,
ModelListener,
TimelineOwner {
    private final ViewGroupHandler.AccessoryPanelVisibility myVisibilityCallback;
    private final DesignSurface mySurface;
    private final List<TimelineListener> myTimelineListeners;
    private NlComponent myMotionLayout;
    private MotionLayoutComponentHelper myMotionLayoutComponentHelper;
    private Gantt myPanel;
    private GanttCommands mGanttCommands;
    private Timer myPositionTimer;
    public static boolean myLoopMode;
    public static boolean myDirectionBackward;
    private float myLastPos;
    private NlComponent mySelection;
    MotionLayoutAttributePanel myMotionLayoutAttributePanel;
    private boolean myInStateChange;
    private NlComponentDelegate myNlComponentDelegate;
    private NlModel myModel;
    private State myCurrentState;
    public static final String TIMELINE = "Timeline";

    public State getCurrentState() {
        return this.myCurrentState;
    }

    public NlComponentDelegate getNlComponentDelegate() {
        return this.myNlComponentDelegate;
    }

    public void setTimelineProgress(float progress) {
        this.myPanel.setProgress(progress);
    }

    public MotionLayoutTimelinePanel(@NotNull DesignSurface surface, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        if (surface == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(2);
        }
        this.myNlComponentDelegate = new MotionLayoutComponentDelegate(this);
        this.myCurrentState = State.TL_UNKNOWN;
        this.mySurface = surface;
        this.myVisibilityCallback = visibility;
        this.myTimelineListeners = new ArrayList<TimelineListener>();
        this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(parent);
        parent.putClientProperty(TIMELINE, this);
        this.updateModel(parent.getModel());
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = (Gantt)this.createPanel(AccessoryPanel.Type.SOUTH_PANEL);
        }
        Gantt gantt = this.myPanel;
        if (gantt == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(3);
        }
        return gantt;
    }

    @Override
    @NotNull
    public JPanel createPanel(AccessoryPanel.Type type) {
        Gantt panel = new Gantt(this);
        panel.setPreferredSize(new Dimension(0, 300));
        Gantt gantt = panel;
        if (gantt == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(4);
        }
        return gantt;
    }

    @Nullable
    public MotionSceneModel.KeyFrame getSelectedKeyframe() {
        return this.myPanel.getSelectedKey(this.mySelection.getId());
    }

    public void clearSelectedKeyframe() {
        this.myPanel.clearSelectedKey();
    }

    @Nullable
    public MotionSceneModel.TransitionTag getTransitionTag() {
        return this.myPanel.getTransitionTag();
    }

    @Nullable
    public MotionSceneModel.OnSwipeTag getOnSwipeTag() {
        return this.myPanel.getOnSwipeTag();
    }

    private void updateModel(@Nullable NlModel model) {
        if (this.myModel == model) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        this.myModel = model;
        if (this.myModel != null) {
            this.myModel.addListener(this);
        }
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        if (type == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(5);
        }
        if (selection == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(6);
        }
        this.myCurrentState = State.TL_UNKNOWN;
        if (selection.isEmpty()) {
            this.mySelection = null;
            return;
        }
        NlComponent component = selection.get(0);
        if (component != this.mySelection) {
            this.myNlComponentDelegate.clearCaches();
        }
        this.mySelection = component;
        if (!NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT) && (component = component.getParent()) != null && !NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.CLASS_MOTION_LAYOUT)) {
            return;
        }
        if (this.myMotionLayout != component) {
            this.myMotionLayout = component;
            this.updateModel(this.myMotionLayout != null ? this.myMotionLayout.getModel() : null);
            this.loadMotionScene();
        }
        this.updateState();
        this.addDelegate();
    }

    public void updateState() {
        if (this.myCurrentState == State.TL_UNKNOWN) {
            float position = this.myPanel.getChart().getProgress();
            if (position == 0.0f) {
                this.setState(State.TL_START);
            } else if (position == 1.0f) {
                this.setState(State.TL_END);
            } else {
                this.setState(State.TL_UNKNOWN);
            }
            SceneComponent root = this.mySurface.getScene().getRoot();
            if (root != null) {
                root.updateTargets();
            }
        }
    }

    private void addDelegate() {
        if (this.myMotionLayout == null) {
            return;
        }
        this.myMotionLayout.setDelegate(this.myNlComponentDelegate);
        for (NlComponent child : this.myMotionLayout.getChildren()) {
            child.setDelegate(this.myNlComponentDelegate);
        }
    }

    private void loadMotionScene() {
        if (this.myMotionLayout == null) {
            return;
        }
        String referencedFile = this.myMotionLayout.getAttribute("http://schemas.android.com/apk/res-auto", "transition");
        if (referencedFile != null) {
            this.parseMotionScene(this.myMotionLayout, referencedFile);
        }
        this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
        switch (this.myPanel.getMode()) {
            case START: {
                this.setState(State.TL_START);
                this.setProgress(0.0f);
                break;
            }
            case PLAY: {
                this.setState(State.TL_PLAY);
                myDirectionBackward = false;
                break;
            }
            case PAUSE: {
                this.setState(State.TL_PAUSE);
                myDirectionBackward = false;
                break;
            }
            case TRANSITION: {
                float position = this.myPanel.getChart().getProgress();
                this.setProgress(position);
                break;
            }
            case END: {
                this.setState(State.TL_END);
                this.setProgress(1.0f);
                break;
            }
            case UNKNOWN: {
                this.setState(State.TL_START);
                this.setProgress(0.0f);
                break;
            }
        }
    }

    private void parseMotionScene(@NotNull NlComponent component, @NotNull String file) {
        if (component == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(7);
        }
        if (file == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(8);
        }
        if (file == null) {
            return;
        }
        int index = file.lastIndexOf("@xml/");
        String fileName = file.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        Project project = component.getModel().getProject();
        AndroidFacet facet = component.getModel().getFacet();
        ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(ResourceType.XML);
        List<VirtualFile> resourcesXML = AndroidResourceUtil.getResourceSubdirs(folderType, facet.getAllResourceDirectories());
        if (resourcesXML.isEmpty()) {
            return;
        }
        VirtualFile directory = resourcesXML.get(0);
        VirtualFile virtualFile = directory.findFileByRelativePath(fileName + ".xml");
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
        MotionSceneModel motionSceneModel = MotionSceneModel.parse(component.getModel(), project, virtualFile, xmlFile);
        this.myPanel.setMotionScene(motionSceneModel);
    }

    @Override
    public void deactivate() {
        this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
        this.stopPlaying();
        this.updateModel(null);
        this.myMotionLayout = null;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model) {
        if (model == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(9);
        }
        this.updateAfterModelDerivedDataChanged();
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
        this.loadMotionScene();
        if (this.myMotionLayoutAttributePanel != null) {
            this.myMotionLayoutAttributePanel.updateAfterModelDerivedDataChanged();
        }
        this.myTimelineListeners.forEach(listener2 -> listener2.updateSelection(this.getSelectedKeyframe()));
    }

    @Override
    public void setProgress(float percent) {
        if (!this.myMotionLayoutComponentHelper.setProgress(percent)) {
            this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
        }
        if (this.myCurrentState != State.TL_PLAY) {
            if (percent == 0.0f) {
                this.setState(State.TL_START);
            } else if (percent == 1.0f) {
                this.setState(State.TL_END);
            } else {
                this.setState(State.TL_TRANSITION);
            }
        }
    }

    private void setState(State state) {
        if (this.myCurrentState == state || this.myInStateChange) {
            return;
        }
        this.myInStateChange = true;
        switch (state) {
            case TL_START: {
                this.mGanttCommands.setMode(GanttCommands.Mode.START);
                this.stopPlaying();
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
                this.mGanttCommands.setProgress(0.0f);
                break;
            }
            case TL_END: {
                this.mGanttCommands.setMode(GanttCommands.Mode.END);
                this.stopPlaying();
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, false);
                this.mGanttCommands.setProgress(1.0f);
                break;
            }
            case TL_PLAY: {
                this.mGanttCommands.setMode(GanttCommands.Mode.PLAY);
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, true);
                this.startPlaying();
                break;
            }
            case TL_PAUSE: {
                this.stopPlaying();
                this.mGanttCommands.setMode(GanttCommands.Mode.PAUSE);
                break;
            }
            case TL_TRANSITION: {
                this.stopPlaying();
                this.mGanttCommands.setMode(GanttCommands.Mode.TRANSITION);
                this.myVisibilityCallback.show(AccessoryPanel.Type.EAST_PANEL, true);
                break;
            }
            case TL_UNKNOWN: {
                this.stopPlaying();
            }
        }
        this.myCurrentState = state;
        this.myInStateChange = false;
        SceneComponent root = this.mySurface.getScene().getRoot();
        if (root != null) {
            root.updateTargets();
        }
    }

    private void startPlaying() {
        int timer_delay_in_ms = 16;
        if (this.myPositionTimer != null) {
            this.myPositionTimer.stop();
        }
        this.myPositionTimer = new Timer(0, e -> {
            float increment = 0.016f;
            if (this.myPanel != null) {
                float speedMultiplier = this.myPanel.getChart().getPlayBackSpeed();
                float timeMs = this.myPanel.getChart().getAnimationTimeInMs();
                increment = speedMultiplier * 16.0f / timeMs;
            }
            float value = this.myLastPos + increment;
            if (myDirectionBackward) {
                value = this.myLastPos - increment;
                if (value < 0.0f) {
                    if (myLoopMode) {
                        value = 0.0f;
                        myDirectionBackward = false;
                    } else {
                        value = 100.0f;
                    }
                }
            } else if (value > 1.0f) {
                if (myLoopMode) {
                    value = 1.0f;
                    myDirectionBackward = true;
                } else {
                    value = 0.0f;
                }
            }
            this.myLastPos = value;
            if (!this.myMotionLayoutComponentHelper.setProgress(value)) {
                this.myMotionLayoutComponentHelper = new MotionLayoutComponentHelper(this.myMotionLayout);
            }
            if (this.mGanttCommands != null) {
                this.mGanttCommands.setProgress(value);
            }
        });
        this.myPositionTimer.setRepeats(true);
        this.myPositionTimer.setDelay(16);
        this.myPositionTimer.start();
    }

    private void stopPlaying() {
        if (this.myCurrentState == State.TL_PLAY && this.myPositionTimer != null) {
            this.myPositionTimer.stop();
        }
    }

    @Override
    public void buttonPressed(ActionEvent e, GanttEventListener.Actions action2) {
        switch (action2) {
            case START_ACTION: {
                this.setState(State.TL_START);
                break;
            }
            case END_ACTION: {
                this.setState(State.TL_END);
                break;
            }
            case LOOP_ACTION: {
                myLoopMode = !myLoopMode;
                myDirectionBackward = false;
                if (this.myCurrentState != State.TL_PAUSE) break;
                this.setState(State.TL_PLAY);
                break;
            }
            case PLAY_ACTION: 
            case SLOW_MOTION: {
                if (this.myCurrentState == State.TL_PLAY) {
                    this.setState(State.TL_PAUSE);
                    break;
                }
                this.setState(State.TL_PLAY);
                break;
            }
        }
    }

    @Override
    public void selectionEvent() {
        if (this.myMotionLayoutAttributePanel != null) {
            this.myMotionLayoutAttributePanel.updateSelection();
        }
        this.myTimelineListeners.forEach(listener2 -> listener2.updateSelection(this.getSelectedKeyframe()));
        String selectedElementName = this.myPanel.getChart().getSelectedKeyView();
        if (selectedElementName != null) {
            List<NlComponent> selection = this.getSelectionFrom(this.myMotionLayout, selectedElementName);
            this.mySurface.getSelectionModel().setSelection(selection);
        }
    }

    private List<NlComponent> getSelectionFrom(@NotNull NlComponent component, @NotNull String id) {
        if (component == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(10);
        }
        if (id == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(11);
        }
        if (component.getId().equals(id)) {
            return Arrays.asList(component);
        }
        for (NlComponent child : component.getChildren()) {
            if (!child.getId().equals(id)) continue;
            return Arrays.asList(child);
        }
        return new ArrayList<NlComponent>();
    }

    @Override
    public void transitionDuration(int duration) {
    }

    @Override
    public void motionLayoutAccess(int cmd, String type, float[] in, int inLength, float[] out, int outLength) {
        this.myMotionLayoutComponentHelper.motionLayoutAccess(cmd, type, null, in, inLength, out, outLength);
    }

    @Override
    public void onInit(GanttCommands commands) {
        this.mGanttCommands = commands;
    }

    public void setKeyframeAttribute(@NotNull String attributeName, float value) {
        if (attributeName == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(12);
        }
        MotionSceneModel.KeyFrame keyFrame = this.myPanel.getChart().getSelectedKeyFrame();
        keyFrame.setValue(attributeName, Float.toString(value));
    }

    public void setKeyframeAttributes(@NotNull HashMap<String, String> values2) {
        if (values2 == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(13);
        }
        MotionSceneModel.KeyFrame keyFrame = this.myPanel.getChart().getSelectedKeyFrame();
        keyFrame.setValues(values2);
    }

    @Nullable
    XmlFile getTransitionFile(@NotNull NlComponent component) {
        if (component == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(14);
        }
        if (!(NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT) || (component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT))) {
            return null;
        }
        String file = component.getAttribute("http://schemas.android.com/apk/res-auto", "transition");
        if (file == null) {
            return null;
        }
        int index = file.lastIndexOf("@xml/");
        String fileName = file.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        Project project = component.getModel().getProject();
        AndroidFacet facet = component.getModel().getFacet();
        ResourceFolderType folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(ResourceType.XML);
        List<VirtualFile> resourcesXML = AndroidResourceUtil.getResourceSubdirs(folderType, facet.getAllResourceDirectories());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile directory = resourcesXML.get(0);
        VirtualFile virtualFile = directory.findFileByRelativePath(fileName + ".xml");
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
    }

    @Nullable
    List<XmlTag> getKeyframes(XmlFile file, String componentId) {
        XmlTag[] children = file.getRootTag().findSubTags("KeyFrames");
        ArrayList<XmlTag> found = new ArrayList<XmlTag>();
        for (int i = 0; i < children.length; ++i) {
            XmlTag[] keyframes = children[i].getSubTags();
            for (int j = 0; j < keyframes.length; ++j) {
                XmlTag keyframe = keyframes[j];
                XmlAttribute attribute = keyframe.getAttribute("motion:target");
                if (attribute == null) continue;
                System.out.println("attribute value: " + attribute.getValue());
                String keyframeTarget = attribute.getValue();
                int index = keyframeTarget.indexOf(47);
                if (index != -1) {
                    keyframeTarget = keyframeTarget.substring(index + 1);
                }
                if (!componentId.equalsIgnoreCase(keyframeTarget)) continue;
                found.add(keyframe);
            }
        }
        return found;
    }

    @Nullable
    XmlTag getConstraintSet(XmlFile file, String constraintSetId) {
        XmlTag[] children = file.getRootTag().findSubTags("ConstraintSet");
        for (int i = 0; i < children.length; ++i) {
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null || !attribute.getValue().equalsIgnoreCase(constraintSetId)) continue;
            return children[i];
        }
        return null;
    }

    @Nullable
    XmlTag getConstrainView(XmlTag constraintSet, String id) {
        XmlTag[] children = constraintSet.getSubTags();
        for (int i = 0; i < children.length; ++i) {
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null) continue;
            String value = attribute.getValue();
            int index = value.lastIndexOf("id/");
            if ((value = value.substring(index + 3)) == null || !value.equalsIgnoreCase(id)) continue;
            return children[i];
        }
        return null;
    }

    public void setInTransition(@NotNull NlComponent component, final boolean inTransition) {
        if (component == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(15);
        }
        if (!(NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT) || (component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, SdkConstants.MOTION_LAYOUT))) {
            return;
        }
        NlModel myModel = component.getModel();
        final NlComponent finalComponent = component;
        new WriteCommandAction(myModel.getProject(), "Set In Transition", new PsiFile[]{myModel.getFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                finalComponent.setAttribute("http://schemas.android.com/apk/res-auto", "applyTransition", Boolean.toString(inTransition));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutTimelinePanel$1", "run"));
            }
        }.execute();
        NlModel model = component.getModel();
        model.notifyModified(NlModel.ChangeType.EDIT);
    }

    public void setMotionLayoutAttributePanel(MotionLayoutAttributePanel panel) {
        this.myMotionLayoutAttributePanel = panel;
    }

    @Override
    public void addTimelineListener(@NotNull TimelineListener listener2) {
        if (listener2 == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(16);
        }
        this.myTimelineListeners.add(listener2);
    }

    @Override
    public void removeTimeLineListener(@NotNull TimelineListener listener2) {
        if (listener2 == null) {
            MotionLayoutTimelinePanel.$$$reportNull$$$0(17);
        }
        this.myTimelineListeners.remove(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutTimelinePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutTimelinePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateAccessoryPanelWithSelection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseMotionScene";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modelDerivedDataChanged";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setKeyframeAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setKeyframeAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTransitionFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setInTransition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTimelineListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeTimeLineListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum State {
        TL_UNKNOWN,
        TL_START,
        TL_PLAY,
        TL_PAUSE,
        TL_TRANSITION,
        TL_END;

    }
}

